<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:xhtml="http://www.w3.org/1999/xhtml">
    <xsl:output method="html" encoding="UTF-8" indent="yes"/>
    <xsl:template match="/">
        <html>
            <head>
                <title>XML Sitemap</title>
                <style>
          body{font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,Oxygen-Sans,Ubuntu,Cantarell,"Helvetica Neue",sans-serif;font-size:14px;line-height:1.5;color:#23282d;background:#f1f1f1}
          table{border-collapse:collapse;width:100%;background:#fff;box-shadow:0 1px 3px rgba(0,0,0,.1)}
          th,td{padding:8px 12px;text-align:left;border-bottom:1px solid #eee}
          th{background:#f9f9f9;font-weight:600}
          tr:hover{background:#f7f7f7}
          a{color:#0073aa;text-decoration:none}
          a:hover{color:#00a0d2}
          .xhtml{white-space:nowrap;font-size:12px;color:#666}
          details summary{cursor:pointer;font-weight:600;margin:8px 0}
          #sitemap{
            max-width: 900px;
            margin: 0 auto;
          }
                </style>
            </head>
            <body>
                <div id="sitemap">
                    <div id="sitemap__header">
                        <h1>XML Sitemap</h1>
                        <p>This is a XML Sitemap generated by GuaQi.</p>
                    </div>
                    <!--  urlset  -->
                    <xsl:if test="sitemap:urlset">
                        <table>
                            <thead>
                                <tr>
                                    <th>URL</th>
                                    <th>Last Modified</th>
                                    <th>Alternates</th>
                                </tr>
                            </thead>
                            <tbody>
                                <xsl:for-each select="sitemap:urlset/sitemap:url">
                                    <tr>
                                        <td>
                                            <a href="{sitemap:loc}">
                                                <xsl:value-of select="sitemap:loc"/>
                                            </a>
                                        </td>
                                        <td>
                                            <xsl:value-of select="sitemap:lastmod"/>
                                        </td>
                                        <td class="xhtml">
                                            <details>
                                                <summary>
                                                    <xsl:value-of select="count(xhtml:link)"/>
 alternates</summary>
                                                <xsl:for-each select="xhtml:link">
                                                    <div>
                                                        <xsl:value-of select="@hreflang"/>
:                                                        <a href="{@href}">
                                                            <xsl:value-of select="@href"/>
                                                        </a>
                                                    </div>
                                                </xsl:for-each>
                                            </details>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </tbody>
                        </table>
                    </xsl:if>

                    <!--  sitemapindex  -->
                    <xsl:if test="sitemap:sitemapindex">
                        <table>
                            <thead>
                                <tr>
                                    <th>Sitemap</th>
                                    <th>Last Modified</th>
                                </tr>
                            </thead>
                            <tbody>
                                <xsl:for-each select="sitemap:sitemapindex/sitemap:sitemap">
                                    <tr>
                                        <td>
                                            <a href="{sitemap:loc}">
                                                <xsl:value-of select="sitemap:loc"/>
                                            </a>
                                        </td>
                                        <td>
                                            <xsl:value-of select="sitemap:lastmod"/>
                                        </td>
                                    </tr>
                                </xsl:for-each>
                            </tbody>
                        </table>
                    </xsl:if>

                    <p style="margin-top:16px;font-size:12px;color:#666">
          Generated with <a href="https://guaqi.com" target="_blank">GuaQi</a> ·                        <a href="https://www.sitemaps.org" target="_blank">About XML Sitemaps</a>
                    </p>
                </div>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>