import { e as setCookie } from './nitro.mjs';

const storeTokens = (event, data) => {
  const { authToken, refreshToken, authTokenExpiration } = data;
  try {
    if (authToken) {
      setCookie(event, "authToken", authToken, {
        httpOnly: true,
        secure: true,
        maxAge: 31536e3,
        sameSite: "strict",
        path: "/"
      });
    }
    if (authTokenExpiration) {
      setCookie(event, "authTokenExpiration", authTokenExpiration, {
        httpOnly: false,
        secure: true,
        maxAge: 31536e3,
        sameSite: "strict",
        path: "/"
      });
    }
    if (refreshToken) {
      setCookie(event, "refreshToken", refreshToken, {
        httpOnly: true,
        secure: true,
        maxAge: 31536e3,
        sameSite: "strict",
        path: "/"
      });
    }
  } catch (error) {
    console.log("error", error);
  }
};

export { storeTokens as s };
