var common = {
	home: "Home",
	defaultPage: "Default",
	safe: {
		report: "Report"
	},
	postType: {
		post: "Post",
		community: "Topic"
	},
	sticky: {
		label: "Sticky",
		success: "Stickied",
		cancel: "Unstick",
		cancelSuccess: "Unstickied"
	},
	breadcrumbList: "Breadcrumbs",
	faqList: "FAQs",
	edit: {
		add: "Add",
		edit: "Edit",
		cancel: "Cancel",
		ok: "OK",
		confirm: "Confirm",
		"delete": "Del",
		back: "Back",
		save: "Save",
		deleteMsg: "Delete?",
		error: "Fill fields",
		copied: "Copied"
	},
	untitled: "Untitled",
	colorMode: {
		light: "Light",
		dark: "Dark",
		system: "Auto"
	},
	unzipPassword: "Unzip PW",
	extractionCode: "Ext. Code",
	transfer: {
		source: "Src",
		target: "Tgt"
	},
	editor: {
		detail: "Details",
		undo: "Undo",
		redo: "Redo",
		clear: "Clear Fmt",
		heading: "Header",
		h2: "H2",
		h3: "H3",
		bold: "Bold",
		italic: "Italic",
		blockquote: "Quote",
		code: "Code",
		hr: "Line",
		list: "List",
		ol: "Num. List",
		ul: "Bul. List",
		image: "Img",
		link: "Link",
		table: "Table",
		video: "Video",
		audio: "Audio",
		attachment: "Attach.",
		titlePlaceholder: "Title (max 100)",
		contentPlaceholder: "Content",
		imagecaptionPlaceholder: "Caption (opt, max 40)",
		library: {
			image: "My Imgs",
			video: "My Vids",
			audio: "My Auds",
			attachment: "My Files",
			insert: "Insert",
			insertGallery: "Insert Gallery",
			"delete": "Del Selected",
			select: "Select/Drag (max {0})",
			support: "{0} formats",
			empty: "Empty",
			embed: "Vid Platform",
			iframe: "Embed Code",
			external: "Ext. Link",
			embedUrl: "Video URL",
			embedSupport: "Supports: {0}",
			iframeCode: "Embed Code (Iframe)",
			iframeSupport: "Iframe only",
			externalUrl: "Link",
			externalTitle: "Title",
			externalCaption: "Desc",
			externalSupport: "Formats: {0}",
			insertFail: "Failed, retry",
			disabledClose: "Uploading...",
			attachmentInput: {
				title: "Name",
				fileSize: "Size",
				caption: "Desc",
				otherMetas: "Props",
				otherMetasDesc: "Key:Value, one per line."
			},
			noUploadToday: "Daily limit reached ({0} {1}).",
			noUpload: "No Permission",
			addDescription: "Add Desc",
			editDescription: "Edit Desc"
		},
		linkBox: {
			title: "Link",
			url: {
				label: "URL",
				placeholder: "Enter URL"
			},
			text: {
				label: "Text",
				placeholder: "Enter Text"
			},
			target: {
				label: "Open",
				options: {
					self: "Current",
					blank: "New Win"
				}
			}
		},
		mention: {
			placeholder: {
				userMention: "Who?",
				tagMention: "Which topic?"
			},
			noresults: "No results \"{0}\""
		},
		tableToolbar: {
			"delete": "Del Table"
		},
		lineCount: "Lines",
		error: {
			linkText: "Text Req",
			linkInvalid: "Bad URL",
			imageEmpty: "Img URL Req",
			imageInvalid: "Bad Img URL",
			videoEmpty: "Vid URL Req",
			videoInvalid: "Bad Vid URL",
			audioEmpty: "Aud URL Req",
			audioInvalid: "Bad Aud URL",
			attachmentEmpty: "File URL Req",
			attachmentInvalid: "Bad File URL"
		},
		saveSuccess: "Saved",
		publishSuccess: "Published",
		editSuccess: "Edited"
	},
	time: {
		justNow: "Now",
		past: "{0} ago",
		future: "in {0}",
		invalid: "Bad Date",
		second: "{0}s",
		minute: "{0}m",
		hour: "{0}h",
		day: "{0}d",
		week: "{0}w",
		month: "{0}mo",
		year: "{0}y",
		expiresDay: "Exp {0}d {1}h",
		expiresHour: "Exp {0}h {1}m",
		expiresMinute: "Exp {0}m",
		hasExpired: "Expired"
	},
	"default": "Default {0}",
	iconTips: "Go to {0}, copy Data URL to input.",
	logOut: "Logout",
	logOutSuccess: "Bye!",
	logIn: "Login",
	signUp: "Signup",
	errorMsg: {
		required: "Required"
	},
	status: {
		HOLD: "HOLD",
		APPROVED: "OK",
		REJECTED: "REJECT",
		DRAFT: "DRAFT"
	},
	follow: {
		follow: "Follow",
		followed: "Following",
		unfollow: "Unfollow",
		following: "Following",
		cancelFollow: "Unfollow",
		empty: "No Follows",
		confirm: "Unfollow?",
		success: "Unfollowed"
	},
	fans: {
		fans: "Fans",
		followed: "Following",
		cancelFans: "Remove Fan",
		confirm: "Remove fan?",
		success: "Removed"
	},
	subscribe: {
		subscribe: "Sub",
		subscribed: "Subbed",
		unsubscribe: "Unsub"
	},
	vote: {
		vote: "Vote",
		voted: "Voted"
	},
	share: {
		share: "Share",
		shared: "Shared",
		wechat: {
			title: "WeChat",
			desc: "Scan QR Code"
		},
		name: {
			qzone: "Qzone",
			weibo: "Weibo",
			wechat: "WeChat",
			qq: "QQ",
			reddit: "Reddit",
			instagram: "Instagram",
			facebook: "Facebook",
			telegram: "Telegram",
			whatsapp: "WhatsApp",
			twitter: "Twitter",
			tumblr: "Tumblr",
			linkedin: "LinkedIn",
			pinterest: "Pinterest",
			line: "Line",
			email: "Email"
		}
	},
	wealth: {
		balance: "Bal",
		credit: "Credits"
	},
	uploadFile: {
		upload: "Upload",
		success: "Done",
		uploading: "Uploading...",
		error: "Failed",
		errorType: "Bad Type",
		errorSize: "Too Large"
	},
	comment: {
		comment: "Comment",
		commented: "Commented",
		commentCount: "{0} Cmts",
		noComment: "No Cmts",
		placeholder: "Say something...",
		orderby: {
			newest: "Newest",
			hot: "Hot"
		},
		noPermission: "No Access",
		reply: {
			reply: "Reply",
			replied: "Replied"
		},
		status: {
			pending: "Pending"
		},
		welcome: "Discuss",
		sketchpad: {
			penSize: {
				small: "S",
				medium: "M",
				large: "L"
			}
		}
	},
	like: {
		like: "Like",
		liked: "Liked",
		getLike: "Likes",
		cancel: "Unlike",
		success: "Unliked",
		confirm: "Unlike?"
	},
	collection: {
		collection: "Collect",
		collected: "Collected",
		cancel: "Uncollect",
		empty: "Empty",
		confirm: "Uncollect?",
		success: "Uncollected"
	},
	rating: {
		rating: "Stars",
		point: "Rate"
	},
	report: {
		report: "Report",
		reported: "Reported",
		selectType: "Type",
		type: "Type",
		screenshot: "Screen",
		upload: "Upload",
		content: "Content",
		inputContent: "Details",
		submit: "Send",
		result: "Feedback via msg/profile.",
		resultFooter: "Check msg/profile for feedback.",
		maxUpload: "Max {0}",
		submitSuccess: "Sent"
	},
	verify: {
		title: "Verify",
		newPhone: "New Phone",
		newEmail: "New Email",
		desc: "Security Check",
		desc2: "Wait {0}",
		desc3: "Verified Only",
		phone: "Use Phone {0}",
		email: "Use Email",
		code: "6-digit Code",
		verify: "Verify",
		verifySuccess: "Success",
		verifyFailed: "Failed",
		verifyExpired: "Expired",
		expiry: "{0}d",
		validity: "Valid"
	},
	publish: {
		publish: "Pub",
		published: "Pubbed",
		publishing: "Pub..."
	},
	identity: {
		author: "Author",
		admin: "Admin",
		guest: "Guest",
		youIdentity: "You:"
	},
	roles: {
		free: "Free",
		changeRole: "Change",
		lv: "User",
		vip: "VIP",
		guest: "Guest",
		all: "All",
		other: "Others"
	},
	pay: {
		pay: "Pay",
		exchange: "Swap"
	},
	contact: {
		contact: "Contact"
	},
	or: "Or",
	filter: {
		filter: "Filter",
		reset: "Reset",
		sort: {
			label: "Sort",
			all: "All",
			newest: "Newest",
			hot: "Hot",
			comment: "Comments",
			like: "Likes",
			collection: "Collects"
		},
		filterType: {
			all: "All",
			content: "Priv",
			video: "Vid",
			audio: "Aud",
			image: "Img",
			resource: "Res"
		},
		pay: {
			label: "Access",
			all: "All",
			free: "Free",
			followed: "Follow",
			money: "Paid",
			credit: "Swap",
			login: "Login",
			comment: "Cmt",
			qrcode: "Scan"
		},
		random: "Rnd"
	},
	login: {
		type: {
			phone: "Phone Reg",
			email: "Email Reg",
			usephone: "Phone Reset",
			useemail: "Email Reset",
			loginphone: "Phone Login",
			loginemail: "Email Login",
			passkey: "Passkey",
			phonePlaceholder: "Phone",
			emailPlaceholder: "Email",
			phoneOrEmailPlaceholder: "Phone/Email",
			passwordPlaceholder: "Pwd",
			newPasswordPlaceholder: "New Pwd",
			rePasswordPlaceholder: "Retype Pwd"
		},
		authorize: {
			bindPhone: "Bind Phone",
			bindEmail: "Bind Email",
			authorizing: "Auth...",
			authorizingDesc: "Don't close",
			authorizingError: "Auth Fail",
			authorizingErrorDesc: "Retry later/Contact Admin",
			boundPhoneOrEmail: "Bound Contact"
		},
		moreInfomation: {
			title: "Profile",
			random: "Rnd Avatar",
			placeholder: "Nickname",
			uploadAvatar: "Avatar",
			success: "Saved!",
			randomCover: "Rnd Cover",
			uploadCover: "Cover"
		},
		social: {
			qq: "QQ",
			douyin: "Douyin",
			weibo: "Weibo",
			wechat: "WeChat",
			facebook: "Facebook",
			google: "Google",
			instagram: "Instagram",
			linkedin: "LinkedIn",
			github: "Github",
			outlook: "Outlook",
			alipay: "Alipay",
			taobao: "Taobao",
			baidu: "Baidu",
			dingtalk: "Dingtalk",
			feishu: "Feishu",
			douban: "Douban",
			line: "Line",
			coding: "Coding",
			gitee: "Gitee",
			scanLogin: "Scan Login",
			scanLoginDesc: "Scan with {0}"
		},
		protocol: {
			label: "Agree",
			and: "&",
			service: "Terms",
			privacy: "Privacy"
		},
		action: {
			login: "Login",
			signup: "Signup",
			forget: "Lost Pwd",
			next: "Next",
			repass: "Reset"
		},
		loginSuccess: "Logged In",
		registerSuccess: "Registered",
		error: {
			requiredEmail: "Email req",
			requiredPhone: "Phone req",
			requiredPassword: "Pwd req",
			passwordNotMatch: "Pwd mismatch",
			resetPasswordSuccess: "Pwd reset! Login now."
		},
		forget: "Lost Pwd?",
		forgetTip: "Use {0} to get code.",
		verifySuccessTip: "{0} verified, set pwd!",
		not: "No Account?",
		has: "Have Account?",
		getCode: "Get Code",
		reget: "Retry {0}s",
		captcha: {
			placeHolder: "Captcha",
			title: "Captcha",
			description: "Enter chars",
			error: "Wrong Captcha"
		}
	},
	levelTips: {
		level: "User",
		vip: "VIP",
		levelUp: "Lvl Up",
		becomeVipMember: "Join VIP"
	},
	coupon: {
		status: "Status",
		invalid: "Invalid",
		expired: "Expired",
		unused: "Unused",
		used: "Used",
		allowPush: "Allow Push",
		allow: "Allow",
		disallow: "Disallow",
		createTime: "Created",
		expiredTime: "Expires",
		expiredOn: "{0} Exp",
		none: "Never",
		faceValue: "Value",
		reward: "Reward",
		noneReward: "None",
		allowUser: "Users",
		allowUserGroup: "Groups",
		noRestrict: "Any",
		description: "Desc",
		terms: "Terms",
		ids: "IDs",
		products: "Prods",
		redeem: "Redeem",
		pushTo: "Push To",
		confirmPush: "Push",
		pushSuccess: "Pushed",
		cancelUse: "Cancel"
	},
	creditPay: {
		title: "Cred Pay",
		availableCredit: "Avail Creds",
		finalPrice: "Price",
		discount: "🎉Disc",
		cancelUse: "No Creds",
		needMoreCredit: "More Creds?",
		pay: "Exchange",
		notEnoughCredit: "Not enough creds!",
		count: "{0} swapped",
		exchange: "Swap"
	},
	moneyPay: {
		title: "Pay",
		discount: "Exp {0}",
		count: "{0} paid",
		hasDiscount: "Orig {0}, Disc {1}",
		hasOff: "Off {0}",
		reward: "Reward {0}",
		balance: "Bal Pay",
		balanceTip: "Bal:",
		pay: "Pay",
		selectCoupon: "Use Coupon",
		couponTip: "Unused/valid only",
		scanPay: "Scan with {0}",
		success: "Paid",
		waiting: {
			title: "Confirming",
			desc: "Please Pay",
			pay: "Auto-confirming",
			failed: "Timeout",
			failedDesc: "No feedback, retry or contact admin.",
			confirm: "Paid"
		}
	},
	qrcode: {
		title: "Pay",
		expired: "Exp QR",
		pay: "Scan with {0}"
	},
	roleBox: {
		userGroup: "Group",
		getWay: "Method",
		status: "Status",
		noPermission: "No Access",
		originalPrice: "Orig Price",
		allow: "🎉Accessed!"
	},
	searchUser: {
		title: "Find User"
	},
	hasPaid: "Paid:",
	pmBox: {
		title: "DM",
		recents: "Recent",
		followings: "Follows",
		selectUser: "Select",
		noPermission: "1 msg limit (no mutual follow/reply)."
	}
};
var header = {
	search: {
		placeholder: "Search",
		searchResult: "Results",
		noResult: "None",
		noKeyword: "Keyword req",
		resultCount: "{0} found",
		title: "Search",
		description: "Search site",
		keywords: "Search"
	},
	downloadButton: {
		label: "Client",
		list: {
			mobile: "Mobile App",
			desktop: "Desktop App"
		}
	},
	user: {
		message: "New Msg",
		ticket: "Ticket Replied"
	},
	userInfo: {
		registerDate: "Reg Date"
	}
};
var footer = {
	mobuleMenu: {
		addMenu: "Add footer menu",
		shareIdea: "Idea?",
		shareIdeaDesc: "Share idea..."
	}
};
var page = {
	modules: {
		post: {
			switchPosts: "Refresh",
			moreButton: "More",
			loadMoreButton: "Load More",
			loading: "Loading...",
			noMore: "End",
			free: "Free",
			downloadButton: "Download",
			rating: "Like",
			episode: "{0} Eps",
			chap: "{0} Vols",
			bookComplete: "Done",
			bookReaders: "{0} Reads",
			bookNotComplete: "Ongoing",
			recommend: "Rec",
			resource: "Down",
			video: "Vid",
			audio: "Aud",
			gallery: "Gal",
			downloadCount: "{0} Dl",
			playCount: "{0} Play"
		},
		community: {
			empty: "No Topics",
			join: "Join",
			post: "Post",
			joinBox: {
				title: "Select Node",
				join: "Join",
				joined: "Joined",
				allNodes: "All",
				selectNode: "Select"
			}
		},
		html: {
			title: "Add HTML"
		},
		menu: {
			title: "Add Menu"
		},
		form: {
			hasSubmit: "Submitted. {0} retries left.",
			pay: {
				expire: "Disc Exp {0}",
				forever: "Disc Forever",
				paid: "Paid"
			}
		},
		ad: {
			title: "Ad"
		}
	},
	article: {
		header: {
			datePublished: "Pub {0}",
			dateUpdated: "Upd {0}"
		},
		resource: {
			resourcesCount: "{0} Files",
			comment: "Cmt",
			login: "Login",
			preview: "Preview",
			qrcode: "QR",
			downloadCount: "Dls",
			roles: "Rules",
			downloadLink: "Link",
			showQrcode: "Show QR",
			download: "Download",
			reportButton: "Report"
		},
		rolesInfo: {
			originalPrice: "Orig {0}",
			expireTime: "Disc Exp {0}",
			discount: "-{0}%",
			purchased: "Bought",
			become: "Become",
			disallow: {
				free: {
					resource: "Free DL",
					audio: "Free Play",
					video: "Free Play",
					gallery: "Free View"
				},
				firstLogin: ", login 1st",
				login: {
					resource: "Login to DL",
					audio: "Login to Play",
					video: "Login to Play",
					gallery: "Login to View"
				},
				qrcode: {
					resource: "Scan to DL",
					audio: "Scan to Play",
					video: "Scan to Play",
					gallery: "Scan to View"
				},
				comment: {
					resource: "Cmt to DL",
					audio: "Cmt to Play",
					video: "Cmt to Play",
					gallery: "Cmt to View"
				},
				money: {
					resource: "Pay {0}",
					audio: "Pay {0}",
					video: "Pay {0}",
					gallery: "Pay {0}"
				},
				credit: {
					resource: "{0} Creds",
					audio: "{0} Creds",
					video: "{0} Creds",
					gallery: "{0} Creds"
				},
				level: {
					resource: "Group Limit",
					audio: "Group Limit",
					video: "Group Limit",
					gallery: "Group Limit"
				},
				darkRoom: {
					resource: "Banned",
					audio: "Banned",
					video: "Banned",
					gallery: "Banned"
				}
			}
		},
		video: {
			playList: "Playlist",
			current: "{0}/{1}",
			automatic: "Auto",
			unlock: "Click to unlock",
			unlockVideo: "Unlock Vid",
			fullVideo: "Full Vid"
		},
		gallery: {
			page: "Pg {0}",
			unlock: "Unlock",
			unlockGallery: "Unlock Gal"
		},
		audio: {
			unlock: "Unlock",
			unlockAudio: "Unlock Aud",
			free: "Free",
			bought: "Bought"
		}
	},
	archive: {
		search: {
			placeholder: "Search Cat"
		}
	},
	widgets: {
		my: {
			hi: {
				late: "Hi, sleep early!",
				morning: "Morning!",
				afternoon: "Afternoon!",
				evening: "Evening!"
			},
			joinButton: "Profile"
		},
		chat: {
			label: "Chat",
			join: "{0} joined",
			limitText: "100 msgs kept",
			leave: "{0} left",
			newMessage: "New Msgs",
			form: {
				send: "Send",
				placeholder: "Msg...",
				join: "Join",
				description: "Login Only!",
				noAccess: "No Access",
				viewRole: "Perms",
				joinRoom: "Join Chat",
				allowUser: "Allowed Users"
			},
			empty: "Empty"
		},
		player: {
			label: "Player"
		},
		download: {
			label: "Get Client"
		},
		rocket: {
			label: "Top"
		},
		support: {
			label: "Support"
		},
		faq: {
			label: "Help"
		}
	},
	profile: {
		info: {
			title: "Profile",
			coverButton: "Cover",
			editAvatar: "Avatar",
			notVerify: "Unverified"
		},
		content: {
			activity: {
				label: "Activity",
				title: "Recent",
				empty: "None",
				actionType: {
					register: "Hi!",
					register_first: "Reg",
					register_total: "Reg Days",
					create_comment: "Cmt",
					create_comment_first: "1st Cmt",
					create_comment_today: "Today's Cmt",
					create_comment_total: "Total Cmt",
					comment_reply: "Reply",
					like: "Like",
					like_first: "1st Like",
					like_today: "Today's Likes",
					like_total: "Total Likes",
					liked: "Liked",
					liked_first: "1st Liked",
					liked_today: "Today's Liked",
					liked_total: "Total Liked",
					follow: "Follow",
					follow_first: "1st Follow",
					follow_today: "Today's Fols",
					follow_total: "Total Fols",
					followed: "Followed",
					followed_first: "1st Followed",
					followed_today: "Today's Foled",
					followed_total: "Total Foled",
					collection: "Collect",
					collection_first: "1st Col",
					collection_today: "Today's Cols",
					collection_total: "Total Cols",
					collectioned: "Collected",
					collectioned_first: "1st Collected",
					collectioned_today: "Today's Coled",
					collectioned_total: "Total Coled",
					audio: "Unlk Aud",
					video: "Unlk Vid",
					create_post: "Post",
					create_post_first: "1st Post",
					create_post_total: "Total Posts",
					create_post_today: "Today's Posts",
					create_topic: "Topic",
					create_topic_first: "1st Topic",
					create_topic_today: "Today's Topics",
					create_topic_total: "Total Topics",
					topic_reply: "Replied Topic",
					topic_replyed: "Topic Replied",
					create_product: "Prod",
					create_product_first: "1st Prod",
					product_reply: "Replied Prod",
					product_replyed: "Prod Replied",
					post_reply: "Replied Post",
					post_replyed: "Post Replied",
					gallery: "Unlk Gal",
					resource: "DL Res",
					coupon: "Coupon",
					joinNode: "Join Node",
					topic: "View Topic",
					bounty: "Bounty",
					balance_transfer: "Transfer",
					vip: "VIP",
					form: "Form",
					verify: "Verify",
					withdraw: "W/D",
					buyCredit: "Buy Cred",
					transfer: "{0} to {1}",
					recharge: "Recharge",
					withdrawal: "W/D {0}",
					licenseCount: "Lic Change"
				}
			},
			create: {
				label: "Create",
				types: {
					post: "Post",
					community: "Topic",
					comment: "Cmt",
					community_answer: "Ans",
					communityAnswers: "Answers"
				},
				postType: {
					resource: "Res",
					gallery: "Gal",
					video: "Vid",
					audio: "Aud",
					circle: "Circle",
					download: "DL"
				}
			},
			interactive: {
				label: "Interaction",
				types: {
					like: "Like",
					collection: "Collect",
					followers: "Followers",
					following: "Following"
				}
			},
			history: {
				label: "History"
			}
		}
	},
	community: {
		topicTags: {
			all: "All",
			week: "Hot",
			search: "Search"
		},
		nodes: {
			title: "Nodes",
			joined: "Joined",
			unjoined: "Unjoined",
			"private": "Priv",
			"public": "Pub",
			money: "Paid",
			level: "Excl",
			free: "Free"
		},
		empty: "No Topics",
		menu: {
			recommend: "Rec",
			all: "All"
		},
		header: {
			admin: "(Admin)",
			moreAdmin: "+{1} Admins",
			selectNode: "Select Node:",
			say: "Say",
			vote: "Vote",
			bounty: "Bounty",
			create: "Create",
			allNode: "All",
			loadEditor: "Loading...",
			title: "Title (Req)",
			at: "At",
			"default": "Default",
			createLongTopic: "Long Post",
			"private": "Private",
			joinToRead: "Join to read",
			joinNode: "Join",
			readHidden: "🔒Hidden",
			userToRead: "Allowed Users"
		},
		tools: {
			image: "Img",
			video: "Vid",
			audio: "Aud",
			attachment: "Attach",
			publish: "Pub"
		},
		joinNode: {
			join: "Join {0}",
			desc: {
				free: "Free Join",
				levelAllow: "Excl (No Access)",
				levelDisallow: "Excl (Access)",
				access: "Get Access",
				joinNode: "Join"
			},
			canTopic: {
				title: "Joined",
				desc: "Joined, no post rights."
			},
			joinSuccess: "Joined",
			pay: {
				month: "Mo",
				season: "Qtr",
				year: "Yr",
				halfYear: "6 Mo",
				permanent: "Perm"
			},
			topicCan: "Posters",
			canJoin: "Joiners"
		},
		types: {
			bounty: {
				title: "Bounty",
				"public": "Public",
				"private": "Private",
				credit: "Credit",
				creditPlaceholder: "Creds",
				moneyPlaceholder: "Amt",
				money: "Cash",
				gold: "Wealth",
				description: "Deducted now. Bal:",
				time: "Exp",
				placeholder: "Select Exp",
				timeDescription: "Closes after exp.",
				all: "All",
				target: "Targets",
				answerList: "Answers",
				submitAnswer: "Answer",
				noPermission: "No Access",
				noAnswer: "None",
				users: "Users",
				allDesc: "Anyone answers",
				usersDesc: "Specific users answer"
			},
			vote: {
				radio: "Single",
				checkbox: "Multi",
				pk: "PK",
				placeholder: {
					text: "Option",
					vote: "Val"
				},
				success: "Voted",
				add: "Add Opt",
				time: "Exp",
				timeDescription: "Results after exp.",
				radioDesc: "Pick 1",
				checkboxDesc: "Pick Multi",
				pkDesc: "Pick 1 of 2"
			}
		},
		submit: {
			error: {
				title: "Title Req",
				content: "Content Req",
				money: "Amt Req",
				bountyDeadline: "Exp Req",
				voteCount: "2+ Opts Req",
				voteContent: "Opts Req",
				voteDeadline: "Exp Req"
			}
		},
		roles: {
			title: "Access",
			"public": {
				label: "Pub",
				description: "All view"
			},
			followed: {
				label: "Follow",
				description: "Followers view"
			},
			login: {
				label: "Login",
				description: "Login view"
			},
			comment: {
				label: "Cmt",
				description: "Cmt view"
			},
			credit: {
				label: "Cred",
				description: "Pay {0} creds",
				placeholder: "{0} amt"
			},
			money: {
				label: "Paid",
				description: "Pay view",
				placeholder: "Amt"
			},
			level: {
				label: "Group",
				description: "Groups view"
			},
			"private": {
				label: "Priv",
				description: "Users view"
			}
		},
		list: {
			topic: "Topic",
			member: "Memb",
			admin: "Admin",
			join: "Join",
			joined: "Joined",
			subscribe: "Sub",
			subscribed: "Subbed",
			unsubscribe: "Unsub",
			create: "Create",
			allCats: "All Nodes",
			pending: "Pending",
			comment: "Cmt {0}",
			filter: {
				label: "Filter",
				options: {
					hot: "Hot",
					"new": "New",
					recommend: "Rec"
				}
			},
			hidden: {
				title: "Hidden",
				has: "{0} bought",
				level: "No Access",
				comment: "Cmt to read",
				followed: "Follow to read",
				pay: "Pay",
				exchange: "Swap",
				check: "Check",
				login: "Login/Reg",
				follow: "Follow"
			},
			vote: {
				voteCount: "{0} Votes",
				voteJoin: "{0} Joined",
				optionCount: "{0} Opts",
				result: "Result after vote",
				vote: "Vote",
				voted: "Voted",
				votes: "Votes",
				endAt: "Ends {0}",
				ended: "Ended"
			}
		}
	},
	create: {
		login: "Login first",
		permission: "No Perms",
		permission_desc: "Perms required",
		writeAnswer: "Answer",
		cover: "Cover",
		selectCategory: "Select Cat",
		draft: "Saved",
		preview: "Preview",
		publish: "Pub",
		title: {
			editAnswer: "Edit Ans",
			editTopic: "Edit Topic",
			editPost: "Edit Post",
			longTopic: "New Long Post",
			post: "New Post"
		}
	},
	account: {
		title: "Account",
		task: {
			title: "Tasks",
			taskItem: {
				registerTime: "Reg Days",
				register: "Reg",
				createPost: "Post",
				createComment: "Cmt",
				createTopic: "Topic",
				like: "Like",
				liked: "Liked",
				follow: "Follow",
				followed: "Followed",
				collection: "Collect",
				collectioned: "Collected"
			},
			"new": {
				prefix: "New",
				title: "Newbie",
				description: "One-time rewards."
			},
			day: {
				prefix: "Daily",
				title: "Daily",
				description: "Daily rewards."
			},
			total: {
				prefix: "Total",
				title: "Total",
				description: "Cumulative rewards."
			}
		},
		wealth: {
			title: "Wealth",
			myWealth: "My Wealth",
			balance: "Bal",
			credit: "Cred",
			creditBuy: "Buy Cred",
			creditTask: "Task",
			exchange: "Swap",
			withdraw: "W/D",
			recharge: "Charge",
			creditDetail: "Details",
			balanceDetail: "Details",
			withdrawalDetail: "W/D Details",
			tableHeader: {
				time: "Time",
				type: "Type",
				amount: "Amt",
				balance: "Bal",
				description: "Desc"
			},
			transfer: {
				title: "Transfer",
				from: "From {0}",
				formBalance: "{0} Bal: {1}",
				toBalance: "{0} Bal: {1}",
				rate: "Rate: {0}",
				transferTo: "To {0}",
				transfer: "Transfer"
			},
			rechargeBox: {
				balance: "Curr Bal:"
			},
			withdrawal: {
				box: {
					title: "W/D App",
					balance: "Bal /",
					min: "Min /",
					commission: "Fee:",
					real: "Receive:",
					need: "Min Req:",
					account: "Acct:",
					accountPlaceholder: "Enter Acct",
					channel: "Channel:",
					amount: "Amt:",
					desc: "Bal deducted pending review.",
					submit: "Withdraw",
					success: "Sent"
				},
				tableHeader: {
					time: "Time",
					currency: "Curr",
					amountGroup: "Amt",
					amount: "Amt",
					commission: "Fee",
					finalAmount: "Rec'd",
					status: "Status",
					paymentAccount: "Acct"
				},
				status: {
					pending: "Pending",
					approved: "Success",
					rejected: "Failed"
				}
			},
			buyCredit: {
				title: "Range",
				desc: "Use {0} {1}"
			}
		},
		coupon: {
			title: "Coupons",
			action: {
				extract: "Get",
				use: "Use",
				push: "Push",
				placeHolder: "Code",
				exchange: "Redeem",
				exchangeTip: "Paste code to redeem.",
				extractTip: "Paste code to get.",
				pushTip: "Select code & user to push.",
				selectCoupon: "Select Code",
				selectTip: "Valid/Pushable Only",
				selectUser: "Select User",
				extractSuccess: "Got",
				useSuccess: "Used"
			},
			types: {
				register: "Invite",
				cash: "Coupon",
				credit: "Cred Code",
				exchange: "Redeem"
			},
			status: {
				used: "Used",
				unused: "Unused",
				expired: "Exp",
				none: "Inv",
				forever: "Perm",
				expiredAt: "{0} Exp"
			},
			history: {
				title: "History",
				tableHeader: {
					name: "Name",
					code: "Code",
					type: "Type",
					time: "Time",
					description: "Desc"
				},
				tableBody: {
					content: {
						create: "Got {0} {1}",
						receive: "Got {1} fr {0}",
						push: "Pushed {0} to {1}",
						use: "Used {0} {1}"
					}
				}
			}
		},
		membership: {
			title: "VIP",
			off: "{0}% Off",
			vipInfo: "More",
			info: {
				get: "{0} Days",
				credit: "Get {0} Creds",
				off: "{0}% Off",
				limit: "Exp {0}"
			},
			myMembership: {
				title: "My VIP",
				endTime: "End: {0}",
				renew: "Renew",
				become: "Join",
				joinInfo: "Join for benefits!",
				forever: "Perm VIP",
				exchange: "Change"
			},
			days: "{0} Days",
			forever: "Forever",
			gift: "Gift",
			giftTime: "Perm",
			endAt: "End in {0}",
			join: "Join",
			group: "Group",
			joinMembership: "Join VIP",
			directMessages: "DMs",
			article: "Post",
			comment: "Cmt",
			topic: "Topic",
			promotion: "Promo",
			product: "Shop",
			content: "Paid Cont",
			gallery: "Paid Gal",
			video: "Paid Vid",
			audio: "Paid Aud",
			resource: "Paid DL",
			vip: "VIP Buy",
			credit: "Cred Buy",
			joinNode: "Paid Circle",
			form: "Paid Form",
			renew: "Renew {0}"
		},
		promotion: {
			title: "Promo",
			effective: "Active",
			noEffective: "No Perms",
			link: "Link",
			desc: "Reg via link = your user.",
			promotion: "Rebate",
			total: "Total Comm",
			closed: "Closed",
			waiting: "Wait",
			paid: "Paid",
			withdrawn: "Unavail",
			withdrawable: "Avail",
			drawable: "Withdraw",
			cycle: "Cycle",
			cycleUnit: "{0}d",
			cycleDesc: "Wait {0}d after completion.",
			level: "Lvl Earnings",
			level1: "Lvl 1",
			level2: "Lvl 2",
			level3: "Lvl 3",
			promotionDesc: "Desc",
			promotionList: "Details",
			promotionLevel: "Ratios:",
			noPromotionLevel: "No Ratios",
			promotionAllow: "Products:",
			noPromotionAllow: "None",
			rule: {
				title: "Rule",
				desc1: "A->B, B->C;",
				desc2: "A buys = no comm;",
				desc3: "B buys = A gets Lvl1;",
				desc4: "C buys = B Lvl1, A Lvl2."
			},
			promotionUser: "Users",
			promotionPermission: "Perms",
			proportion: "Ratio",
			levels: {
				level1: "Lvl 1",
				level2: "Lvl 2",
				level3: "Lvl 3"
			},
			"default": "Default Settings",
			defaultDesc: "Uses default if not set specifically.",
			allow: "Allowed Prods",
			method: "Calc Method",
			methodDesc: "Amt x Ratio = Comm.",
			guide: "Guide",
			guideDesc: "1. Share link.\n2. Users reg via link.\n3. User buys = Comm.\n4. Comm > 50 = W/D.\n5. W/D processed in 24h.",
			permissions: {
				product: "Shop",
				content: "Paid Cont",
				gallery: "Paid Gal",
				video: "Paid Vid",
				audio: "Paid Aud",
				resource: "Paid DL",
				vip: "VIP Buy",
				credit: "Cred Buy",
				joinNode: "Paid Circle",
				form: "Paid Form",
				topic: "Paid Topic"
			},
			withdrawnBox: {
				title: "W/D to Bal",
				cycle: "Cycle {0}d",
				unaccounted: "Pending:",
				unaccountedDesc: "Cannot w/d until period ends.",
				accounted: "Avail:",
				success: "Success",
				successDesc: "Credited to bal!",
				successBtn: "Wealth Ctr"
			},
			promotionDetail: {
				time: "Time",
				product: "Prod",
				user: "User",
				commission: "Comm",
				status: "Status"
			},
			list: {
				status: {
					closed: "Closed",
					waiting: "Wait",
					withdrawable: "Avail",
					withdrawn: "Unavail",
					paid: "Paid"
				}
			}
		},
		verify: {
			title: "Verify",
			backStep1: "Back",
			backStep2: "Back",
			step2: "Step 2: Form",
			step3: "Step 3: Done",
			submitSuccess: "Done",
			tipsTitle: "Info",
			tipsDesc: "1. Meet reqs.\n2. Get badge.\n3. Get perms.",
			step: {
				step1: {
					notMeet: "Reqs Not Met",
					precondition: "Reqs",
					role: "Group",
					registerTime: "Reg ≥ {0}d",
					verifyFee: "Fee",
					payAll: "Pay All",
					payOne: "Pay One",
					goVerify: "Verify",
					approved: "Ok",
					pending: "Pending",
					rejected: "Rejected",
					expiry: "{0}d",
					validity: "Valid",
					forever: "Perm"
				},
				step2: {
					desc: "Group is {0}, submit form.",
					desc2: "Group {0}, submit form.",
					payAll: "Pay Both",
					payOne: "Pay One"
				}
			}
		},
		ticket: {
			title: "Ticket",
			myTicket: "My Tickets",
			newTicket: "New",
			hasTicket: "Complete current ticket first.",
			form: {
				type: "Type",
				title: "Title",
				titlePlaceholder: "Title",
				content: "Desc",
				contentPlaceholder: "Question",
				submit: "Create"
			},
			tableHeader: {
				status: "Status",
				action: "Act",
				type: "Type",
				title: "Title",
				time: "Time"
			},
			tableBody: {
				status: {
					closed: "Done",
					open: "Pending"
				},
				empty: "No Tickets"
			},
			backToList: "Back",
			reply: "Reply",
			waiting: "Wait for reply",
			hasReply: "Done",
			"continue": "Cont.",
			close: "Solved",
			documents: "Docs",
			unread: "Unread",
			read: "Read"
		},
		orders: {
			title: "Orders",
			search: "Search",
			backToList: "Back",
			all: "All",
			money: "Cash",
			credit: "Cred",
			orderStatus: "Status",
			status: {
				label: "Status",
				unpaid: "Unpaid",
				paid_pending_shipment: "Pending Ship",
				shipped: "Shipped",
				delivered: "Delivered",
				finished: "Done",
				cancelled: "Cancelled",
				refund_pending: "Ref Pending",
				refunded: "Refunded",
				partially_shipped: "Part Shipped",
				partially_refunded: "Part Refunded"
			},
			tableHeader: {
				orderId: "Order #",
				product: "Prod",
				status: "Status",
				amount: "Amt",
				time: "Time"
			},
			paymentMethod: {
				alipay: "Alipay",
				wechat: "Wechat",
				bank: "Bank",
				paypal: "PayPal",
				stripe: "Stripe",
				balance: "Bal",
				credit: "Cred",
				other: "Other"
			},
			orderInfo: {
				orderTime: "Time",
				orderId: "Order #",
				deliveryInfo: "Deliv Info",
				productInfo: "Prod Info",
				price: "Price",
				count: "Count",
				total: "Total",
				delivery: "Deliv",
				payment: "Pay"
			}
		},
		invoice: {
			title: "Invoice"
		},
		creator: {
			title: "Creator",
			desc: "Earn creds via posts/cmts. Higher creds = higher lvl/perms.",
			credit: "Creds",
			creditNext: "Next Lvl: {0}",
			creditMax: "Max Lvl",
			creditTask: "Tasks",
			post: "Art",
			community: "Topic",
			comment: "Cmt",
			answer: "Ans"
		},
		notification: {
			title: "Notifs",
			allRead: "Read All",
			sendMessage: "Send Msg",
			from: "Fr {0}",
			system: "System",
			ticket: "Ticket",
			noMessage: "None",
			more: "More",
			noMore: "End",
			box: {
				report: {
					title: "Report Solved:",
					content: "Content:",
					type: "Type:",
					userContent: "Feedback:",
					result: "Result:",
					view: "View"
				}
			}
		},
		cart: {
			title: "Cart"
		},
		settings: {
			title: "Settings",
			cover: "Cover",
			avatar: "Avatar",
			email: "Email",
			notBound: "Unbound",
			modify: "Mod",
			bind: "Bind",
			collapse: "Hide",
			inputEmail: "New Email",
			phone: "Phone",
			inputPhone: "New Phone",
			nickname: "Nick",
			inputNickname: "New Nick",
			password: "Pwd",
			inputPassword: "New Pwd",
			passwordConfirm: "Confirm Pwd",
			social: "Social",
			error: {
				empty: "Empty",
				passwordConfirm: "Pwd mismatch"
			},
			bindSocial: {
				unbindSuccess: "Unbound",
				unbindConfirm: "Unbind?"
			},
			address: {
				title: "Address",
				editAddress: "Edit",
				addAddress: "Add",
				selectAddress: "Select",
				manualInput: "Manual",
				setDefault: "Set Def",
				"default": "Def",
				inputAddress: "Addr",
				country: "Region",
				selectCountry: "Select",
				province: "Prov",
				selectProvince: "Select",
				city: "City",
				selectCity: "Select",
				district: "Dist",
				selectDistrict: "Select",
				address: "Detail",
				phone: "Phone",
				inputPhone: "Phone",
				name: "Name",
				inputName: "Name",
				postalCode: "Zip",
				inputPostalCode: "Zip",
				success: "Saved",
				deleteConfirm: "Delete?",
				deleteSuccess: "Deleted"
			}
		}
	},
	notify: {
		title: "Pay Note",
		success: "Paid",
		desc: "Paid successfully! Details:",
		orderId: "Order #",
		amount: "Amt",
		status: "Status",
		productType: "Type",
		paymentMethod: "Method",
		currency: "Curr",
		home: "Home",
		product: "Prod",
		orders: "Orders",
		confirming: "Confirming...",
		failed: "Fail",
		failedDesc: "If paid, contact admin.",
		confirmingDesc: "Confirming, don't close.",
		productTitle: "Prod",
		orderCount: "Count",
		orderDate: "Date",
		continueShopping: "Shop More"
	}
};
const en = {
	common: common,
	header: header,
	footer: footer,
	page: page
};

export { common, en as default, footer, header, page };
