import { p as pageCache } from './nitro.mjs';

const getClients = async (event) => {
  const host = event.context.host;
  const settings = await pageCache.get("gq_page_settings", host);
  if (!settings) {
    return [];
  }
  let allowedHosts = settings.fontend_urls || "";
  allowedHosts = allowedHosts.split("\n").map((host2) => host2.trim());
  allowedHosts = allowedHosts.map((host2) => {
    return host2.replace(/https?:\/\//, "").replace(/\/$/, "");
  });
  return allowedHosts;
};

export { getClients as g };
