var global = {
	settings: {
		backgroundCSS: "var(--el-bg-color-page)",
		radius: "base"
	},
	box: {
		animation: false,
		animationIndex: "",
		backgroundCSS: "var(--el-bg-color)",
		margin: {
			top: 0,
			right: 0,
			bottom: 0,
			left: 0
		},
		color: "",
		padding: {
			top: 4,
			right: 4,
			bottom: 4,
			left: 4
		},
		radius: {
			topLeft: "small",
			topRight: "small",
			bottomLeft: "none",
			bottomRight: "none"
		},
		border: {
			top: false,
			right: false,
			bottom: false,
			left: false
		}
	}
};
var header = {
	backgroundColor: "var(--el-bg-color)",
	logoWidth: "90px",
	width: "76rem",
	textColor: "var(--el-text-color-regular)",
	textSize: "sm",
	position: "top",
	attrs: [
		"logo",
		"menu",
		"search",
		"darkMode",
		"locale",
		"user",
		"cart"
	],
	attrsPicked: [
		"logo",
		"menu",
		"search",
		"darkMode",
		"locale",
		"user",
		"cart"
	],
	userList: [
		{
			name: {
				"zh-hans": "通知",
				en: "Notification",
				es: "Notificaciones"
			},
			link: "/account/notification",
			icon: "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='1em' height='1em' viewBox='0 0 256 256'%3E%3Cpath fill='currentColor' d='M221.8 175.94c-5.55-9.56-13.8-36.61-13.8-71.94a80 80 0 1 0-160 0c0 35.34-8.26 62.38-13.81 71.94A16 16 0 0 0 48 200h40.81a40 40 0 0 0 78.38 0H208a16 16 0 0 0 13.8-24.06ZM128 216a24 24 0 0 1-22.62-16h45.24A24 24 0 0 1 128 216Zm-80-32c7.7-13.24 16-43.92 16-80a64 64 0 1 1 128 0c0 36.05 8.28 66.73 16 80Z'/%3E%3C/svg%3E"
		},
		{
			name: {
				"zh-hans": "我的订单",
				en: "My Orders",
				es: "Mis pedidos"
			},
			link: "/account/orders",
			icon: "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='1em' height='1em' viewBox='0 0 256 256'%3E%3Cpath fill='currentColor' d='M96 104a8 8 0 0 1 8-8h64a8 8 0 0 1 0 16h-64a8 8 0 0 1-8-8Zm8 40h64a8 8 0 0 0 0-16h-64a8 8 0 0 0 0 16Zm128 48a32 32 0 0 1-32 32H88a32 32 0 0 1-32-32V64a16 16 0 0 0-32 0c0 5.74 4.83 9.62 4.88 9.66A8 8 0 0 1 24 88a7.89 7.89 0 0 1-4.79-1.61C18.05 85.54 8 77.61 8 64a32 32 0 0 1 32-32h136a32 32 0 0 1 32 32v104h8a8 8 0 0 1 4.8 1.6c1.2.86 11.2 8.79 11.2 22.4ZM96.26 173.48A8.07 8.07 0 0 1 104 168h88V64a16 16 0 0 0-16-16H67.69A31.71 31.71 0 0 1 72 64v128a16 16 0 0 0 32 0c0-5.74-4.83-9.62-4.88-9.66a7.82 7.82 0 0 1-2.86-8.86ZM216 192a12.58 12.58 0 0 0-3.23-8h-94a26.92 26.92 0 0 1 1.21 8a31.82 31.82 0 0 1-4.29 16H200a16 16 0 0 0 16-16Z'/%3E%3C/svg%3E"
		},
		{
			name: {
				"zh-hans": "财富",
				en: "Wealth",
				es: "Riqueza"
			},
			link: "/account/wealth",
			icon: "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='1em' height='1em' viewBox='0 0 256 256'%3E%3Cpath fill='currentColor' d='M128 24a104 104 0 1 0 104 104A104.11 104.11 0 0 0 128 24Zm0 192a88 88 0 1 1 88-88a88.1 88.1 0 0 1-88 88Zm40-68a28 28 0 0 1-28 28h-4v8a8 8 0 0 1-16 0v-8h-16a8 8 0 0 1 0-16h36a12 12 0 0 0 0-24h-24a28 28 0 0 1 0-56h4v-8a8 8 0 0 1 16 0v8h16a8 8 0 0 1 0 16h-36a12 12 0 0 0 0 24h24a28 28 0 0 1 28 28Z'/%3E%3C/svg%3E"
		},
		{
			name: {
				"zh-hans": "设置",
				en: "Settings",
				es: "Configuración"
			},
			link: "/account/settings",
			icon: "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='1em' height='1em' viewBox='0 0 256 256'%3E%3Cpath fill='currentColor' d='M128 80a48 48 0 1 0 48 48a48.05 48.05 0 0 0-48-48Zm0 80a32 32 0 1 1 32-32a32 32 0 0 1-32 32Zm109.94-52.79a8 8 0 0 0-3.89-5.4l-29.83-17l-.12-33.62a8 8 0 0 0-2.83-6.08a111.91 111.91 0 0 0-36.72-20.67a8 8 0 0 0-6.46.59L128 41.85L97.88 25a8 8 0 0 0-6.47-.6a112.1 112.1 0 0 0-36.68 20.75a8 8 0 0 0-2.83 6.07l-.15 33.65l-29.83 17a8 8 0 0 0-3.89 5.4a106.47 106.47 0 0 0 0 41.56a8 8 0 0 0 3.89 5.4l29.83 17l.12 33.62a8 8 0 0 0 2.83 6.08a111.91 111.91 0 0 0 36.72 20.67a8 8 0 0 0 6.46-.59L128 214.15L158.12 231a7.91 7.91 0 0 0 3.9 1a8.09 8.09 0 0 0 2.57-.42a112.1 112.1 0 0 0 36.68-20.73a8 8 0 0 0 2.83-6.07l.15-33.65l29.83-17a8 8 0 0 0 3.89-5.4a106.47 106.47 0 0 0-.03-41.52Zm-15 34.91l-28.57 16.25a8 8 0 0 0-3 3c-.58 1-1.19 2.06-1.81 3.06a7.94 7.94 0 0 0-1.22 4.21l-.15 32.25a95.89 95.89 0 0 1-25.37 14.3L134 199.13a8 8 0 0 0-3.91-1h-3.83a8.08 8.08 0 0 0-4.1 1l-28.84 16.1A96 96 0 0 1 67.88 201l-.11-32.2a8 8 0 0 0-1.22-4.22c-.62-1-1.23-2-1.8-3.06a8.09 8.09 0 0 0-3-3.06l-28.6-16.29a90.49 90.49 0 0 1 0-28.26l28.52-16.28a8 8 0 0 0 3-3c.58-1 1.19-2.06 1.81-3.06a7.94 7.94 0 0 0 1.22-4.21l.15-32.25a95.89 95.89 0 0 1 25.37-14.3L122 56.87a8 8 0 0 0 4.1 1h3.64a8.08 8.08 0 0 0 4.1-1l28.84-16.1A96 96 0 0 1 188.12 55l.11 32.2a8 8 0 0 0 1.22 4.22c.62 1 1.23 2 1.8 3.06a8.09 8.09 0 0 0 3 3.06l28.6 16.29a90.49 90.49 0 0 1 .05 28.29Z'/%3E%3C/svg%3E"
		}
	],
	menus: [
		{
			name: {
				"zh-hans": "内页",
				en: "All",
				es: "Todo"
			},
			icon: "",
			sub: {
				html: "",
				list: [
				]
			},
			link: "/article/39428"
		},
		{
			name: {
				"zh-hans": "下拉菜单",
				en: "Product"
			},
			icon: "",
			sub: {
				html: "",
				list: [
					{
						name: {
							"zh-hans": "AI翻译",
							en: "AI Translate",
							es: "Traducción AI"
						},
						description: {
							"zh-hans": "提供AI翻译功能，您可以通过简单的命令完成翻译dfasdfsadfsadfsadfsadfasdfsadfsadf",
							en: "Provide AI translation function. You can complete the translation with a simple command",
							es: "Proporciona la función de traducción AI. Puedes completar la traducción con un comando simple"
						},
						icon: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjU2IDI1NiI+PHBhdGggZmlsbD0iY3VycmVudENvbG9yIiBkPSJNMTAzLjc3IDE4NS45NEMxMDMuMzggMTg3LjQ5IDkzLjYzIDIyNCA0MCAyMjRhOCA4IDAgMCAxLTgtOGMwLTUzLjYzIDM2LjUxLTYzLjM4IDM4LjA2LTYzLjc3YTggOCAwIDAgMSAzLjg4IDE1LjUzYy0uOS4yNS0yMi40MiA2LjU0LTI1LjU2IDM5Ljg2QzgxLjcgMjA0LjQ4IDg4IDE4MyA4OC4yNiAxODJhOCA4IDAgMCAxIDE1LjUxIDRabTkzLTY3LjRsLTQuNzcgNC43N3Y1OC4zM2ExNS45MSAxNS45MSAwIDAgMS00LjY4IDExLjM2TDE1MyAyMjcuM2ExNS45MSAxNS45MSAwIDAgMS0xMS4zIDQuN2ExNi4xMSAxNi4xMSAwIDAgMS01LjEtLjgzYTE1Ljk0IDE1Ljk0IDAgMCAxLTEwLjc4LTEyLjkybC01LjM3LTM4LjQ5bC00NC4yMS00NC4yMWwtMzguNDctNS4zN0ExNiAxNiAwIDAgMSAyOC43IDEwM0w2MyA2OC42OEExNS45MSAxNS45MSAwIDAgMSA3NC4zNiA2NGg1OC4zM2w0Ljc3LTQuNzdjMjYuNjgtMjYuNjcgNTguODMtMjcuODIgNzEuNDEtMjcuMDdhMTYgMTYgMCAwIDEgMTUgMTVjLjczIDEyLjU1LS40MiA0NC43LTI3LjA5IDcxLjM4Wk00MCAxMTQuMzRsMzcuMTUgNS4xOEwxMTYuNjkgODBINzQuMzZaTTkxLjMyIDEyOEwxMjggMTY0LjY4bDU3LjQ1LTU3LjQ1YTc2LjQ2IDc2LjQ2IDAgMCAwIDIyLjQyLTU5LjE2YTc2LjY1IDc2LjY1IDAgMCAwLTU5LjExIDIyLjQ3Wk0xNzYgMTM5LjMxbC0zOS41MyAzOS41M2w1LjIgMzcuMTZMMTc2IDE4MS42NFoiLz48L3N2Zz4=",
						link: "/"
					},
					{
						name: {
							"zh-hans": "AI编程",
							en: "AI Code",
							es: "Código AI"
						},
						description: {
							"zh-hans": "提供AI编程功能，您可以通过简单的命令完成编程",
							en: "Provide AI programming function. You can complete the programming with a simple command",
							es: "Proporciona la función de programación AI. Puedes completar el programa con un comando simple"
						},
						icon: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjU2IDI1NiI+PHBhdGggZmlsbD0iY3VycmVudENvbG9yIiBkPSJNMjAwIDQ4aC02NFYxNmE4IDggMCAwIDAtMTYgMHYzMkg1NmEzMiAzMiAwIDAgMC0zMiAzMnYxMTJhMzIgMzIgMCAwIDAgMzIgMzJoMTQ0YTMyIDMyIDAgMCAwIDMyLTMyVjgwYTMyIDMyIDAgMCAwLTMyLTMyWm0xNiAxNDRhMTYgMTYgMCAwIDEtMTYgMTZINTZhMTYgMTYgMCAwIDEtMTYtMTZWODBhMTYgMTYgMCAwIDEgMTYtMTZoMTQ0YTE2IDE2IDAgMCAxIDE2IDE2Wm0tNTItNTZIOTJhMjggMjggMCAwIDAgMCA1Nmg3MmEyOCAyOCAwIDAgMCAwLTU2Wm0tMjggMTZ2MjRoLTE2di0yNFptLTU2IDEyYTEyIDEyIDAgMCAxIDEyLTEyaDEydjI0SDkyYTEyIDEyIDAgMCAxLTEyLTEyWm04NCAxMmgtMTJ2LTI0aDEyYTEyIDEyIDAgMCAxIDAgMjRabS05Mi02OGExMiAxMiAwIDEgMSAxMiAxMmExMiAxMiAwIDAgMS0xMi0xMlptODggMGExMiAxMiAwIDEgMSAxMiAxMmExMiAxMiAwIDAgMS0xMi0xMloiLz48L3N2Zz4=",
						link: "/"
					},
					{
						name: {
							"zh-hans": "AI语音",
							en: "AI Voice",
							es: "Voz AI"
						},
						description: {
							"zh-hans": "提供AI语音功能，您可以通过简单的命令完成语音",
							en: "Provide AI voice function. You can complete the voice with a simple command",
							es: "Proporciona la función de voz AI. Puedes completar la voz con un comando simple"
						},
						icon: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjU2IDI1NiI+PHBhdGggZmlsbD0iY3VycmVudENvbG9yIiBkPSJNMjA4IDMySDQ4YTE2IDE2IDAgMCAwLTE2IDE2djE2MGExNiAxNiAwIDAgMCAxNiAxNmgxNjBhMTYgMTYgMCAwIDAgMTYtMTZWNDhhMTYgMTYgMCAwIDAtMTYtMTZtMCAxNzZINDhWNDhoMTYwek03MiA3NmExMiAxMiAwIDEgMSAxMiAxMmExMiAxMiAwIDAgMS0xMi0xMm00NCAwYTEyIDEyIDAgMSAxIDEyIDEyYTEyIDEyIDAgMCAxLTEyLTEybTQ0IDBhMTIgMTIgMCAxIDEgMTIgMTJhMTIgMTIgMCAwIDEtMTItMTJtMjQgMjhINzJhOCA4IDAgMCAwLTggOHY3MmE4IDggMCAwIDAgOCA4aDExMmE4IDggMCAwIDAgOC04di03MmE4IDggMCAwIDAtOC04bS04IDcySDgwdi01Nmg5NloiLz48L3N2Zz4=",
						link: "/"
					},
					{
						name: {
							"zh-hans": "AI绘图",
							en: "AI Draw",
							es: "Dibujo AI"
						},
						description: {
							"zh-hans": "提供AI绘画功能，您可以通过简单的命令完成绘图",
							en: "Provide AI drawing function. You can complete the drawing with a simple command",
							es: "Proporciona la función de dibujo AI. Puedes completar el dibujo con un comando simple"
						},
						icon: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjU2IDI1NiI+PHBhdGggZmlsbD0iY3VycmVudENvbG9yIiBkPSJNMjAxLjU0IDU0LjQ2QTEwNCAxMDQgMCAwIDAgNTQuNDYgMjAxLjU0QTEwNCAxMDQgMCAwIDAgMjAxLjU0IDU0LjQ2Wk04OCAyMDYuMzdWMTc2aDgwdjMwLjM3YTg4LjM4IDg4LjM4IDAgMCAxLTgwIDBaTTEwNCAxNDRoNDh2MTZoLTQ4Wm0xNC0xNmwxMC00OGwxMCA0OFptNzIuMjIgNjIuMjNjLTIgMi00LjA4IDMuODctNi4yMiA1LjY0VjE3NmExNiAxNiAwIDAgMC0xNi0xNnYtMTZhMTYgMTYgMCAwIDAtMTMuNjEtMTUuOGwtMTAuNzMtNTEuNDZhMTYgMTYgMCAwIDAtMzEuMzIgMGwtMTAuNzMgNTEuNDZBMTYgMTYgMCAwIDAgODggMTQ0djE2YTE2IDE2IDAgMCAwLTE2IDE2djE5Ljg3YTg4LjkxNyA4OC45MTcgMCAwIDEtNi4yMi01LjY0YTg4IDg4IDAgMSAxIDEyNC40NCAwWiIvPjwvc3ZnPg==",
						link: "/"
					},
					{
						name: {
							"zh-hans": "AI写作",
							en: "AI Write",
							es: "Escritura AI"
						},
						description: {
							"zh-hans": "提供AI写作功能，您可以通过简单的命令完成写作",
							en: "Provide AI writing function. You can complete the writing with a simple command",
							es: "Proporciona la función de escritura AI. Puedes completar la escritura con un comando simple"
						},
						icon: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjU2IDI1NiI+PHBhdGggZmlsbD0iY3VycmVudENvbG9yIiBkPSJNMjMyIDMyYTggOCAwIDAgMC04LThjLTQ0LjA4IDAtODkuMzEgNDkuNzEtMTE0LjQzIDgyLjYzQTYwIDYwIDAgMCAwIDMyIDE2NGMwIDMwLjg4LTE5LjU0IDQ0LjczLTIwLjQ3IDQ1LjM3QTggOCAwIDAgMCAxNiAyMjRoNzZhNjAgNjAgMCAwIDAgNTcuMzctNzcuNTdDMTgyLjMgMTIxLjMxIDIzMiA3Ni4wOCAyMzIgMzJaTTkyIDIwOEgzNC42M0M0MS4zOCAxOTguNDEgNDggMTgzLjkyIDQ4IDE2NGE0NCA0NCAwIDEgMSA0NCA0NFptMzIuNDItOTQuNDVxNS4xNC02LjY2IDEwLjA5LTEyLjU1QTc2LjIzIDc2LjIzIDAgMCAxIDE1NSAxMjEuNDlxLTUuOSA0Ljk0LTEyLjU1IDEwLjA5YTYwLjU0IDYwLjU0IDAgMCAwLTE4LjAzLTE4LjAzWm00Mi43LTIuNjhhOTIuNTcgOTIuNTcgMCAwIDAtMjItMjJjMzEuNzgtMzQuNTMgNTUuNzUtNDUgNjkuOS00Ny45MWMtMi44NSAxNC4xNi0xMy4zNyAzOC4xMy00Ny45IDY5LjkxWiIvPjwvc3ZnPg==",
						link: "/"
					}
				]
			},
			link: "/"
		},
		{
			name: {
				"zh-hans": "存档页",
				en: "Market",
				es: "Mercado"
			},
			sub: {
				html: "",
				list: [
				]
			},
			link: "/archive/1"
		},
		{
			name: {
				"zh-hans": "讨论",
				en: "community",
				es: ""
			},
			sub: {
				html: "",
				list: [
				]
			},
			link: "/builder"
		},
		{
			name: {
				"zh-hans": "工作",
				en: "Job"
			},
			sub: {
				html: "",
				list: [
					{
						name: {
							"zh-hans": "AI绘图",
							en: "AI Draw"
						},
						description: {
							"zh-hans": "",
							en: ""
						},
						icon: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjU2IDI1NiI+PHBhdGggZmlsbD0iY3VycmVudENvbG9yIiBkPSJNMjMyIDMyYTggOCAwIDAgMC04LThjLTQ0LjA4IDAtODkuMzEgNDkuNzEtMTE0LjQzIDgyLjYzQTYwIDYwIDAgMCAwIDMyIDE2NGMwIDMwLjg4LTE5LjU0IDQ0LjczLTIwLjQ3IDQ1LjM3QTggOCAwIDAgMCAxNiAyMjRoNzZhNjAgNjAgMCAwIDAgNTcuMzctNzcuNTdDMTgyLjMgMTIxLjMxIDIzMiA3Ni4wOCAyMzIgMzJaTTkyIDIwOEgzNC42M0M0MS4zOCAxOTguNDEgNDggMTgzLjkyIDQ4IDE2NGE0NCA0NCAwIDEgMSA0NCA0NFptMzIuNDItOTQuNDVxNS4xNC02LjY2IDEwLjA5LTEyLjU1QTc2LjIzIDc2LjIzIDAgMCAxIDE1NSAxMjEuNDlxLTUuOSA0Ljk0LTEyLjU1IDEwLjA5YTYwLjU0IDYwLjU0IDAgMCAwLTE4LjAzLTE4LjAzWm00Mi43LTIuNjhhOTIuNTcgOTIuNTcgMCAwIDAtMjItMjJjMzEuNzgtMzQuNTMgNTUuNzUtNDUgNjkuOS00Ny45MWMtMi44NSAxNC4xNi0xMy4zNyAzOC4xMy00Ny45IDY5LjkxWiIvPjwvc3ZnPg==",
						link: "/"
					},
					{
						name: {
							"zh-hans": "AI写作",
							en: "AI Write"
						},
						description: {
							"zh-hans": "",
							en: ""
						},
						icon: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjU2IDI1NiI+PHBhdGggZmlsbD0iY3VycmVudENvbG9yIiBkPSJNMjMyIDMyYTggOCAwIDAgMC04LThjLTQ0LjA4IDAtODkuMzEgNDkuNzEtMTE0LjQzIDgyLjYzQTYwIDYwIDAgMCAwIDMyIDE2NGMwIDMwLjg4LTE5LjU0IDQ0LjczLTIwLjQ3IDQ1LjM3QTggOCAwIDAgMCAxNiAyMjRoNzZhNjAgNjAgMCAwIDAgNTcuMzctNzcuNTdDMTgyLjMgMTIxLjMxIDIzMiA3Ni4wOCAyMzIgMzJaTTkyIDIwOEgzNC42M0M0MS4zOCAxOTguNDEgNDggMTgzLjkyIDQ4IDE2NGE0NCA0NCAwIDEgMSA0NCA0NFptMzIuNDItOTQuNDVxNS4xNC02LjY2IDEwLjA5LTEyLjU1QTc2LjIzIDc2LjIzIDAgMCAxIDE1NSAxMjEuNDlxLTUuOSA0Ljk0LTEyLjU1IDEwLjA5YTYwLjU0IDYwLjU0IDAgMCAwLTE4LjAzLTE4LjAzWm00Mi43LTIuNjhhOTIuNTcgOTIuNTcgMCAwIDAtMjItMjJjMzEuNzgtMzQuNTMgNTUuNzUtNDUgNjkuOS00Ny45MWMtMi44NSAxNC4xNi0xMy4zNyAzOC4xMy00Ny45IDY5LjkxWiIvPjwvc3ZnPg==",
						link: "/"
					},
					{
						name: {
							"zh-hans": "AI翻译",
							en: "AI Translate"
						},
						description: {
							"zh-hans": "",
							en: ""
						},
						icon: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjU2IDI1NiI+PHBhdGggZmlsbD0iY3VycmVudENvbG9yIiBkPSJNMTAzLjc3IDE4NS45NEMxMDMuMzggMTg3LjQ5IDkzLjYzIDIyNCA0MCAyMjRhOCA4IDAgMCAxLTgtOGMwLTUzLjYzIDM2LjUxLTYzLjM4IDM4LjA2LTYzLjc3YTggOCAwIDAgMSAzLjg4IDE1LjUzYy0uOS4yNS0yMi40MiA2LjU0LTI1LjU2IDM5Ljg2QzgxLjcgMjA0LjQ4IDg4IDE4MyA4OC4yNiAxODJhOCA4IDAgMCAxIDE1LjUxIDRabTkzLTY3LjRsLTQuNzcgNC43N3Y1OC4zM2ExNS45MSAxNS45MSAwIDAgMS00LjY4IDExLjM2TDE1MyAyMjcuM2ExNS45MSAxNS45MSAwIDAgMS0xMS4zIDQuN2ExNi4xMSAxNi4xMSAwIDAgMS01LjEtLjgzYTE1Ljk0IDE1Ljk0IDAgMCAxLTEwLjc4LTEyLjkybC01LjM3LTM4LjQ5bC00NC4yMS00NC4yMWwtMzguNDctNS4zN0ExNiAxNiAwIDAgMSAyOC43IDEwM0w2MyA2OC42OEExNS45MSAxNS45MSAwIDAgMSA3NC4zNiA2NGg1OC4zM2w0Ljc3LTQuNzdjMjYuNjgtMjYuNjcgNTguODMtMjcuODIgNzEuNDEtMjcuMDdhMTYgMTYgMCAwIDEgMTUgMTVjLjczIDEyLjU1LS40MiA0NC43LTI3LjA5IDcxLjM4Wk00MCAxMTQuMzRsMzcuMTUgNS4xOEwxMTYuNjkgODBINzQuMzZaTTkxLjMyIDEyOEwxMjggMTY0LjY4bDU3LjQ1LTU3LjQ1YTc2LjQ2IDc2LjQ2IDAgMCAwIDIyLjQyLTU5LjE2YTc2LjY1IDc2LjY1IDAgMCAwLTU5LjExIDIyLjQ3Wk0xNzYgMTM5LjMxbC0zOS41MyAzOS41M2w1LjIgMzcuMTZMMTc2IDE4MS42NFoiLz48L3N2Zz4=",
						link: "/"
					},
					{
						name: {
							"zh-hans": "AI编程",
							en: "AI Code"
						},
						description: {
							"zh-hans": "",
							en: ""
						},
						icon: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjU2IDI1NiI+PHBhdGggZmlsbD0iY3VycmVudENvbG9yIiBkPSJNMjAwIDQ4aC02NFYxNmE4IDggMCAwIDAtMTYgMHYzMkg1NmEzMiAzMiAwIDAgMC0zMiAzMnYxMTJhMzIgMzIgMCAwIDAgMzIgMzJoMTQ0YTMyIDMyIDAgMCAwIDMyLTMyVjgwYTMyIDMyIDAgMCAwLTMyLTMyWm0xNiAxNDRhMTYgMTYgMCAwIDEtMTYgMTZINTZhMTYgMTYgMCAwIDEtMTYtMTZWODBhMTYgMTYgMCAwIDEgMTYtMTZoMTQ0YTE2IDE2IDAgMCAxIDE2IDE2Wm0tNTItNTZIOTJhMjggMjggMCAwIDAgMCA1Nmg3MmEyOCAyOCAwIDAgMCAwLTU2Wm0tMjggMTZ2MjRoLTE2di0yNFptLTU2IDEyYTEyIDEyIDAgMCAxIDEyLTEyaDEydjI0SDkyYTEyIDEyIDAgMCAxLTEyLTEyWm04NCAxMmgtMTJ2LTI0aDEyYTEyIDEyIDAgMCAxIDAgMjRabS05Mi02OGExMiAxMiAwIDEgMSAxMiAxMmExMiAxMiAwIDAgMS0xMi0xMlptODggMGExMiAxMiAwIDEgMSAxMiAxMmExMiAxMiAwIDAgMS0xMi0xMloiLz48L3N2Zz4=",
						link: "/"
					},
					{
						name: {
							"zh-hans": "AI语音",
							en: "AI Voice"
						},
						description: {
							"zh-hans": "",
							en: ""
						},
						icon: "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxZW0iIGhlaWdodD0iMWVtIiB2aWV3Qm94PSIwIDAgMjU2IDI1NiI+PHBhdGggZmlsbD0iY3VycmVudENvbG9yIiBkPSJNMjA4IDMySDQ4YTE2IDE2IDAgMCAwLTE2IDE2djE2MGExNiAxNiAwIDAgMCAxNiAxNmgxNjBhMTYgMTYgMCAwIDAgMTYtMTZWNDhhMTYgMTYgMCAwIDAtMTYtMTZtMCAxNzZINDhWNDhoMTYwek03MiA3NmExMiAxMiAwIDEgMSAxMiAxMmExMiAxMiAwIDAgMS0xMi0xMm00NCAwYTEyIDEyIDAgMSAxIDEyIDEyYTEyIDEyIDAgMCAxLTEyLTEybTQ0IDBhMTIgMTIgMCAxIDEgMTIgMTJhMTIgMTIgMCAwIDEtMTItMTJtMjQgMjhINzJhOCA4IDAgMCAwLTggOHY3MmE4IDggMCAwIDAgOCA4aDExMmE4IDggMCAwIDAgOC04di03MmE4IDggMCAwIDAtOC04bS04IDcySDgwdi01Nmg5NloiLz48L3N2Zz4=",
						link: "/"
					}
				]
			},
			link: "/"
		},
		{
			name: {
				"zh-hans": "个人中心",
				en: "Task"
			},
			sub: {
				html: "",
				list: [
				]
			},
			link: "/profile/1"
		}
	],
	search: {
	}
};
var footer = {
	backgroundColor: "#ffffff",
	width: "76rem",
	textColor: "#303133",
	textSize: "sm",
	attrs: [
		"logo",
		"menu",
		"search",
		"download",
		"darkMode",
		"locale",
		"user",
		"cart"
	],
	attrsPicked: [
		"logo",
		"menu",
		"search",
		"download",
		"darkMode",
		"locale",
		"user",
		"cart"
	],
	textHtmlLastRow: "<div>Made by ruchun © 2025</div><div class='text-xs opacity-80'> All success originates from a courageous beginning </div><div class='text-xs opacity-80'>京ICP备2024000000号-1</div>"
};
var pages = {
	page: {
		custom: {
			slug: "",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		},
		single: {
			slug: "page",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		}
	},
	article: {
		single: {
			slug: "article",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		},
		archive: {
			slug: "archive",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		},
		tag: {
			slug: "article-tag",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		}
	},
	shop: {
		single: {
			slug: "product",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		},
		archive: {
			slug: "collections",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		},
		tag: {
			slug: "product-tag",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		}
	},
	community: {
		single: {
			slug: "topic",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		},
		archive: {
			slug: "node",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		},
		tag: {
			slug: "topic-tag",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		},
		answer: {
			slug: "answer",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		}
	},
	docs: {
		single: {
			slug: "docs",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		},
		archive: {
			slug: "docs-archive",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		}
	},
	profile: {
		single: {
			slug: "profile",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		}
	}
};
var modules = {
	page: {
		custom: [
			{
				ids: [
				],
				id: "KPB989L5",
				data: [
					{
						id: "BLKEOQX1",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		],
		single: [
			{
				ids: [
				],
				id: "KPB989L2",
				data: [
					{
						id: "BLKEOQX2",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		]
	},
	article: {
		single: [
			{
				ids: [
				],
				id: "KPB989L4",
				data: [
					{
						id: "BLKEOQX4",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						]
					}
				]
			}
		],
		archive: [
			{
				ids: [
				],
				id: "KPB989L3",
				data: [
					{
						id: "BLKEOQX3",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		],
		tag: [
			{
				ids: [
				],
				id: "KPB989L5",
				data: [
					{
						id: "BLKEOQX5",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		]
	},
	shop: {
		single: [
			{
				ids: [
				],
				id: "KPB989L7",
				data: [
					{
						id: "BLKEOQX7",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		],
		archive: [
			{
				ids: [
				],
				id: "KPB989L6",
				data: [
					{
						id: "BLKEOQX6",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		],
		tag: [
			{
				ids: [
				],
				id: "KPB989L8",
				data: [
					{
						id: "BLKEOQX8",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		]
	},
	community: {
		single: [
			{
				ids: [
				],
				id: "KPB98910",
				data: [
					{
						id: "BLKEOQ10",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		],
		archive: [
			{
				ids: [
				],
				id: "KPB989L9",
				data: [
					{
						id: "BLKEOQX9",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		],
		tag: [
			{
				ids: [
				],
				id: "KPB98911",
				data: [
					{
						id: "BLKEOQ11",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		],
		answer: [
			{
				ids: [
				],
				id: "KPB38912",
				data: [
					{
						id: "BLKEO211",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		]
	},
	profile: {
		single: [
			{
				ids: [
				],
				id: "KPB989L4",
				data: [
					{
						id: "BLKEOQX4",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		],
		archive: [
			{
				ids: [
				],
				id: "KPB989L3",
				data: [
					{
						id: "BLKEOQX3",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		]
	},
	docs: {
		single: [
			{
				ids: [
				],
				id: "KPB98913",
				data: [
					{
						id: "BLKEOQ13",
						settings: {
							gap: 4,
							width: "100%",
							widthInner: "64rem",
							height: "auto",
							widget: {
								show: true,
								width: 28
							},
							backgroundCSS: "",
							margin: {
								top: 4,
								right: 0,
								bottom: 0,
								left: 0
							},
							color: "",
							padding: {
								top: 0,
								right: 0,
								bottom: 0,
								left: 0
							},
							radius: {
								topLeft: "none",
								topRight: "none",
								bottomLeft: "none",
								bottomRight: "none"
							},
							border: {
								top: false,
								right: false,
								bottom: false,
								left: false
							}
						},
						modules: [
						],
						widgets: [
						],
						widgetsLeft: [
						]
					}
				]
			}
		],
		archive: {
			slug: "docs-archive",
			list: [
				{
					type: "default",
					ids: [
					]
				}
			]
		}
	}
};

export { footer as f, global as g, header as h, modules as m, pages as p };
