import { P as withInstall, D as useLocale, C as useNamespace, ab as useThrottleFn$1, L as isNumber$1, a0 as buildProps, a2 as definePropType, a7 as mutable } from './server.mjs';
import { mergeProps, withCtx, createVNode, defineComponent, useAttrs, computed, ref, watch, openBlock, createElementBlock, unref, renderSlot, createElementVNode, normalizeClass, toDisplayString, Fragment, createCommentVNode, createBlock, createSlots, normalizeProps, guardReactiveProps, useSSRContext } from 'vue';
import { fromPairs } from 'lodash-unified';
import { E as ElImageViewer } from './image-viewer-DG2qIWb8.mjs';
import { u as useAttrs$1 } from './index-BKB3Djp4.mjs';
import { isArray } from '@vue/shared';
import { ssrRenderComponent } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './index-ChPMoinw.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import './index-Di0Jlzch.mjs';

const imageProps = buildProps({
  /**
   * @description when enabling preview, use this flag to control whether clicking on backdrop can exit preview mode.
   */
  hideOnClickModal: Boolean,
  /**
   * @description image source, same as native.
   */
  src: {
    type: String,
    default: ""
  },
  /**
   * @description indicate how the image should be resized to fit its container, same as [object-fit](https://developer.mozilla.org/en-US/docs/Web/CSS/object-fit).
   */
  fit: {
    type: String,
    values: ["", "contain", "cover", "fill", "none", "scale-down"],
    default: ""
  },
  /**
   * @description Indicates how the browser should load the image, same as [native](https://developer.mozilla.org/en-US/docs/Web/HTML/Reference/Elements/img#loading)
   */
  loading: {
    type: String,
    values: ["eager", "lazy"]
  },
  /**
   * @description whether to use lazy load.
   */
  lazy: Boolean,
  /**
   * @description the container to add scroll listener when using lazy load.
   */
  scrollContainer: {
    type: definePropType([String, Object])
  },
  /**
   * @description allow big image preview.
   */
  previewSrcList: {
    type: definePropType(Array),
    default: () => mutable([])
  },
  /**
   * @description whether to append image-viewer to body. A nested parent element attribute transform should have this attribute set to `true`.
   */
  previewTeleported: Boolean,
  /**
   * @description set image preview z-index.
   */
  zIndex: {
    type: Number
  },
  /**
   * @description initial preview image index, less than the length of `url-list`.
   */
  initialIndex: {
    type: Number,
    default: 0
  },
  /**
   * @description whether the viewer preview is infinite.
   */
  infinite: {
    type: Boolean,
    default: true
  },
  /**
   * @description whether the image-viewer can be closed by pressing ESC.
   */
  closeOnPressEscape: {
    type: Boolean,
    default: true
  },
  /**
   * @description the zoom rate of the image viewer zoom event
   */
  zoomRate: {
    type: Number,
    default: 1.2
  },
  /**
   * @description preview image scale.
   */
  scale: {
    type: Number,
    default: 1
  },
  /**
   * @description the min scale of the image viewer zoom event.
   */
  minScale: {
    type: Number,
    default: 0.2
  },
  /**
   * @description the max scale of the image viewer zoom event.
   */
  maxScale: {
    type: Number,
    default: 7
  },
  /**
   * @description show preview image progress content.
   */
  showProgress: Boolean,
  /**
   * @description set HTML attribute: crossorigin.
   */
  crossorigin: {
    type: definePropType(String)
  }
});
const imageEmits = {
  load: (evt) => evt instanceof Event,
  error: (evt) => evt instanceof Event,
  switch: (val) => isNumber$1(val),
  close: () => true,
  show: () => true
};
const _hoisted_1 = ["src", "loading", "crossorigin"];
const _hoisted_2 = { key: 0 };
var _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElImage",
    inheritAttrs: false
  },
  __name: "image",
  props: imageProps,
  emits: imageEmits,
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const { t } = useLocale();
    const ns = useNamespace("image");
    const rawAttrs = useAttrs();
    const containerAttrs = computed(() => {
      return fromPairs(
        Object.entries(rawAttrs).filter(
          ([key]) => /^(data-|on[A-Z])/i.test(key) || ["id", "style"].includes(key)
        )
      );
    });
    const imgAttrs = useAttrs$1({
      excludeListeners: true,
      excludeKeys: computed(() => {
        return Object.keys(containerAttrs.value);
      })
    });
    const imageSrc = ref();
    const hasLoadError = ref(false);
    const isLoading = ref(true);
    const showViewer = ref(false);
    const container = ref();
    ref();
    const imageKls = computed(() => [
      ns.e("inner"),
      preview.value && ns.e("preview"),
      isLoading.value && ns.is("loading")
    ]);
    const imageStyle = computed(() => {
      const { fit } = props;
      return {};
    });
    const preview = computed(() => {
      const { previewSrcList } = props;
      return isArray(previewSrcList) && previewSrcList.length > 0;
    });
    const imageIndex = computed(() => {
      const { previewSrcList, initialIndex } = props;
      let previewIndex = initialIndex;
      if (initialIndex > previewSrcList.length - 1) {
        previewIndex = 0;
      }
      return previewIndex;
    });
    const isManual = computed(() => {
      if (props.loading === "eager") return false;
      return props.loading === "lazy" || props.lazy;
    });
    function handleLoad(event) {
      isLoading.value = false;
      hasLoadError.value = false;
      emit("load", event);
    }
    function handleError(event) {
      isLoading.value = false;
      hasLoadError.value = true;
      emit("error", event);
    }
    function handleLazyLoad(isIntersecting) {
    }
    useThrottleFn$1(handleLazyLoad, 200, true);
    async function addLazyLoadListener() {
      return;
    }
    function clickHandler() {
      if (!preview.value) return;
      showViewer.value = true;
      emit("show");
    }
    function closeViewer() {
      showViewer.value = false;
      emit("close");
    }
    function switchViewer(val) {
      emit("switch", val);
    }
    watch(
      () => props.src,
      () => {
        if (isManual.value) {
          isLoading.value = true;
          hasLoadError.value = false;
          addLazyLoadListener();
        }
      }
    );
    __expose({
      /** @description manually open preview */
      showPreview: clickHandler
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        mergeProps({
          ref_key: "container",
          ref: container
        }, containerAttrs.value, {
          class: [unref(ns).b(), _ctx.$attrs.class]
        }),
        [
          hasLoadError.value ? renderSlot(_ctx.$slots, "error", { key: 0 }, () => [
            createElementVNode(
              "div",
              {
                class: normalizeClass(unref(ns).e("error"))
              },
              toDisplayString(unref(t)("el.image.error")),
              3
              /* TEXT, CLASS */
            )
          ]) : (openBlock(), createElementBlock(
            Fragment,
            { key: 1 },
            [
              imageSrc.value !== void 0 ? (openBlock(), createElementBlock("img", mergeProps({ key: 0 }, unref(imgAttrs), {
                src: imageSrc.value,
                loading: __props.loading,
                style: imageStyle.value,
                class: imageKls.value,
                crossorigin: __props.crossorigin,
                onClick: clickHandler,
                onLoad: handleLoad,
                onError: handleError
              }), null, 16, _hoisted_1)) : createCommentVNode("v-if", true),
              isLoading.value ? (openBlock(), createElementBlock(
                "div",
                {
                  key: 1,
                  class: normalizeClass(unref(ns).e("wrapper"))
                },
                [
                  renderSlot(_ctx.$slots, "placeholder", {}, () => [
                    createElementVNode(
                      "div",
                      {
                        class: normalizeClass(unref(ns).e("placeholder"))
                      },
                      null,
                      2
                      /* CLASS */
                    )
                  ])
                ],
                2
                /* CLASS */
              )) : createCommentVNode("v-if", true)
            ],
            64
            /* STABLE_FRAGMENT */
          )),
          preview.value ? (openBlock(), createElementBlock(
            Fragment,
            { key: 2 },
            [
              showViewer.value ? (openBlock(), createBlock(unref(ElImageViewer), {
                key: 0,
                "z-index": __props.zIndex,
                "initial-index": imageIndex.value,
                infinite: __props.infinite,
                "zoom-rate": __props.zoomRate,
                "min-scale": __props.minScale,
                "max-scale": __props.maxScale,
                "show-progress": __props.showProgress,
                "url-list": __props.previewSrcList,
                scale: __props.scale,
                crossorigin: __props.crossorigin,
                "hide-on-click-modal": __props.hideOnClickModal,
                teleported: __props.previewTeleported,
                "close-on-press-escape": __props.closeOnPressEscape,
                onClose: closeViewer,
                onSwitch: switchViewer
              }, createSlots({
                toolbar: withCtx((toolbar) => [
                  renderSlot(_ctx.$slots, "toolbar", normalizeProps(guardReactiveProps(toolbar)))
                ]),
                default: withCtx(() => [
                  _ctx.$slots.viewer ? (openBlock(), createElementBlock("div", _hoisted_2, [
                    renderSlot(_ctx.$slots, "viewer")
                  ])) : createCommentVNode("v-if", true)
                ]),
                _: 2
                /* DYNAMIC */
              }, [
                _ctx.$slots.progress ? {
                  name: "progress",
                  fn: withCtx((progress) => [
                    renderSlot(_ctx.$slots, "progress", normalizeProps(guardReactiveProps(progress)))
                  ]),
                  key: "0"
                } : void 0,
                _ctx.$slots["viewer-error"] ? {
                  name: "viewer-error",
                  fn: withCtx((viewerError) => [
                    renderSlot(_ctx.$slots, "viewer-error", normalizeProps(guardReactiveProps(viewerError)))
                  ]),
                  key: "1"
                } : void 0
              ]), 1032, ["z-index", "initial-index", "infinite", "zoom-rate", "min-scale", "max-scale", "show-progress", "url-list", "scale", "crossorigin", "hide-on-click-modal", "teleported", "close-on-press-escape"])) : createCommentVNode("v-if", true)
            ],
            64
            /* STABLE_FRAGMENT */
          )) : createCommentVNode("v-if", true)
        ],
        16
        /* FULL_PROPS */
      );
    };
  }
});
const ElImage = withInstall(_sfc_main$1);
const _sfc_main = {
  __name: "Image",
  __ssrInlineRender: true,
  props: {
    src: {
      type: String,
      default: ""
    }
  },
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_image = ElImage;
      _push(ssrRenderComponent(_component_el_image, mergeProps({
        decoding: "async",
        fit: "cover",
        lazy: true,
        src: __props.src,
        key: __props.src,
        class: "fade-in-image bg-[--el-color-info-light-10]"
      }, _attrs), {
        error: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-center justify-center w-full h-full bg-[--el-color-info-light-10]" data-v-0ddeddce${_scopeId}><i class="i-ph-image-thin opacity-30 gq-gs" data-v-0ddeddce${_scopeId}></i></div>`);
          } else {
            return [
              createVNode("div", { class: "flex items-center justify-center w-full h-full bg-[--el-color-info-light-10]" }, [
                createVNode("i", { class: "i-ph-image-thin opacity-30 gq-gs" })
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/Image.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_4 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-0ddeddce"]]);
const Image = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: __nuxt_component_4
}, Symbol.toStringTag, { value: "Module" }));

export { ElImage as E, Image as I, __nuxt_component_4 as _ };
