import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import { v as vLoading } from './directive-BPPM1aUC.mjs';
import { g as getServerSettings, r as useRequest, E as ElMessage } from './server.mjs';
import { useSSRContext, ref, computed, reactive, nextTick, mergeProps, unref, withCtx, createTextVNode, createVNode, openBlock, createBlock, createCommentVNode, toDisplayString, Fragment, renderList, withDirectives } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderStyle, ssrRenderList, ssrRenderClass, ssrInterpolate, ssrGetDirectiveProps } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './event-BZTOGHfp.mjs';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import './index-ChPMoinw.mjs';
import './index-BKB3Djp4.mjs';
import './index-Bp-nwGzu.mjs';
import './aria-BhThsKez.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonTopicFormTags",
  __ssrInlineRender: true,
  props: ["data", "settings", "editor", "id", "action"],
  setup(__props) {
    const props = __props;
    const serverSettings = getServerSettings();
    const searchInputRef = ref(null);
    const createInputRef = ref(null);
    const list = computed(() => {
      if (state.show == "search") {
        return state.searchList?.edges;
      } else if (state.show == "all") {
        return state.allHotList?.edges;
      } else {
        return state.weekHotList?.edges;
      }
    });
    const moreButton = computed(() => {
      if (state.show == "search") {
        if (state.searchList?.edges && state.searchList?.edges?.length == 0) {
          return {
            show: false
          };
        }
        if (!state.searchList?.edges) {
          return {
            show: false
          };
        }
        if (state.searchList?.pageInfo?.hasNextPage) {
          return {
            text: state.moreLocked ? "加载中..." : "加载更多",
            disabled: false,
            show: true
          };
        }
        if (!state.searchList?.pageInfo?.hasNextPage) {
          return {
            text: "没有更多了",
            disabled: true,
            show: true
          };
        }
      }
      if (state.show == "week") {
        if (state.weekHotList?.edges && state.weekHotList?.edges?.length == 0) {
          return {
            show: false
          };
        }
        if (!state.weekHotList?.edges) {
          return {
            show: false
          };
        }
        if (state.weekHotList?.pageInfo?.hasNextPage) {
          return {
            text: state.moreLocked ? "加载中..." : "加载更多",
            disabled: false,
            show: true
          };
        }
        if (!state.weekHotList?.pageInfo?.hasNextPage) {
          return {
            text: "没有更多了",
            disabled: true,
            show: true
          };
        }
      }
      if (state.show == "all") {
        if (state.allHotList?.edges && state.allHotList?.edges?.length == 0) {
          return {
            show: false
          };
        }
        if (!state.allHotList?.edges) {
          return {
            show: false
          };
        }
        if (state.allHotList?.pageInfo?.hasNextPage) {
          return {
            text: state.moreLocked ? "加载中..." : "加载更多",
            disabled: false,
            show: true
          };
        }
        if (!state.allHotList?.pageInfo?.hasNextPage) {
          return {
            text: "没有更多了",
            disabled: true,
            show: true
          };
        }
      }
      return {
        show: false
      };
    });
    const state = reactive({
      searchList: null,
      weekHotList: null,
      allHotList: null,
      key: "",
      oldKey: "",
      createName: "",
      locked: false,
      loading: false,
      moreLocked: false,
      show: "week",
      orderby: "WEEK_HOT",
      showAction: async (type) => {
        state.show = type;
        if (state.show == "search") {
          nextTick(() => {
            searchInputRef.value.focus();
          });
        }
        if (state.show == "create") {
          nextTick(() => {
            createInputRef.value.focus();
          });
        }
        if (state.show == "all" && !state.allHotList) {
          await state.getAllHotTags(false);
        }
        if (state.show == "week" && !state.weekHotList) {
          await state.getWeekHotTags(false);
        }
      },
      loadMore: async () => {
        state.moreLocked = true;
        if (state.show == "search") {
          await state.getSearchTags(true);
        }
        if (state.show == "week") {
          await state.getWeekHotTags(true);
        }
        if (state.show == "all") {
          await state.getAllHotTags(true);
        }
        state.moreLocked = false;
      },
      getAllHotTags: async (loadMore) => {
        if (state.locked) return;
        state.locked = true;
        const res = await state.getTags({
          type: "COMMUNITYTAG",
          search: state.key,
          orderby: "COUNT",
          after: loadMore ? state.allHotList?.pageInfo?.endCursor : null
        });
        if (res) {
          if (!loadMore || !state.allHotList) {
            state.allHotList = res;
          } else {
            state.allHotList.edges.push(...res.edges);
            state.allHotList.pageInfo = res.pageInfo;
          }
        }
        state.locked = false;
      },
      getWeekHotTags: async (loadMore) => {
        if (state.locked) return;
        state.locked = true;
        const res = await state.getTags({
          type: "COMMUNITYTAG",
          search: state.key,
          orderby: "WEEK_HOT",
          after: loadMore ? state.weekHotList?.pageInfo?.endCursor : null
        });
        if (res) {
          if (!loadMore || !state.weekHotList) {
            state.weekHotList = res;
          } else {
            state.weekHotList.edges.push(...res.edges);
            state.weekHotList.pageInfo = res.pageInfo;
          }
        }
        state.locked = false;
      },
      getSearchTags: async (loadMore) => {
        if (!state.key) {
          return;
        }
        state.oldKey = state.key;
        if (state.locked) return;
        state.locked = true;
        const res = await state.getTags({
          type: "COMMUNITYTAG",
          search: state.key,
          orderby: "COUNT",
          after: loadMore ? state.searchList?.pageInfo?.endCursor : null
        });
        if (res) {
          if (!loadMore || !state.searchList) {
            state.searchList = res;
          } else {
            if (state.searchList) {
              state.searchList.edges.push(...res.edges);
              state.searchList.pageInfo = res.pageInfo;
            }
          }
        }
        state.locked = false;
        state.loading = false;
      },
      getTags: async (data) => {
        state.loading = true;
        const res = await useRequest("/api/request", {});
        state.loading = false;
        if (res?.terms) {
          return res.terms;
        }
        return null;
      },
      createTag: async () => {
        if (state.locked) return;
        state.locked = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              name: state.createName
            }
          }
        });
        if (res?.createCommunityTag?.communityTag?.name) {
          res.createCommunityTag.communityTag.new = true;
          ElMessage.success("创建成功");
          state.show = "week";
          state.weekHotList.edges.unshift({
            node: res.createCommunityTag.communityTag
          });
        }
        state.locked = false;
      }
    });
    const addTag = (tag, editor) => {
      props.action.addTag(tag, props.editor);
      props.action.showTagBox();
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      const _component_el_input = ElInput;
      const _component_el_scrollbar = ElScrollbar;
      const _directive_loading = vLoading;
      let _temp0;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: `absolute overflow-hidden communitytags-box tag-box w-full top-0 right-0 h-full z-1 bg-[--el-bg-color] @md:border-1 @md:rounded flex flex-col border-t border-b ${__props.action.showTags ? "opacity-100 translate-y-0" : "opacity-0 translate-y-full"} transition-all duration-300`
      }, _attrs))} data-v-4c52db03><div class="flex justify-between items-center @md:p-3 p-2 @md:h-10 h-8" data-v-4c52db03><div class="flex items-center flex-1 @md:divide-x" data-v-4c52db03><div class="flex items-center gap-2 @md:pr-2 pr-1" data-v-4c52db03>`);
      _push(ssrRenderComponent(_component_el_button, {
        link: "",
        onClick: ($event) => unref(state).showAction("week"),
        type: unref(state).show == "week" ? "primary" : "default",
        class: "!m-0 !text-xs !font-500"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`热门`);
          } else {
            return [
              createTextVNode("热门")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_el_button, {
        link: "",
        onClick: ($event) => unref(state).showAction("all"),
        type: unref(state).show == "all" ? "primary" : "default",
        class: "!m-0 !text-xs !font-500"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`全部`);
          } else {
            return [
              createTextVNode("全部")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="flex items-center @md:gap-3 gap-2 @md:pl-3 pl-1 search-button" data-v-4c52db03>`);
      _push(ssrRenderComponent(_component_el_button, {
        link: "",
        onClick: ($event) => unref(state).showAction("search"),
        type: unref(state).show == "search" ? "primary" : "default",
        class: "!m-0 !text-xs !font-500"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(` 搜索 `);
          } else {
            return [
              createTextVNode(" 搜索 ")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_el_button, {
        link: "",
        onClick: ($event) => unref(state).showAction("create"),
        type: unref(state).show == "create" ? "primary" : "default",
        class: "!m-0 !text-xs !font-500 create-button"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(` 创建 `);
          } else {
            return [
              createTextVNode(" 创建 ")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div>`);
      _push(ssrRenderComponent(_component_el_button, {
        text: "",
        type: "primary",
        size: "small",
        circle: "",
        class: "-mr-1 close-button",
        onClick: ($event) => {
          unref(state).key = "";
          __props.action.showTagBox();
        }
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-caret-double-down" data-v-4c52db03${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-caret-double-down" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="@md:p-3 p-2 flex-1 flex flex-col border-t @md:gap-3 gap-2" data-v-4c52db03><div class="flex items-center z-1 bg-[--el-color-info-light-10] border-b @md:-m-3 @md:mb-0 -m-2 mb-0 h-8 @md:px-1 px-0" data-v-4c52db03>`);
      if (unref(state).show == "week") {
        _push(`<div class="text-xs opacity-70 pl-3" data-v-4c52db03> 本周热门话题 </div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(state).show == "all") {
        _push(`<div class="text-xs opacity-70 pl-3" data-v-4c52db03> 所有热门话题 </div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flex items-center justify-between w-full" style="${ssrRenderStyle(unref(state).show == "search" ? null : { display: "none" })}" data-v-4c52db03>`);
      _push(ssrRenderComponent(_component_el_input, {
        modelValue: unref(state).key,
        "onUpdate:modelValue": ($event) => unref(state).key = $event,
        placeholder: "搜索话题",
        onKeyup: ($event) => unref(state).getSearchTags(),
        ref_key: "searchInputRef",
        ref: searchInputRef,
        style: { "--el-input-border-color": "transparent", "--el-input-bg-color": "transparent" },
        class: "!text-xs"
      }, {
        suffix: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_el_button, {
              text: "",
              bg: "",
              onClick: ($event) => unref(state).getSearchTags(),
              size: "small",
              loading: unref(state).locked,
              type: "primary"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  if (!unref(state).locked) {
                    _push3(`<span data-v-4c52db03${_scopeId2}>搜索</span>`);
                  } else {
                    _push3(`<!---->`);
                  }
                } else {
                  return [
                    !unref(state).locked ? (openBlock(), createBlock("span", { key: 0 }, "搜索")) : createCommentVNode("", true)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_el_button, {
                text: "",
                bg: "",
                onClick: ($event) => unref(state).getSearchTags(),
                size: "small",
                loading: unref(state).locked,
                type: "primary"
              }, {
                default: withCtx(() => [
                  !unref(state).locked ? (openBlock(), createBlock("span", { key: 0 }, "搜索")) : createCommentVNode("", true)
                ]),
                _: 1
              }, 8, ["onClick", "loading"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="flex items-center justify-between w-full" style="${ssrRenderStyle(unref(state).show == "create" ? null : { display: "none" })}" data-v-4c52db03>`);
      _push(ssrRenderComponent(_component_el_input, {
        modelValue: unref(state).createName,
        "onUpdate:modelValue": ($event) => unref(state).createName = $event,
        placeholder: `每日最多创建${unref(serverSettings)?.community_node?.tag_count || 5}个话题`,
        onKeyup: ($event) => unref(state).createTag(),
        ref_key: "createInputRef",
        ref: createInputRef,
        class: "!text-xs",
        style: { "--el-input-border-color": "transparent", "--el-input-bg-color": "transparent" }
      }, {
        suffix: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_el_button, {
              text: "",
              bg: "",
              type: "primary",
              size: "small",
              onClick: ($event) => unref(state).createTag(),
              disabled: unref(state).locked,
              loading: unref(state).locked
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  if (!unref(state).locked) {
                    _push3(`<span data-v-4c52db03${_scopeId2}>创建</span>`);
                  } else {
                    _push3(`<!---->`);
                  }
                } else {
                  return [
                    !unref(state).locked ? (openBlock(), createBlock("span", { key: 0 }, "创建")) : createCommentVNode("", true)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_el_button, {
                text: "",
                bg: "",
                type: "primary",
                size: "small",
                onClick: ($event) => unref(state).createTag(),
                disabled: unref(state).locked,
                loading: unref(state).locked
              }, {
                default: withCtx(() => [
                  !unref(state).locked ? (openBlock(), createBlock("span", { key: 0 }, "创建")) : createCommentVNode("", true)
                ]),
                _: 1
              }, 8, ["onClick", "disabled", "loading"])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div><div class="flex-1 relative @md:-m-3 -m-2" data-v-4c52db03><div class="absolute inset-0" data-v-4c52db03>`);
      _push(ssrRenderComponent(_component_el_scrollbar, { height: "100%" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex items-start gap-2 flex-wrap @md:p-3 p-2" data-v-4c52db03${_scopeId}><!--[-->`);
            ssrRenderList(unref(list), (tag) => {
              _push2(`<div class="flex items-center" data-v-4c52db03${_scopeId}><div class="${ssrRenderClass(`@md:text-sm text-xs cursor-pointer flex hover:text-[--el-color-primary] hover:border-[--el-color-primary] flex-col items-end rounded-sm p-2 py-1 pr-3 border-1 ${tag.node.new ? "border-dashed border-[--el-color-primary] text-[--el-color-primary]" : ""}`)}" data-v-4c52db03${_scopeId}><span class="flex items-center gap-.3" data-v-4c52db03${_scopeId}><i class="i-ph-hash text-xs opacity-50" data-v-4c52db03${_scopeId}></i>${ssrInterpolate(tag.node.name)}</span><span class="text-[11px] opacity-50" data-v-4c52db03${_scopeId}>${ssrInterpolate(tag.node.count || 0)}话题</span></div></div>`);
            });
            _push2(`<!--]--></div>`);
            if (unref(state).loading) {
              _push2(`<div${ssrRenderAttrs(_temp0 = mergeProps({ class: "w-full h-[calc(100%-40px)] flex items-center justify-center" }, ssrGetDirectiveProps(_ctx, _directive_loading, unref(state).loading)))} data-v-4c52db03${_scopeId}>${"textContent" in _temp0 ? ssrInterpolate(_temp0.textContent) : _temp0.innerHTML ?? ""}</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(state).show == "search" && !unref(state).searchList) {
              _push2(`<div class="w-full h-full flex items-center justify-center text-xs opacity-50" data-v-4c52db03${_scopeId}> 搜索话题... </div>`);
            } else if (unref(state).searchList?.edges?.length == 0 && unref(state).show == "search" || unref(state).weekHotList?.edges?.length == 0 && unref(state).show == "week" || unref(state).allHotList?.edges?.length == 0 && unref(state).show == "all") {
              _push2(`<div class="w-full h-full flex items-center justify-center" data-v-4c52db03${_scopeId}><span class="text-xs opacity-50" data-v-4c52db03${_scopeId}>暂无数据</span></div>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(moreButton).show) {
              _push2(`<div class="flex justify-center pb-4" data-v-4c52db03${_scopeId}>`);
              _push2(ssrRenderComponent(_component_el_button, {
                onClick: ($event) => unref(state).loadMore(),
                bg: "",
                text: "",
                size: "small",
                loading: unref(state).moreLocked,
                disabled: unref(moreButton).disabled
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<span data-v-4c52db03${_scopeId2}>${ssrInterpolate(unref(moreButton).text)}</span>`);
                  } else {
                    return [
                      createVNode("span", null, toDisplayString(unref(moreButton).text), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("div", { class: "flex items-start gap-2 flex-wrap @md:p-3 p-2" }, [
                (openBlock(true), createBlock(Fragment, null, renderList(unref(list), (tag) => {
                  return openBlock(), createBlock("div", {
                    key: tag.node.databaseId,
                    class: "flex items-center"
                  }, [
                    createVNode("div", {
                      class: `@md:text-sm text-xs cursor-pointer flex hover:text-[--el-color-primary] hover:border-[--el-color-primary] flex-col items-end rounded-sm p-2 py-1 pr-3 border-1 ${tag.node.new ? "border-dashed border-[--el-color-primary] text-[--el-color-primary]" : ""}`,
                      onClick: ($event) => addTag(tag.node)
                    }, [
                      createVNode("span", { class: "flex items-center gap-.3" }, [
                        createVNode("i", { class: "i-ph-hash text-xs opacity-50" }),
                        createTextVNode(toDisplayString(tag.node.name), 1)
                      ]),
                      createVNode("span", { class: "text-[11px] opacity-50" }, toDisplayString(tag.node.count || 0) + "话题", 1)
                    ], 10, ["onClick"])
                  ]);
                }), 128))
              ]),
              unref(state).loading ? withDirectives((openBlock(), createBlock("div", {
                key: 0,
                class: "w-full h-[calc(100%-40px)] flex items-center justify-center"
              }, null, 512)), [
                [_directive_loading, unref(state).loading]
              ]) : createCommentVNode("", true),
              unref(state).show == "search" && !unref(state).searchList ? (openBlock(), createBlock("div", {
                key: 1,
                class: "w-full h-full flex items-center justify-center text-xs opacity-50"
              }, " 搜索话题... ")) : unref(state).searchList?.edges?.length == 0 && unref(state).show == "search" || unref(state).weekHotList?.edges?.length == 0 && unref(state).show == "week" || unref(state).allHotList?.edges?.length == 0 && unref(state).show == "all" ? (openBlock(), createBlock("div", {
                key: 2,
                class: "w-full h-full flex items-center justify-center"
              }, [
                createVNode("span", { class: "text-xs opacity-50" }, "暂无数据")
              ])) : createCommentVNode("", true),
              unref(moreButton).show ? (openBlock(), createBlock("div", {
                key: 3,
                class: "flex justify-center pb-4"
              }, [
                createVNode(_component_el_button, {
                  onClick: ($event) => unref(state).loadMore(),
                  bg: "",
                  text: "",
                  size: "small",
                  loading: unref(state).moreLocked,
                  disabled: unref(moreButton).disabled
                }, {
                  default: withCtx(() => [
                    createVNode("span", null, toDisplayString(unref(moreButton).text), 1)
                  ]),
                  _: 1
                }, 8, ["onClick", "loading", "disabled"])
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/form/Tags.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_3 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-4c52db03"]]);

export { __nuxt_component_3 as default };
