import __nuxt_component_0 from './sectionBox-IsmpB-6v.mjs';
import __nuxt_component_7 from './moduleBox-CTwb_Fll.mjs';
import { d as useRoute, k as deviceStore, c as createError, o as usePageData, b as useSeoMeta, u as useHead, p as getFilteredModules, q as loadPageComponent, h as useServerHost, a as useI18n, e as useUtils } from './server.mjs';
import { reactive, provide, withAsyncContext, mergeProps, unref, withCtx, createVNode, resolveDynamicComponent, openBlock, createBlock, Fragment, renderList, createCommentVNode, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderList, ssrRenderComponent, ssrRenderStyle, ssrRenderAttr, ssrRenderVNode } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const HomePage = (obj) => {
  return {
    "@context": "https://schema.org",
    "@graph": [
      {
        "@type": "WebSite",
        "@id": obj?.siteUrl + "/#website",
        url: obj?.siteUrl,
        name: obj?.data?.seo?.ogSiteName,
        inLanguage: obj?.data?.seo?.ogLocale.replace("_", "-"),
        potentialAction: {
          "@type": "SearchAction",
          target: obj?.siteUrl + "/search?q={search_term}",
          "query-input": "required name=search_term"
        }
      },
      {
        "@type": "Organization",
        "@id": obj?.siteUrl + "/#organization",
        name: "UME",
        url: obj?.siteUrl,
        logo: obj?.data?.seo?.ogImage
      }
    ]
  };
};
const Article = (obj) => {
  const route = useRoute();
  return {
    "@context": "https://schema.org",
    "@graph": [
      {
        "@type": obj.data.seo.ogType,
        "@id": route.path + "/#article",
        headline: obj?.data?.seo?.ogTitle,
        alternativeHeadline: obj?.data?.seo?.title,
        description: obj?.data?.seo?.ogDescription,
        image: obj?.data?.seo?.ogImage,
        datePublished: obj?.data?.seo?.datePublished,
        dateModified: obj?.data?.seo?.dateModified,
        image: obj?.data?.seo?.ogImage,
        author: {
          "@type": "Person",
          name: obj?.data?.seo?.author?.name,
          url: obj.siteUrl + obj?.data?.seo?.author?.url
        },
        publisher: { "@id": obj?.siteUrl + "/#organization" },
        //英文逗号或者中文逗号分隔的keywords，转换为数组
        articleSection: obj?.data?.seo?.keywords.split(/[,，]/).map((item) => item.trim()),
        inLanguage: obj?.data?.seo?.ogLocale.replace("_", "-"),
        mainEntity: { "@id": route.path + "/#faq" }
      }
    ]
  };
};
const Product = (obj) => {
};
const Website = (obj) => {
  const route = useRoute();
  return {
    "@context": "https://schema.org",
    "@graph": [
      {
        "@type": "WebPage",
        "@id": route.path + "/#webpage",
        publisher: { "@id": obj?.siteUrl + "/#organization" },
        url: obj?.siteUrl,
        name: obj?.data?.seo?.ogTitle,
        description: obj?.data?.seo?.ogDescription,
        inLanguage: obj?.data?.seo?.ogLocale.replace("_", "-"),
        isPartOf: { "@id": obj?.siteUrl + "/#website" },
        mainEntity: { "@id": route.path + "/#faq" }
      }
    ]
  };
};
const QAPage = (obj) => {
  const route = useRoute();
  let suggestedAnswer = [];
  if (obj?.data?.seo?.qaPage?.suggestedAnswer?.length > 0 && obj?.data?.seo?.qaPage?.suggestedAnswer[0]?.text) {
    suggestedAnswer = obj?.data?.seo?.qaPage?.suggestedAnswer?.map((item) => {
      return {
        "@type": "Answer",
        text: item.text,
        datePublished: item.dateCreated,
        author: {
          "@type": "Person",
          name: item.author,
          url: obj.siteUrl + item.url
        },
        upvoteCount: item.upvoteCount,
        url: item.url ? obj.siteUrl + item.url : route.path + "/#answer"
      };
    });
  }
  return {
    "@context": "https://schema.org",
    "@graph": [
      {
        "@type": "QAPage",
        "@id": route.path + "/#qa",
        mainEntity: {
          "@type": "Question",
          "@id": route.path + "/#question",
          inLanguage: obj?.data?.seo?.ogLocale.replace("_", "-"),
          publisher: { "@id": obj?.siteUrl + "/#organization" },
          datePublished: obj?.data?.seo?.datePublished,
          name: obj?.data?.seo?.qaPage?.name,
          text: obj?.data?.seo?.qaPage?.text,
          author: {
            "@type": "Person",
            name: obj?.data?.seo?.author?.name,
            url: obj.siteUrl + obj?.data?.seo?.author?.url
          },
          answerCount: obj?.data?.seo?.qaPage?.answerCount,
          acceptedAnswer: {
            "@type": "Answer",
            text: obj?.data?.seo?.qaPage?.acceptedAnswer?.text,
            datePublished: obj?.data?.seo?.qaPage?.acceptedAnswer?.dateCreated,
            author: {
              "@type": "Person",
              name: obj?.data?.seo?.qaPage?.acceptedAnswer?.author,
              url: obj.siteUrl + obj?.data?.seo?.qaPage?.acceptedAnswer?.url
            },
            upvoteCount: obj?.data?.seo?.qaPage?.acceptedAnswer?.upvoteCount,
            url: obj?.data?.seo?.qaPage?.acceptedAnswer?.url ? obj.siteUrl + obj?.data?.seo?.qaPage?.acceptedAnswer?.url : route.path + "/#answer"
          },
          suggestedAnswer
        }
      }
    ]
  };
};
const Answer = (obj) => {
  const route = useRoute();
  return {
    "@context": "https://schema.org",
    "@graph": [
      {
        "@type": "QAPage",
        "@id": route.path + "/#faq",
        mainEntity: {
          "@type": "Question",
          inLanguage: obj?.data?.seo?.ogLocale.replace("_", "-"),
          publisher: { "@id": obj?.siteUrl + "/#organization" },
          name: obj?.data?.seo?.qaPage?.name,
          text: obj?.data?.seo?.qaPage?.text,
          datePublished: obj?.data?.seo?.datePublished,
          acceptedAnswer: {
            "@type": "Answer",
            text: obj?.data?.seo?.qaPage?.acceptedAnswer?.text,
            datePublished: obj?.data?.seo?.qaPage?.acceptedAnswer?.dateCreated,
            author: {
              "@type": "Person",
              name: obj?.data?.seo?.qaPage?.acceptedAnswer?.author,
              url: obj.siteUrl + obj?.data?.seo?.qaPage?.acceptedAnswer?.url
            },
            upvoteCount: obj?.data?.seo?.qaPage?.acceptedAnswer?.upvoteCount,
            url: obj.siteUrl + obj?.data?.seo?.qaPage?.acceptedAnswer?.url
          }
        }
      }
    ]
  };
};
const ProfilePage = (obj) => {
  return {
    "@context": "https://schema.org",
    "@graph": [
      {
        "@type": obj.data.seo.ogType,
        "@id": obj?.siteUrl + obj.data.seo?.author?.url + "/#profilepage",
        name: obj?.data?.title,
        url: obj?.siteUrl + obj.data.seo?.author?.url,
        inLanguage: obj?.data?.seo?.ogLocale.replace("_", "-"),
        publisher: { "@id": obj?.siteUrl + "/#organization" },
        mainEntity: {
          "@id": obj?.siteUrl + obj.data.seo?.author?.url + "/#person"
        }
      },
      {
        "@type": "Person",
        "@id": obj?.siteUrl + obj.data.seo?.author?.url + "/#person",
        name: obj.data.seo?.author?.name,
        image: obj?.siteUrl + useUtils.avatar(obj.data.seo?.author?.avatar)
      }
    ]
  };
};
const CollectionPage = (obj) => {
  const route = useRoute();
  let itemListElement = [];
  if (obj?.data?.seo?.itemListElement?.length > 0) {
    itemListElement = obj?.data?.seo?.itemListElement?.map((item) => {
      return {
        "@type": "ListItem",
        position: item.position,
        url: obj.siteUrl + item.url,
        name: item.name,
        datePublished: item.datePublished
      };
    });
  }
  return {
    "@context": "https://schema.org",
    "@type": obj.data.seo.ogType,
    "@graph": [
      {
        "@type": "CollectionPage",
        "@id": route.path + "/#collectionpage",
        url: route.path,
        name: obj?.data?.seo?.ogTitle,
        description: obj?.data?.seo?.ogDescription,
        inLanguage: obj?.data?.seo?.ogLocale.replace("_", "-"),
        mainEntity: { "@id": route.path + "/#itemlist" }
      },
      {
        "@type": "ItemList",
        "@id": route.path + "/#itemlist",
        name: obj?.data?.seo?.ogTitle,
        itemListElement
      }
    ]
  };
};
const ArchivePage = (obj) => {
  return CollectionPage(obj);
};
const JsonLd = {
  Article,
  Product,
  Website,
  QAPage,
  Answer,
  ProfilePage,
  CollectionPage,
  ArchivePage,
  HomePage
};
const getJsonLd = (data, pageSettings) => {
  const route = useRoute();
  const type = data?.seo?.ogType;
  if (!type) return null;
  const host = useServerHost().value;
  const siteUrl = "https://" + host;
  const path = siteUrl + route.path;
  const { t } = useI18n();
  let breadcrumbObject = null;
  if (data?.seo?.breadcrumb) {
    const breadcrumbList = data?.seo?.breadcrumb?.map((item, index) => {
      if (index == 0) {
        return {
          "@type": "ListItem",
          position: index + 1,
          name: t("common.home"),
          item: siteUrl
        };
      } else {
        return {
          "@type": "ListItem",
          position: index + 1,
          name: item.name,
          item: siteUrl + item.gqSlug
        };
      }
    });
    if (breadcrumbList?.length > 0) {
      breadcrumbObject = {
        "@type": "BreadcrumbList",
        "@id": siteUrl + "/#breadcrumb",
        name: t("common.breadcrumbList"),
        itemListElement: breadcrumbList
      };
    }
  }
  let faqObject = null;
  if (data?.seo?.faq) {
    const faqList = data?.seo?.faq?.map((item, index) => {
      return {
        "@type": "Question",
        name: item.question,
        acceptedAnswer: {
          "@type": "Answer",
          text: item.answer
        }
      };
    });
    if (faqList?.length > 0) {
      faqObject = {
        "@type": "FAQPage",
        "@id": path + "/#faq",
        name: t("common.faqList"),
        mainEntity: faqList
      };
    }
  }
  let jsonLdData = null;
  if (JsonLd[type]) {
    jsonLdData = JsonLd[type]({
      data,
      pageSettings,
      siteUrl,
      path
    });
  }
  if (!jsonLdData) return null;
  if (breadcrumbObject) {
    jsonLdData["@graph"].push(breadcrumbObject);
  }
  if (faqObject) {
    jsonLdData["@graph"].push(faqObject);
  }
  return jsonLdData;
};
const _sfc_main = {
  __name: "[...name]",
  __ssrInlineRender: true,
  async setup(__props) {
    let __temp, __restore;
    const route = useRoute();
    const device = deviceStore();
    const pageSettings = route.meta.pageSettings;
    if (pageSettings.notFound) {
      throw createError({
        statusCode: 404,
        statusMessage: "Page Not Found"
      });
    }
    const pageState = reactive({
      community: {},
      loginDataReady: false
    });
    provide("pageState", pageState);
    const data = ([__temp, __restore] = withAsyncContext(() => usePageData(pageSettings)), __temp = await __temp, __restore(), __temp);
    const jsonLd = getJsonLd(data?.value, pageSettings);
    useSeoMeta({
      title: () => data?.value?.seo?.title,
      description: () => data?.value?.seo?.description,
      keywords: () => data?.value?.seo?.keywords,
      ogTitle: () => data?.value?.seo?.ogTitle,
      ogDescription: () => data?.value?.seo?.ogDescription,
      ogImage: () => data?.value?.seo?.ogImage,
      ogLocale: () => data?.value?.seo?.ogLocale,
      ogType: () => data?.value?.seo?.ogType == "HomePage" ? "Website" : data?.value?.seo?.ogType,
      ogUrl: () => data?.value?.seo?.ogUrl,
      ogSiteName: () => data?.value?.seo?.ogSiteName,
      twitterCard: () => "summary_large_image",
      twitterTitle: () => data?.value?.seo?.ogTitle,
      twitterDescription: () => data?.value?.seo?.ogDescription,
      twitterImage: () => data?.value?.seo?.ogImage
    });
    const head = {
      htmlAttrs: {
        lang: data?.value?.seo?.ogLocale.replace("_", "-")
      },
      link: [
        {
          rel: "icon",
          type: "image/ico",
          href: "/favicon.ico"
        }
      ]
    };
    if (jsonLd) {
      head.script = [
        {
          type: "application/ld+json",
          innerHTML: JSON.stringify(jsonLd, null, "")
          // 不要转义中文
        }
      ];
    }
    useHead(head);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CommonSectionBox = __nuxt_component_0;
      const _component_CommonModuleBox = __nuxt_component_7;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: `flex-1 max-w-full ${unref(data)?.module ? "load-success" : ""}`
      }, _attrs))} data-v-b866d933><!--[-->`);
      ssrRenderList(unref(pageSettings)?.settings || [], (item, i) => {
        _push(ssrRenderComponent(_component_CommonSectionBox, {
          data: item,
          settings: item.settings,
          key: i,
          id: `section-${i}`,
          class: "z-2 relative"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="section-inner flex w-[--tswi] gap-[--tsgap] mx-auto max-w-full" data-v-b866d933${_scopeId}>`);
              if (!unref(device).isMobile && item.settings?.widgetLeft?.show) {
                _push2(`<div class="w-[--tsww] widget widget-left" style="${ssrRenderStyle(`--tsww:${item.settings?.widgetLeft?.width}%;`)}"${ssrRenderAttr("id", `sticky-left-container-${i}`)} data-v-b866d933${_scopeId}><div class="widget-left-inner gap-[--tsgap] flex flex-col"${ssrRenderAttr("data-sticky", item.settings?.widgetLeft?.sticky ? 1 : 0)}${ssrRenderAttr(
                  "data-sticky-offset",
                  item.settings?.widgetLeft?.stickyOffset ? item.settings?.widgetLeft?.stickyOffset : 70
                )} data-v-b866d933${_scopeId}><!--[-->`);
                ssrRenderList(("getFilteredModules" in _ctx ? _ctx.getFilteredModules : unref(getFilteredModules))(
                  item,
                  "widgetsLeft",
                  unref(data)
                ), (widget, _i) => {
                  _push2(ssrRenderComponent(_component_CommonModuleBox, {
                    settings: widget.settings.box,
                    id: widget.id,
                    key: widget.id,
                    index: _i,
                    type: widget.type
                  }, {
                    default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                      if (_push3) {
                        ssrRenderVNode(_push3, createVNode(resolveDynamicComponent(("loadPageComponent" in _ctx ? _ctx.loadPageComponent : unref(loadPageComponent))(widget)), {
                          data: unref(data)?.module?.[widget.id],
                          settings: widget.settings,
                          id: widget.id
                        }, null), _parent3, _scopeId2);
                      } else {
                        return [
                          (openBlock(), createBlock(resolveDynamicComponent(("loadPageComponent" in _ctx ? _ctx.loadPageComponent : unref(loadPageComponent))(widget)), {
                            data: unref(data)?.module?.[widget.id],
                            settings: widget.settings,
                            id: widget.id
                          }, null, 8, ["data", "settings", "id"]))
                        ];
                      }
                    }),
                    _: 2
                  }, _parent2, _scopeId));
                });
                _push2(`<!--]--></div></div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<div class="w-0 flex-1 gap-[--tsgap] flex flex-col" data-v-b866d933${_scopeId}><!--[-->`);
              ssrRenderList(("getFilteredModules" in _ctx ? _ctx.getFilteredModules : unref(getFilteredModules))(item, "modules", unref(data)), (module, _i) => {
                _push2(ssrRenderComponent(_component_CommonModuleBox, {
                  settings: module.settings?.box,
                  key: module.id,
                  index: _i,
                  id: module.id,
                  type: module.type
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      ssrRenderVNode(_push3, createVNode(resolveDynamicComponent(("loadPageComponent" in _ctx ? _ctx.loadPageComponent : unref(loadPageComponent))(module)), {
                        data: unref(data)?.module?.[module.id],
                        settings: module.settings,
                        id: module.id
                      }, null), _parent3, _scopeId2);
                    } else {
                      return [
                        (openBlock(), createBlock(resolveDynamicComponent(("loadPageComponent" in _ctx ? _ctx.loadPageComponent : unref(loadPageComponent))(module)), {
                          data: unref(data)?.module?.[module.id],
                          settings: module.settings,
                          id: module.id
                        }, null, 8, ["data", "settings", "id"]))
                      ];
                    }
                  }),
                  _: 2
                }, _parent2, _scopeId));
              });
              _push2(`<!--]--></div>`);
              if (!unref(device).isMobile && item.settings?.widget?.show) {
                _push2(`<div class="w-[--tsww] widget" style="${ssrRenderStyle(`--tsww:${item.settings?.widget?.width}%;`)}"${ssrRenderAttr("id", `sticky-right-container-${i}`)} data-v-b866d933${_scopeId}><div class="widget-right-inner gap-[--tsgap] flex flex-col"${ssrRenderAttr("data-sticky", item.settings?.widget?.sticky ? 1 : 0)}${ssrRenderAttr(
                  "data-sticky-offset",
                  item.settings?.widget?.stickyOffset ? item.settings?.widget?.stickyOffset : 70
                )} data-v-b866d933${_scopeId}><!--[-->`);
                ssrRenderList(("getFilteredModules" in _ctx ? _ctx.getFilteredModules : unref(getFilteredModules))(item, "widgets", unref(data)), (widget, _i) => {
                  _push2(ssrRenderComponent(_component_CommonModuleBox, {
                    settings: widget.settings?.box,
                    key: widget.id,
                    index: _i,
                    id: widget.id,
                    type: widget.type
                  }, {
                    default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                      if (_push3) {
                        ssrRenderVNode(_push3, createVNode(resolveDynamicComponent(("loadPageComponent" in _ctx ? _ctx.loadPageComponent : unref(loadPageComponent))(widget)), {
                          data: unref(data)?.module?.[widget.id],
                          settings: widget.settings,
                          id: widget.id
                        }, null), _parent3, _scopeId2);
                      } else {
                        return [
                          (openBlock(), createBlock(resolveDynamicComponent(("loadPageComponent" in _ctx ? _ctx.loadPageComponent : unref(loadPageComponent))(widget)), {
                            data: unref(data)?.module?.[widget.id],
                            settings: widget.settings,
                            id: widget.id
                          }, null, 8, ["data", "settings", "id"]))
                        ];
                      }
                    }),
                    _: 2
                  }, _parent2, _scopeId));
                });
                _push2(`<!--]--></div></div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
            } else {
              return [
                createVNode("div", { class: "section-inner flex w-[--tswi] gap-[--tsgap] mx-auto max-w-full" }, [
                  !unref(device).isMobile && item.settings?.widgetLeft?.show ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "w-[--tsww] widget widget-left",
                    style: `--tsww:${item.settings?.widgetLeft?.width}%;`,
                    id: `sticky-left-container-${i}`
                  }, [
                    createVNode("div", {
                      class: "widget-left-inner gap-[--tsgap] flex flex-col",
                      "data-sticky": item.settings?.widgetLeft?.sticky ? 1 : 0,
                      "data-sticky-offset": item.settings?.widgetLeft?.stickyOffset ? item.settings?.widgetLeft?.stickyOffset : 70
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(("getFilteredModules" in _ctx ? _ctx.getFilteredModules : unref(getFilteredModules))(
                        item,
                        "widgetsLeft",
                        unref(data)
                      ), (widget, _i) => {
                        return openBlock(), createBlock(_component_CommonModuleBox, {
                          settings: widget.settings.box,
                          id: widget.id,
                          key: widget.id,
                          index: _i,
                          type: widget.type
                        }, {
                          default: withCtx(() => [
                            (openBlock(), createBlock(resolveDynamicComponent(("loadPageComponent" in _ctx ? _ctx.loadPageComponent : unref(loadPageComponent))(widget)), {
                              data: unref(data)?.module?.[widget.id],
                              settings: widget.settings,
                              id: widget.id
                            }, null, 8, ["data", "settings", "id"]))
                          ]),
                          _: 2
                        }, 1032, ["settings", "id", "index", "type"]);
                      }), 128))
                    ], 8, ["data-sticky", "data-sticky-offset"])
                  ], 12, ["id"])) : createCommentVNode("", true),
                  createVNode("div", { class: "w-0 flex-1 gap-[--tsgap] flex flex-col" }, [
                    (openBlock(true), createBlock(Fragment, null, renderList(("getFilteredModules" in _ctx ? _ctx.getFilteredModules : unref(getFilteredModules))(item, "modules", unref(data)), (module, _i) => {
                      return openBlock(), createBlock(_component_CommonModuleBox, {
                        settings: module.settings?.box,
                        key: module.id,
                        index: _i,
                        id: module.id,
                        type: module.type
                      }, {
                        default: withCtx(() => [
                          (openBlock(), createBlock(resolveDynamicComponent(("loadPageComponent" in _ctx ? _ctx.loadPageComponent : unref(loadPageComponent))(module)), {
                            data: unref(data)?.module?.[module.id],
                            settings: module.settings,
                            id: module.id
                          }, null, 8, ["data", "settings", "id"]))
                        ]),
                        _: 2
                      }, 1032, ["settings", "index", "id", "type"]);
                    }), 128))
                  ]),
                  !unref(device).isMobile && item.settings?.widget?.show ? (openBlock(), createBlock("div", {
                    key: 1,
                    class: "w-[--tsww] widget",
                    style: `--tsww:${item.settings?.widget?.width}%;`,
                    id: `sticky-right-container-${i}`
                  }, [
                    createVNode("div", {
                      class: "widget-right-inner gap-[--tsgap] flex flex-col",
                      "data-sticky": item.settings?.widget?.sticky ? 1 : 0,
                      "data-sticky-offset": item.settings?.widget?.stickyOffset ? item.settings?.widget?.stickyOffset : 70
                    }, [
                      (openBlock(true), createBlock(Fragment, null, renderList(("getFilteredModules" in _ctx ? _ctx.getFilteredModules : unref(getFilteredModules))(item, "widgets", unref(data)), (widget, _i) => {
                        return openBlock(), createBlock(_component_CommonModuleBox, {
                          settings: widget.settings?.box,
                          key: widget.id,
                          index: _i,
                          id: widget.id,
                          type: widget.type
                        }, {
                          default: withCtx(() => [
                            (openBlock(), createBlock(resolveDynamicComponent(("loadPageComponent" in _ctx ? _ctx.loadPageComponent : unref(loadPageComponent))(widget)), {
                              data: unref(data)?.module?.[widget.id],
                              settings: widget.settings,
                              id: widget.id
                            }, null, 8, ["data", "settings", "id"]))
                          ]),
                          _: 2
                        }, 1032, ["settings", "index", "id", "type"]);
                      }), 128))
                    ], 8, ["data-sticky", "data-sticky-offset"])
                  ], 12, ["id"])) : createCommentVNode("", true)
                ])
              ];
            }
          }),
          _: 2
        }, _parent));
      });
      _push(`<!--]--></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/pages/[...name].vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const ____name_ = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-b866d933"]]);

export { ____name_ as default };
