import { E as ElDialog } from './index-awVc4A7-.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElSwitch } from './switch-DUHUs6lt.mjs';
import { E as ElForm, a as ElFormItem } from './index-DwNba9hO.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import { E as ElSelect, a as ElOption } from './index-03hfIBa_.mjs';
import _sfc_main$1 from './countryDialCodes-DK3oAU-H.mjs';
import { a as useI18n, j as actionStore, g as getServerSettings, r as useRequest, E as ElMessage } from './server.mjs';
import { useSSRContext, ref, reactive, watch, mergeProps, unref, withCtx, createTextVNode, toDisplayString, createVNode, openBlock, createBlock, Fragment, renderList } from 'vue';
import { ssrRenderComponent, ssrInterpolate, ssrRenderList } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './use-dialog-7J0bwlna.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import 'lodash-unified';
import './aria-BhThsKez.mjs';
import './event-BZTOGHfp.mjs';
import '@vue/shared';
import './vnode-l2ZP2UQa.mjs';
import './index-Di0Jlzch.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './index-DRiwogtD.mjs';
import 'async-validator';
import './index-ChPMoinw.mjs';
import './index-BKB3Djp4.mjs';
import './index-Bp-nwGzu.mjs';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-tCyBRCDx.mjs';
import './index-BY8mj3AC.mjs';
import './popover-B8HtRMY4.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonFormAddressForm",
  __ssrInlineRender: true,
  setup(__props) {
    const { t: $t } = useI18n();
    const action = actionStore();
    const serverSettings = getServerSettings();
    const { locale } = useI18n();
    const lang = ref(locale.value);
    const state = reactive({
      locekd: false,
      type: "SELECTED",
      defaultAddress: false,
      selectedCountry: "",
      hasSelectedCountry: false,
      selectedProvince: "",
      hasSelectedProvince: false,
      selectedCity: "",
      hasSelectedCity: false,
      selectedDistrict: "",
      hasSelectedDistrict: false,
      postalCode: "",
      addressString: "",
      address: "",
      phone: "",
      name: "",
      index: null,
      dialCode: "",
      countries: serverSettings?.address_picker?.map((item) => ({
        value: item.geonameId,
        label: item.country
      })),
      provinces: [],
      cities: [],
      districts: [],
      fetchGeonamesData: async (geonameId, featureCode) => {
        lang.value.split("-")[0];
        const res = await useRequest("/api/request", {});
        if (res?.guaqi?.utils?.addressPicker) {
          return res?.guaqi?.utils?.addressPicker.map((item) => ({
            value: item.geonameId,
            label: item.name
          })) || [];
        }
        return [];
      },
      loadProvinces: async () => {
        if (!state.selectedCountry) return;
        state.provinces = await state.fetchGeonamesData(
          state.selectedCountry,
          "ADM1"
        );
        state.hasSelectedProvince = true;
        state.hasSelectedCountry = "";
        state.selectedProvince = "";
        state.selectedCity = "";
        state.selectedDistrict = "";
        state.cities = [];
        state.districts = [];
      },
      loadCities: async () => {
        if (!state.selectedProvince) return;
        state.cities = await state.fetchGeonamesData(
          state.selectedProvince,
          "ADM2"
        );
        state.hasSelectedCity = true;
        state.selectedCity = "";
        state.selectedDistrict = "";
        state.districts = [];
      },
      loadDistricts: async () => {
        if (!state.selectedCity) return;
        state.districts = await state.fetchGeonamesData(state.selectedCity, "ADM3");
        state.hasSelectedDistrict = true;
        state.selectedDistrict = "";
      },
      saveAddress: async () => {
        state.locekd = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              type: state.type,
              default: state.defaultAddress,
              country: {
                geonameId: state.selectedCountry,
                name: state.countries.find(
                  (item) => item.value === state.selectedCountry
                )?.label[locale.value]
              },
              province: {
                geonameId: state.selectedProvince,
                name: state.provinces.find(
                  (item) => item.value === state.selectedProvince
                )?.label
              },
              city: {
                geonameId: state.selectedCity,
                name: state.cities.find((item) => item.value === state.selectedCity)?.label
              },
              district: {
                geonameId: state.selectedDistrict,
                name: state.districts.find(
                  (item) => item.value === state.selectedDistrict
                )?.label
              },
              address: state.address,
              addressString: state.addressString,
              phone: state.phone,
              dialCode: state.dialCode,
              name: state.name,
              postcode: state.postalCode,
              index: state.index
            }
          }
        });
        if (res?.gqAddressCreate?.success) {
          if (state.index === null) {
            ElMessage.success($t("common.editor.saveSuccess"));
          } else {
            ElMessage.success($t("common.editor.editSuccess"));
          }
          action.addressForm.show = false;
          action.addressForm.data = res?.gqAddressCreate?.data;
          action.addressForm.show = false;
          action.addressForm.data = res?.gqAddressCreate?.data;
        }
        state.locekd = false;
      },
      setAddressString: () => {
        const country = state.countries.find((item) => item.value === state.selectedCountry)?.label[locale.value] || "";
        const province = state.provinces.find((item) => item.value === state.selectedProvince)?.label || "";
        const city = state.cities.find((item) => item.value === state.selectedCity)?.label || "";
        const district = state.districts.find((item) => item.value === state.selectedDistrict)?.label || "";
        const address = state.address || "";
        state.addressString = `${country} ${province} ${city} ${district} ${address}`.replace(
          /^\s+/,
          ""
        );
      }
    });
    watch(
      () => action.addressForm.defaultAddress,
      (newVal) => {
        if (newVal) {
          state.type = action.addressForm.defaultAddress.type;
          state.selectedCountry = "" + action.addressForm.defaultAddress.country.geonameId;
          state.provinces = [
            {
              value: "" + action.addressForm.defaultAddress.province.geonameId,
              label: action.addressForm.defaultAddress.province.name
            }
          ];
          state.selectedProvince = "" + action.addressForm.defaultAddress.province.geonameId;
          state.cities = [
            {
              value: "" + action.addressForm.defaultAddress.city.geonameId,
              label: action.addressForm.defaultAddress.city.name
            }
          ];
          state.selectedCity = "" + action.addressForm.defaultAddress.city.geonameId;
          state.districts = [
            {
              value: "" + action.addressForm.defaultAddress.district.geonameId,
              label: action.addressForm.defaultAddress.district.name
            }
          ];
          state.selectedDistrict = "" + action.addressForm.defaultAddress.district.geonameId;
          state.address = action.addressForm.defaultAddress.address;
          state.addressString = action.addressForm.defaultAddress.addressString;
          state.phone = action.addressForm.defaultAddress.phone;
          state.dialCode = action.addressForm.defaultAddress.dialCode;
          state.name = action.addressForm.defaultAddress.name;
          state.postalCode = action.addressForm.defaultAddress.postcode;
          state.defaultAddress = action.addressForm.defaultAddress.default;
          state.index = action.addressForm.defaultAddress.index;
        } else {
          state.type = "SELECTED";
          state.defaultAddress = false;
          state.selectedCountry = "";
          state.hasSelectedCountry = false;
          state.selectedProvince = "";
          state.hasSelectedProvince = false;
          state.selectedCity = "";
          state.hasSelectedCity = false;
          state.selectedDistrict = "";
          state.hasSelectedDistrict = false;
          state.provinces = [];
          state.cities = [];
          state.districts = [];
          state.phone = "";
          state.name = "";
          state.postalCode = "";
          state.address = "";
          state.addressString = "";
          state.index = null;
        }
      }
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_dialog = ElDialog;
      const _component_el_button = ElButton;
      const _component_el_switch = ElSwitch;
      const _component_el_form = ElForm;
      const _component_el_form_item = ElFormItem;
      const _component_el_input = ElInput;
      const _component_el_select = ElSelect;
      const _component_el_option = ElOption;
      const _component_CommonFormCountryDialCodes = _sfc_main$1;
      _push(ssrRenderComponent(_component_el_dialog, mergeProps({
        modelValue: unref(action).addressForm.show,
        "onUpdate:modelValue": ($event) => unref(action).addressForm.show = $event,
        "lock-scroll": false,
        "append-to-body": true,
        title: unref(state).index !== null ? unref($t)("page.account.settings.address.editAddress") : unref($t)("page.account.settings.address.addAddress"),
        width: "340"
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="mb-6 pb-4 border-b border-gray-200" data-v-a79f1ce6${_scopeId}><div class="flex gap-3 items-center justify-between" data-v-a79f1ce6${_scopeId}><div class="inline-flex bg-[--el-color-info-light-10] rounded-md p-1 gq-border-none border-1 gap-2" data-v-a79f1ce6${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_button, {
              plain: "",
              size: "small",
              class: `cursor-pointer !m-0 ${unref(state).type === "SELECTED" ? "is-active" : ""}`,
              onClick: ($event) => unref(state).type = "SELECTED"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(unref($t)("page.account.settings.address.selectAddress"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(unref($t)("page.account.settings.address.selectAddress")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_el_button, {
              plain: "",
              size: "small",
              class: `cursor-pointer !m-0 ${unref(state).type === "MANUAL" ? "is-active" : ""}`,
              onClick: ($event) => unref(state).type = "MANUAL"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(unref($t)("page.account.settings.address.manualInput"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(unref($t)("page.account.settings.address.manualInput")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div><label class="flex items-center gap-2 cursor-pointer" data-v-a79f1ce6${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_switch, {
              modelValue: unref(state).defaultAddress,
              "onUpdate:modelValue": ($event) => unref(state).defaultAddress = $event,
              size: "small"
            }, null, _parent2, _scopeId));
            _push2(`<span class="text-xs text-[--el-color-primary] leading-none" data-v-a79f1ce6${_scopeId}>${ssrInterpolate(unref($t)("page.account.settings.address.setDefault"))}</span></label></div></div>`);
            _push2(ssrRenderComponent(_component_el_form, {
              "label-width": "120px",
              "label-position": "top"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  if (unref(state).type === "MANUAL") {
                    _push3(ssrRenderComponent(_component_el_form_item, { class: "col-span-2" }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_el_input, {
                            modelValue: unref(state).addressString,
                            "onUpdate:modelValue": ($event) => unref(state).addressString = $event,
                            placeholder: unref($t)("page.account.settings.address.inputAddress"),
                            rows: 6,
                            type: "textarea",
                            class: "w-full"
                          }, null, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(_component_el_input, {
                              modelValue: unref(state).addressString,
                              "onUpdate:modelValue": ($event) => unref(state).addressString = $event,
                              placeholder: unref($t)("page.account.settings.address.inputAddress"),
                              rows: 6,
                              type: "textarea",
                              class: "w-full"
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    _push3(`<!--[-->`);
                    _push3(ssrRenderComponent(_component_el_form_item, {
                      label: unref($t)("page.account.settings.address.country")
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_el_select, {
                            modelValue: unref(state).selectedCountry,
                            "onUpdate:modelValue": ($event) => unref(state).selectedCountry = $event,
                            placeholder: unref($t)("page.account.settings.address.selectCountry"),
                            onChange: unref(state).loadProvinces,
                            clearable: ""
                          }, {
                            default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                              if (_push5) {
                                _push5(`<!--[-->`);
                                ssrRenderList(unref(state).countries, (country) => {
                                  _push5(ssrRenderComponent(_component_el_option, {
                                    key: country.value,
                                    label: country.label[_ctx.$i18n.locale],
                                    value: country.value
                                  }, null, _parent5, _scopeId4));
                                });
                                _push5(`<!--]-->`);
                              } else {
                                return [
                                  (openBlock(true), createBlock(Fragment, null, renderList(unref(state).countries, (country) => {
                                    return openBlock(), createBlock(_component_el_option, {
                                      key: country.value,
                                      label: country.label[_ctx.$i18n.locale],
                                      value: country.value
                                    }, null, 8, ["label", "value"]);
                                  }), 128))
                                ];
                              }
                            }),
                            _: 1
                          }, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(_component_el_select, {
                              modelValue: unref(state).selectedCountry,
                              "onUpdate:modelValue": ($event) => unref(state).selectedCountry = $event,
                              placeholder: unref($t)("page.account.settings.address.selectCountry"),
                              onChange: unref(state).loadProvinces,
                              clearable: ""
                            }, {
                              default: withCtx(() => [
                                (openBlock(true), createBlock(Fragment, null, renderList(unref(state).countries, (country) => {
                                  return openBlock(), createBlock(_component_el_option, {
                                    key: country.value,
                                    label: country.label[_ctx.$i18n.locale],
                                    value: country.value
                                  }, null, 8, ["label", "value"]);
                                }), 128))
                              ]),
                              _: 1
                            }, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onChange"])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_el_form_item, {
                      label: unref($t)("page.account.settings.address.province")
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_el_select, {
                            modelValue: unref(state).selectedProvince,
                            "onUpdate:modelValue": ($event) => unref(state).selectedProvince = $event,
                            placeholder: unref($t)("page.account.settings.address.selectProvince"),
                            onChange: unref(state).loadCities,
                            disabled: unref(state).provinces.length === 0 && !unref(state).hasSelectedProvince || !unref(state).hasSelectedProvince,
                            clearable: ""
                          }, {
                            default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                              if (_push5) {
                                _push5(`<!--[-->`);
                                ssrRenderList(unref(state).provinces, (province) => {
                                  _push5(ssrRenderComponent(_component_el_option, {
                                    key: province.value,
                                    label: province.label,
                                    value: province.value
                                  }, null, _parent5, _scopeId4));
                                });
                                _push5(`<!--]-->`);
                              } else {
                                return [
                                  (openBlock(true), createBlock(Fragment, null, renderList(unref(state).provinces, (province) => {
                                    return openBlock(), createBlock(_component_el_option, {
                                      key: province.value,
                                      label: province.label,
                                      value: province.value
                                    }, null, 8, ["label", "value"]);
                                  }), 128))
                                ];
                              }
                            }),
                            _: 1
                          }, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(_component_el_select, {
                              modelValue: unref(state).selectedProvince,
                              "onUpdate:modelValue": ($event) => unref(state).selectedProvince = $event,
                              placeholder: unref($t)("page.account.settings.address.selectProvince"),
                              onChange: unref(state).loadCities,
                              disabled: unref(state).provinces.length === 0 && !unref(state).hasSelectedProvince || !unref(state).hasSelectedProvince,
                              clearable: ""
                            }, {
                              default: withCtx(() => [
                                (openBlock(true), createBlock(Fragment, null, renderList(unref(state).provinces, (province) => {
                                  return openBlock(), createBlock(_component_el_option, {
                                    key: province.value,
                                    label: province.label,
                                    value: province.value
                                  }, null, 8, ["label", "value"]);
                                }), 128))
                              ]),
                              _: 1
                            }, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onChange", "disabled"])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_el_form_item, {
                      label: unref($t)("page.account.settings.address.city")
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_el_select, {
                            modelValue: unref(state).selectedCity,
                            "onUpdate:modelValue": ($event) => unref(state).selectedCity = $event,
                            placeholder: unref($t)("page.account.settings.address.selectCity"),
                            onChange: unref(state).loadDistricts,
                            disabled: unref(state).cities.length === 0 && !unref(state).hasSelectedCity || !unref(state).hasSelectedCity,
                            clearable: ""
                          }, {
                            default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                              if (_push5) {
                                _push5(`<!--[-->`);
                                ssrRenderList(unref(state).cities, (city) => {
                                  _push5(ssrRenderComponent(_component_el_option, {
                                    key: city.value,
                                    label: city.label,
                                    value: city.value
                                  }, null, _parent5, _scopeId4));
                                });
                                _push5(`<!--]-->`);
                              } else {
                                return [
                                  (openBlock(true), createBlock(Fragment, null, renderList(unref(state).cities, (city) => {
                                    return openBlock(), createBlock(_component_el_option, {
                                      key: city.value,
                                      label: city.label,
                                      value: city.value
                                    }, null, 8, ["label", "value"]);
                                  }), 128))
                                ];
                              }
                            }),
                            _: 1
                          }, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(_component_el_select, {
                              modelValue: unref(state).selectedCity,
                              "onUpdate:modelValue": ($event) => unref(state).selectedCity = $event,
                              placeholder: unref($t)("page.account.settings.address.selectCity"),
                              onChange: unref(state).loadDistricts,
                              disabled: unref(state).cities.length === 0 && !unref(state).hasSelectedCity || !unref(state).hasSelectedCity,
                              clearable: ""
                            }, {
                              default: withCtx(() => [
                                (openBlock(true), createBlock(Fragment, null, renderList(unref(state).cities, (city) => {
                                  return openBlock(), createBlock(_component_el_option, {
                                    key: city.value,
                                    label: city.label,
                                    value: city.value
                                  }, null, 8, ["label", "value"]);
                                }), 128))
                              ]),
                              _: 1
                            }, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onChange", "disabled"])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_el_form_item, {
                      label: unref($t)("page.account.settings.address.district")
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_el_select, {
                            modelValue: unref(state).selectedDistrict,
                            "onUpdate:modelValue": ($event) => unref(state).selectedDistrict = $event,
                            placeholder: unref($t)("page.account.settings.address.selectDistrict"),
                            onChange: unref(state).setAddressString,
                            disabled: unref(state).districts.length === 0 && !unref(state).hasSelectedDistrict || !unref(state).hasSelectedDistrict,
                            clearable: ""
                          }, {
                            default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                              if (_push5) {
                                _push5(`<!--[-->`);
                                ssrRenderList(unref(state).districts, (district) => {
                                  _push5(ssrRenderComponent(_component_el_option, {
                                    key: district.value,
                                    label: district.label,
                                    value: district.value
                                  }, null, _parent5, _scopeId4));
                                });
                                _push5(`<!--]-->`);
                              } else {
                                return [
                                  (openBlock(true), createBlock(Fragment, null, renderList(unref(state).districts, (district) => {
                                    return openBlock(), createBlock(_component_el_option, {
                                      key: district.value,
                                      label: district.label,
                                      value: district.value
                                    }, null, 8, ["label", "value"]);
                                  }), 128))
                                ];
                              }
                            }),
                            _: 1
                          }, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(_component_el_select, {
                              modelValue: unref(state).selectedDistrict,
                              "onUpdate:modelValue": ($event) => unref(state).selectedDistrict = $event,
                              placeholder: unref($t)("page.account.settings.address.selectDistrict"),
                              onChange: unref(state).setAddressString,
                              disabled: unref(state).districts.length === 0 && !unref(state).hasSelectedDistrict || !unref(state).hasSelectedDistrict,
                              clearable: ""
                            }, {
                              default: withCtx(() => [
                                (openBlock(true), createBlock(Fragment, null, renderList(unref(state).districts, (district) => {
                                  return openBlock(), createBlock(_component_el_option, {
                                    key: district.value,
                                    label: district.label,
                                    value: district.value
                                  }, null, 8, ["label", "value"]);
                                }), 128))
                              ]),
                              _: 1
                            }, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onChange", "disabled"])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(ssrRenderComponent(_component_el_form_item, {
                      label: unref($t)("page.account.settings.address.address"),
                      class: "col-span-2"
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_el_input, {
                            modelValue: unref(state).address,
                            "onUpdate:modelValue": ($event) => unref(state).address = $event,
                            placeholder: unref($t)("page.account.settings.address.inputAddress"),
                            onInput: unref(state).setAddressString
                          }, null, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(_component_el_input, {
                              modelValue: unref(state).address,
                              "onUpdate:modelValue": ($event) => unref(state).address = $event,
                              placeholder: unref($t)("page.account.settings.address.inputAddress"),
                              onInput: unref(state).setAddressString
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onInput"])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`<!--]-->`);
                  }
                  _push3(ssrRenderComponent(_component_el_form_item, {
                    label: unref($t)("page.account.settings.address.phone"),
                    class: "col-span-2"
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_el_input, {
                          modelValue: unref(state).phone,
                          "onUpdate:modelValue": ($event) => unref(state).phone = $event,
                          placeholder: unref($t)("page.account.settings.address.inputPhone")
                        }, {
                          prefix: withCtx((_4, _push5, _parent5, _scopeId4) => {
                            if (_push5) {
                              _push5(ssrRenderComponent(_component_CommonFormCountryDialCodes, {
                                modelValue: unref(state).dialCode,
                                "onUpdate:modelValue": ($event) => unref(state).dialCode = $event
                              }, null, _parent5, _scopeId4));
                            } else {
                              return [
                                createVNode(_component_CommonFormCountryDialCodes, {
                                  modelValue: unref(state).dialCode,
                                  "onUpdate:modelValue": ($event) => unref(state).dialCode = $event
                                }, null, 8, ["modelValue", "onUpdate:modelValue"])
                              ];
                            }
                          }),
                          _: 1
                        }, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_el_input, {
                            modelValue: unref(state).phone,
                            "onUpdate:modelValue": ($event) => unref(state).phone = $event,
                            placeholder: unref($t)("page.account.settings.address.inputPhone")
                          }, {
                            prefix: withCtx(() => [
                              createVNode(_component_CommonFormCountryDialCodes, {
                                modelValue: unref(state).dialCode,
                                "onUpdate:modelValue": ($event) => unref(state).dialCode = $event
                              }, null, 8, ["modelValue", "onUpdate:modelValue"])
                            ]),
                            _: 1
                          }, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_el_form_item, {
                    label: unref($t)("page.account.settings.address.name")
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_el_input, {
                          modelValue: unref(state).name,
                          "onUpdate:modelValue": ($event) => unref(state).name = $event,
                          placeholder: unref($t)("page.account.settings.address.inputName")
                        }, null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_el_input, {
                            modelValue: unref(state).name,
                            "onUpdate:modelValue": ($event) => unref(state).name = $event,
                            placeholder: unref($t)("page.account.settings.address.inputName")
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                  _push3(ssrRenderComponent(_component_el_form_item, {
                    label: unref($t)("page.account.settings.address.postalCode")
                  }, {
                    default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                      if (_push4) {
                        _push4(ssrRenderComponent(_component_el_input, {
                          modelValue: unref(state).postalCode,
                          "onUpdate:modelValue": ($event) => unref(state).postalCode = $event,
                          placeholder: unref($t)("page.account.settings.address.inputPostalCode")
                        }, null, _parent4, _scopeId3));
                      } else {
                        return [
                          createVNode(_component_el_input, {
                            modelValue: unref(state).postalCode,
                            "onUpdate:modelValue": ($event) => unref(state).postalCode = $event,
                            placeholder: unref($t)("page.account.settings.address.inputPostalCode")
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                        ];
                      }
                    }),
                    _: 1
                  }, _parent3, _scopeId2));
                } else {
                  return [
                    unref(state).type === "MANUAL" ? (openBlock(), createBlock(_component_el_form_item, {
                      key: 0,
                      class: "col-span-2"
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_el_input, {
                          modelValue: unref(state).addressString,
                          "onUpdate:modelValue": ($event) => unref(state).addressString = $event,
                          placeholder: unref($t)("page.account.settings.address.inputAddress"),
                          rows: 6,
                          type: "textarea",
                          class: "w-full"
                        }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                      ]),
                      _: 1
                    })) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                      createVNode(_component_el_form_item, {
                        label: unref($t)("page.account.settings.address.country")
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_el_select, {
                            modelValue: unref(state).selectedCountry,
                            "onUpdate:modelValue": ($event) => unref(state).selectedCountry = $event,
                            placeholder: unref($t)("page.account.settings.address.selectCountry"),
                            onChange: unref(state).loadProvinces,
                            clearable: ""
                          }, {
                            default: withCtx(() => [
                              (openBlock(true), createBlock(Fragment, null, renderList(unref(state).countries, (country) => {
                                return openBlock(), createBlock(_component_el_option, {
                                  key: country.value,
                                  label: country.label[_ctx.$i18n.locale],
                                  value: country.value
                                }, null, 8, ["label", "value"]);
                              }), 128))
                            ]),
                            _: 1
                          }, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onChange"])
                        ]),
                        _: 1
                      }, 8, ["label"]),
                      createVNode(_component_el_form_item, {
                        label: unref($t)("page.account.settings.address.province")
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_el_select, {
                            modelValue: unref(state).selectedProvince,
                            "onUpdate:modelValue": ($event) => unref(state).selectedProvince = $event,
                            placeholder: unref($t)("page.account.settings.address.selectProvince"),
                            onChange: unref(state).loadCities,
                            disabled: unref(state).provinces.length === 0 && !unref(state).hasSelectedProvince || !unref(state).hasSelectedProvince,
                            clearable: ""
                          }, {
                            default: withCtx(() => [
                              (openBlock(true), createBlock(Fragment, null, renderList(unref(state).provinces, (province) => {
                                return openBlock(), createBlock(_component_el_option, {
                                  key: province.value,
                                  label: province.label,
                                  value: province.value
                                }, null, 8, ["label", "value"]);
                              }), 128))
                            ]),
                            _: 1
                          }, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onChange", "disabled"])
                        ]),
                        _: 1
                      }, 8, ["label"]),
                      createVNode(_component_el_form_item, {
                        label: unref($t)("page.account.settings.address.city")
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_el_select, {
                            modelValue: unref(state).selectedCity,
                            "onUpdate:modelValue": ($event) => unref(state).selectedCity = $event,
                            placeholder: unref($t)("page.account.settings.address.selectCity"),
                            onChange: unref(state).loadDistricts,
                            disabled: unref(state).cities.length === 0 && !unref(state).hasSelectedCity || !unref(state).hasSelectedCity,
                            clearable: ""
                          }, {
                            default: withCtx(() => [
                              (openBlock(true), createBlock(Fragment, null, renderList(unref(state).cities, (city) => {
                                return openBlock(), createBlock(_component_el_option, {
                                  key: city.value,
                                  label: city.label,
                                  value: city.value
                                }, null, 8, ["label", "value"]);
                              }), 128))
                            ]),
                            _: 1
                          }, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onChange", "disabled"])
                        ]),
                        _: 1
                      }, 8, ["label"]),
                      createVNode(_component_el_form_item, {
                        label: unref($t)("page.account.settings.address.district")
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_el_select, {
                            modelValue: unref(state).selectedDistrict,
                            "onUpdate:modelValue": ($event) => unref(state).selectedDistrict = $event,
                            placeholder: unref($t)("page.account.settings.address.selectDistrict"),
                            onChange: unref(state).setAddressString,
                            disabled: unref(state).districts.length === 0 && !unref(state).hasSelectedDistrict || !unref(state).hasSelectedDistrict,
                            clearable: ""
                          }, {
                            default: withCtx(() => [
                              (openBlock(true), createBlock(Fragment, null, renderList(unref(state).districts, (district) => {
                                return openBlock(), createBlock(_component_el_option, {
                                  key: district.value,
                                  label: district.label,
                                  value: district.value
                                }, null, 8, ["label", "value"]);
                              }), 128))
                            ]),
                            _: 1
                          }, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onChange", "disabled"])
                        ]),
                        _: 1
                      }, 8, ["label"]),
                      createVNode(_component_el_form_item, {
                        label: unref($t)("page.account.settings.address.address"),
                        class: "col-span-2"
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_el_input, {
                            modelValue: unref(state).address,
                            "onUpdate:modelValue": ($event) => unref(state).address = $event,
                            placeholder: unref($t)("page.account.settings.address.inputAddress"),
                            onInput: unref(state).setAddressString
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onInput"])
                        ]),
                        _: 1
                      }, 8, ["label"])
                    ], 64)),
                    createVNode(_component_el_form_item, {
                      label: unref($t)("page.account.settings.address.phone"),
                      class: "col-span-2"
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_el_input, {
                          modelValue: unref(state).phone,
                          "onUpdate:modelValue": ($event) => unref(state).phone = $event,
                          placeholder: unref($t)("page.account.settings.address.inputPhone")
                        }, {
                          prefix: withCtx(() => [
                            createVNode(_component_CommonFormCountryDialCodes, {
                              modelValue: unref(state).dialCode,
                              "onUpdate:modelValue": ($event) => unref(state).dialCode = $event
                            }, null, 8, ["modelValue", "onUpdate:modelValue"])
                          ]),
                          _: 1
                        }, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                      ]),
                      _: 1
                    }, 8, ["label"]),
                    createVNode(_component_el_form_item, {
                      label: unref($t)("page.account.settings.address.name")
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_el_input, {
                          modelValue: unref(state).name,
                          "onUpdate:modelValue": ($event) => unref(state).name = $event,
                          placeholder: unref($t)("page.account.settings.address.inputName")
                        }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                      ]),
                      _: 1
                    }, 8, ["label"]),
                    createVNode(_component_el_form_item, {
                      label: unref($t)("page.account.settings.address.postalCode")
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_el_input, {
                          modelValue: unref(state).postalCode,
                          "onUpdate:modelValue": ($event) => unref(state).postalCode = $event,
                          placeholder: unref($t)("page.account.settings.address.inputPostalCode")
                        }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                      ]),
                      _: 1
                    }, 8, ["label"])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`<div class="flex w-full" data-v-a79f1ce6${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_button, {
              type: "primary",
              onClick: unref(state).saveAddress,
              class: "w-full",
              loading: unref(state).locekd
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(unref($t)("common.edit.save"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(unref($t)("common.edit.save")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "mb-6 pb-4 border-b border-gray-200" }, [
                createVNode("div", { class: "flex gap-3 items-center justify-between" }, [
                  createVNode("div", { class: "inline-flex bg-[--el-color-info-light-10] rounded-md p-1 gq-border-none border-1 gap-2" }, [
                    createVNode(_component_el_button, {
                      plain: "",
                      size: "small",
                      class: `cursor-pointer !m-0 ${unref(state).type === "SELECTED" ? "is-active" : ""}`,
                      onClick: ($event) => unref(state).type = "SELECTED"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(unref($t)("page.account.settings.address.selectAddress")), 1)
                      ]),
                      _: 1
                    }, 8, ["class", "onClick"]),
                    createVNode(_component_el_button, {
                      plain: "",
                      size: "small",
                      class: `cursor-pointer !m-0 ${unref(state).type === "MANUAL" ? "is-active" : ""}`,
                      onClick: ($event) => unref(state).type = "MANUAL"
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(unref($t)("page.account.settings.address.manualInput")), 1)
                      ]),
                      _: 1
                    }, 8, ["class", "onClick"])
                  ]),
                  createVNode("label", { class: "flex items-center gap-2 cursor-pointer" }, [
                    createVNode(_component_el_switch, {
                      modelValue: unref(state).defaultAddress,
                      "onUpdate:modelValue": ($event) => unref(state).defaultAddress = $event,
                      size: "small"
                    }, null, 8, ["modelValue", "onUpdate:modelValue"]),
                    createVNode("span", { class: "text-xs text-[--el-color-primary] leading-none" }, toDisplayString(unref($t)("page.account.settings.address.setDefault")), 1)
                  ])
                ])
              ]),
              createVNode(_component_el_form, {
                "label-width": "120px",
                "label-position": "top"
              }, {
                default: withCtx(() => [
                  unref(state).type === "MANUAL" ? (openBlock(), createBlock(_component_el_form_item, {
                    key: 0,
                    class: "col-span-2"
                  }, {
                    default: withCtx(() => [
                      createVNode(_component_el_input, {
                        modelValue: unref(state).addressString,
                        "onUpdate:modelValue": ($event) => unref(state).addressString = $event,
                        placeholder: unref($t)("page.account.settings.address.inputAddress"),
                        rows: 6,
                        type: "textarea",
                        class: "w-full"
                      }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                    ]),
                    _: 1
                  })) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                    createVNode(_component_el_form_item, {
                      label: unref($t)("page.account.settings.address.country")
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_el_select, {
                          modelValue: unref(state).selectedCountry,
                          "onUpdate:modelValue": ($event) => unref(state).selectedCountry = $event,
                          placeholder: unref($t)("page.account.settings.address.selectCountry"),
                          onChange: unref(state).loadProvinces,
                          clearable: ""
                        }, {
                          default: withCtx(() => [
                            (openBlock(true), createBlock(Fragment, null, renderList(unref(state).countries, (country) => {
                              return openBlock(), createBlock(_component_el_option, {
                                key: country.value,
                                label: country.label[_ctx.$i18n.locale],
                                value: country.value
                              }, null, 8, ["label", "value"]);
                            }), 128))
                          ]),
                          _: 1
                        }, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onChange"])
                      ]),
                      _: 1
                    }, 8, ["label"]),
                    createVNode(_component_el_form_item, {
                      label: unref($t)("page.account.settings.address.province")
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_el_select, {
                          modelValue: unref(state).selectedProvince,
                          "onUpdate:modelValue": ($event) => unref(state).selectedProvince = $event,
                          placeholder: unref($t)("page.account.settings.address.selectProvince"),
                          onChange: unref(state).loadCities,
                          disabled: unref(state).provinces.length === 0 && !unref(state).hasSelectedProvince || !unref(state).hasSelectedProvince,
                          clearable: ""
                        }, {
                          default: withCtx(() => [
                            (openBlock(true), createBlock(Fragment, null, renderList(unref(state).provinces, (province) => {
                              return openBlock(), createBlock(_component_el_option, {
                                key: province.value,
                                label: province.label,
                                value: province.value
                              }, null, 8, ["label", "value"]);
                            }), 128))
                          ]),
                          _: 1
                        }, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onChange", "disabled"])
                      ]),
                      _: 1
                    }, 8, ["label"]),
                    createVNode(_component_el_form_item, {
                      label: unref($t)("page.account.settings.address.city")
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_el_select, {
                          modelValue: unref(state).selectedCity,
                          "onUpdate:modelValue": ($event) => unref(state).selectedCity = $event,
                          placeholder: unref($t)("page.account.settings.address.selectCity"),
                          onChange: unref(state).loadDistricts,
                          disabled: unref(state).cities.length === 0 && !unref(state).hasSelectedCity || !unref(state).hasSelectedCity,
                          clearable: ""
                        }, {
                          default: withCtx(() => [
                            (openBlock(true), createBlock(Fragment, null, renderList(unref(state).cities, (city) => {
                              return openBlock(), createBlock(_component_el_option, {
                                key: city.value,
                                label: city.label,
                                value: city.value
                              }, null, 8, ["label", "value"]);
                            }), 128))
                          ]),
                          _: 1
                        }, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onChange", "disabled"])
                      ]),
                      _: 1
                    }, 8, ["label"]),
                    createVNode(_component_el_form_item, {
                      label: unref($t)("page.account.settings.address.district")
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_el_select, {
                          modelValue: unref(state).selectedDistrict,
                          "onUpdate:modelValue": ($event) => unref(state).selectedDistrict = $event,
                          placeholder: unref($t)("page.account.settings.address.selectDistrict"),
                          onChange: unref(state).setAddressString,
                          disabled: unref(state).districts.length === 0 && !unref(state).hasSelectedDistrict || !unref(state).hasSelectedDistrict,
                          clearable: ""
                        }, {
                          default: withCtx(() => [
                            (openBlock(true), createBlock(Fragment, null, renderList(unref(state).districts, (district) => {
                              return openBlock(), createBlock(_component_el_option, {
                                key: district.value,
                                label: district.label,
                                value: district.value
                              }, null, 8, ["label", "value"]);
                            }), 128))
                          ]),
                          _: 1
                        }, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onChange", "disabled"])
                      ]),
                      _: 1
                    }, 8, ["label"]),
                    createVNode(_component_el_form_item, {
                      label: unref($t)("page.account.settings.address.address"),
                      class: "col-span-2"
                    }, {
                      default: withCtx(() => [
                        createVNode(_component_el_input, {
                          modelValue: unref(state).address,
                          "onUpdate:modelValue": ($event) => unref(state).address = $event,
                          placeholder: unref($t)("page.account.settings.address.inputAddress"),
                          onInput: unref(state).setAddressString
                        }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onInput"])
                      ]),
                      _: 1
                    }, 8, ["label"])
                  ], 64)),
                  createVNode(_component_el_form_item, {
                    label: unref($t)("page.account.settings.address.phone"),
                    class: "col-span-2"
                  }, {
                    default: withCtx(() => [
                      createVNode(_component_el_input, {
                        modelValue: unref(state).phone,
                        "onUpdate:modelValue": ($event) => unref(state).phone = $event,
                        placeholder: unref($t)("page.account.settings.address.inputPhone")
                      }, {
                        prefix: withCtx(() => [
                          createVNode(_component_CommonFormCountryDialCodes, {
                            modelValue: unref(state).dialCode,
                            "onUpdate:modelValue": ($event) => unref(state).dialCode = $event
                          }, null, 8, ["modelValue", "onUpdate:modelValue"])
                        ]),
                        _: 1
                      }, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                    ]),
                    _: 1
                  }, 8, ["label"]),
                  createVNode(_component_el_form_item, {
                    label: unref($t)("page.account.settings.address.name")
                  }, {
                    default: withCtx(() => [
                      createVNode(_component_el_input, {
                        modelValue: unref(state).name,
                        "onUpdate:modelValue": ($event) => unref(state).name = $event,
                        placeholder: unref($t)("page.account.settings.address.inputName")
                      }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                    ]),
                    _: 1
                  }, 8, ["label"]),
                  createVNode(_component_el_form_item, {
                    label: unref($t)("page.account.settings.address.postalCode")
                  }, {
                    default: withCtx(() => [
                      createVNode(_component_el_input, {
                        modelValue: unref(state).postalCode,
                        "onUpdate:modelValue": ($event) => unref(state).postalCode = $event,
                        placeholder: unref($t)("page.account.settings.address.inputPostalCode")
                      }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                    ]),
                    _: 1
                  }, 8, ["label"])
                ]),
                _: 1
              }),
              createVNode("div", { class: "flex w-full" }, [
                createVNode(_component_el_button, {
                  type: "primary",
                  onClick: unref(state).saveAddress,
                  class: "w-full",
                  loading: unref(state).locekd
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(unref($t)("common.edit.save")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick", "loading"])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/form/addressForm.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const addressForm = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-a79f1ce6"]]);

export { addressForm as default };
