import { defineStore } from 'pinia';

function saveListToLocalStorage(list) {
  localStorage.setItem("audioPlayList", JSON.stringify(list));
}
const audioStore = defineStore("audio", {
  state: () => ({
    src: "",
    time: 0,
    playing: false,
    thumb: "",
    title: "",
    canvas: null,
    list: [],
    // Initialize with data from localStorage
    currentTime: 0,
    duration: 0,
    picked: 0
  }),
  actions: {
    // since we rely on `this`, we cannot use an arrow function
    setCanvas(val) {
      this.canvas = val;
      if (this.canvas) {
        this.canvas.style.display = "block";
      }
    },
    setData(data) {
      if (!data.src) {
        return;
      }
      this.src = data.src;
      this.time = data.time;
      this.thumb = data.thumb;
      if (!data.title) {
        data.title = data.src.split("/").pop().split(".").shift();
      } else {
        data.title = data.title;
      }
      const exists = this.list.findIndex((item) => item.src === data.src);
      if (exists == -1) {
        if (this.list.length >= 20) {
          this.list.splice(0, this.list.length - 20);
        }
        this.list.push(data);
      }
      saveListToLocalStorage(this.list);
    }
  }
});

export { audioStore as a };
