import { E as ElForm, a as ElFormItem } from './index-DwNba9hO.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import _sfc_main$1 from './countryDialCodes-DK3oAU-H.mjs';
import { d as useRoute, f as useRouter, v as viewerStore, a as useI18n, r as useRequest, E as ElMessage, s as useIntervalFn, _ as __nuxt_component_0$2 } from './server.mjs';
import { v as vLoading } from './directive-BPPM1aUC.mjs';
import { ref, reactive, mergeProps, unref, withCtx, createTextVNode, toDisplayString, createSlots, createVNode, openBlock, createBlock, createCommentVNode, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrGetDirectiveProps, ssrInterpolate, ssrRenderComponent } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '@vue/shared';
import 'lodash-unified';
import './constants-hAKFmBbq.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import 'async-validator';
import './index-ChPMoinw.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import '@ctrl/tinycolor';
import './event-BZTOGHfp.mjs';
import './index-DRiwogtD.mjs';
import './index-BKB3Djp4.mjs';
import './index-Bp-nwGzu.mjs';
import './aria-BhThsKez.mjs';
import './popover-B8HtRMY4.mjs';
import './index-tCyBRCDx.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "authorize",
  __ssrInlineRender: true,
  setup(__props) {
    const route = useRoute();
    const router = useRouter();
    const viewer = viewerStore();
    const { locale, t } = useI18n();
    const captcha = ref(null);
    const countryDialCodes = ref(null);
    const form = reactive({
      type: "phone",
      boundEmail: false,
      boundPhone: false,
      key: "",
      password: "",
      verificationInput: "",
      verificationSign: "",
      phoneOrEmail: "",
      error: "",
      timer: 0,
      hasCallback: false,
      submitLocked: false,
      interval: useIntervalFn(
        () => {
          if (form.timer <= 0) {
            form.getCodeLocked = false;
            form.interval.pause();
          } else {
            form.timer--;
          }
        },
        1e3,
        {
          // 默认不开启定时任务
          immediate: false
        }
      ),
      getCode: async function() {
        if (!form.phoneOrEmail) {
          if (form.type == "phone") {
            ElMessage.error(t("common.login.error.requiredPhone"));
          } else {
            ElMessage.error(t("common.login.error.requiredEmail"));
          }
        }
        if (form.getCodeLocked) {
          return;
        }
        form.getCodeLocked = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              captchaSign: captcha.value.captchaSign,
              captchaInput: captcha.value.captchaInput,
              phoneOrEmail: form.type == "phone" ? (countryDialCodes.value?.countryDialCodes?.picked[1] ?? "") + " " + form.phoneOrEmail : form.phoneOrEmail,
              lang: locale.value,
              siteUrl: (void 0).origin,
              timestamp: captcha.value.timestamp
            }
          }
        });
        if (res) {
          if (form.timer === 0) {
            form.timer = 60;
            form.interval.resume();
          } else {
            form.getCodeLocked = false;
            form.interval.pause();
            form.timer = 0;
          }
          form.verificationSign = res?.guaqi?.utils?.getCode;
        } else {
          form.getCodeLocked = false;
          form.interval.pause();
          form.timer = 0;
        }
      },
      getData: async () => {
        if (form.submitLocked) return;
        form.submitLocked = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              type: route.query.type.toUpperCase() || "",
              code: route.query.code || "",
              state: route.query.state || ""
            }
          }
        });
        if (res?.guaqi?.utils?.socialLoginCallback) {
          if (res?.guaqi?.utils?.socialLoginCallback?.key) {
            form.key = res?.guaqi?.utils?.socialLoginCallback?.key;
            form.boundEmail = res?.guaqi?.utils?.socialLoginCallback?.email;
            form.boundPhone = res?.guaqi?.utils?.socialLoginCallback?.phone;
            form.type = form.boundPhone ? "phone" : "email";
          } else {
            delete res?.guaqi?.utils.socialLoginCallback.auth;
            viewer.setData(res?.guaqi?.utils.socialLoginCallback);
            const socialLoginUrl = localStorage.getItem("socialLoginUrl");
            if (socialLoginUrl) {
              localStorage.removeItem("socialLoginUrl");
              (void 0).location.href = socialLoginUrl;
            }
          }
        } else {
          form.error = "登录失败";
        }
        form.hasCallback = true;
        form.submitLocked = false;
      },
      socialCreateUser: async () => {
        if (form.submitLocked) return;
        form.submitLocked = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              key: form.key,
              phoneOrEmail: form.type == "phone" ? (countryDialCodes.value?.countryDialCodes?.picked[1] ?? "") + " " + form.phoneOrEmail : form.phoneOrEmail,
              password: form.password,
              verificationInput: form.verificationInput,
              verificationSign: form.verificationSign,
              captchaInput: captcha.value.captchaInput,
              captchaSign: captcha.value.captchaSign,
              timestamp: captcha.value.timestamp
            }
          }
        });
        if (res?.gqSocialCreateUser?.user) {
          delete res?.gqSocialCreateUser.user.auth;
          viewer.setData(res?.gqSocialCreateUser.user);
          router.back();
        }
        form.submitLocked = false;
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_form = ElForm;
      const _component_el_button = ElButton;
      const _component_el_form_item = ElFormItem;
      const _component_el_input = ElInput;
      const _component_CommonFormCountryDialCodes = _sfc_main$1;
      const _component_CommonFormCaptcha = __nuxt_component_0$2;
      const _directive_loading = vLoading;
      let _temp0;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "w-full mx-auto mt-8 max-w-xs" }, _attrs))} data-v-b3cd61b9>`);
      if (!unref(form).hasCallback) {
        _push(`<div class="flex justify-center gap-3 flex-col items-center py-8 bg-[--el-bg-color]" data-v-b3cd61b9><div${ssrRenderAttrs(_temp0 = mergeProps({ class: "w-12 h-12 rounded-full mb-3" }, ssrGetDirectiveProps(_ctx, _directive_loading, true)))} data-v-b3cd61b9>${"textContent" in _temp0 ? ssrInterpolate(_temp0.textContent) : _temp0.innerHTML ?? ""}</div><h2 class="text-lg font-600" data-v-b3cd61b9>${ssrInterpolate(_ctx.$t("common.login.authorize.authorizing"))}</h2><div class="text-sm" data-v-b3cd61b9>${ssrInterpolate(_ctx.$t("common.login.authorize.authorizingDesc"))}</div></div>`);
      } else if (unref(form).error) {
        _push(`<div class="flex justify-center gap-2 flex-col items-center py-8 bg-[--el-bg-color]" data-v-b3cd61b9><div class="w-12 h-12 rounded-full mb-3 flex" data-v-b3cd61b9><i class="i-ph-x-circle-thin text-[--el-color-danger] text-5xl" data-v-b3cd61b9></i></div><h2 class="text-lg font-600" data-v-b3cd61b9>${ssrInterpolate(unref(form).error)}</h2><div class="text-sm" data-v-b3cd61b9>${ssrInterpolate(_ctx.$t("common.login.authorize.authorizingErrorDesc"))}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(form).boundPhone || unref(form).boundEmail) {
        _push(`<div class="mb-4 flex items-center justify-between flex-col gap-3" data-v-b3cd61b9><i class="i-ph-fediverse-logo-thin text-[--el-color-primary] text-5xl" data-v-b3cd61b9></i><div class="flex text-sm" data-v-b3cd61b9>`);
        if (unref(form).boundEmail && unref(form).boundPhone) {
          _push(`<span data-v-b3cd61b9>${ssrInterpolate(_ctx.$t("common.login.authorize.boundPhoneOrEmail"))}</span>`);
        } else if (unref(form).boundPhone) {
          _push(`<span data-v-b3cd61b9>${ssrInterpolate(_ctx.$t("common.login.authorize.bindPhone"))}</span>`);
        } else if (unref(form).boundEmail) {
          _push(`<span data-v-b3cd61b9>${ssrInterpolate(_ctx.$t("common.login.authorize.bindEmail"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (unref(form).boundPhone || unref(form).boundEmail) {
        _push(`<div class="bg-[--el-bg-color] h-full overflow-hidden rounded-md shadow p-4 w-full bound-form" data-v-b3cd61b9><div class="flex gap-2 flex-col" data-v-b3cd61b9>`);
        _push(ssrRenderComponent(_component_el_form, { "label-position": "top" }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (unref(form).boundPhone && unref(form).boundEmail) {
                _push2(`<div class="mb-4 flex justify-center" data-v-b3cd61b9${_scopeId}>`);
                _push2(ssrRenderComponent(_component_el_button, {
                  style: { "--el-fill-color-light": "transparent", "--el-fill-color": "transparent" },
                  text: "",
                  size: "small",
                  class: `cursor-pointer !bg-none !p-0 !rounded-none !border-0 ${unref(form).type === "phone" ? "!border-b-2 !border-[--el-color-primary] !font-600" : ""}`,
                  onClick: ($event) => unref(form).type = "phone"
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`${ssrInterpolate(_ctx.$t("common.login.authorize.bindPhone"))}`);
                    } else {
                      return [
                        createTextVNode(toDisplayString(_ctx.$t("common.login.authorize.bindPhone")), 1)
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
                _push2(ssrRenderComponent(_component_el_button, {
                  style: { "--el-fill-color-light": "transparent", "--el-fill-color": "transparent" },
                  text: "",
                  size: "small",
                  class: `cursor-pointer !bg-none !p-0 !rounded-none !border-0 !ml-6 ${unref(form).type === "email" ? "!border-b-2 !border-[--el-color-primary] !font-600" : ""}`,
                  onClick: ($event) => unref(form).type = "email"
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`${ssrInterpolate(_ctx.$t("common.login.authorize.bindEmail"))}`);
                    } else {
                      return [
                        createTextVNode(toDisplayString(_ctx.$t("common.login.authorize.bindEmail")), 1)
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
                _push2(`</div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(ssrRenderComponent(_component_el_form_item, null, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_el_input, {
                      autocomplete: "new-password",
                      size: "large",
                      class: "border-1 rounded px-3",
                      id: unref(form).type == "phone" ? "phone" : "email",
                      name: unref(form).type == "phone" ? "phone" : "email",
                      modelValue: unref(form).phoneOrEmail,
                      "onUpdate:modelValue": ($event) => unref(form).phoneOrEmail = $event,
                      placeholder: unref(form).type == "phone" ? _ctx.$t("common.login.type.phonePlaceholder") : _ctx.$t("common.login.type.emailPlaceholder"),
                      disabled: unref(form).submitLocked
                    }, createSlots({ _: 2 }, [
                      unref(form).type == "phone" ? {
                        name: "prepend",
                        fn: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(ssrRenderComponent(_component_CommonFormCountryDialCodes, {
                              ref_key: "countryDialCodes",
                              ref: countryDialCodes
                            }, null, _parent4, _scopeId3));
                          } else {
                            return [
                              createVNode(_component_CommonFormCountryDialCodes, {
                                ref_key: "countryDialCodes",
                                ref: countryDialCodes
                              }, null, 512)
                            ];
                          }
                        }),
                        key: "0"
                      } : void 0
                    ]), _parent3, _scopeId2));
                  } else {
                    return [
                      createVNode(_component_el_input, {
                        autocomplete: "new-password",
                        size: "large",
                        class: "border-1 rounded px-3",
                        id: unref(form).type == "phone" ? "phone" : "email",
                        name: unref(form).type == "phone" ? "phone" : "email",
                        modelValue: unref(form).phoneOrEmail,
                        "onUpdate:modelValue": ($event) => unref(form).phoneOrEmail = $event,
                        placeholder: unref(form).type == "phone" ? _ctx.$t("common.login.type.phonePlaceholder") : _ctx.$t("common.login.type.emailPlaceholder"),
                        disabled: unref(form).submitLocked
                      }, createSlots({ _: 2 }, [
                        unref(form).type == "phone" ? {
                          name: "prepend",
                          fn: withCtx(() => [
                            createVNode(_component_CommonFormCountryDialCodes, {
                              ref_key: "countryDialCodes",
                              ref: countryDialCodes
                            }, null, 512)
                          ]),
                          key: "0"
                        } : void 0
                      ]), 1032, ["id", "name", "modelValue", "onUpdate:modelValue", "placeholder", "disabled"])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_form_item, null, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_el_input, {
                      autocomplete: "new-password",
                      modelValue: unref(form).verificationInput,
                      "onUpdate:modelValue": ($event) => unref(form).verificationInput = $event,
                      size: "large",
                      name: "code",
                      class: "border-1 rounded pl-3",
                      disabled: unref(form).submitLocked,
                      placeholder: _ctx.$t("common.login.captcha.placeHolder")
                    }, {
                      append: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(ssrRenderComponent(_component_el_button, {
                            size: "small",
                            disabled: unref(form).getCodeLocked,
                            class: "!text-[12px] !h-full",
                            onClick: ($event) => unref(captcha).show = true
                          }, {
                            default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                              if (_push5) {
                                _push5(`${ssrInterpolate(unref(form).getCodeLocked ? _ctx.$t("common.login.reget", [unref(form).timer]) : _ctx.$t("common.login.getCode"))}`);
                              } else {
                                return [
                                  createTextVNode(toDisplayString(unref(form).getCodeLocked ? _ctx.$t("common.login.reget", [unref(form).timer]) : _ctx.$t("common.login.getCode")), 1)
                                ];
                              }
                            }),
                            _: 1
                          }, _parent4, _scopeId3));
                        } else {
                          return [
                            createVNode(_component_el_button, {
                              size: "small",
                              disabled: unref(form).getCodeLocked,
                              class: "!text-[12px] !h-full",
                              onClick: ($event) => unref(captcha).show = true
                            }, {
                              default: withCtx(() => [
                                createTextVNode(toDisplayString(unref(form).getCodeLocked ? _ctx.$t("common.login.reget", [unref(form).timer]) : _ctx.$t("common.login.getCode")), 1)
                              ]),
                              _: 1
                            }, 8, ["disabled", "onClick"])
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    return [
                      createVNode(_component_el_input, {
                        autocomplete: "new-password",
                        modelValue: unref(form).verificationInput,
                        "onUpdate:modelValue": ($event) => unref(form).verificationInput = $event,
                        size: "large",
                        name: "code",
                        class: "border-1 rounded pl-3",
                        disabled: unref(form).submitLocked,
                        placeholder: _ctx.$t("common.login.captcha.placeHolder")
                      }, {
                        append: withCtx(() => [
                          createVNode(_component_el_button, {
                            size: "small",
                            disabled: unref(form).getCodeLocked,
                            class: "!text-[12px] !h-full",
                            onClick: ($event) => unref(captcha).show = true
                          }, {
                            default: withCtx(() => [
                              createTextVNode(toDisplayString(unref(form).getCodeLocked ? _ctx.$t("common.login.reget", [unref(form).timer]) : _ctx.$t("common.login.getCode")), 1)
                            ]),
                            _: 1
                          }, 8, ["disabled", "onClick"])
                        ]),
                        _: 1
                      }, 8, ["modelValue", "onUpdate:modelValue", "disabled", "placeholder"])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_form_item, null, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_el_input, {
                      autocomplete: "new-password",
                      type: "password",
                      size: "large",
                      name: "password",
                      modelValue: unref(form).password,
                      "onUpdate:modelValue": ($event) => unref(form).password = $event,
                      placeholder: _ctx.$t("common.login.type.passwordPlaceholder"),
                      class: "border-1 rounded px-3"
                    }, null, _parent3, _scopeId2));
                  } else {
                    return [
                      createVNode(_component_el_input, {
                        autocomplete: "new-password",
                        type: "password",
                        size: "large",
                        name: "password",
                        modelValue: unref(form).password,
                        "onUpdate:modelValue": ($event) => unref(form).password = $event,
                        placeholder: _ctx.$t("common.login.type.passwordPlaceholder"),
                        class: "border-1 rounded px-3"
                      }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(ssrRenderComponent(_component_el_form_item, { class: "!m-0 !p-0" }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_el_button, {
                      type: "primary",
                      class: "ml-auto",
                      loading: unref(form).submitLocked,
                      onClick: unref(form).socialCreateUser
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          _push4(`${ssrInterpolate(_ctx.$t("common.edit.save"))}`);
                        } else {
                          return [
                            createTextVNode(toDisplayString(_ctx.$t("common.edit.save")), 1)
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                  } else {
                    return [
                      createVNode(_component_el_button, {
                        type: "primary",
                        class: "ml-auto",
                        loading: unref(form).submitLocked,
                        onClick: unref(form).socialCreateUser
                      }, {
                        default: withCtx(() => [
                          createTextVNode(toDisplayString(_ctx.$t("common.edit.save")), 1)
                        ]),
                        _: 1
                      }, 8, ["loading", "onClick"])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              return [
                unref(form).boundPhone && unref(form).boundEmail ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "mb-4 flex justify-center"
                }, [
                  createVNode(_component_el_button, {
                    style: { "--el-fill-color-light": "transparent", "--el-fill-color": "transparent" },
                    text: "",
                    size: "small",
                    class: `cursor-pointer !bg-none !p-0 !rounded-none !border-0 ${unref(form).type === "phone" ? "!border-b-2 !border-[--el-color-primary] !font-600" : ""}`,
                    onClick: ($event) => unref(form).type = "phone"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("common.login.authorize.bindPhone")), 1)
                    ]),
                    _: 1
                  }, 8, ["class", "onClick"]),
                  createVNode(_component_el_button, {
                    style: { "--el-fill-color-light": "transparent", "--el-fill-color": "transparent" },
                    text: "",
                    size: "small",
                    class: `cursor-pointer !bg-none !p-0 !rounded-none !border-0 !ml-6 ${unref(form).type === "email" ? "!border-b-2 !border-[--el-color-primary] !font-600" : ""}`,
                    onClick: ($event) => unref(form).type = "email"
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("common.login.authorize.bindEmail")), 1)
                    ]),
                    _: 1
                  }, 8, ["class", "onClick"])
                ])) : createCommentVNode("", true),
                createVNode(_component_el_form_item, null, {
                  default: withCtx(() => [
                    createVNode(_component_el_input, {
                      autocomplete: "new-password",
                      size: "large",
                      class: "border-1 rounded px-3",
                      id: unref(form).type == "phone" ? "phone" : "email",
                      name: unref(form).type == "phone" ? "phone" : "email",
                      modelValue: unref(form).phoneOrEmail,
                      "onUpdate:modelValue": ($event) => unref(form).phoneOrEmail = $event,
                      placeholder: unref(form).type == "phone" ? _ctx.$t("common.login.type.phonePlaceholder") : _ctx.$t("common.login.type.emailPlaceholder"),
                      disabled: unref(form).submitLocked
                    }, createSlots({ _: 2 }, [
                      unref(form).type == "phone" ? {
                        name: "prepend",
                        fn: withCtx(() => [
                          createVNode(_component_CommonFormCountryDialCodes, {
                            ref_key: "countryDialCodes",
                            ref: countryDialCodes
                          }, null, 512)
                        ]),
                        key: "0"
                      } : void 0
                    ]), 1032, ["id", "name", "modelValue", "onUpdate:modelValue", "placeholder", "disabled"])
                  ]),
                  _: 1
                }),
                createVNode(_component_el_form_item, null, {
                  default: withCtx(() => [
                    createVNode(_component_el_input, {
                      autocomplete: "new-password",
                      modelValue: unref(form).verificationInput,
                      "onUpdate:modelValue": ($event) => unref(form).verificationInput = $event,
                      size: "large",
                      name: "code",
                      class: "border-1 rounded pl-3",
                      disabled: unref(form).submitLocked,
                      placeholder: _ctx.$t("common.login.captcha.placeHolder")
                    }, {
                      append: withCtx(() => [
                        createVNode(_component_el_button, {
                          size: "small",
                          disabled: unref(form).getCodeLocked,
                          class: "!text-[12px] !h-full",
                          onClick: ($event) => unref(captcha).show = true
                        }, {
                          default: withCtx(() => [
                            createTextVNode(toDisplayString(unref(form).getCodeLocked ? _ctx.$t("common.login.reget", [unref(form).timer]) : _ctx.$t("common.login.getCode")), 1)
                          ]),
                          _: 1
                        }, 8, ["disabled", "onClick"])
                      ]),
                      _: 1
                    }, 8, ["modelValue", "onUpdate:modelValue", "disabled", "placeholder"])
                  ]),
                  _: 1
                }),
                createVNode(_component_el_form_item, null, {
                  default: withCtx(() => [
                    createVNode(_component_el_input, {
                      autocomplete: "new-password",
                      type: "password",
                      size: "large",
                      name: "password",
                      modelValue: unref(form).password,
                      "onUpdate:modelValue": ($event) => unref(form).password = $event,
                      placeholder: _ctx.$t("common.login.type.passwordPlaceholder"),
                      class: "border-1 rounded px-3"
                    }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder"])
                  ]),
                  _: 1
                }),
                createVNode(_component_el_form_item, { class: "!m-0 !p-0" }, {
                  default: withCtx(() => [
                    createVNode(_component_el_button, {
                      type: "primary",
                      class: "ml-auto",
                      loading: unref(form).submitLocked,
                      onClick: unref(form).socialCreateUser
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.$t("common.edit.save")), 1)
                      ]),
                      _: 1
                    }, 8, ["loading", "onClick"])
                  ]),
                  _: 1
                })
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_CommonFormCaptcha, {
        ref_key: "captcha",
        ref: captcha,
        phoneOrEmail: unref(form).type == "phone" ? (unref(countryDialCodes)?.countryDialCodes?.picked[1] ?? "") + " " + unref(form).phoneOrEmail : unref(form).phoneOrEmail,
        action: "bound",
        onCaptchaSuccess: ($event) => unref(form).getCode()
      }, null, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/pages/authorize.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const authorize = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-b3cd61b9"]]);

export { authorize as default };
