import _sfc_main$1 from './barPrice-BCPjAPM9.mjs';
import { e as useUtils } from './server.mjs';
import { mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from 'vue/server-renderer';
import './creditIcon-eOdkwofx.mjs';
import './svgIcon-BpIUCf-e.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonPostComponentsBookBar",
  __ssrInlineRender: true,
  props: ["item", "settings"],
  setup(__props) {
    const props = __props;
    const inc = (type) => {
      return props.settings.attrsPicked.includes(type);
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ModulesCommonPostComponentsBarPrice = _sfc_main$1;
      if (inc("bookRating") || inc("bookReaders") || inc("bookComplete") || inc("bookPrice")) {
        _push(`<div${ssrRenderAttrs(mergeProps({
          class: `resource-bar gq-rounded list-bar rounded-[var(--el-border-radius-${__props.settings.thumb.thumbRadius})]`
        }, _attrs))}><div class="flex cursor-pointer gap-2 items-center">`);
        if (inc("bookRating")) {
          _push(`<span class="bar-rating gq-gs">${ssrInterpolate(__props.item.book.attrs.rating)}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (inc("bookReaders")) {
          _push(`<span class="opacity-80 line-clamp-1 text-ellipsis gq-gs">${ssrInterpolate(_ctx.$t("page.modules.post.bookReaders", [("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(__props.item.book.attrs.readers)]))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (inc("bookComplete") && __props.item.book.attrs.completed) {
          _push(`<span class="text-[var(--el-color-success)] line-clamp-1 text-ellipsis gq-gs">${ssrInterpolate(_ctx.$t("page.modules.post.bookComplete"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (inc("bookComplete") && !__props.item.book.attrs.completed) {
          _push(`<span class="text-[var(--el-color-danger)] line-clamp-1 text-ellipsis gq-gs">${ssrInterpolate(_ctx.$t("page.modules.post.bookNotComplete"))}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div><div class="flex gap-4 items-center">`);
        if (inc("bookPrice")) {
          _push(ssrRenderComponent(_component_ModulesCommonPostComponentsBarPrice, {
            settings: __props.settings,
            item: __props.item
          }, null, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/post/components/bookBar.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
