import _sfc_main$1 from './creditIcon-eOdkwofx.mjs';
import _sfc_main$2 from './blink-DRvWMg-X.mjs';
import { j as actionStore, a as useI18n, e as useUtils, x as __nuxt_component_0$1 } from './server.mjs';
import { computed, mergeProps, unref, withCtx, createTextVNode, toDisplayString, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderList } from 'vue/server-renderer';
import './svgIcon-BpIUCf-e.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';
import './nuxt-link-Dd6LuEo9.mjs';

const _sfc_main = {
  __name: "ModulesCommonTopicBounty",
  __ssrInlineRender: true,
  props: ["bounty"],
  setup(__props) {
    const props = __props;
    const action = actionStore();
    const { t } = useI18n();
    const bountyValue = (bounty) => {
      if (bounty.type == "money") {
        try {
          const value = JSON.parse(bounty.value);
          return value[action.currency.iso];
        } catch (error) {
          return bounty.value;
        }
      }
      return bounty.value;
    };
    computed(() => {
      return useUtils.convertAndCalculateTime(props.bounty.deadline);
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CommonCreditIcon = _sfc_main$1;
      const _component_Blink = _sfc_main$2;
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: "flex w-82 flex-col p-3 border rounded max-w-full gap-3 gq-gs text-sm",
        style: { "--el-border-color": "var(--el-color-primary-light-9)", "--gq-vote-bg": "var(--el-fill-color-extra-light)" }
      }, _attrs))}><div class="flex justify-between border-b pb-2 text-xs"><div class="flex items-center"><i class="i-ph-currency-circle-dollar mr-1 text-[var(--el-color-primary)]"></i> ${ssrInterpolate(_ctx.$t("page.community.types.bounty.title"))}</div><div class="flex items-center font-600 text-xs text-[--el-color-danger-dark-2]">`);
      if (__props.bounty.type == "credit") {
        _push(`<span>`);
        _push(ssrRenderComponent(_component_CommonCreditIcon, { class: "w-3 h-3 flex" }, null, _parent));
        _push(`</span>`);
      } else {
        _push(`<span>${ssrInterpolate(unref(action).currency.symbol)}</span>`);
      }
      _push(`<span class="ml-0.5">${ssrInterpolate(bountyValue(__props.bounty))}</span></div></div><div class="flex flex-col gap-2"><div class="flex items-center text-xs text-[--el-color-primary]">`);
      if (__props.bounty.target == "all") {
        _push(`<span> @${ssrInterpolate(unref(t)("page.community.types.bounty.all"))}</span>`);
      } else {
        _push(`<span><!--[-->`);
        ssrRenderList(__props.bounty.targetList, (item) => {
          _push(ssrRenderComponent(_component_Blink, {
            to: item.gqSlug,
            key: item.id
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(` @${ssrInterpolate(item.name)}`);
              } else {
                return [
                  createTextVNode(" @" + toDisplayString(item.name), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        });
        _push(`<!--]--></span>`);
      }
      _push(`</div><div class="flex items-center text-xs h-5">`);
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`</div></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/bounty.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
