import { E as ElAvatar } from './index-R6EFYpWa.mjs';
import _sfc_main$1 from './timeAgo-D7-A3XOx.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import _sfc_main$2 from './blink-DRvWMg-X.mjs';
import { j as actionStore, d as useRoute, r as useRequest, w as isLogin, e as useUtils } from './server.mjs';
import { computed, reactive, mergeProps, unref, withCtx, createVNode, createTextVNode, toDisplayString, openBlock, createBlock, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderList, ssrRenderComponent, ssrInterpolate } from 'vue/server-renderer';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './index-ChPMoinw.mjs';
import './constants-hAKFmBbq.mjs';
import './vnode-l2ZP2UQa.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import '@ctrl/tinycolor';
import './nuxt-link-Dd6LuEo9.mjs';

const _sfc_main = {
  __name: "ModulesCommonTopicBountyList",
  __ssrInlineRender: true,
  props: ["list"],
  setup(__props) {
    const props = __props;
    const action = actionStore();
    const route = useRoute();
    const postId = computed(() => parseInt(route.params.page?.split(".")?.[0] || route.meta.pageSettings?.id || route.params.name?.[1]?.split(".")?.[0]));
    const state = reactive({
      locked: false,
      submitLocked: [],
      reportForm: false,
      pageInfo: {
        hasNextPage: false,
        endCursor: ""
      },
      report: (id) => {
        if (!isLogin.value) {
          action.showLogin = true;
          return;
        }
        action.report.show = true;
        action.report.type = "content";
        action.report.postId = id;
        action.report.postType = "post";
      },
      accept: (id) => {
      },
      getList: async () => {
        if (state.locked) return;
        state.locked = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              articleID: postId.value,
              after: props.list?.list?.pageInfo?.endCursor
            }
          }
        });
        if (res?.guaqi?.community?.single?.content?.bounty?.answerList?.list?.edges?.length > 0) {
          props.list.list.pageInfo.hasNextPage = res?.guaqi?.community?.single?.content?.bounty?.answerList?.list?.pageInfo?.hasNextPage;
          props.list.list.pageInfo.endCursor = res?.guaqi?.community?.single?.content?.bounty?.answerList?.list?.pageInfo?.endCursor;
          props.list.list.edges.push(...res?.guaqi?.community?.single?.content?.bounty?.answerList?.list?.edges);
        }
        state.locked = false;
      },
      methods: async (index, type) => {
        if (state.submitLocked[index]) {
          return;
        }
        state.submitLocked[index] = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              id: props.list.list.edges[index].node.databaseId
            }
          }
        });
        if (res?.gqToggleContent) {
          if (type == "like") {
            props.list.list.edges[index].node.liked = res.gqToggleContent.status;
            props.list.list.edges[index].node.likeCount += res.gqToggleContent.status ? 1 : -1;
          } else if (type == "collection") {
            props.list.list.edges[index].node.collected = res.gqToggleContent.status;
            props.list.list.edges[index].node.collectionCount += res.gqToggleContent.status ? 1 : -1;
          }
        }
        state.submitLocked[index] = false;
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_avatar = ElAvatar;
      const _component_TimeAgo = _sfc_main$1;
      const _component_el_button = ElButton;
      const _component_Blink = _sfc_main$2;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "pb-4" }, _attrs))}><!--[-->`);
      ssrRenderList(__props.list?.list?.edges || 1, (item, index) => {
        _push(`<div class="border-t pt-4 mt-4"><div class="flex items-center gap-2 justify-between"><div class="flex items-center gap-2 text-sm">`);
        _push(ssrRenderComponent(_component_el_avatar, {
          size: 36,
          src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item?.node?.author?.node?.avatar?.url),
          class: "gq-gs"
        }, null, _parent));
        _push(`<div class="flex flex-col"><span class="gq-gs">${ssrInterpolate(item?.node?.author?.node?.name || "Placeholder")}</span>`);
        _push(ssrRenderComponent(_component_TimeAgo, {
          date: item?.node?.dateGmt,
          class: "text-xs opacity-80 gq-gs"
        }, null, _parent));
        _push(`</div></div><div class="cursor-pointer relative group/report">`);
        _push(ssrRenderComponent(_component_el_button, {
          text: "",
          size: "small",
          class: "w-5 !h-4"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="i-ph-dots-three"${_scopeId}></i>`);
            } else {
              return [
                createVNode("i", { class: "i-ph-dots-three" })
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`<div id="reportForm" class="absolute z-2 bg-[--el-bg-color-overlay] p-2 left-1/2 transform -translate-x-1/2 shadow-md w-20 rounded border-1 group-hover/report:block hidden transition-opacity duration-200">`);
        _push(ssrRenderComponent(_component_el_button, {
          class: "w-full",
          text: "",
          size: "small",
          onClick: ($event) => unref(state).report(item?.node?.databaseId)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("common.safe.report"))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("common.safe.report")), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></div></div><div class="mt-4 text-sm gq-gs">`);
        _push(ssrRenderComponent(_component_Blink, {
          to: item?.node?.gqSlug
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(item?.node?.excerpt || "Placeholder answer")}`);
            } else {
              return [
                createTextVNode(toDisplayString(item?.node?.excerpt || "Placeholder answer"), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div><div class="flex items-center gap-2 justify-between mt-4 text-xs"><div class="flex items-center gap-1">`);
        _push(ssrRenderComponent(_component_el_button, {
          class: "flex items-center gq-gs",
          text: "",
          bg: "",
          size: "small",
          onClick: ($event) => unref(state).methods(index, "like")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (!item?.node?.liked) {
                _push2(`<i class="i-ph-heart"${_scopeId}></i>`);
              } else {
                _push2(`<i class="i-ph-heart-fill text-[--el-color-danger]"${_scopeId}></i>`);
              }
              _push2(` ${ssrInterpolate(_ctx.$t("page.modules.post.rating"))} (${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(item?.node?.likeCount || 0))}) `);
            } else {
              return [
                !item?.node?.liked ? (openBlock(), createBlock("i", {
                  key: 0,
                  class: "i-ph-heart"
                })) : (openBlock(), createBlock("i", {
                  key: 1,
                  class: "i-ph-heart-fill text-[--el-color-danger]"
                })),
                createTextVNode(" " + toDisplayString(_ctx.$t("page.modules.post.rating")) + " (" + toDisplayString(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(item?.node?.likeCount || 0)) + ") ", 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(ssrRenderComponent(_component_el_button, {
          class: "flex items-center gq-gs",
          text: "",
          bg: "",
          size: "small",
          onClick: ($event) => unref(state).methods(index, "collection")
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (!item?.node?.collected) {
                _push2(`<i class="i-ph-star"${_scopeId}></i>`);
              } else {
                _push2(`<i class="i-ph-star-fill text-[--el-color-danger]"${_scopeId}></i>`);
              }
              _push2(` ${ssrInterpolate(_ctx.$t("common.collection.collection"))} (${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(item?.node?.collectionCount || 0))}) `);
            } else {
              return [
                !item?.node?.collected ? (openBlock(), createBlock("i", {
                  key: 0,
                  class: "i-ph-star"
                })) : (openBlock(), createBlock("i", {
                  key: 1,
                  class: "i-ph-star-fill text-[--el-color-danger]"
                })),
                createTextVNode(" " + toDisplayString(_ctx.$t("common.collection.collection")) + " (" + toDisplayString(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(item?.node?.collectionCount || 0)) + ") ", 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div>`);
        _push(ssrRenderComponent(_component_Blink, {
          to: item?.node?.gqSlug,
          class: "flex items-center text-[--el-color-primary] gq-gs"
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(` (${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(item?.node?.commentCount || 0))}) ${ssrInterpolate(_ctx.$t("common.comment.comment"))} <i class="i-ph-caret-right"${_scopeId}></i>`);
            } else {
              return [
                createTextVNode(" (" + toDisplayString(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(item?.node?.commentCount || 0)) + ") " + toDisplayString(_ctx.$t("common.comment.comment")) + " ", 1),
                createVNode("i", { class: "i-ph-caret-right" })
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</div></div>`);
      });
      _push(`<!--]--><div>`);
      _push(ssrRenderComponent(_component_el_button, {
        plain: "",
        text: "",
        class: "w-full !p-6 mt-4",
        loading: unref(state).locked,
        disabled: !__props.list?.list?.pageInfo?.hasNextPage,
        onClick: ($event) => unref(state).getList()
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (__props.list?.list?.pageInfo?.hasNextPage) {
              _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.modules.post.loadMoreButton"))}</span>`);
            } else if (unref(state).locked) {
              _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.modules.post.loading"))}</span>`);
            } else {
              _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.modules.post.noMore"))}</span>`);
            }
          } else {
            return [
              __props.list?.list?.pageInfo?.hasNextPage ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("page.modules.post.loadMoreButton")), 1)) : unref(state).locked ? (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("page.modules.post.loading")), 1)) : (openBlock(), createBlock("span", { key: 2 }, toDisplayString(_ctx.$t("page.modules.post.noMore")), 1))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/bountyList.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
