import { P as withInstall, Q as withNoopInstall, C as useNamespace, D as useLocale, a0 as buildProps, a2 as definePropType, a1 as iconPropType } from './server.mjs';
import { defineComponent, getCurrentInstance, inject, openBlock, createElementBlock, normalizeClass, unref, createElementVNode, renderSlot, createBlock, withCtx, resolveDynamicComponent, toDisplayString, ref, provide } from 'vue';
import { E as ElIcon } from './index-CRbm0e05.mjs';

const breadcrumbProps = buildProps({
  /**
   * @description separator character
   */
  separator: {
    type: String,
    default: "/"
  },
  /**
   * @description icon component of icon separator
   */
  separatorIcon: {
    type: iconPropType
  }
});
const breadcrumbKey = /* @__PURE__ */ Symbol("breadcrumbKey");
const _hoisted_1 = ["aria-label"];
var _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElBreadcrumb"
  },
  __name: "breadcrumb",
  props: breadcrumbProps,
  setup(__props) {
    const { t } = useLocale();
    const props = __props;
    const ns = useNamespace("breadcrumb");
    const breadcrumb = ref();
    provide(breadcrumbKey, props);
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock("div", {
        ref_key: "breadcrumb",
        ref: breadcrumb,
        class: normalizeClass(unref(ns).b()),
        "aria-label": unref(t)("el.breadcrumb.label"),
        role: "navigation"
      }, [
        renderSlot(_ctx.$slots, "default")
      ], 10, _hoisted_1);
    };
  }
});
const breadcrumbItemProps = buildProps({
  /**
   * @description target route of the link, same as `to` of `vue-router`
   */
  to: {
    type: definePropType([String, Object]),
    default: ""
  },
  /**
   * @description if `true`, the navigation will not leave a history record
   */
  replace: Boolean
});
var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElBreadcrumbItem"
  },
  __name: "breadcrumb-item",
  props: breadcrumbItemProps,
  setup(__props) {
    const props = __props;
    const instance = getCurrentInstance();
    const breadcrumbContext = inject(breadcrumbKey, void 0);
    const ns = useNamespace("breadcrumb");
    const router = instance.appContext.config.globalProperties.$router;
    const onClick = () => {
      if (!props.to || !router) return;
      props.replace ? router.replace(props.to) : router.push(props.to);
    };
    return (_ctx, _cache) => {
      var _a, _b;
      return openBlock(), createElementBlock(
        "span",
        {
          class: normalizeClass(unref(ns).e("item"))
        },
        [
          createElementVNode(
            "span",
            {
              class: normalizeClass([unref(ns).e("inner"), unref(ns).is("link", !!__props.to)]),
              role: "link",
              onClick
            },
            [
              renderSlot(_ctx.$slots, "default")
            ],
            2
            /* CLASS */
          ),
          ((_a = unref(breadcrumbContext)) == null ? void 0 : _a.separatorIcon) ? (openBlock(), createBlock(unref(ElIcon), {
            key: 0,
            class: normalizeClass(unref(ns).e("separator"))
          }, {
            default: withCtx(() => [
              (openBlock(), createBlock(resolveDynamicComponent(unref(breadcrumbContext).separatorIcon)))
            ]),
            _: 1
            /* STABLE */
          }, 8, ["class"])) : (openBlock(), createElementBlock(
            "span",
            {
              key: 1,
              class: normalizeClass(unref(ns).e("separator")),
              role: "presentation"
            },
            toDisplayString((_b = unref(breadcrumbContext)) == null ? void 0 : _b.separator),
            3
            /* TEXT, CLASS */
          ))
        ],
        2
        /* CLASS */
      );
    };
  }
});
const ElBreadcrumb = withInstall(_sfc_main$1, {
  BreadcrumbItem: _sfc_main
});
const ElBreadcrumbItem = withNoopInstall(_sfc_main);

export { ElBreadcrumb as E, ElBreadcrumbItem as a };
