import { E as ElDialog } from './index-awVc4A7-.mjs';
import _sfc_main$1 from './creditIcon-eOdkwofx.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { g as getServerSettings, v as viewerStore, j as actionStore, a as useI18n, e as useUtils, x as __nuxt_component_0$1 } from './server.mjs';
import { useSSRContext, ref, reactive, computed, watch, resolveDirective, unref, withCtx, mergeProps, createVNode, createTextVNode, toDisplayString, withDirectives, openBlock, createBlock } from 'vue';
import { ssrRenderComponent, ssrInterpolate, ssrGetDirectiveProps } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './use-dialog-7J0bwlna.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import 'lodash-unified';
import './aria-BhThsKez.mjs';
import './event-BZTOGHfp.mjs';
import '@vue/shared';
import './vnode-l2ZP2UQa.mjs';
import './index-Di0Jlzch.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './svgIcon-BpIUCf-e.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './index-DRiwogtD.mjs';
import './index-ChPMoinw.mjs';
import './index-BKB3Djp4.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import './index-Bp-nwGzu.mjs';
import '@ctrl/tinycolor';

const _sfc_main = {
  __name: "ModulesAccountWealthBuyCredit",
  __ssrInlineRender: true,
  emits: ["success"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const settingsStore = getServerSettings();
    const viewer = viewerStore();
    const action = actionStore();
    const payRef = ref(null);
    const { t } = useI18n();
    const state = reactive({
      show: false,
      data: {
        amount: settingsStore?.wealth_settings?.credit?.min_amount || 0,
        toAmount: useUtils.localPrice(useUtils.div(
          settingsStore?.wealth_settings?.credit?.min_amount || 0,
          settingsStore?.wealth_settings?.credit?.rate[action.currency.iso]
        ), action.currency.iso)
      },
      viewerMoney: computed(() => viewer.data?.gqMoney || "{}"),
      buy: () => {
        state.show = false;
        payRef.value.state.show({
          title: t("page.account.wealth.creditBuy"),
          thumb: "",
          postId: 0,
          args: {
            index: 0,
            roleIndex: 0
          },
          payment: "money",
          count: 0,
          expiredAt: "",
          type: "buyCredit",
          finalPrice: state.data.toAmount,
          price: state.data.toAmount
        });
      },
      updateAmount: (type) => {
        if (type === "amount") {
          state.data.toAmount = useUtils.localPrice(useUtils.div(
            state.data.amount,
            settingsStore?.wealth_settings?.credit?.rate[action.currency.iso]
          ), action.currency.iso);
        } else {
          let res = useUtils.mul(
            state.data.toAmount,
            settingsStore?.wealth_settings?.credit?.rate[action.currency.iso]
          );
          state.data.amount = Math.floor(res);
        }
      }
    });
    watch(() => action.currency.iso, (val) => {
      state.data.toAmount = useUtils.localPrice(useUtils.div(
        settingsStore?.wealth_settings?.credit?.min_amount || 0,
        settingsStore?.wealth_settings?.credit?.rate[val]
      ), val);
      state.updateAmount("amount");
    });
    __expose({
      state
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_dialog = ElDialog;
      const _component_CommonCreditIcon = _sfc_main$1;
      const _component_el_input = ElInput;
      const _component_el_button = ElButton;
      const _component_ClientOnly = __nuxt_component_0$1;
      const _directive_decimal = resolveDirective("decimal");
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_el_dialog, {
        modelValue: unref(state).show,
        "onUpdate:modelValue": ($event) => unref(state).show = $event,
        title: _ctx.$t("page.account.wealth.creditBuy"),
        "lock-scroll": false,
        "append-to-body": true,
        width: "240"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex flex-col" data-v-47f274c7${_scopeId}><div class="text-xs flex opacity-80 mb-2 flex-col" data-v-47f274c7${_scopeId}><div class="flex items-center" data-v-47f274c7${_scopeId}><span class="mr-1" data-v-47f274c7${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.wealth.buyCredit.title"))}</span>`);
            _push2(ssrRenderComponent(_component_CommonCreditIcon, { class: "opacity-50" }, null, _parent2, _scopeId));
            _push2(` ${ssrInterpolate(unref(settingsStore)?.wealth_settings?.credit?.min_amount || 0)} <span class="mx-2" data-v-47f274c7${_scopeId}>-</span>`);
            _push2(ssrRenderComponent(_component_CommonCreditIcon, { class: "opacity-50" }, null, _parent2, _scopeId));
            _push2(` ${ssrInterpolate(unref(settingsStore)?.wealth_settings?.credit?.max_amount || 0)}</div></div>`);
            _push2(ssrRenderComponent(_component_el_input, mergeProps({
              modelValue: unref(state).data.amount,
              "onUpdate:modelValue": ($event) => unref(state).data.amount = $event,
              type: "number",
              onInput: ($event) => unref(state).updateAmount("amount")
            }, ssrGetDirectiveProps(_ctx, _directive_decimal, {
              decimals: 0,
              min: 0,
              max: unref(settingsStore)?.wealth_settings?.credit?.max_amount || 0
            })), {
              prefix: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(ssrRenderComponent(_component_CommonCreditIcon, { class: "flex" }, null, _parent3, _scopeId2));
                } else {
                  return [
                    createVNode(_component_CommonCreditIcon, { class: "flex" })
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`<div class="text-center font-600 text-[--el-color-primary] opacity-50" data-v-47f274c7${_scopeId}> = </div>`);
            _push2(ssrRenderComponent(_component_el_input, mergeProps({
              modelValue: unref(state).data.toAmount,
              "onUpdate:modelValue": ($event) => unref(state).data.toAmount = $event,
              type: "number",
              onInput: ($event) => unref(state).updateAmount("toAmount")
            }, ssrGetDirectiveProps(_ctx, _directive_decimal, {
              decimals: 2,
              min: 0,
              max: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).div(
                unref(settingsStore)?.wealth_settings?.credit?.max_amount || 0,
                unref(settingsStore)?.wealth_settings?.credit?.rate[unref(action).currency.iso]
              )
            })), {
              prefix: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(unref(action).currency.symbol)}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(unref(action).currency.symbol), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`<div class="text-xs flex items-center justify-center text-[--el-color-primary-dark-2] bg-[--el-color-primary-light-9] rounded p-2 mt-2 border-1" data-v-47f274c7${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.wealth.buyCredit.desc", [unref(action).currency.symbol, ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(state).data.toAmount, unref(action).currency.iso)]))} `);
            _push2(ssrRenderComponent(_component_CommonCreditIcon, { class: "opacity-50 ml-1" }, null, _parent2, _scopeId));
            _push2(` ${ssrInterpolate(unref(state).data.amount)}</div>`);
            _push2(ssrRenderComponent(_component_el_button, {
              type: "primary",
              onClick: unref(state).buy,
              class: "mt-4",
              disabled: parseInt(unref(state).data.amount) > (unref(settingsStore)?.wealth_settings?.credit?.max_amount || 0) || parseInt(unref(state).data.amount) < (unref(settingsStore)?.wealth_settings?.credit?.min_amount || 0)
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("page.account.wealth.creditBuy"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("page.account.wealth.creditBuy")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", { class: "flex flex-col" }, [
                createVNode("div", { class: "text-xs flex opacity-80 mb-2 flex-col" }, [
                  createVNode("div", { class: "flex items-center" }, [
                    createVNode("span", { class: "mr-1" }, toDisplayString(_ctx.$t("page.account.wealth.buyCredit.title")), 1),
                    createVNode(_component_CommonCreditIcon, { class: "opacity-50" }),
                    createTextVNode(" " + toDisplayString(unref(settingsStore)?.wealth_settings?.credit?.min_amount || 0) + " ", 1),
                    createVNode("span", { class: "mx-2" }, "-"),
                    createVNode(_component_CommonCreditIcon, { class: "opacity-50" }),
                    createTextVNode(" " + toDisplayString(unref(settingsStore)?.wealth_settings?.credit?.max_amount || 0), 1)
                  ])
                ]),
                withDirectives((openBlock(), createBlock(_component_el_input, {
                  modelValue: unref(state).data.amount,
                  "onUpdate:modelValue": ($event) => unref(state).data.amount = $event,
                  type: "number",
                  onInput: ($event) => unref(state).updateAmount("amount")
                }, {
                  prefix: withCtx(() => [
                    createVNode(_component_CommonCreditIcon, { class: "flex" })
                  ]),
                  _: 1
                }, 8, ["modelValue", "onUpdate:modelValue", "onInput"])), [
                  [_directive_decimal, {
                    decimals: 0,
                    min: 0,
                    max: unref(settingsStore)?.wealth_settings?.credit?.max_amount || 0
                  }]
                ]),
                createVNode("div", { class: "text-center font-600 text-[--el-color-primary] opacity-50" }, " = "),
                withDirectives((openBlock(), createBlock(_component_el_input, {
                  modelValue: unref(state).data.toAmount,
                  "onUpdate:modelValue": ($event) => unref(state).data.toAmount = $event,
                  type: "number",
                  onInput: ($event) => unref(state).updateAmount("toAmount")
                }, {
                  prefix: withCtx(() => [
                    createTextVNode(toDisplayString(unref(action).currency.symbol), 1)
                  ]),
                  _: 1
                }, 8, ["modelValue", "onUpdate:modelValue", "onInput"])), [
                  [_directive_decimal, {
                    decimals: 2,
                    min: 0,
                    max: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).div(
                      unref(settingsStore)?.wealth_settings?.credit?.max_amount || 0,
                      unref(settingsStore)?.wealth_settings?.credit?.rate[unref(action).currency.iso]
                    )
                  }]
                ]),
                createVNode("div", { class: "text-xs flex items-center justify-center text-[--el-color-primary-dark-2] bg-[--el-color-primary-light-9] rounded p-2 mt-2 border-1" }, [
                  createTextVNode(toDisplayString(_ctx.$t("page.account.wealth.buyCredit.desc", [unref(action).currency.symbol, ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).localPrice(unref(state).data.toAmount, unref(action).currency.iso)])) + " ", 1),
                  createVNode(_component_CommonCreditIcon, { class: "opacity-50 ml-1" }),
                  createTextVNode(" " + toDisplayString(unref(state).data.amount), 1)
                ]),
                createVNode(_component_el_button, {
                  type: "primary",
                  onClick: unref(state).buy,
                  class: "mt-4",
                  disabled: parseInt(unref(state).data.amount) > (unref(settingsStore)?.wealth_settings?.credit?.max_amount || 0) || parseInt(unref(state).data.amount) < (unref(settingsStore)?.wealth_settings?.credit?.min_amount || 0)
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("page.account.wealth.creditBuy")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick", "disabled"])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`<!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/account/wealth/buyCredit.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_6 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-47f274c7"]]);

export { __nuxt_component_6 as default };
