import { a as useI18n, x as __nuxt_component_0$1, r as useRequest } from './server.mjs';
import { useSSRContext, ref, watch } from 'vue';
import { ssrRenderComponent } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonFormCaptcha",
  __ssrInlineRender: true,
  props: ["phoneOrEmail", "verifyType", "type", "action"],
  emits: ["captchaSuccess"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const show = ref(false);
    const { t } = useI18n();
    const locked = ref(false);
    const captcha = ref("");
    const captchaSign = ref("");
    const timestamp = ref("");
    const captchaInput = ref("");
    const inputRef = ref(null);
    const success = ref(false);
    const getCaptcha = async () => {
      if (locked.value) {
        return;
      }
      locked.value = true;
      captchaInput.value = "";
      const res = await useRequest("/api/request", {
        body: {
          data: {
            phoneOrEmail: props.phoneOrEmail,
            action: props.action,
            type: props.verifyType || ""
          }
        }
      });
      if (res?.guaqi?.utils) {
        captcha.value = res.guaqi.utils.captcha.base64;
        captchaSign.value = res.guaqi.utils.captcha.captchaSign;
        timestamp.value = res.guaqi.utils.captcha.timestamp;
      }
      inputRef.value.input.focus();
      locked.value = false;
    };
    ref(false);
    watch(show, (val) => {
      if (val) {
        getCaptcha();
      }
    });
    __expose({
      success,
      captchaInput,
      captchaSign,
      timestamp,
      show
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(ssrRenderComponent(_component_ClientOnly, _attrs, {}, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/form/captcha.client.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const captcha_client = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-18d7bf9d"]]);

export { captcha_client as default };
