import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import _sfc_main$1 from './timeAgo-D7-A3XOx.mjs';
import { E as ElAvatar } from './index-R6EFYpWa.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElForm } from './index-DwNba9hO.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import __nuxt_component_3 from './smileButton-HPVl__f7.mjs';
import { j as actionStore, a as useI18n, v as viewerStore, e as useUtils, aE as useDebounceFn, r as useRequest, w as isLogin } from './server.mjs';
import { useSSRContext, ref, computed, watch, mergeProps, unref, withCtx, createVNode, withDirectives, openBlock, createBlock, toDisplayString, createCommentVNode, Fragment, renderList, createTextVNode, vShow, isRef, nextTick } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderStyle, ssrInterpolate, ssrRenderList, ssrRenderClass } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import './index-ChPMoinw.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './index-CRbm0e05.mjs';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './constants-hAKFmBbq.mjs';
import './vnode-l2ZP2UQa.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import '@ctrl/tinycolor';
import 'async-validator';
import './event-BZTOGHfp.mjs';
import './index-BKB3Djp4.mjs';
import './index-Bp-nwGzu.mjs';
import './popover-B8HtRMY4.mjs';

/* empty css                */
/* empty css                 */
const _sfc_main = {
  __name: "CommonChat",
  __ssrInlineRender: true,
  setup(__props) {
    const action = actionStore();
    const { t } = useI18n();
    const showRole = () => {
      action.levelTips.show = true;
      action.levelTips.title = t("page.widgets.chat.form.allowUser");
      action.levelTips.levels = useUtils.getAllowLevels("chat");
    };
    const sendData = ref(null);
    const viewer = viewerStore();
    const newMsg = ref(false);
    const loading = ref(false);
    const hasMore = ref(true);
    const message = ref("");
    const history = computed(() => {
      return action.chat.history[action.chat.room] || [];
    });
    watch(
      () => history.value?.edges?.length,
      (newVal, oldVal) => {
        if (!oldVal) {
          scrollToBottom();
        } else {
          if (isBottom.value && newVal > oldVal) {
            scrollToBottom();
          } else if (oldVal != 0 && !loading.value) {
            newMsg.value = true;
          }
        }
      }
    );
    function isDifferenceGreaterThanTenMinutes(entry, history2, i) {
      if (entry.node.action == "chat_room" && history2[i - 1]?.node.action == "chat_room") {
        let entryTimestamp = new Date(entry.node.created_at).getTime();
        let historyTimestamp = new Date(history2[i - 1]?.node.created_at).getTime();
        return entryTimestamp - historyTimestamp > 300 * 1e3;
      }
      return false;
    }
    const scrollBar = ref(null);
    const joinRoom = () => {
      if (!isLogin.value) {
        action.showLogin = true;
        return;
      }
      if (!action.socket) return;
      let viewerSocketToken = JSON.parse(viewer.data.gqUserSocketToken);
      action.socket.send(
        JSON.stringify({
          type: "join_room",
          room: "chat",
          data: {
            action: "join_room",
            user: {
              avatar: {
                url: viewer.data.avatar.url
              },
              name: viewer.data.name,
              gqSlug: viewer.data.gqSlug,
              databaseId: viewer.data.id
            },
            signature: viewerSocketToken.signature,
            timestamp: viewerSocketToken.timestamp
          }
        })
      );
    };
    const textarea = ref("");
    const switchAction = ref(false);
    const deleteChat = async (index) => {
      const id = history.value.edges[index].node.id;
      const res = await useRequest("/api/request", {});
      if (res?.guaqi?.utils?.chatDelete) {
        action.socket.send(
          JSON.stringify({
            type: "delete_chat",
            room: "chat",
            data: {
              id,
              signature: res?.guaqi?.utils?.chatDelete
            }
          })
        );
        history.value.edges.splice(index, 1);
      }
    };
    const locked = ref(false);
    const scrollToBottom = () => {
      setTimeout(() => {
        scrollBar.value?.setScrollTop(999999);
        newMsg.value = false;
      }, 100);
    };
    const handleKeydown = (event) => {
      if (event.shiftKey) {
        return;
      }
      if (event.key === "Enter") {
        event.preventDefault();
        sendData.value();
      }
    };
    const loadHistory = async (scrollTop) => {
      if (!hasMore.value) return;
      if (loading.value) return;
      loading.value = true;
      const beforeHeight = scrollBar.value?.wrapRef?.scrollHeight || 0;
      await useUtils.getChatMessages(action, action.chat.room);
      await nextTick();
      loading.value = false;
      if (history.value?.pageInfo?.hasNextPage == false) {
        hasMore.value = false;
      }
      if (scrollBar.value) {
        scrollBar.value.setScrollTop(
          scrollBar.value?.wrapRef?.scrollHeight - beforeHeight
        );
      }
      if (history.value?.edges?.length == 0) {
        scrollToBottom();
      }
    };
    const isBottom = ref(false);
    const onScroll = useDebounceFn(({ scrollTop }) => {
      if (scrollTop + scrollBar.value?.wrapRef?.clientHeight >= scrollBar.value?.wrapRef?.scrollHeight - 10) {
        isBottom.value = true;
        newMsg.value = false;
      } else {
        isBottom.value = false;
      }
      if (scrollTop < 50) loadHistory();
    }, 200);
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_scrollbar = ElScrollbar;
      const _component_TimeAgo = _sfc_main$1;
      const _component_el_avatar = ElAvatar;
      const _component_el_button = ElButton;
      const _component_el_form = ElForm;
      const _component_el_input = ElInput;
      const _component_CommonFormSmileButton = __nuxt_component_3;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: "chat-box w-full flex-1 load-success",
        id: "chat"
      }, _attrs))} data-v-0196e837>`);
      _push(ssrRenderComponent(_component_el_scrollbar, {
        ref_key: "scrollBar",
        ref: scrollBar,
        onScroll: unref(onScroll),
        class: "rounded flex-1 border-1 shadow-[inset_0_0_20px_0_rgba(0,0,0,0.03)]"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="p-3 w-full flex gap-4 flex-col items-start relative pt-8 chat-list-box" style="${ssrRenderStyle(unref(history)?.edges?.length > 0 ? null : { display: "none" })}" data-v-0196e837${_scopeId}>`);
            if (unref(loading) || !unref(hasMore)) {
              _push2(`<div class="absolute top-0 left-0 w-full flex justify-center border-b items-center text-[--el-color-primary-dark-2] text-xs z-1" data-v-0196e837${_scopeId}>`);
              if (unref(loading)) {
                _push2(`<span class="p-1" data-v-0196e837${_scopeId}>${ssrInterpolate(_ctx.$t("page.modules.post.loading"))}</span>`);
              } else if (!unref(hasMore)) {
                _push2(`<span class="p-1" data-v-0196e837${_scopeId}>${ssrInterpolate(_ctx.$t("page.modules.post.noMore"))}</span>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<!--[-->`);
            ssrRenderList(unref(history)?.edges, (entry, i) => {
              _push2(`<!--[-->`);
              if (entry.node.action == "join_room" || entry.node.action == "leave_room") {
                _push2(`<div class="text-xs flex justify-center w-full" data-v-0196e837${_scopeId}>`);
                if (entry.node.action == "join_room") {
                  _push2(`<span data-v-0196e837${_scopeId}> 🎉 <span class="opacity-40" data-v-0196e837${_scopeId}>${ssrInterpolate(_ctx.$t("page.widgets.chat.join", [entry.node.user.name]))}</span></span>`);
                } else {
                  _push2(`<span data-v-0196e837${_scopeId}> 👋 <span class="opacity-40" data-v-0196e837${_scopeId}>${ssrInterpolate(_ctx.$t("page.widgets.chat.leave", [entry.node.user.name]))}</span></span>`);
                }
                _push2(`</div>`);
              } else {
                _push2(`<!--[-->`);
                if (isDifferenceGreaterThanTenMinutes(entry, unref(history)?.edges, i) || i == 0) {
                  _push2(`<div class="text-center text-xs opacity-60 w-full" data-v-0196e837${_scopeId}>`);
                  _push2(ssrRenderComponent(_component_TimeAgo, {
                    date: entry.node.created_at
                  }, null, _parent2, _scopeId));
                  _push2(`</div>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(`<div class="${ssrRenderClass(`chat-list group/item ${entry.node.user.gqSlug == unref(viewer).data.gqSlug ? "flex-row-reverse self-end" : ""}`)}" data-v-0196e837${_scopeId}>`);
                _push2(ssrRenderComponent(_component_el_avatar, {
                  src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(entry.node.user.avatar.url),
                  size: 18,
                  shape: "square",
                  class: "a"
                }, null, _parent2, _scopeId));
                _push2(`<div class="${ssrRenderClass(`chat-text @xs:text-sm text-xs bg-[--el-color-info-light-10] p-2 pt-1 rounded-[5px] relative flex-1 ${entry.node.user.gqSlug == unref(viewer).data.gqSlug ? "!bg-[--el-color-info-light-10]" : ""}`)}" data-v-0196e837${_scopeId}><div class="${ssrRenderClass(`text-xs opacity-60 mb-0.5 ${entry.node.user.gqSlug == unref(viewer).data.gqSlug ? "text-right" : ""}`)}" data-v-0196e837${_scopeId}>${ssrInterpolate(entry.node.user.name)}</div> ${ssrInterpolate(entry.node.message)} `);
                if (unref(viewer).data.gqRoles.isAdmin || unref(viewer).data.gqSlug == entry.node.user.gqSlug) {
                  _push2(ssrRenderComponent(_component_el_button, {
                    plain: "",
                    circle: "",
                    size: "small",
                    class: "absolute opacity-0 group-hover/item:opacity-100 -right-1 -top-1 !w-4 !h-4",
                    onClick: ($event) => deleteChat(i)
                  }, {
                    default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                      if (_push3) {
                        _push3(`<i class="i-ph-x text-[10px]" data-v-0196e837${_scopeId2}></i>`);
                      } else {
                        return [
                          createVNode("i", { class: "i-ph-x text-[10px]" })
                        ];
                      }
                    }),
                    _: 2
                  }, _parent2, _scopeId));
                } else {
                  _push2(`<!---->`);
                }
                _push2(`</div></div><!--]-->`);
              }
              _push2(`<!--]-->`);
            });
            _push2(`<!--]--></div><div class="flex flex-col w-full items-center max-h-full justify-center text-xs w-full bg-[--el-color-info-light-10] h-full absolute top-0 left-0" style="${ssrRenderStyle(!unref(history)?.edges?.length ? null : { display: "none" })}" data-v-0196e837${_scopeId}><i class="i-ph-shooting-star-thin w-10 h-10 opacity-20" data-v-0196e837${_scopeId}></i><p class="mt-2 opacity-50" data-v-0196e837${_scopeId}>登录后参与聊天</p></div>`);
          } else {
            return [
              withDirectives(createVNode("div", { class: "p-3 w-full flex gap-4 flex-col items-start relative pt-8 chat-list-box" }, [
                unref(loading) || !unref(hasMore) ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "absolute top-0 left-0 w-full flex justify-center border-b items-center text-[--el-color-primary-dark-2] text-xs z-1"
                }, [
                  unref(loading) ? (openBlock(), createBlock("span", {
                    key: 0,
                    class: "p-1"
                  }, toDisplayString(_ctx.$t("page.modules.post.loading")), 1)) : !unref(hasMore) ? (openBlock(), createBlock("span", {
                    key: 1,
                    class: "p-1"
                  }, toDisplayString(_ctx.$t("page.modules.post.noMore")), 1)) : createCommentVNode("", true)
                ])) : createCommentVNode("", true),
                (openBlock(true), createBlock(Fragment, null, renderList(unref(history)?.edges, (entry, i) => {
                  return openBlock(), createBlock(Fragment, { key: i }, [
                    entry.node.action == "join_room" || entry.node.action == "leave_room" ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "text-xs flex justify-center w-full"
                    }, [
                      entry.node.action == "join_room" ? (openBlock(), createBlock("span", { key: 0 }, [
                        createTextVNode(" 🎉 "),
                        createVNode("span", { class: "opacity-40" }, toDisplayString(_ctx.$t("page.widgets.chat.join", [entry.node.user.name])), 1)
                      ])) : (openBlock(), createBlock("span", { key: 1 }, [
                        createTextVNode(" 👋 "),
                        createVNode("span", { class: "opacity-40" }, toDisplayString(_ctx.$t("page.widgets.chat.leave", [entry.node.user.name])), 1)
                      ]))
                    ])) : (openBlock(), createBlock(Fragment, { key: 1 }, [
                      isDifferenceGreaterThanTenMinutes(entry, unref(history)?.edges, i) || i == 0 ? (openBlock(), createBlock("div", {
                        key: 0,
                        class: "text-center text-xs opacity-60 w-full"
                      }, [
                        createVNode(_component_TimeAgo, {
                          date: entry.node.created_at
                        }, null, 8, ["date"])
                      ])) : createCommentVNode("", true),
                      createVNode("div", {
                        class: `chat-list group/item ${entry.node.user.gqSlug == unref(viewer).data.gqSlug ? "flex-row-reverse self-end" : ""}`
                      }, [
                        createVNode(_component_el_avatar, {
                          src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(entry.node.user.avatar.url),
                          size: 18,
                          shape: "square",
                          class: "a"
                        }, null, 8, ["src"]),
                        createVNode("div", {
                          class: `chat-text @xs:text-sm text-xs bg-[--el-color-info-light-10] p-2 pt-1 rounded-[5px] relative flex-1 ${entry.node.user.gqSlug == unref(viewer).data.gqSlug ? "!bg-[--el-color-info-light-10]" : ""}`
                        }, [
                          createVNode("div", {
                            class: `text-xs opacity-60 mb-0.5 ${entry.node.user.gqSlug == unref(viewer).data.gqSlug ? "text-right" : ""}`
                          }, toDisplayString(entry.node.user.name), 3),
                          createTextVNode(" " + toDisplayString(entry.node.message) + " ", 1),
                          unref(viewer).data.gqRoles.isAdmin || unref(viewer).data.gqSlug == entry.node.user.gqSlug ? (openBlock(), createBlock(_component_el_button, {
                            key: 0,
                            plain: "",
                            circle: "",
                            size: "small",
                            class: "absolute opacity-0 group-hover/item:opacity-100 -right-1 -top-1 !w-4 !h-4",
                            onClick: ($event) => deleteChat(i)
                          }, {
                            default: withCtx(() => [
                              createVNode("i", { class: "i-ph-x text-[10px]" })
                            ]),
                            _: 1
                          }, 8, ["onClick"])) : createCommentVNode("", true)
                        ], 2)
                      ], 2)
                    ], 64))
                  ], 64);
                }), 128))
              ], 512), [
                [vShow, unref(history)?.edges?.length > 0]
              ]),
              withDirectives(createVNode("div", { class: "flex flex-col w-full items-center max-h-full justify-center text-xs w-full bg-[--el-color-info-light-10] h-full absolute top-0 left-0" }, [
                createVNode("i", { class: "i-ph-shooting-star-thin w-10 h-10 opacity-20" }),
                createVNode("p", { class: "mt-2 opacity-50" }, "登录后参与聊天")
              ], 512), [
                [vShow, !unref(history)?.edges?.length]
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_el_form, { class: "mt-2 relative chat-form" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (unref(newMsg)) {
              _push2(`<div class="bg-[--el-color-danger-light-9] cursor-pointer text-[--el-color-danger] text-xs px-2 py-1 rounded absolute -top-10 right-2 z-10" data-v-0196e837${_scopeId}><span class="flex items-center gap-1" data-v-0196e837${_scopeId}>${ssrInterpolate(_ctx.$t("page.widgets.chat.newMessage"))}<i class="i-ph-caret-double-down" data-v-0196e837${_scopeId}></i></span></div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="absolute inset-0 bg-[var(--el-color-info-light-10)] flex items-center justify-center flex-col gap-3 z-1 border chat-rounded text-center" style="${ssrRenderStyle(unref(action).chat.isJoin != "chat" ? null : { display: "none" })}" data-v-0196e837${_scopeId}><div class="text-xs text-gray-400" data-v-0196e837${_scopeId}>`);
            if (!unref(viewer).data?.databaseId) {
              _push2(`<div data-v-0196e837${_scopeId}>${ssrInterpolate(_ctx.$t("page.widgets.chat.form.description"))}</div>`);
            } else if (!unref(viewer).data?.gqRoles?.userCan?.includes("chat")) {
              _push2(`<div data-v-0196e837${_scopeId}>${ssrInterpolate(_ctx.$t("page.widgets.chat.form.noAccess"))} <span class="cursor-pointer text-[--el-color-primary]" data-v-0196e837${_scopeId}>${ssrInterpolate(_ctx.$t("page.widgets.chat.form.viewRole"))}</span></div>`);
            } else {
              _push2(`<div class="flex flex-col items-center gap-2" data-v-0196e837${_scopeId}>`);
              _push2(ssrRenderComponent(_component_el_button, {
                size: "small",
                type: "primary",
                plain: "",
                onClick: joinRoom
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`${ssrInterpolate(_ctx.$t("page.widgets.chat.form.join"))}`);
                  } else {
                    return [
                      createTextVNode(toDisplayString(_ctx.$t("page.widgets.chat.form.join")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(` ${ssrInterpolate(_ctx.$t("page.widgets.chat.form.joinRoom"))}</div>`);
            }
            _push2(`</div></div>`);
            _push2(ssrRenderComponent(_component_el_input, {
              modelValue: unref(message),
              "onUpdate:modelValue": ($event) => isRef(message) ? message.value = $event : null,
              maxlength: "120",
              class: "w-full",
              resize: "none",
              onKeydown: handleKeydown,
              autosize: { minRows: 3, maxRows: 8 },
              ref_key: "textarea",
              ref: textarea,
              placeholder: _ctx.$t("page.widgets.chat.form.placeholder"),
              "show-word-limit": "",
              type: "textarea",
              onFocus: ($event) => switchAction.value = true,
              onBlur: ($event) => switchAction.value = false
            }, null, _parent2, _scopeId));
            _push2(`<div class="mt-2 flex justify-between items-center" data-v-0196e837${_scopeId}><div data-v-0196e837${_scopeId}>`);
            _push2(ssrRenderComponent(_component_CommonFormSmileButton, {
              textarea: unref(textarea),
              switchAction: unref(switchAction)
            }, null, _parent2, _scopeId));
            _push2(`</div>`);
            _push2(ssrRenderComponent(_component_el_button, {
              onClick: unref(sendData),
              type: "primary",
              loading: unref(locked)
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("page.widgets.chat.form.send"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("page.widgets.chat.form.send")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div>`);
          } else {
            return [
              unref(newMsg) ? (openBlock(), createBlock("div", {
                key: 0,
                onClick: scrollToBottom,
                class: "bg-[--el-color-danger-light-9] cursor-pointer text-[--el-color-danger] text-xs px-2 py-1 rounded absolute -top-10 right-2 z-10"
              }, [
                createVNode("span", { class: "flex items-center gap-1" }, [
                  createTextVNode(toDisplayString(_ctx.$t("page.widgets.chat.newMessage")), 1),
                  createVNode("i", { class: "i-ph-caret-double-down" })
                ])
              ])) : createCommentVNode("", true),
              withDirectives(createVNode("div", { class: "absolute inset-0 bg-[var(--el-color-info-light-10)] flex items-center justify-center flex-col gap-3 z-1 border chat-rounded text-center" }, [
                createVNode("div", { class: "text-xs text-gray-400" }, [
                  !unref(viewer).data?.databaseId ? (openBlock(), createBlock("div", { key: 0 }, toDisplayString(_ctx.$t("page.widgets.chat.form.description")), 1)) : !unref(viewer).data?.gqRoles?.userCan?.includes("chat") ? (openBlock(), createBlock("div", { key: 1 }, [
                    createTextVNode(toDisplayString(_ctx.$t("page.widgets.chat.form.noAccess")) + " ", 1),
                    createVNode("span", {
                      onClick: showRole,
                      class: "cursor-pointer text-[--el-color-primary]"
                    }, toDisplayString(_ctx.$t("page.widgets.chat.form.viewRole")), 1)
                  ])) : (openBlock(), createBlock("div", {
                    key: 2,
                    class: "flex flex-col items-center gap-2"
                  }, [
                    createVNode(_component_el_button, {
                      size: "small",
                      type: "primary",
                      plain: "",
                      onClick: joinRoom
                    }, {
                      default: withCtx(() => [
                        createTextVNode(toDisplayString(_ctx.$t("page.widgets.chat.form.join")), 1)
                      ]),
                      _: 1
                    }),
                    createTextVNode(" " + toDisplayString(_ctx.$t("page.widgets.chat.form.joinRoom")), 1)
                  ]))
                ])
              ], 512), [
                [vShow, unref(action).chat.isJoin != "chat"]
              ]),
              createVNode(_component_el_input, {
                modelValue: unref(message),
                "onUpdate:modelValue": ($event) => isRef(message) ? message.value = $event : null,
                maxlength: "120",
                class: "w-full",
                resize: "none",
                onKeydown: handleKeydown,
                autosize: { minRows: 3, maxRows: 8 },
                ref_key: "textarea",
                ref: textarea,
                placeholder: _ctx.$t("page.widgets.chat.form.placeholder"),
                "show-word-limit": "",
                type: "textarea",
                onFocus: ($event) => switchAction.value = true,
                onBlur: ($event) => switchAction.value = false
              }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "onFocus", "onBlur"]),
              createVNode("div", { class: "mt-2 flex justify-between items-center" }, [
                createVNode("div", null, [
                  createVNode(_component_CommonFormSmileButton, {
                    textarea: unref(textarea),
                    switchAction: unref(switchAction)
                  }, null, 8, ["textarea", "switchAction"])
                ]),
                createVNode(_component_el_button, {
                  onClick: unref(sendData),
                  type: "primary",
                  loading: unref(locked)
                }, {
                  default: withCtx(() => [
                    createTextVNode(toDisplayString(_ctx.$t("page.widgets.chat.form.send")), 1)
                  ]),
                  _: 1
                }, 8, ["onClick", "loading"])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/chat.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_0 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-0196e837"]]);

export { __nuxt_component_0 as default };
