import { E as ElButton } from './index-DYnTqrQe.mjs';
import { a as useI18n, E as ElMessage } from './server.mjs';
import { mergeProps, withCtx, unref, withDirectives, createVNode, vShow, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderStyle } from 'vue/server-renderer';
import { u as useColorMode } from './composables-1jje8stA.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonColorMode",
  __ssrInlineRender: true,
  setup(__props) {
    const colorMode = useColorMode();
    const { t } = useI18n();
    const toggleColorMode = () => {
      const modes = ["dark", "light", "system"];
      const currentIndex = modes.indexOf(colorMode.preference);
      const nextIndex = (currentIndex + 1) % modes.length;
      colorMode.preference = modes[nextIndex];
      ElMessage.success({
        message: t("common.colorMode." + modes[nextIndex]),
        offset: 60
      });
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      _push(ssrRenderComponent(_component_el_button, mergeProps({
        link: "",
        onClick: toggleColorMode
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-moon-stars" style="${ssrRenderStyle(unref(colorMode).preference == "dark" ? null : { display: "none" })}"${_scopeId}></i><i class="i-ph-sun" style="${ssrRenderStyle(unref(colorMode).preference == "light" ? null : { display: "none" })}"${_scopeId}></i><i class="i-ph-sliders-horizontal" style="${ssrRenderStyle(unref(colorMode).preference == "system" ? null : { display: "none" })}"${_scopeId}></i>`);
          } else {
            return [
              withDirectives(createVNode("i", { class: "i-ph-moon-stars" }, null, 512), [
                [vShow, unref(colorMode).preference == "dark"]
              ]),
              withDirectives(createVNode("i", { class: "i-ph-sun" }, null, 512), [
                [vShow, unref(colorMode).preference == "light"]
              ]),
              withDirectives(createVNode("i", { class: "i-ph-sliders-horizontal" }, null, 512), [
                [vShow, unref(colorMode).preference == "system"]
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/colorMode.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
