import { mergeProps, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate } from 'vue/server-renderer';

const _sfc_main = {
  __name: "ModulesCommonModuleHtml",
  __ssrInlineRender: true,
  props: ["data", "settings"],
  setup(__props) {
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "custom-html" }, _attrs))}>`);
      if (__props.settings.html) {
        _push(`<div>${__props.settings.html ?? ""}</div>`);
      } else {
        _push(`<div class="min-h-[100px] flex items-center justify-center"><div class="text-center text-sm opacity-80">${ssrInterpolate(_ctx.$t("page.modules.html.title"))}</div></div>`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/commonModuleHtml.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
