import { E as ElButton } from './index-DYnTqrQe.mjs';
import { v as viewerStore, e as useUtils } from './server.mjs';
import { useSSRContext, mergeProps, unref, withCtx, openBlock, createBlock, toDisplayString } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonModuleMembership",
  __ssrInlineRender: true,
  props: ["data", "settings"],
  setup(__props) {
    const viewer = viewerStore();
    const handleJoinMembership = () => {
      useUtils.navigateTo("/account/membership");
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "membership-widget group" }, _attrs))} data-v-5a67e38d><div class="absolute inset-0 bg-gradient-to-br from-[--el-color-primary-light-9] via-[--el-color-primary-light-8] to-[--el-color-primary-light-9] opacity-80 z-0" data-v-5a67e38d></div><div class="absolute -bottom-6 -right-6 text-[--el-color-primary] opacity-[0.08] rotate-12 transform group-hover:scale-110 transition-transform duration-500 z-0 pointer-events-none" data-v-5a67e38d><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-32 h-32" data-v-5a67e38d><path fill-rule="evenodd" d="M12.963 2.286a.75.75 0 00-1.071-.136 9.742 9.742 0 00-3.539 6.177A7.547 7.547 0 016.648 6.61a.75.75 0 00-1.152-.082A9 9 0 1015.68 4.534a7.46 7.46 0 01-2.717-2.248zM15.75 14.25a3.75 3.75 0 11-7.5 0 3.75 3.75 0 017.5 0z" clip-rule="evenodd" data-v-5a67e38d></path></svg></div><div class="relative z-0 flex justify-between items-center w-full h-full" data-v-5a67e38d><div class="flex items-center gap-3" data-v-5a67e38d><div class="flex flex-col" data-v-5a67e38d><div class="text-[--el-color-primary] font-bold text-base leading-tight tracking-wide @md:text-base text-sm" data-v-5a67e38d>${ssrInterpolate(_ctx.$t("page.account.membership.myMembership.title"))}</div><div class="text-xs text-[--el-color-primary] mt-1 font-medium opacity-80 line-clamp-1" data-v-5a67e38d>`);
      if (unref(viewer).data.gqVipExpired) {
        _push(`<span data-v-5a67e38d>${ssrInterpolate(_ctx.$t("page.account.membership.myMembership.endTime", [
          unref(viewer).data.gqVipExpired
        ]))}</span>`);
      } else if (!unref(viewer).data.gqVIP) {
        _push(`<span data-v-5a67e38d>${ssrInterpolate(_ctx.$t("page.account.membership.myMembership.joinInfo"))}</span>`);
      } else {
        _push(`<span data-v-5a67e38d>${ssrInterpolate(_ctx.$t("page.account.membership.myMembership.forever"))}</span>`);
      }
      _push(`</div></div></div><div class="pl-2" data-v-5a67e38d>`);
      _push(ssrRenderComponent(_component_el_button, {
        type: "primary",
        round: "",
        size: "small",
        class: "!shadow-md hover:!scale-105 transition-transform duration-300 border-none bg-gradient-to-r from-[--el-color-primary] to-[--el-color-primary-light-3]",
        onClick: handleJoinMembership
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (unref(viewer).data.gqVIP && unref(viewer).data.gqVipExpired) {
              _push2(`<span data-v-5a67e38d${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.membership.myMembership.renew"))}</span>`);
            } else if (unref(viewer).data.gqVIP && !unref(viewer).data.gqVipExpired) {
              _push2(`<span data-v-5a67e38d${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.membership.myMembership.exchange"))}</span>`);
            } else {
              _push2(`<span class="font-bold tracking-wider" data-v-5a67e38d${_scopeId}>${ssrInterpolate(_ctx.$t("page.account.membership.myMembership.become"))}</span>`);
            }
          } else {
            return [
              unref(viewer).data.gqVIP && unref(viewer).data.gqVipExpired ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("page.account.membership.myMembership.renew")), 1)) : unref(viewer).data.gqVIP && !unref(viewer).data.gqVipExpired ? (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("page.account.membership.myMembership.exchange")), 1)) : (openBlock(), createBlock("span", {
                key: 2,
                class: "font-bold tracking-wider"
              }, toDisplayString(_ctx.$t("page.account.membership.myMembership.become")), 1))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/commonModuleMembership.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const commonModuleMembership = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-5a67e38d"]]);

export { commonModuleMembership as default };
