import { E as ElEmpty } from './index-Dbj2uCwz.mjs';
import __nuxt_component_1 from './itemContent-BMgv7q_B.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { d as useRoute, k as deviceStore, e as useUtils, r as useRequest, aN as useIntersectionObserver, l as loadComponent } from './server.mjs';
import { useSSRContext, inject, computed, watch, reactive, provide, ref, mergeProps, unref, createVNode, resolveDynamicComponent, withCtx, openBlock, createBlock, toDisplayString } from 'vue';
import { ssrRenderAttrs, ssrRenderClass, ssrRenderComponent, ssrRenderVNode, ssrRenderStyle, ssrInterpolate } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonModulePost",
  __ssrInlineRender: true,
  props: ["data", "settings", "id"],
  setup(__props) {
    const props = __props;
    const route = useRoute();
    const device = deviceStore();
    const pageState = inject("pageState");
    const postId = computed(() => parseInt(route.params.page?.split(".")?.[0] || route.meta.pageSettings?.id || route.params.name?.[1]?.split(".")?.[0]));
    watch(
      () => pageState?.filter,
      (newVal) => {
        if (newVal?.moduleId == props.id) {
          state.pay = newVal.pay ?? "";
          state.filterType = newVal.filterType ?? "";
          state.tags = newVal.tags?.length > 0 ? newVal.tags.join(",") : "";
          state.orderby = newVal.orderby ?? "";
          state.random = newVal.random ?? false;
          state.sortByPrice = newVal.sortByPrice ?? "";
          state.key = newVal.key ?? "";
          state.category = newVal.categoryId ?? null;
          state.getPosts();
        }
      }
    );
    const state = reactive({
      category: 0,
      pay: "",
      filterType: "",
      tags: "",
      orderby: "",
      loadMore: false,
      random: false,
      locked: false,
      loadMoreAction: async () => {
        if (state.loadMore) return;
        state.loadMore = true;
        await state.getPosts();
      },
      getPosts: async () => {
        let cats = state.category ? [state.category] : props.settings.menus?.length > 0 ? props.settings.menus.map((item) => item.databaseId) : [];
        if (props.settings.isArchive && postId.value) {
          cats = [postId.value];
        }
        if (!state.loadMore) {
          if (state.locked) return;
          state.locked = true;
        }
        state.tags = state.tags?.startsWith(",") ? state.tags?.slice(1) : state.tags;
        const res = await useRequest("/api/page", {
          body: {
            device: device.currentDevice,
            path: route.path,
            args: {
              moduleId: props.id,
              category: cats?.length > 0 ? cats.join(",") : "",
              pay: state.pay,
              filterType: state.filterType,
              tags: state.tags,
              key: state.key,
              sortByPrice: state.sortByPrice,
              after: state.loadMore ? props.data.list.pageInfo.endCursor : "",
              orderby: state.orderby,
              random: state.random || false
            }
          }
        });
        if (res?.module) {
          if (state.loadMore) {
            props.data.list.edges = [
              ...props.data.list.edges,
              ...res.module[props.id].list.edges
            ];
            props.data.list.pageInfo = res.module[props.id].list.pageInfo;
          } else {
            props.data.list = res.module[props.id].list;
          }
        }
        state.loadMore = false;
        state.random = false;
        state.locked = false;
      },
      handleClick: (item) => {
        useUtils.navigateTo(item?.node?.gqSlug);
      },
      articleClass: (i) => {
        let c = ``;
        if (props.settings.gap == 0 && props.settings.padding != 0) {
          c += ` border-b `;
          if (props.settings.rowCount > 1) {
            c += ` border-r `;
            if ((i + 1) % props.settings.rowCount === 0) {
              c += ` border-r-0`;
            }
          }
        }
        if (props.settings.rowCount == 1 && (props.settings.backgroundColor == "transparent" || props.settings.backgroundColor == "")) {
          c += ` px-0`;
        }
        if (props.settings.gap != 0) {
          c += ` rounded-[var(--gq-post-thumb-radius)] hover:shadow-lg transition-shadow duration-300`;
        }
        if (props.settings.padding == 0 || props.settings.gap == 0) {
          c += ` hover:!shadow-none`;
        }
        return c;
      }
    });
    provide("state", state);
    const loadTrigger = ref(null);
    if (props.settings?.autoLoadMore && route.path != "/builder") {
      useIntersectionObserver(
        loadTrigger,
        ([{ isIntersecting }]) => {
          if (isIntersecting && !state.loadMore && props.data?.list?.pageInfo?.hasNextPage) {
            state.loadMoreAction();
          }
        },
        {
          rootMargin: "100px"
          // 可选：提前 100px 触发，让用户无感加载
        }
      );
    }
    const loadMoreButtonClass = () => {
      if (!props.settings.attrsPicked.includes("loadMoreButton")) {
        return "h-0 overflow-hidden";
      }
      let c = `bg-[var(--tbg)] ${props.settings.animation ? "xyz-nested" : ""} flex w-full justify-center mt-[var(--gq-post-gap)] cursor-pointer rounded-[var(--gq-post-thumb-radius)]`;
      if (props.settings.gap == 0 && props.settings.padding != 0) {
        c += ` `;
      }
      c += ` gq-rounded mt-${props.settings.gap}`;
      if (props.settings.gap == 0 && props.settings.padding != 0) {
        c += ` !rounded-t-none`;
      }
      c += ` p-${props.settings.padding} `;
      if (props.settings.padding == 0) {
        c += ` hover:!shadow-none`;
      }
      return c;
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_empty = ElEmpty;
      const _component_ModulesCommonTopicItemContent = __nuxt_component_1;
      const _component_el_button = ElButton;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: `${__props.settings.gap == 0 ? "overflow-hidden" : ""} gq-rounded !bg-transparent`,
        style: `--gq-bar-padding:${__props.settings.bar.padding}px;
        --gq-bar-bg:${__props.settings.bar.backgroundColor};
        --gq-bar-fontSize:${__props.settings.bar.fontSize}px;
        --gq-post-grid:${__props.settings.grid[__props.settings.style == "list" ? "list" : "grid"]};
        --gq-post-padding:${__props.settings.padding * 0.25}rem;
        --gq-post-padding-normal:0.75rem;
        --gq-post-thumb-radius:var(--el-border-radius-${__props.settings.thumb.thumbRadius});
        --gq-post-thumb-ratio:${__props.settings.thumb.thumbRatio * 100}%;
        --gq-post-gap:${__props.settings.gap * 0.25}rem;
        `
      }, _attrs))} data-v-69c6a080>`);
      if (__props.data?.list?.edges && __props.data?.list?.edges?.length == 0) {
        _push(`<div class="${ssrRenderClass(`bg-[--tbg] ${unref(state).locked ? "child-load" : "child-load-success"} style-${__props.settings.style}`)}" data-v-69c6a080>`);
        _push(ssrRenderComponent(_component_el_empty, {
          description: _ctx.$t("common.editor.library.empty"),
          id: __props.id + "-empty",
          class: "gq-gs"
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(("loadComponent" in _ctx ? _ctx.loadComponent : unref(loadComponent))("modules/common/post/postList", (__props.settings.style == "grid" ? "list" : __props.settings.style) || "list")), {
        settings: __props.settings,
        data: __props.data,
        id: __props.id,
        state: unref(state)
      }, null), _parent);
      if (__props.settings.style == "xiaohongshu") {
        _push(ssrRenderComponent(_component_ModulesCommonTopicItemContent, {
          data: __props.data,
          settings: __props.settings,
          state: unref(state),
          id: __props.id,
          postType: "post"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="${ssrRenderClass(loadMoreButtonClass())}" style="${ssrRenderStyle(`--xyz-index:${__props.settings.totalCount + 1};`)}" data-v-69c6a080>`);
      _push(ssrRenderComponent(_component_el_button, {
        class: "w-full block",
        link: "",
        loading: unref(state).loadMore,
        disabled: !__props.data?.list?.pageInfo?.hasNextPage
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            if (__props.data?.list?.pageInfo?.hasNextPage) {
              _push2(`<span data-v-69c6a080${_scopeId}>${ssrInterpolate(unref(state).loadMore ? _ctx.$t("page.modules.post.loading") : _ctx.$t("page.modules.post.loadMoreButton"))}</span>`);
            } else {
              _push2(`<span data-v-69c6a080${_scopeId}>${ssrInterpolate(_ctx.$t("page.modules.post.noMore"))}</span>`);
            }
          } else {
            return [
              __props.data?.list?.pageInfo?.hasNextPage ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(unref(state).loadMore ? _ctx.$t("page.modules.post.loading") : _ctx.$t("page.modules.post.loadMoreButton")), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("page.modules.post.noMore")), 1))
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/commonModulePost.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const commonModulePost = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-69c6a080"]]);

export { commonModulePost as default };
