import { E as ElButton } from './index-DYnTqrQe.mjs';
import { j as actionStore, g as getServerSettings, e as useUtils, x as __nuxt_component_0$1 } from './server.mjs';
import { useSSRContext, reactive, computed, mergeProps, withCtx, createVNode, unref } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent } from 'vue/server-renderer';
import NumberFlow from '@number-flow/vue';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonModulePromotion",
  __ssrInlineRender: true,
  props: ["data", "settings"],
  setup(__props) {
    const props = __props;
    const action = actionStore();
    const settingsStore = getServerSettings();
    const state = reactive({
      current: computed(() => {
        const item = props.data?.info?.userPromotion?.statistics?.find(
          (item2) => item2.currency === state.currencyPicked.iso
        );
        if (!item) return null;
        return item;
      }),
      currencyPicked: {
        iso: action.currency.iso,
        symbol: action.currency.symbol
      },
      info: computed(() => {
        return props.data?.info;
      }),
      changeCurrency: (iso) => {
        state.currencyPicked.iso = iso;
        state.currencyPicked.symbol = useUtils.isoToSymbol(
          iso,
          settingsStore.currency
        );
      },
      money: (val) => {
        return useUtils.localPrice(val, state.currencyPicked.iso);
      },
      total: computed(() => {
        const item = state.current;
        if (!item) return 0;
        let total = useUtils.add(item.closed, item.paid);
        total = useUtils.add(total, item.waiting);
        total = useUtils.add(total, item.withdrawn);
        total = useUtils.add(total, item.withdrawable);
        return total;
      })
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "promotion" }, _attrs))} data-v-8b37eaac><div class="flex flex-col gap-2 cursor-pointer" data-v-8b37eaac><div class="flex justify-between items-center border-b pb-3" data-v-8b37eaac><h2 class="text-sm" data-v-8b37eaac>${ssrInterpolate(_ctx.$t("page.account.promotion.promotion"))}</h2>`);
      _push(ssrRenderComponent(_component_el_button, {
        text: "",
        bg: "",
        circle: "",
        class: "!rounded",
        size: "small"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<i class="i-ph-caret-right-bold 2xl" data-v-8b37eaac${_scopeId}></i>`);
          } else {
            return [
              createVNode("i", { class: "i-ph-caret-right-bold 2xl" })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div data-v-8b37eaac><div class="flex items-center justify-between group cursor-pointer" data-v-8b37eaac><div class="text-2xl flex items-baseline gap-1 ml-1" data-v-8b37eaac><span class="text-xs font-bold opacity-70 text-[--el-color-primary]" data-v-8b37eaac>${ssrInterpolate(unref(state).currencyPicked.symbol)}</span>`);
      _push(ssrRenderComponent(unref(NumberFlow), {
        value: unref(state).money(unref(state).total),
        format: {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
          useGrouping: false
        },
        class: "font-bold text-[--el-color-primary]"
      }, null, _parent));
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`</div></div><div class="flex justify-between gap-1 mt-2 text-xs" data-v-8b37eaac><div class="flex items-center bg-[--el-color-info-light-10] px-2 py-1.5 gap-2 rounded-lg w-full" data-v-8b37eaac><span class="flex items-center justify-center w-7 h-7 bg-[--el-bg-color] rounded-full" data-v-8b37eaac><i class="i-ph-wallet" data-v-8b37eaac></i></span><div data-v-8b37eaac><span class="opacity-70 text-[11px]" data-v-8b37eaac>${ssrInterpolate(_ctx.$t("page.account.promotion.withdrawable"))}：</span><div class="text-sm" data-v-8b37eaac>${ssrInterpolate(unref(state).currencyPicked.symbol)} `);
      _push(ssrRenderComponent(unref(NumberFlow), {
        value: unref(state).money(unref(state).current?.withdrawable),
        format: {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
          useGrouping: false
        }
      }, null, _parent));
      _push(`</div></div></div><div class="flex items-center bg-[--el-color-info-light-10] px-2 py-1.5 gap-2 rounded-lg w-full" data-v-8b37eaac><span class="flex items-center justify-center w-7 h-7 bg-[--el-bg-color] rounded-full" data-v-8b37eaac><i class="i-ph-clock" data-v-8b37eaac></i></span><div data-v-8b37eaac><span class="opacity-70 text-[11px]" data-v-8b37eaac>${ssrInterpolate(_ctx.$t("page.account.promotion.withdrawn"))}：</span><div class="text-sm" data-v-8b37eaac>${ssrInterpolate(unref(state).currencyPicked.symbol)} `);
      _push(ssrRenderComponent(unref(NumberFlow), {
        value: unref(state).money(unref(state).current?.withdrawn),
        format: {
          minimumFractionDigits: 2,
          maximumFractionDigits: 2,
          useGrouping: false
        }
      }, null, _parent));
      _push(`</div></div></div></div></div></div>`);
      if (__props.settings.content[_ctx.$i18n.locale]) {
        _push(`<div class="border-t mt-[--tpt] pt-[--tpt]" data-v-8b37eaac><div data-v-8b37eaac>${__props.settings.content[_ctx.$i18n.locale] ?? ""}</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/commonModulePromotion.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const commonModulePromotion = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-8b37eaac"]]);

export { commonModulePromotion as default };
