import { l as loadComponent } from './server.mjs';
import { ref, inject, watchEffect, createVNode, resolveDynamicComponent, unref, mergeProps, useSSRContext } from 'vue';
import { ssrRenderVNode } from 'vue/server-renderer';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonModuleTopicInfo",
  __ssrInlineRender: true,
  props: ["data", "settings", "id", "action"],
  setup(__props) {
    const props = __props;
    const _data = ref({});
    const _action = ref(props.data || {});
    const _settings = ref(props.settings || {});
    const pageState = inject("pageState");
    const id = props.settings?.moduleId?.replace("#", "");
    watchEffect(() => {
      if (pageState?.community?.[id]) {
        _action.value = pageState?.community?.[id].action;
        _data.value = pageState?.community?.[id].data;
        _settings.value = pageState?.community?.[id].settings;
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(("loadComponent" in _ctx ? _ctx.loadComponent : unref(loadComponent))("modules/common/topicInfo", __props.settings.type || "default")), mergeProps({
        settings: __props.settings,
        data: unref(_data),
        id: unref(id),
        _settings: unref(_settings),
        action: unref(_action)
      }, _attrs), null), _parent);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/commonModuleTopicInfo.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
