import { d as useRoute, l as loadComponent } from './server.mjs';
import { ref, inject, watchEffect, computed, createVNode, resolveDynamicComponent, unref, mergeProps, useSSRContext } from 'vue';
import { ssrRenderVNode } from 'vue/server-renderer';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonModuleTopicMenu",
  __ssrInlineRender: true,
  props: ["data", "settings", "id", "action"],
  setup(__props) {
    const props = __props;
    const route = useRoute();
    const _settings = ref({});
    const _action = ref({});
    const pageState = inject("pageState");
    const id = props.settings?.moduleId?.replace("#", "");
    if (id) {
      watchEffect(() => {
        if (pageState?.community?.[id]) {
          _action.value = pageState?.community?.[id].action;
          _settings.value = pageState?.community?.[id].settings;
        }
      });
    } else {
      if (route.path.includes("/builder")) {
        _action.value.menuList = computed(
          () => props.settings?.menus.map((item) => {
            return {
              ...item,
              communityCatMetas: {
                name: JSON.parse(item.communityCatMetas.name),
                memberCount: item.communityCatMetas.memberCount,
                isJoin: item.communityCatMetas.isJoin
              }
            };
          })
        );
      } else {
        _action.value.menuList = computed(
          () => props.data?.menu?.nodes?.map((item) => {
            return {
              ...item,
              communityCatMetas: {
                name: JSON.parse(item.communityCatMetas.name),
                memberCount: item.communityCatMetas.memberCount,
                isJoin: item.communityCatMetas.isJoin
              }
            };
          })
        );
      }
      _action.value.link = 1;
    }
    return (_ctx, _push, _parent, _attrs) => {
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(("loadComponent" in _ctx ? _ctx.loadComponent : unref(loadComponent))("modules/common/topicMenu", __props.settings.type || "default")), mergeProps({
        settings: unref(_settings),
        globalSettings: __props.settings,
        data: __props.data,
        id: unref(id),
        action: unref(_action)
      }, _attrs), null), _parent);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/commonModuleTopicMenu.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
