import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import { v as vLoading } from './directive-BPPM1aUC.mjs';
import { r as useRequest, e as useUtils } from './server.mjs';
import { useSSRContext, ref, computed, reactive, nextTick, watch, inject, mergeProps, unref, withCtx, createTextVNode, toDisplayString, createVNode, openBlock, createBlock, createCommentVNode, Fragment, renderList, withModifiers, withDirectives } from 'vue';
import { ssrRenderAttrs, ssrRenderList, ssrRenderComponent, ssrInterpolate, ssrRenderClass, ssrRenderStyle, ssrGetDirectiveProps } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './event-BZTOGHfp.mjs';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import './index-ChPMoinw.mjs';
import './index-BKB3Djp4.mjs';
import './index-Bp-nwGzu.mjs';
import './aria-BhThsKez.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonModuleTopicTags",
  __ssrInlineRender: true,
  props: ["data", "settings", "id"],
  setup(__props) {
    const props = __props;
    const searchInputRef = ref(null);
    const list = computed(() => {
      if (state.show == "search") {
        return state.searchList?.edges;
      } else if (state.show == "all") {
        return state.allHotList?.edges;
      } else {
        return state.weekHotList?.edges;
      }
    });
    const moreButton = ref({});
    const state = reactive({
      searchList: null,
      weekHotList: null,
      allHotList: null,
      key: "",
      oldKey: "",
      createName: "",
      locked: false,
      loading: false,
      moreLocked: false,
      show: props.settings?.defaultShow?.[0] ? props.settings?.defaultShow?.[0] : props.settings?.showSearch ? "search" : "week",
      orderby: "WEEK_HOT",
      showAction: async (type) => {
        state.show = type;
        if (state.show == "search") {
          nextTick(() => {
            searchInputRef.value.focus();
          });
        }
        if (state.show == "all" && !state.allHotList) {
          await state.getAllHotTags(false);
        }
        if (state.show == "week" && !state.weekHotList) {
          await state.getWeekHotTags(false);
        }
      },
      loadMore: async () => {
        state.moreLocked = true;
        if (state.show == "search") {
          await state.getSearchTags(true);
        }
        if (state.show == "week") {
          await state.getWeekHotTags(true);
        }
        if (state.show == "all") {
          await state.getAllHotTags(true);
        }
        state.moreLocked = false;
      },
      getAllHotTags: async (loadMore) => {
        if (state.locked) return;
        state.locked = true;
        const res = await state.getTags({
          type: "COMMUNITYTAG",
          search: state.key,
          orderby: "COUNT",
          after: loadMore ? state.allHotList?.pageInfo?.endCursor : null
        });
        if (res) {
          if (!loadMore || !state.allHotList) {
            state.allHotList = res;
          } else {
            state.allHotList.edges.push(...res.edges);
            state.allHotList.pageInfo = res.pageInfo;
          }
        }
        state.locked = false;
      },
      getWeekHotTags: async (loadMore) => {
        if (state.locked) return;
        state.locked = true;
        const res = await state.getTags({
          type: "COMMUNITYTAG",
          search: state.key,
          orderby: "WEEK_HOT",
          after: loadMore ? state.weekHotList?.pageInfo?.endCursor : null
        });
        if (res) {
          if (!loadMore || !state.weekHotList) {
            state.weekHotList = res;
          } else {
            state.weekHotList.edges.push(...res.edges);
            state.weekHotList.pageInfo = res.pageInfo;
          }
        }
        state.locked = false;
      },
      getSearchTags: async (loadMore) => {
        if (!state.key) {
          return;
        }
        state.oldKey = state.key;
        if (state.locked) return;
        state.locked = true;
        const res = await state.getTags({
          type: "COMMUNITYTAG",
          search: state.key,
          orderby: "COUNT",
          after: loadMore ? state.searchList?.pageInfo?.endCursor : null
        });
        if (res) {
          if (!loadMore || !state.searchList) {
            state.searchList = res;
          } else {
            if (state.searchList) {
              state.searchList.edges.push(...res.edges);
              state.searchList.pageInfo = res.pageInfo;
            }
          }
        }
        state.locked = false;
        state.loading = false;
      },
      getTags: async (data) => {
        state.loading = true;
        const res = await useRequest("/api/request", {});
        state.loading = false;
        if (res?.terms) {
          return res.terms;
        }
        return null;
      }
    });
    watch(
      () => props.data,
      (newVal) => {
        if (newVal) {
          if (state.show == "week") {
            state.weekHotList = newVal;
          } else if (state.show == "all") {
            state.allHotList = newVal;
          }
        }
      },
      { deep: false, immediate: true }
    );
    const pageState = inject("pageState");
    const id = props.settings?.moduleId?.replace("#", "");
    const currentTag = computed(() => {
      return pageState?.community?.[id]?.action?.tag;
    });
    const go = (tag) => {
      if (id && pageState?.community?.[id]) {
        pageState?.community?.[id].action.getList(
          pageState?.community?.[id].action.category,
          null,
          tag?.databaseId
        );
        pageState.community[id].action.currentTag = tag;
      } else {
        useUtils.navigateTo(tag?.gqSlug);
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      const _component_el_input = ElInput;
      const _component_el_scrollbar = ElScrollbar;
      const _directive_loading = vLoading;
      let _temp0;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "communitytags-box tag-box w-full h-full z-1 bg-[--el-bg-color] flex flex-col" }, _attrs))} data-v-1e758ac4>`);
      if (__props.settings?.defaultShow?.length > 0) {
        _push(`<div class="flex justify-between items-cente -ml-[--tpl] -mr-[--tpl] pl-[--tpl] border-b pr-[--tpr] pb-[calc(var(--tpb)*.6)] -mt-[calc(var(--tpt)*.3)]" data-v-1e758ac4><div class="flex items-center flex-1 gap-3" data-v-1e758ac4><!--[-->`);
        ssrRenderList(__props.settings?.defaultShow || ["week", "all"], (item) => {
          _push(ssrRenderComponent(_component_el_button, {
            link: "",
            size: "small",
            onClick: ($event) => unref(state).showAction(item),
            type: unref(state).show == item ? "primary" : "default",
            class: "!m-0 !p-0 !text-xs"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("page.community.topicTags." + item))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("page.community.topicTags." + item)), 1)
                ];
              }
            }),
            _: 2
          }, _parent));
        });
        _push(`<!--]--></div>`);
        if (__props.settings?.showSearch) {
          _push(ssrRenderComponent(_component_el_button, {
            link: "",
            onClick: ($event) => unref(state).showAction("search"),
            type: unref(state).show == "search" ? "primary" : "default",
            class: "!m-0 !p-0 @md:!text-sm !text-xs !font-500"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<i class="i-ph-magnifying-glass-bold" data-v-1e758ac4${_scopeId}></i>`);
              } else {
                return [
                  createVNode("i", { class: "i-ph-magnifying-glass-bold" })
                ];
              }
            }),
            _: 1
          }, _parent));
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="${ssrRenderClass(`flex-1 flex flex-col -ml-[--tpl] overflow-hidden -mr-[--tpl]  ${!__props.settings?.defaultShow || __props.settings?.defaultShow?.length == 0 ? "rounded-tl-[--trtl] rounded-tr-[--trtr] -mt-[--tpt]" : ""}`)}" data-v-1e758ac4>`);
      if (__props.settings?.defaultShow?.length > 0 || __props.settings?.showSearch) {
        _push(`<div class="flex items-center pl-[--tpl] pr-[--tpr] @md:h-10 h-8 bg-[--el-color-info-light-10] border-b" data-v-1e758ac4>`);
        if (unref(state).show == "week") {
          _push(`<div class="@md:text-sm text-xs opacity-70" data-v-1e758ac4> 本周热门话题 </div>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(state).show == "all") {
          _push(`<div class="@md:text-sm text-xs opacity-70" data-v-1e758ac4> 所有热门话题 </div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="flex items-center justify-between w-full" style="${ssrRenderStyle(unref(state).show == "search" ? null : { display: "none" })}" data-v-1e758ac4>`);
        _push(ssrRenderComponent(_component_el_input, {
          modelValue: unref(state).key,
          "onUpdate:modelValue": ($event) => unref(state).key = $event,
          placeholder: "搜索话题",
          onKeyup: ($event) => unref(state).getSearchTags(),
          ref_key: "searchInputRef",
          ref: searchInputRef,
          style: { "--el-input-border-color": "transparent", "--el-input-bg-color": "transparent" }
        }, {
          suffix: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(ssrRenderComponent(_component_el_button, {
                text: "",
                bg: "",
                onClick: ($event) => unref(state).getSearchTags(),
                size: "small",
                loading: unref(state).locked,
                type: "primary",
                class: "-mr-1"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    if (!unref(state).locked) {
                      _push3(`<span data-v-1e758ac4${_scopeId2}>搜索</span>`);
                    } else {
                      _push3(`<!---->`);
                    }
                  } else {
                    return [
                      !unref(state).locked ? (openBlock(), createBlock("span", { key: 0 }, "搜索")) : createCommentVNode("", true)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              return [
                createVNode(_component_el_button, {
                  text: "",
                  bg: "",
                  onClick: ($event) => unref(state).getSearchTags(),
                  size: "small",
                  loading: unref(state).locked,
                  type: "primary",
                  class: "-mr-1"
                }, {
                  default: withCtx(() => [
                    !unref(state).locked ? (openBlock(), createBlock("span", { key: 0 }, "搜索")) : createCommentVNode("", true)
                  ]),
                  _: 1
                }, 8, ["onClick", "loading"])
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div></div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="relative h-[var(--gq-max-height)]" style="${ssrRenderStyle(`--gq-max-height: ${__props.settings?.maxHeight || 20}rem;`)}" data-v-1e758ac4><div class="absolute inset-0" data-v-1e758ac4>`);
      _push(ssrRenderComponent(_component_el_scrollbar, { height: "100%" }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="auto-grid gap-3 pl-[--tpl] pr-[--tpr] pt-[--tpt] pb-[--tpb]" style="${ssrRenderStyle({ "--gq-grid-min-width": "9.6rem" })}" data-v-1e758ac4${_scopeId}><!--[-->`);
            ssrRenderList(unref(list), (tag) => {
              _push2(`<div class="${ssrRenderClass(`flex items-center flex-1 hover:text-[--el-color-primary] cursor-pointer ${unref(currentTag) == tag?.node?.databaseId ? "text-[--el-color-primary] " : ""}`)}" data-v-1e758ac4${_scopeId}><span class="gap-.3 flex-1 line-clamp-1 text-sm gq-gs" data-v-1e758ac4${_scopeId}><span class="text-[--el-color-primary]" data-v-1e758ac4${_scopeId}>#</span> ${ssrInterpolate(tag?.node?.name || "Tag name not found")}</span>`);
              if (!unref(id)) {
                _push2(`<span class="text-[11px] opacity-50 ml-4 gq-gs" data-v-1e758ac4${_scopeId}>${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(tag?.node?.count || 0))}</span>`);
              } else if (unref(currentTag) == tag?.node?.databaseId) {
                _push2(ssrRenderComponent(_component_el_button, {
                  size: "small",
                  type: "danger",
                  circle: "",
                  link: "",
                  bg: "",
                  onClick: ($event) => unref(pageState)?.community?.[unref(id)].action.getList(
                    unref(pageState)?.community?.[unref(id)].action.category,
                    null,
                    0
                  ),
                  class: "!w-4 !h-4"
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`<i class="i-ph-x-bold" data-v-1e758ac4${_scopeId2}></i>`);
                    } else {
                      return [
                        createVNode("i", { class: "i-ph-x-bold" })
                      ];
                    }
                  }),
                  _: 2
                }, _parent2, _scopeId));
              } else {
                _push2(`<!---->`);
              }
              _push2(`</div>`);
            });
            _push2(`<!--]--></div>`);
            if (unref(state).loading) {
              _push2(`<div${ssrRenderAttrs(_temp0 = mergeProps({ class: "w-full h-[calc(100%-40px)] flex items-center justify-center" }, ssrGetDirectiveProps(_ctx, _directive_loading, unref(state).loading)))} data-v-1e758ac4${_scopeId}>${"textContent" in _temp0 ? ssrInterpolate(_temp0.textContent) : _temp0.innerHTML ?? ""}</div>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(state).show == "search" && !unref(state).searchList) {
              _push2(`<div class="w-full h-full flex items-center justify-center text-xs opacity-50" data-v-1e758ac4${_scopeId}> 搜索话题... </div>`);
            } else if (unref(state).searchList?.edges?.length == 0 && unref(state).show == "search" || unref(state).weekHotList?.edges?.length == 0 && unref(state).show == "week" || unref(state).allHotList?.edges?.length == 0 && unref(state).show == "all") {
              _push2(`<div class="w-full h-full flex items-center justify-center" data-v-1e758ac4${_scopeId}><span class="text-xs opacity-50" data-v-1e758ac4${_scopeId}>暂无数据</span></div>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(moreButton)?.show && __props.settings?.showMore) {
              _push2(`<div class="flex justify-center pb-4 gq" data-v-1e758ac4${_scopeId}>`);
              _push2(ssrRenderComponent(_component_el_button, {
                onClick: ($event) => unref(state).loadMore(),
                bg: "",
                text: "",
                size: "small",
                loading: unref(state).moreLocked,
                disabled: unref(moreButton)?.disabled
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<span data-v-1e758ac4${_scopeId2}>${ssrInterpolate(unref(moreButton)?.text)}</span>`);
                  } else {
                    return [
                      createVNode("span", null, toDisplayString(unref(moreButton)?.text), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode("div", {
                class: "auto-grid gap-3 pl-[--tpl] pr-[--tpr] pt-[--tpt] pb-[--tpb]",
                style: { "--gq-grid-min-width": "9.6rem" }
              }, [
                (openBlock(true), createBlock(Fragment, null, renderList(unref(list), (tag) => {
                  return openBlock(), createBlock("div", {
                    key: tag?.node?.databaseId,
                    class: `flex items-center flex-1 hover:text-[--el-color-primary] cursor-pointer ${unref(currentTag) == tag?.node?.databaseId ? "text-[--el-color-primary] " : ""}`,
                    onClick: ($event) => go(tag?.node)
                  }, [
                    createVNode("span", { class: "gap-.3 flex-1 line-clamp-1 text-sm gq-gs" }, [
                      createVNode("span", { class: "text-[--el-color-primary]" }, "#"),
                      createTextVNode(" " + toDisplayString(tag?.node?.name || "Tag name not found"), 1)
                    ]),
                    !unref(id) ? (openBlock(), createBlock("span", {
                      key: 0,
                      class: "text-[11px] opacity-50 ml-4 gq-gs"
                    }, toDisplayString(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).nFormatter(tag?.node?.count || 0)), 1)) : unref(currentTag) == tag?.node?.databaseId ? (openBlock(), createBlock(_component_el_button, {
                      key: 1,
                      size: "small",
                      type: "danger",
                      circle: "",
                      link: "",
                      bg: "",
                      onClick: withModifiers(($event) => unref(pageState)?.community?.[unref(id)].action.getList(
                        unref(pageState)?.community?.[unref(id)].action.category,
                        null,
                        0
                      ), ["stop"]),
                      class: "!w-4 !h-4"
                    }, {
                      default: withCtx(() => [
                        createVNode("i", { class: "i-ph-x-bold" })
                      ]),
                      _: 1
                    }, 8, ["onClick"])) : createCommentVNode("", true)
                  ], 10, ["onClick"]);
                }), 128))
              ]),
              unref(state).loading ? withDirectives((openBlock(), createBlock("div", {
                key: 0,
                class: "w-full h-[calc(100%-40px)] flex items-center justify-center"
              }, null, 512)), [
                [_directive_loading, unref(state).loading]
              ]) : createCommentVNode("", true),
              unref(state).show == "search" && !unref(state).searchList ? (openBlock(), createBlock("div", {
                key: 1,
                class: "w-full h-full flex items-center justify-center text-xs opacity-50"
              }, " 搜索话题... ")) : unref(state).searchList?.edges?.length == 0 && unref(state).show == "search" || unref(state).weekHotList?.edges?.length == 0 && unref(state).show == "week" || unref(state).allHotList?.edges?.length == 0 && unref(state).show == "all" ? (openBlock(), createBlock("div", {
                key: 2,
                class: "w-full h-full flex items-center justify-center"
              }, [
                createVNode("span", { class: "text-xs opacity-50" }, "暂无数据")
              ])) : createCommentVNode("", true),
              unref(moreButton)?.show && __props.settings?.showMore ? (openBlock(), createBlock("div", {
                key: 3,
                class: "flex justify-center pb-4 gq"
              }, [
                createVNode(_component_el_button, {
                  onClick: ($event) => unref(state).loadMore(),
                  bg: "",
                  text: "",
                  size: "small",
                  loading: unref(state).moreLocked,
                  disabled: unref(moreButton)?.disabled
                }, {
                  default: withCtx(() => [
                    createVNode("span", null, toDisplayString(unref(moreButton)?.text), 1)
                  ]),
                  _: 1
                }, 8, ["onClick", "loading", "disabled"])
              ])) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/commonModuleTopicTags.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const commonModuleTopicTags = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-1e758ac4"]]);

export { commonModuleTopicTags as default };
