import _sfc_main$1 from './blink-DRvWMg-X.mjs';
import { E as ElAvatar } from './index-R6EFYpWa.mjs';
import _sfc_main$2 from './timeAgo-D7-A3XOx.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElEmpty } from './index-Dbj2uCwz.mjs';
import { d as useRoute, v as viewerStore, e as useUtils, r as useRequest } from './server.mjs';
import { ref, computed, resolveComponent, mergeProps, unref, withCtx, createVNode, toDisplayString, openBlock, createBlock, withModifiers, createCommentVNode, Fragment, renderList, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrRenderClass, ssrRenderStyle, ssrInterpolate } from 'vue/server-renderer';
import './nuxt-link-Dd6LuEo9.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-DRiwogtD.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './index-ChPMoinw.mjs';
import './constants-hAKFmBbq.mjs';
import './vnode-l2ZP2UQa.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import '@ctrl/tinycolor';

const _sfc_main = {
  __name: "ModulesProfileListCreateCommunityAnswers",
  __ssrInlineRender: true,
  setup(__props) {
    const posts = ref("");
    const route = useRoute();
    const userId = computed(() => parseInt(route.params?.page?.split(".")?.[0] || route.meta.pageSettings?.id || route.params.name?.[1]?.split(".")?.[0]) || viewer.data?.databaseId);
    const locked = ref(false);
    const viewer = viewerStore();
    const handleEdit = async (id) => {
      await useUtils.navigateTo(`/create?type=answer&id=${id}`);
    };
    const deleteAction = (id) => {
      useUtils.deleteAction(id, "answer", (bid) => {
        const index = posts.value.edges.findIndex(
          (item) => item.node.databaseId === bid
        );
        if (index !== -1) {
          posts.value.edges.splice(index, 1);
        }
      });
    };
    const handleLoadMore = () => {
      getPosts();
    };
    const isCreator = computed(() => route.params?.tab == "creator" || route.path == "/account");
    const getPosts = async (flush = false) => {
      if (locked.value) return;
      locked.value = true;
      const res = await useRequest("/api/request", {
        body: {
          data: {
            userId: isCreator.value ? viewer.data.databaseId : userId.value,
            after: flush === true ? null : posts.value?.pageInfo?.endCursor,
            isCreator: isCreator.value
          }
        }
      });
      if (res?.communityAnswers) {
        if (posts.value && flush !== true) {
          posts.value.edges = [...posts.value.edges, ...res.communityAnswers.edges];
          posts.value.pageInfo = res.communityAnswers.pageInfo;
        } else {
          posts.value = res.communityAnswers;
        }
      }
      locked.value = false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_masonry = resolveComponent("masonry");
      const _component_Blink = _sfc_main$1;
      const _component_el_avatar = ElAvatar;
      const _component_TimeAgo = _sfc_main$2;
      const _component_el_button = ElButton;
      const _component_el_empty = ElEmpty;
      _push(`<div${ssrRenderAttrs(mergeProps({
        class: `mt-2 child-load ${unref(posts)?.edges?.length > 0 ? "child-load-success" : ""}`
      }, _attrs))}>`);
      if (unref(posts) === "" || unref(posts)?.edges?.length > 0) {
        _push(`<!--[-->`);
        _push(ssrRenderComponent(_component_masonry, {
          cols: 2,
          gutter: 0,
          key: 2,
          class: `grid grid-cols-2 gap-2`
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<!--[-->`);
              ssrRenderList(unref(posts)?.edges ?? 6, (item, i) => {
                _push2(`<div class="${ssrRenderClass(`border-1 flex flex-col text-sm justify-between rounded mt-2 transition-all duration-200 hover:shadow-md ${unref(posts)?.edges?.length > 0 ? "xyz-nested" : ""}`)}" style="${ssrRenderStyle(`--xyz-index:${i % 12};`)}"${_scopeId}><div${_scopeId}>`);
                _push2(ssrRenderComponent(_component_Blink, {
                  class: "p-2 flex flex-col gap-2",
                  to: `${item.node?.gqSlug}?type=preview`
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`<div class="flex items-center gap-2 justify-between"${_scopeId2}><div class="flex items-center gap-2"${_scopeId2}>`);
                      _push3(ssrRenderComponent(_component_el_avatar, {
                        size: 32,
                        shape: "square",
                        src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item.node?.author?.node?.avatar?.url),
                        class: "gq-gs"
                      }, null, _parent3, _scopeId2));
                      _push3(`<div class="flex-1 flex flex-col"${_scopeId2}><span class="text-sm gq-gs"${_scopeId2}>${ssrInterpolate(item.node?.author?.node?.name || "Placeholder author")}</span>`);
                      if (!unref(isCreator)) {
                        _push3(ssrRenderComponent(_component_TimeAgo, {
                          date: item?.node?.dateGmt,
                          class: "opacity-40 gq-gs text-xs"
                        }, null, _parent3, _scopeId2));
                      } else {
                        _push3(`<span class="opacity-40 gq-gs text-xs"${_scopeId2}>${ssrInterpolate(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).timeAgo(item?.node?.date))}</span>`);
                      }
                      _push3(`</div></div>`);
                      if (unref(isCreator)) {
                        _push3(`<div class="flex items-center gap-2"${_scopeId2}>`);
                        _push3(ssrRenderComponent(_component_el_button, {
                          circle: "",
                          text: "",
                          bg: "",
                          type: "primary",
                          size: "small",
                          class: "!m-0 gq-gs",
                          onClick: ($event) => deleteAction(item.node.databaseId)
                        }, {
                          default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                            if (_push4) {
                              _push4(`<i class="i-ph-trash"${_scopeId3}></i>`);
                            } else {
                              return [
                                createVNode("i", { class: "i-ph-trash" })
                              ];
                            }
                          }),
                          _: 2
                        }, _parent3, _scopeId2));
                        _push3(ssrRenderComponent(_component_el_button, {
                          circle: "",
                          text: "",
                          bg: "",
                          type: "primary",
                          size: "small",
                          class: "!m-0 gq-gs",
                          onClick: ($event) => handleEdit(item.node.databaseId)
                        }, {
                          default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                            if (_push4) {
                              _push4(`<i class="i-ph-pencil"${_scopeId3}></i>`);
                            } else {
                              return [
                                createVNode("i", { class: "i-ph-pencil" })
                              ];
                            }
                          }),
                          _: 2
                        }, _parent3, _scopeId2));
                        _push3(`</div>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`</div><div class="text-[13px] gq-gs"${_scopeId2}>${ssrInterpolate(item.node?.excerpt || "Placeholder a long excerpt text")}</div>`);
                    } else {
                      return [
                        createVNode("div", { class: "flex items-center gap-2 justify-between" }, [
                          createVNode("div", { class: "flex items-center gap-2" }, [
                            createVNode(_component_el_avatar, {
                              size: 32,
                              shape: "square",
                              src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item.node?.author?.node?.avatar?.url),
                              class: "gq-gs"
                            }, null, 8, ["src"]),
                            createVNode("div", { class: "flex-1 flex flex-col" }, [
                              createVNode("span", { class: "text-sm gq-gs" }, toDisplayString(item.node?.author?.node?.name || "Placeholder author"), 1),
                              !unref(isCreator) ? (openBlock(), createBlock(_component_TimeAgo, {
                                key: 0,
                                date: item?.node?.dateGmt,
                                class: "opacity-40 gq-gs text-xs"
                              }, null, 8, ["date"])) : (openBlock(), createBlock("span", {
                                key: 1,
                                class: "opacity-40 gq-gs text-xs"
                              }, toDisplayString(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).timeAgo(item?.node?.date)), 1))
                            ])
                          ]),
                          unref(isCreator) ? (openBlock(), createBlock("div", {
                            key: 0,
                            class: "flex items-center gap-2"
                          }, [
                            createVNode(_component_el_button, {
                              circle: "",
                              text: "",
                              bg: "",
                              type: "primary",
                              size: "small",
                              class: "!m-0 gq-gs",
                              onClick: withModifiers(($event) => deleteAction(item.node.databaseId), ["stop", "prevent"])
                            }, {
                              default: withCtx(() => [
                                createVNode("i", { class: "i-ph-trash" })
                              ]),
                              _: 1
                            }, 8, ["onClick"]),
                            createVNode(_component_el_button, {
                              circle: "",
                              text: "",
                              bg: "",
                              type: "primary",
                              size: "small",
                              class: "!m-0 gq-gs",
                              onClick: withModifiers(($event) => handleEdit(item.node.databaseId), ["stop", "prevent"])
                            }, {
                              default: withCtx(() => [
                                createVNode("i", { class: "i-ph-pencil" })
                              ]),
                              _: 1
                            }, 8, ["onClick"])
                          ])) : createCommentVNode("", true)
                        ]),
                        createVNode("div", { class: "text-[13px] gq-gs" }, toDisplayString(item.node?.excerpt || "Placeholder a long excerpt text"), 1)
                      ];
                    }
                  }),
                  _: 2
                }, _parent2, _scopeId));
                _push2(ssrRenderComponent(_component_Blink, {
                  class: "text-xs flex items-start gap-1 bg-[--el-color-info-light-10] p-2 border-t",
                  to: `${item.node?.gqParent?.gqSlug}?type=preview`
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(ssrRenderComponent(_component_el_avatar, {
                        size: 16,
                        src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(
                          item.node?.gqParent?.author?.node?.avatar?.url
                        ),
                        class: "gq-gs"
                      }, null, _parent3, _scopeId2));
                      _push3(`<span class="text-[--el-color-primary] gq-gs"${_scopeId2}>${ssrInterpolate(_ctx.$t("page.community.header.bounty"))}:</span><span class="flex-1 gq-gs line-clamp-1"${_scopeId2}>${ssrInterpolate(item.node?.gqParent?.title || "Placeholder title")}</span>`);
                      if (item.node?.status == "pending") {
                        _push3(`<span class="text-[--el-color-danger]"${_scopeId2}> [${ssrInterpolate(_ctx.$t("page.community.list.pending"))}] </span>`);
                      } else {
                        _push3(`<!---->`);
                      }
                    } else {
                      return [
                        createVNode(_component_el_avatar, {
                          size: 16,
                          src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(
                            item.node?.gqParent?.author?.node?.avatar?.url
                          ),
                          class: "gq-gs"
                        }, null, 8, ["src"]),
                        createVNode("span", { class: "text-[--el-color-primary] gq-gs" }, toDisplayString(_ctx.$t("page.community.header.bounty")) + ":", 1),
                        createVNode("span", { class: "flex-1 gq-gs line-clamp-1" }, toDisplayString(item.node?.gqParent?.title || "Placeholder title"), 1),
                        item.node?.status == "pending" ? (openBlock(), createBlock("span", {
                          key: 0,
                          class: "text-[--el-color-danger]"
                        }, " [" + toDisplayString(_ctx.$t("page.community.list.pending")) + "] ", 1)) : createCommentVNode("", true)
                      ];
                    }
                  }),
                  _: 2
                }, _parent2, _scopeId));
                _push2(`</div></div>`);
              });
              _push2(`<!--]-->`);
            } else {
              return [
                (openBlock(true), createBlock(Fragment, null, renderList(unref(posts)?.edges ?? 6, (item, i) => {
                  return openBlock(), createBlock("div", {
                    key: i,
                    class: `border-1 flex flex-col text-sm justify-between rounded mt-2 transition-all duration-200 hover:shadow-md ${unref(posts)?.edges?.length > 0 ? "xyz-nested" : ""}`,
                    style: `--xyz-index:${i % 12};`
                  }, [
                    createVNode("div", null, [
                      createVNode(_component_Blink, {
                        class: "p-2 flex flex-col gap-2",
                        to: `${item.node?.gqSlug}?type=preview`
                      }, {
                        default: withCtx(() => [
                          createVNode("div", { class: "flex items-center gap-2 justify-between" }, [
                            createVNode("div", { class: "flex items-center gap-2" }, [
                              createVNode(_component_el_avatar, {
                                size: 32,
                                shape: "square",
                                src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item.node?.author?.node?.avatar?.url),
                                class: "gq-gs"
                              }, null, 8, ["src"]),
                              createVNode("div", { class: "flex-1 flex flex-col" }, [
                                createVNode("span", { class: "text-sm gq-gs" }, toDisplayString(item.node?.author?.node?.name || "Placeholder author"), 1),
                                !unref(isCreator) ? (openBlock(), createBlock(_component_TimeAgo, {
                                  key: 0,
                                  date: item?.node?.dateGmt,
                                  class: "opacity-40 gq-gs text-xs"
                                }, null, 8, ["date"])) : (openBlock(), createBlock("span", {
                                  key: 1,
                                  class: "opacity-40 gq-gs text-xs"
                                }, toDisplayString(("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).timeAgo(item?.node?.date)), 1))
                              ])
                            ]),
                            unref(isCreator) ? (openBlock(), createBlock("div", {
                              key: 0,
                              class: "flex items-center gap-2"
                            }, [
                              createVNode(_component_el_button, {
                                circle: "",
                                text: "",
                                bg: "",
                                type: "primary",
                                size: "small",
                                class: "!m-0 gq-gs",
                                onClick: withModifiers(($event) => deleteAction(item.node.databaseId), ["stop", "prevent"])
                              }, {
                                default: withCtx(() => [
                                  createVNode("i", { class: "i-ph-trash" })
                                ]),
                                _: 1
                              }, 8, ["onClick"]),
                              createVNode(_component_el_button, {
                                circle: "",
                                text: "",
                                bg: "",
                                type: "primary",
                                size: "small",
                                class: "!m-0 gq-gs",
                                onClick: withModifiers(($event) => handleEdit(item.node.databaseId), ["stop", "prevent"])
                              }, {
                                default: withCtx(() => [
                                  createVNode("i", { class: "i-ph-pencil" })
                                ]),
                                _: 1
                              }, 8, ["onClick"])
                            ])) : createCommentVNode("", true)
                          ]),
                          createVNode("div", { class: "text-[13px] gq-gs" }, toDisplayString(item.node?.excerpt || "Placeholder a long excerpt text"), 1)
                        ]),
                        _: 2
                      }, 1032, ["to"]),
                      createVNode(_component_Blink, {
                        class: "text-xs flex items-start gap-1 bg-[--el-color-info-light-10] p-2 border-t",
                        to: `${item.node?.gqParent?.gqSlug}?type=preview`
                      }, {
                        default: withCtx(() => [
                          createVNode(_component_el_avatar, {
                            size: 16,
                            src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(
                              item.node?.gqParent?.author?.node?.avatar?.url
                            ),
                            class: "gq-gs"
                          }, null, 8, ["src"]),
                          createVNode("span", { class: "text-[--el-color-primary] gq-gs" }, toDisplayString(_ctx.$t("page.community.header.bounty")) + ":", 1),
                          createVNode("span", { class: "flex-1 gq-gs line-clamp-1" }, toDisplayString(item.node?.gqParent?.title || "Placeholder title"), 1),
                          item.node?.status == "pending" ? (openBlock(), createBlock("span", {
                            key: 0,
                            class: "text-[--el-color-danger]"
                          }, " [" + toDisplayString(_ctx.$t("page.community.list.pending")) + "] ", 1)) : createCommentVNode("", true)
                        ]),
                        _: 2
                      }, 1032, ["to"])
                    ])
                  ], 6);
                }), 128))
              ];
            }
          }),
          _: 1
        }, _parent));
        if (unref(posts)?.edges?.length) {
          _push(`<div class="flex justify-center gq-gs mt-4">`);
          _push(ssrRenderComponent(_component_el_button, {
            disabled: !unref(posts)?.pageInfo?.hasNextPage,
            class: "w-full",
            text: "",
            size: "large",
            loading: unref(locked),
            onClick: handleLoadMore
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                if (unref(posts)?.pageInfo?.hasNextPage) {
                  _push2(`<span class="gq-gs"${_scopeId}>${ssrInterpolate(_ctx.$t("page.modules.post.loadMoreButton"))}</span>`);
                } else {
                  _push2(`<span class="gq-gs"${_scopeId}>${ssrInterpolate(_ctx.$t("page.modules.post.noMore"))}</span>`);
                }
              } else {
                return [
                  unref(posts)?.pageInfo?.hasNextPage ? (openBlock(), createBlock("span", {
                    key: 0,
                    class: "gq-gs"
                  }, toDisplayString(_ctx.$t("page.modules.post.loadMoreButton")), 1)) : (openBlock(), createBlock("span", {
                    key: 1,
                    class: "gq-gs"
                  }, toDisplayString(_ctx.$t("page.modules.post.noMore")), 1))
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<!--]-->`);
      } else {
        _push(`<div class="p-2.5 text-center text-xs opacity-70">`);
        _push(ssrRenderComponent(_component_el_empty, {
          description: _ctx.$t("common.editor.library.empty")
        }, null, _parent));
        _push(`</div>`);
      }
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/profile/list/create/communityAnswers.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
