import { E as ElDialog } from './index-awVc4A7-.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { _ as __nuxt_component_4 } from './Image-BE6Y-a3S.mjs';
import _sfc_main$1 from './creditIcon-eOdkwofx.mjs';
import _sfc_main$2 from './popover-B8HtRMY4.mjs';
import _sfc_main$3 from './pay-BU3dx3V8.mjs';
import { j as actionStore, a as useI18n, v as viewerStore, d as useRoute, e as useUtils, r as useRequest, E as ElMessage, aM as getLoginData } from './server.mjs';
import { useSSRContext, ref, computed, watch, isRef, unref, withCtx, createVNode, openBlock, createBlock, Fragment, renderList, toDisplayString, createCommentVNode, createTextVNode, withModifiers } from 'vue';
import { ssrRenderComponent, ssrRenderClass, ssrInterpolate, ssrRenderList } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './use-dialog-7J0bwlna.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import 'lodash-unified';
import './aria-BhThsKez.mjs';
import './event-BZTOGHfp.mjs';
import '@vue/shared';
import './vnode-l2ZP2UQa.mjs';
import './index-Di0Jlzch.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './image-viewer-DG2qIWb8.mjs';
import './index-ChPMoinw.mjs';
import './index-BKB3Djp4.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './svgIcon-BpIUCf-e.mjs';

/* empty css                */
/* empty css                 */
const _sfc_main = {
  __name: "ModulesCommonTopicFormContentJoin",
  __ssrInlineRender: true,
  props: ["action", "termId"],
  emits: ["success"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const actionSt = actionStore();
    const props = __props;
    const { t, locale } = useI18n();
    const viewer = viewerStore();
    const route = useRoute();
    const emits = __emit;
    const term = ref(null);
    const showJoin = ref(false);
    const payRef = ref(null);
    const success = (type) => {
      term.value.communityCatMetas.isJoin = true;
      emits("success", "joinNode");
      ElMessage.success(t("page.community.joinNode.joinSuccess"));
      reload();
    };
    const payType = ref("permanent");
    const paychose = ref(null);
    const payPicked = computed(() => {
      return term.value?.communityCatMetas?.settings?.joinRole?.pay?.value[payType.value];
    });
    const locked = ref(false);
    const topicCanRole = () => {
      actionSt.levelTips.show = true;
      actionSt.levelTips.title = t("page.community.joinNode.topicCan");
      actionSt.levelTips.levels = term.value?.communityCatMetas?.settings.topicCan.levels;
      return;
    };
    const reload = () => {
      getLoginData(actionSt.pageData[route.path]);
    };
    const pay = () => {
      const type = term.value?.communityCatMetas?.settings?.joinRole?.pay.type;
      if (type == "credit" || type == "money") {
        payRef.value.state.show({
          title: t("page.profile.content.activity.actionType.joinNode") + ": " + term.value?.communityCatMetas.name[locale.value],
          thumb: term.value?.thumb?.sourceUrl || "",
          postId: term.value?.databaseId,
          args: {
            payType: payType.value,
            title: t("page.profile.content.activity.actionType.joinNode") + ": " + term.value?.communityCatMetas.name[locale.value]
          },
          count: term.value?.communityCatMetas.memberCount,
          type: "joinNode",
          payment: type,
          finalPrice: type == "credit" ? term.value?.communityCatMetas.settings.joinRole.pay.value[payType.value] : term.value?.communityCatMetas.settings.joinRole.pay.value[payType.value][actionSt.currency.iso],
          price: type == "credit" ? term.value?.communityCatMetas.settings.joinRole.pay.value[payType.value] : term.value?.communityCatMetas.settings.joinRole.pay.value[payType.value][actionSt.currency.iso]
        });
        return;
      }
    };
    const join = async () => {
      if (!term.value?.communityCatMetas.isJoin && term.value?.communityCatMetas.settings.joinRole.type == "money") {
        pay();
        return;
      }
      if (term.value?.communityCatMetas.settings.joinRole.type == "level" && !useUtils.hasIntersection(
        term.value?.communityCatMetas.settings.joinRole.level,
        [viewer.data.gqLevel, viewer.data.gqVIP]
      )) {
        actionSt.levelTips.show = true;
        actionSt.levelTips.title = t("page.community.joinNode.canJoin");
        actionSt.levelTips.levels = term.value?.communityCatMetas.settings.joinRole.level;
        return;
      }
      if (locked.value) return;
      locked.value = true;
      const res = await useRequest("/api/request", {
        body: {
          data: {
            nodeId: term.value?.databaseId
          }
        }
      });
      if (res?.gqCommunityJoin?.success) {
        showJoin.value = false;
        ElMessage.success(t("page.community.joinNode.joinSuccess"));
        reload();
      }
      locked.value = false;
    };
    const getTerm = async () => {
      const res = await useRequest("/api/request", {
        body: {
          data: {
            termId: props.termId
          }
        }
      });
      if (res.communityCat.communityCatMetas) {
        try {
          res.communityCat.communityCatMetas.name = JSON.parse(
            res.communityCat.communityCatMetas.name
          );
          res.communityCat.communityCatMetas.description = JSON.parse(
            res.communityCat.communityCatMetas.description
          );
          if (res.communityCat.communityCatMetas.settings?.joinRole?.pay?.value) {
            res.communityCat.communityCatMetas.settings.joinRole.pay.value = JSON.parse(
              res.communityCat.communityCatMetas.settings.joinRole.pay.value
            );
          }
        } catch (e) {
          console.log(e);
        }
        term.value = res.communityCat;
      }
    };
    watch(showJoin, async (newVal) => {
      if (newVal) {
        await getTerm();
      }
    });
    watch(
      () => actionSt.levelTips.show,
      async (newVal) => {
        if (newVal) {
          showJoin.value = false;
        }
      }
    );
    __expose({
      showJoin
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_dialog = ElDialog;
      const _component_el_button = ElButton;
      const _component_Image = __nuxt_component_4;
      const _component_CommonCreditIcon = _sfc_main$1;
      const _component_CommonPopover = _sfc_main$2;
      const _component_CommonPay = _sfc_main$3;
      _push(`<!--[-->`);
      _push(ssrRenderComponent(_component_el_dialog, {
        modelValue: unref(showJoin),
        "onUpdate:modelValue": ($event) => isRef(showJoin) ? showJoin.value = $event : null,
        width: "290px",
        "lock-scroll": false,
        "close-on-click-modal": false,
        "show-close": false,
        "append-to-body": "",
        class: "overflow-hidden join-dialog"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="${ssrRenderClass(`flex flex-col gap-3 child-load ${unref(term) ? "child-load-success" : ""}`)}" data-v-2f97be55${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_button, {
              text: "",
              type: "primary",
              size: "small",
              circle: "",
              bg: "",
              class: "absolute top-3 right-3 z-2",
              onClick: ($event) => showJoin.value = false
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<i class="i-ph-x" data-v-2f97be55${_scopeId2}></i>`);
                } else {
                  return [
                    createVNode("i", { class: "i-ph-x" })
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`<div class="flex gap-2" data-v-2f97be55${_scopeId}>`);
            _push2(ssrRenderComponent(_component_Image, {
              src: unref(term)?.thumb?.sourceUrl,
              class: "w-10 h-10 rounded"
            }, null, _parent2, _scopeId));
            _push2(`<div class="flex flex-col g w-full flex-1" data-v-2f97be55${_scopeId}><span class="text-sm font-600 gq-gs w-fit" data-v-2f97be55${_scopeId}>${(unref(term)?.communityCatMetas?.name ? unref(term)?.communityCatMetas?.name?.[_ctx.$i18n.locale] : unref(term)?.name || "Community node name") ?? ""}</span><div class="flex items-center text-xs w-full flex-1 gq-gs w-fit" data-v-2f97be55${_scopeId}><div class="opacity-70 flex-1 line-clamp-1" data-v-2f97be55${_scopeId}>`);
            if (unref(term)?.communityCatMetas?.admin?.length > 1) {
              _push2(`<div class="flex-inline flex-wrap" data-v-2f97be55${_scopeId}>${_ctx.$t("page.community.header.moreAdmin", [
                "<span class='max-w-8 line-clamp-1 overflow-hidden h-4'>" + unref(term)?.communityCatMetas?.admin?.[0]?.name + "</span>",
                unref(term)?.communityCatMetas?.admin?.length
              ]) ?? ""}</div>`);
            } else {
              _push2(`<span data-v-2f97be55${_scopeId}>${unref(term)?.communityCatMetas?.admin?.[0]?.name + _ctx.$t("page.community.header.admin")}</span>`);
            }
            _push2(`</div></div></div></div>`);
            if (!unref(term)) {
              _push2(`<div class="gq-gs h-40" data-v-2f97be55${_scopeId}></div>`);
            } else if (!unref(term)?.communityCatMetas?.isJoin) {
              _push2(`<div class="h-40 flex flex-col items-center justify-center border-1 bg-[--el-color-info-light-10] rounded p-3" data-v-2f97be55${_scopeId}>`);
              if (unref(term).communityCatMetas?.settings?.joinRole?.type == "free") {
                _push2(`<div class="flex flex-col items-center gap-2" data-v-2f97be55${_scopeId}><div class="text-xs opacity-70 mb-1" data-v-2f97be55${_scopeId}>免费节点</div><div class="text-xs" data-v-2f97be55${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.joinNode.desc.free"))}</div></div>`);
              } else if (unref(term).communityCatMetas?.settings?.joinRole?.type == "money") {
                _push2(`<div class="node-join w-full flex items-center gap-1 flex-col" data-v-2f97be55${_scopeId}><div class="text-xs opacity-70 mb-1" data-v-2f97be55${_scopeId}>付费节点</div>`);
                if (unref(term).communityCatMetas?.settings?.joinRole?.pay.type == "money" && unref(payPicked)[unref(actionSt).currency.iso] > 0 || unref(term).communityCatMetas?.settings?.joinRole?.pay.type == "credit" && unref(payPicked) > 0) {
                  _push2(`<div class="px-4 py-2 text-xs pay-bg w-36 border-1 relative rounded flex items-center cursor-pointer hover:bg-[--el-color-primary-light-9] bg-[--el-bg-color-overlay] transition-colors duration-200" data-v-2f97be55${_scopeId}><span class="absolute right-2 top-2 flex" data-v-2f97be55${_scopeId}><i class="i-ph-caret-up-down-fill text-[--el-color-primary]" data-v-2f97be55${_scopeId}></i></span><div class="flex flex-col" data-v-2f97be55${_scopeId}><div class="flex items-center @md:text-sm text-xs" data-v-2f97be55${_scopeId}>`);
                  if (unref(term).communityCatMetas?.settings?.joinRole?.pay?.type == "money") {
                    _push2(`<span data-v-2f97be55${_scopeId}>${ssrInterpolate(unref(actionSt).currency.symbol)}</span>`);
                  } else {
                    _push2(ssrRenderComponent(_component_CommonCreditIcon, { class: "!w-3 !h-3" }, null, _parent2, _scopeId));
                  }
                  if (unref(term).communityCatMetas?.settings?.joinRole?.pay?.type == "credit") {
                    _push2(`<span data-v-2f97be55${_scopeId}>${ssrInterpolate(unref(payPicked))}</span>`);
                  } else {
                    _push2(`<span data-v-2f97be55${_scopeId}>${ssrInterpolate(unref(payPicked)[unref(actionSt).currency.iso])}</span>`);
                  }
                  _push2(`</div><span class="opacity-50" data-v-2f97be55${_scopeId}>/${ssrInterpolate(_ctx.$t("page.community.joinNode.pay." + unref(payType)))}</span></div></div>`);
                } else {
                  _push2(`<!---->`);
                }
                _push2(ssrRenderComponent(_component_CommonPopover, {
                  button: unref(paychose),
                  width: 120
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`<div class="flex w-full flex-col flex-wrap gap-1" data-v-2f97be55${_scopeId2}><!--[-->`);
                      ssrRenderList(unref(term).communityCatMetas?.settings?.joinRole?.pay?.value, (item, key, index) => {
                        _push3(`<div data-v-2f97be55${_scopeId2}>`);
                        if (unref(term).communityCatMetas?.settings?.joinRole?.pay.type == "money" && unref(term).communityCatMetas?.settings?.joinRole?.pay?.value[key][unref(actionSt).currency.iso] > 0 || unref(term).communityCatMetas?.settings?.joinRole?.pay.type == "credit" && unref(term).communityCatMetas?.settings?.joinRole?.pay?.value[key] > 0) {
                          _push3(`<div class="${ssrRenderClass(`px-4 py-1 
                text-xs 
                w-full
                border-1 relative rounded
                flex items-center 
                cursor-pointer 
                hover:bg-[--el-color-primary-light-9] 
                bg-[--el-bg-color] transition-colors 
                duration-200 ${unref(payType) == key ? "border-[--el-color-primary]" : ""}`)}" data-v-2f97be55${_scopeId2}><span class="absolute right-1 top-1 flex" data-v-2f97be55${_scopeId2}>`);
                          if (unref(payType) != key) {
                            _push3(`<i class="i-ph-circle" data-v-2f97be55${_scopeId2}></i>`);
                          } else {
                            _push3(`<i class="i-ph-radio-button-fill text-[--el-color-primary]" data-v-2f97be55${_scopeId2}></i>`);
                          }
                          _push3(`</span><div class="flex flex-col" data-v-2f97be55${_scopeId2}><div class="flex items-center text-sm" data-v-2f97be55${_scopeId2}>`);
                          if (unref(term).communityCatMetas?.settings?.joinRole?.pay?.type == "money") {
                            _push3(`<span data-v-2f97be55${_scopeId2}>${ssrInterpolate(unref(actionSt).currency.symbol)}</span>`);
                          } else {
                            _push3(ssrRenderComponent(_component_CommonCreditIcon, { class: "w-3 h-3" }, null, _parent3, _scopeId2));
                          }
                          if (unref(term).communityCatMetas?.settings?.joinRole?.pay?.type == "credit") {
                            _push3(`<span data-v-2f97be55${_scopeId2}>${ssrInterpolate(unref(term).communityCatMetas?.settings?.joinRole?.pay?.value[key])}</span>`);
                          } else {
                            _push3(`<span data-v-2f97be55${_scopeId2}>${ssrInterpolate(unref(term).communityCatMetas?.settings?.joinRole?.pay?.value[key][unref(actionSt).currency.iso])}</span>`);
                          }
                          _push3(`</div><span class="opacity-70" data-v-2f97be55${_scopeId2}>/${ssrInterpolate(_ctx.$t("page.community.joinNode.pay." + key))}</span></div></div>`);
                        } else {
                          _push3(`<!---->`);
                        }
                        _push3(`</div>`);
                      });
                      _push3(`<!--]--></div>`);
                    } else {
                      return [
                        createVNode("div", { class: "flex w-full flex-col flex-wrap gap-1" }, [
                          (openBlock(true), createBlock(Fragment, null, renderList(unref(term).communityCatMetas?.settings?.joinRole?.pay?.value, (item, key, index) => {
                            return openBlock(), createBlock("div", { key: index }, [
                              unref(term).communityCatMetas?.settings?.joinRole?.pay.type == "money" && unref(term).communityCatMetas?.settings?.joinRole?.pay?.value[key][unref(actionSt).currency.iso] > 0 || unref(term).communityCatMetas?.settings?.joinRole?.pay.type == "credit" && unref(term).communityCatMetas?.settings?.joinRole?.pay?.value[key] > 0 ? (openBlock(), createBlock("div", {
                                key: 0,
                                class: `px-4 py-1 
                text-xs 
                w-full
                border-1 relative rounded
                flex items-center 
                cursor-pointer 
                hover:bg-[--el-color-primary-light-9] 
                bg-[--el-bg-color] transition-colors 
                duration-200 ${unref(payType) == key ? "border-[--el-color-primary]" : ""}`,
                                onClick: ($event) => payType.value = key
                              }, [
                                createVNode("span", { class: "absolute right-1 top-1 flex" }, [
                                  unref(payType) != key ? (openBlock(), createBlock("i", {
                                    key: 0,
                                    class: "i-ph-circle"
                                  })) : (openBlock(), createBlock("i", {
                                    key: 1,
                                    class: "i-ph-radio-button-fill text-[--el-color-primary]"
                                  }))
                                ]),
                                createVNode("div", { class: "flex flex-col" }, [
                                  createVNode("div", { class: "flex items-center text-sm" }, [
                                    unref(term).communityCatMetas?.settings?.joinRole?.pay?.type == "money" ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(unref(actionSt).currency.symbol), 1)) : (openBlock(), createBlock(_component_CommonCreditIcon, {
                                      key: 1,
                                      class: "w-3 h-3"
                                    })),
                                    unref(term).communityCatMetas?.settings?.joinRole?.pay?.type == "credit" ? (openBlock(), createBlock("span", { key: 2 }, toDisplayString(unref(term).communityCatMetas?.settings?.joinRole?.pay?.value[key]), 1)) : (openBlock(), createBlock("span", { key: 3 }, toDisplayString(unref(term).communityCatMetas?.settings?.joinRole?.pay?.value[key][unref(actionSt).currency.iso]), 1))
                                  ]),
                                  createVNode("span", { class: "opacity-70" }, "/" + toDisplayString(_ctx.$t("page.community.joinNode.pay." + key)), 1)
                                ])
                              ], 10, ["onClick"])) : createCommentVNode("", true)
                            ]);
                          }), 128))
                        ])
                      ];
                    }
                  }),
                  _: 1
                }, _parent2, _scopeId));
                _push2(`</div>`);
              } else if (unref(term).communityCatMetas?.settings?.joinRole?.type == "level") {
                _push2(`<div class="text-xs node-join flex items-center gap-1 flex-col" data-v-2f97be55${_scopeId}><div class="opacity-70 mb-1" data-v-2f97be55${_scopeId}>专属节点</div>`);
                if (!("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).hasIntersection(
                  unref(term).communityCatMetas?.settings?.joinRole?.level,
                  [unref(viewer).data.gqLevel, unref(viewer).data.gqVIP]
                )) {
                  _push2(`<div class="" data-v-2f97be55${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.joinNode.desc.levelAllow"))}</div>`);
                } else {
                  _push2(`<div data-v-2f97be55${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.joinNode.desc.levelDisallow"))}</div>`);
                }
                _push2(`</div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(ssrRenderComponent(_component_el_button, {
                type: "primary",
                size: "small",
                class: "mt-4",
                plain: "",
                onClick: join,
                loading: unref(locked)
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(` 🎉 `);
                    if (unref(term).communityCatMetas?.settings?.joinRole?.type == "level" && !("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).hasIntersection(
                      unref(term).communityCatMetas?.settings?.joinRole?.level,
                      [unref(viewer).data.gqLevel, unref(viewer).data.gqVIP]
                    )) {
                      _push3(`<span data-v-2f97be55${_scopeId2}>${ssrInterpolate(_ctx.$t("page.community.joinNode.desc.access"))}</span>`);
                    } else {
                      _push3(`<span data-v-2f97be55${_scopeId2}>${ssrInterpolate(_ctx.$t("page.community.joinNode.desc.joinNode"))}</span>`);
                    }
                  } else {
                    return [
                      createTextVNode(" 🎉 "),
                      unref(term).communityCatMetas?.settings?.joinRole?.type == "level" && !("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).hasIntersection(
                        unref(term).communityCatMetas?.settings?.joinRole?.level,
                        [unref(viewer).data.gqLevel, unref(viewer).data.gqVIP]
                      ) ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("page.community.joinNode.desc.access")), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("page.community.joinNode.desc.joinNode")), 1))
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div>`);
            } else if (!unref(term)?.communityCatMetas?.settings?.topicCan?.can) {
              _push2(`<div class="flex flex-col items-center gap-2" data-v-2f97be55${_scopeId}><div class="flex flex-col items-center gap-2" data-v-2f97be55${_scopeId}><div class="text-xs mb-1 text-[--el-color-success-dark-2]" data-v-2f97be55${_scopeId}> 已加入此节点 </div><div class="text-xs text-[--el-color-danger]" data-v-2f97be55${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.joinNode.canTopic.desc"))}</div></div>`);
              _push2(ssrRenderComponent(_component_el_button, {
                type: "primary",
                size: "small",
                class: "mt-4",
                plain: "",
                onClick: topicCanRole
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(`<span data-v-2f97be55${_scopeId2}>${ssrInterpolate(_ctx.$t("page.community.joinNode.desc.access"))}</span>`);
                  } else {
                    return [
                      createVNode("span", null, toDisplayString(_ctx.$t("page.community.joinNode.desc.access")), 1)
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
              _push2(`</div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div>`);
          } else {
            return [
              createVNode("div", {
                class: `flex flex-col gap-3 child-load ${unref(term) ? "child-load-success" : ""}`
              }, [
                createVNode(_component_el_button, {
                  text: "",
                  type: "primary",
                  size: "small",
                  circle: "",
                  bg: "",
                  class: "absolute top-3 right-3 z-2",
                  onClick: withModifiers(($event) => showJoin.value = false, ["stop"])
                }, {
                  default: withCtx(() => [
                    createVNode("i", { class: "i-ph-x" })
                  ]),
                  _: 1
                }, 8, ["onClick"]),
                createVNode("div", { class: "flex gap-2" }, [
                  createVNode(_component_Image, {
                    src: unref(term)?.thumb?.sourceUrl,
                    class: "w-10 h-10 rounded"
                  }, null, 8, ["src"]),
                  createVNode("div", { class: "flex flex-col g w-full flex-1" }, [
                    createVNode("span", {
                      class: "text-sm font-600 gq-gs w-fit",
                      innerHTML: unref(term)?.communityCatMetas?.name ? unref(term)?.communityCatMetas?.name?.[_ctx.$i18n.locale] : unref(term)?.name || "Community node name"
                    }, null, 8, ["innerHTML"]),
                    createVNode("div", { class: "flex items-center text-xs w-full flex-1 gq-gs w-fit" }, [
                      createVNode("div", { class: "opacity-70 flex-1 line-clamp-1" }, [
                        unref(term)?.communityCatMetas?.admin?.length > 1 ? (openBlock(), createBlock("div", {
                          key: 0,
                          class: "flex-inline flex-wrap",
                          innerHTML: _ctx.$t("page.community.header.moreAdmin", [
                            "<span class='max-w-8 line-clamp-1 overflow-hidden h-4'>" + unref(term)?.communityCatMetas?.admin?.[0]?.name + "</span>",
                            unref(term)?.communityCatMetas?.admin?.length
                          ])
                        }, null, 8, ["innerHTML"])) : (openBlock(), createBlock("span", {
                          key: 1,
                          innerHTML: unref(term)?.communityCatMetas?.admin?.[0]?.name + _ctx.$t("page.community.header.admin")
                        }, null, 8, ["innerHTML"]))
                      ])
                    ])
                  ])
                ]),
                !unref(term) ? (openBlock(), createBlock("div", {
                  key: 0,
                  class: "gq-gs h-40"
                })) : !unref(term)?.communityCatMetas?.isJoin ? (openBlock(), createBlock("div", {
                  key: 1,
                  class: "h-40 flex flex-col items-center justify-center border-1 bg-[--el-color-info-light-10] rounded p-3"
                }, [
                  unref(term).communityCatMetas?.settings?.joinRole?.type == "free" ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "flex flex-col items-center gap-2"
                  }, [
                    createVNode("div", { class: "text-xs opacity-70 mb-1" }, "免费节点"),
                    createVNode("div", { class: "text-xs" }, toDisplayString(_ctx.$t("page.community.joinNode.desc.free")), 1)
                  ])) : unref(term).communityCatMetas?.settings?.joinRole?.type == "money" ? (openBlock(), createBlock("div", {
                    key: 1,
                    class: "node-join w-full flex items-center gap-1 flex-col"
                  }, [
                    createVNode("div", { class: "text-xs opacity-70 mb-1" }, "付费节点"),
                    unref(term).communityCatMetas?.settings?.joinRole?.pay.type == "money" && unref(payPicked)[unref(actionSt).currency.iso] > 0 || unref(term).communityCatMetas?.settings?.joinRole?.pay.type == "credit" && unref(payPicked) > 0 ? (openBlock(), createBlock("div", {
                      key: 0,
                      ref_key: "paychose",
                      ref: paychose,
                      class: "px-4 py-2 text-xs pay-bg w-36 border-1 relative rounded flex items-center cursor-pointer hover:bg-[--el-color-primary-light-9] bg-[--el-bg-color-overlay] transition-colors duration-200"
                    }, [
                      createVNode("span", { class: "absolute right-2 top-2 flex" }, [
                        createVNode("i", { class: "i-ph-caret-up-down-fill text-[--el-color-primary]" })
                      ]),
                      createVNode("div", { class: "flex flex-col" }, [
                        createVNode("div", { class: "flex items-center @md:text-sm text-xs" }, [
                          unref(term).communityCatMetas?.settings?.joinRole?.pay?.type == "money" ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(unref(actionSt).currency.symbol), 1)) : (openBlock(), createBlock(_component_CommonCreditIcon, {
                            key: 1,
                            class: "!w-3 !h-3"
                          })),
                          unref(term).communityCatMetas?.settings?.joinRole?.pay?.type == "credit" ? (openBlock(), createBlock("span", { key: 2 }, toDisplayString(unref(payPicked)), 1)) : (openBlock(), createBlock("span", { key: 3 }, toDisplayString(unref(payPicked)[unref(actionSt).currency.iso]), 1))
                        ]),
                        createVNode("span", { class: "opacity-50" }, "/" + toDisplayString(_ctx.$t("page.community.joinNode.pay." + unref(payType))), 1)
                      ])
                    ], 512)) : createCommentVNode("", true),
                    createVNode(_component_CommonPopover, {
                      button: unref(paychose),
                      width: 120
                    }, {
                      default: withCtx(() => [
                        createVNode("div", { class: "flex w-full flex-col flex-wrap gap-1" }, [
                          (openBlock(true), createBlock(Fragment, null, renderList(unref(term).communityCatMetas?.settings?.joinRole?.pay?.value, (item, key, index) => {
                            return openBlock(), createBlock("div", { key: index }, [
                              unref(term).communityCatMetas?.settings?.joinRole?.pay.type == "money" && unref(term).communityCatMetas?.settings?.joinRole?.pay?.value[key][unref(actionSt).currency.iso] > 0 || unref(term).communityCatMetas?.settings?.joinRole?.pay.type == "credit" && unref(term).communityCatMetas?.settings?.joinRole?.pay?.value[key] > 0 ? (openBlock(), createBlock("div", {
                                key: 0,
                                class: `px-4 py-1 
                text-xs 
                w-full
                border-1 relative rounded
                flex items-center 
                cursor-pointer 
                hover:bg-[--el-color-primary-light-9] 
                bg-[--el-bg-color] transition-colors 
                duration-200 ${unref(payType) == key ? "border-[--el-color-primary]" : ""}`,
                                onClick: ($event) => payType.value = key
                              }, [
                                createVNode("span", { class: "absolute right-1 top-1 flex" }, [
                                  unref(payType) != key ? (openBlock(), createBlock("i", {
                                    key: 0,
                                    class: "i-ph-circle"
                                  })) : (openBlock(), createBlock("i", {
                                    key: 1,
                                    class: "i-ph-radio-button-fill text-[--el-color-primary]"
                                  }))
                                ]),
                                createVNode("div", { class: "flex flex-col" }, [
                                  createVNode("div", { class: "flex items-center text-sm" }, [
                                    unref(term).communityCatMetas?.settings?.joinRole?.pay?.type == "money" ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(unref(actionSt).currency.symbol), 1)) : (openBlock(), createBlock(_component_CommonCreditIcon, {
                                      key: 1,
                                      class: "w-3 h-3"
                                    })),
                                    unref(term).communityCatMetas?.settings?.joinRole?.pay?.type == "credit" ? (openBlock(), createBlock("span", { key: 2 }, toDisplayString(unref(term).communityCatMetas?.settings?.joinRole?.pay?.value[key]), 1)) : (openBlock(), createBlock("span", { key: 3 }, toDisplayString(unref(term).communityCatMetas?.settings?.joinRole?.pay?.value[key][unref(actionSt).currency.iso]), 1))
                                  ]),
                                  createVNode("span", { class: "opacity-70" }, "/" + toDisplayString(_ctx.$t("page.community.joinNode.pay." + key)), 1)
                                ])
                              ], 10, ["onClick"])) : createCommentVNode("", true)
                            ]);
                          }), 128))
                        ])
                      ]),
                      _: 1
                    }, 8, ["button"])
                  ])) : unref(term).communityCatMetas?.settings?.joinRole?.type == "level" ? (openBlock(), createBlock("div", {
                    key: 2,
                    class: "text-xs node-join flex items-center gap-1 flex-col"
                  }, [
                    createVNode("div", { class: "opacity-70 mb-1" }, "专属节点"),
                    !("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).hasIntersection(
                      unref(term).communityCatMetas?.settings?.joinRole?.level,
                      [unref(viewer).data.gqLevel, unref(viewer).data.gqVIP]
                    ) ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: ""
                    }, toDisplayString(_ctx.$t("page.community.joinNode.desc.levelAllow")), 1)) : (openBlock(), createBlock("div", { key: 1 }, toDisplayString(_ctx.$t("page.community.joinNode.desc.levelDisallow")), 1))
                  ])) : createCommentVNode("", true),
                  createVNode(_component_el_button, {
                    type: "primary",
                    size: "small",
                    class: "mt-4",
                    plain: "",
                    onClick: join,
                    loading: unref(locked)
                  }, {
                    default: withCtx(() => [
                      createTextVNode(" 🎉 "),
                      unref(term).communityCatMetas?.settings?.joinRole?.type == "level" && !("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).hasIntersection(
                        unref(term).communityCatMetas?.settings?.joinRole?.level,
                        [unref(viewer).data.gqLevel, unref(viewer).data.gqVIP]
                      ) ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("page.community.joinNode.desc.access")), 1)) : (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("page.community.joinNode.desc.joinNode")), 1))
                    ]),
                    _: 1
                  }, 8, ["loading"])
                ])) : !unref(term)?.communityCatMetas?.settings?.topicCan?.can ? (openBlock(), createBlock("div", {
                  key: 2,
                  class: "flex flex-col items-center gap-2"
                }, [
                  createVNode("div", { class: "flex flex-col items-center gap-2" }, [
                    createVNode("div", { class: "text-xs mb-1 text-[--el-color-success-dark-2]" }, " 已加入此节点 "),
                    createVNode("div", { class: "text-xs text-[--el-color-danger]" }, toDisplayString(_ctx.$t("page.community.joinNode.canTopic.desc")), 1)
                  ]),
                  createVNode(_component_el_button, {
                    type: "primary",
                    size: "small",
                    class: "mt-4",
                    plain: "",
                    onClick: topicCanRole
                  }, {
                    default: withCtx(() => [
                      createVNode("span", null, toDisplayString(_ctx.$t("page.community.joinNode.desc.access")), 1)
                    ]),
                    _: 1
                  })
                ])) : createCommentVNode("", true)
              ], 2)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_CommonPay, {
        ref_key: "payRef",
        ref: payRef,
        onSuccess: success
      }, null, _parent));
      _push(`<!--]-->`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/form/contentJoin.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const contentJoin = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-2f97be55"]]);

export { contentJoin as default };
