import _sfc_main$1 from './popover-B8HtRMY4.mjs';
import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import { a as useI18n, j as actionStore } from './server.mjs';
import { ref, reactive, watch, computed, mergeProps, unref, withCtx, openBlock, createBlock, Fragment, renderList, createVNode, toDisplayString, createTextVNode, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrRenderList } from 'vue/server-renderer';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import './index-ChPMoinw.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonFormCountryDialCodes",
  __ssrInlineRender: true,
  emits: ["update:modelValue"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const { locale } = useI18n();
    const codeSelect = ref(null);
    const action = actionStore();
    const countryDialCodes = reactive({
      data: [],
      countrys: computed(() => action.countrysData?.[locale.value] ?? []),
      picked: "",
      default: {
        "zh-hans": ["中国", "+86"],
        en: ["United States", "+1"],
        es: ["España", "+34"]
      },
      initialize() {
        watch(
          locale,
          (newValue, oldValue) => {
            countryDialCodes.picked = countryDialCodes.default[newValue] || "";
          },
          {
            immediate: true
          }
        );
      }
    });
    const emit = __emit;
    watch(
      () => countryDialCodes.picked,
      (value) => {
        emit("update:modelValue", value[1]);
      }
    );
    __expose({
      countryDialCodes
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_CommonPopover = _sfc_main$1;
      const _component_el_scrollbar = ElScrollbar;
      _push(`<div${ssrRenderAttrs(mergeProps({
        ref_key: "codeSelect",
        ref: codeSelect,
        class: "cursor-pointer flex items-center text-[--el-text-color-primary] text-sm h-full"
      }, _attrs))}><span>${ssrInterpolate(unref(countryDialCodes).picked?.[1])}</span><i class="i-ph-caret-up-down ml-2 h-4 w-4 opacity-50"></i>`);
      _push(ssrRenderComponent(_component_CommonPopover, {
        button: unref(codeSelect),
        width: 200,
        trigger: "click",
        style: `--el-popover-padding:0`,
        offset: 15
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_el_scrollbar, {
              height: "400px",
              class: "py-2"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<!--[-->`);
                  ssrRenderList(unref(countryDialCodes).countrys, (item, i) => {
                    _push3(`<div class="p-2 px-4 text-sm cursor-pointer hover:bg-[var(--el-color-info-light-10)] flex"${_scopeId2}><span class="mr-2 line-clamp-1 flex-1"${_scopeId2}>${ssrInterpolate(item[0])}</span> ${ssrInterpolate(item[1])}</div>`);
                  });
                  _push3(`<!--]-->`);
                } else {
                  return [
                    (openBlock(true), createBlock(Fragment, null, renderList(unref(countryDialCodes).countrys, (item, i) => {
                      return openBlock(), createBlock("div", {
                        class: "p-2 px-4 text-sm cursor-pointer hover:bg-[var(--el-color-info-light-10)] flex",
                        key: i,
                        onClick: ($event) => unref(countryDialCodes).picked = item
                      }, [
                        createVNode("span", { class: "mr-2 line-clamp-1 flex-1" }, toDisplayString(item[0]), 1),
                        createTextVNode(" " + toDisplayString(item[1]), 1)
                      ], 8, ["onClick"]);
                    }), 128))
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              createVNode(_component_el_scrollbar, {
                height: "400px",
                class: "py-2"
              }, {
                default: withCtx(() => [
                  (openBlock(true), createBlock(Fragment, null, renderList(unref(countryDialCodes).countrys, (item, i) => {
                    return openBlock(), createBlock("div", {
                      class: "p-2 px-4 text-sm cursor-pointer hover:bg-[var(--el-color-info-light-10)] flex",
                      key: i,
                      onClick: ($event) => unref(countryDialCodes).picked = item
                    }, [
                      createVNode("span", { class: "mr-2 line-clamp-1 flex-1" }, toDisplayString(item[0]), 1),
                      createTextVNode(" " + toDisplayString(item[1]), 1)
                    ], 8, ["onClick"]);
                  }), 128))
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/form/countryDialCodes.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
