import { a as useI18n, j as actionStore, r as useRequest, E as ElMessage, x as __nuxt_component_0$1 } from './server.mjs';
import { useSSRContext, computed, reactive, watch } from 'vue';
import { ssrRenderComponent } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonFormCouponInfo",
  __ssrInlineRender: true,
  setup(__props) {
    const data = computed(() => {
      return action.coupon.data;
    });
    const { t } = useI18n();
    const action = actionStore();
    const state = reactive({
      pushLocked: false,
      copyCode: () => {
        (void 0).clipboard.writeText(data.value.code);
        ElMessage.success(t("common.edit.copied"));
      },
      close: () => {
        action.coupon.visible = false;
      },
      pushCoupon: async () => {
        if (state.pushLocked) {
          return;
        }
        action.coupon.pushSuccess = false;
        state.pushLocked = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              couponCode: data.value.code,
              toUserId: action.coupon.to.databaseId
            }
          }
        });
        if (res?.guaqi?.account?.coupon?.push) {
          ElMessage.success(t("common.coupon.pushSuccess"));
          action.coupon.pushSuccess = data.value.type;
          state.close();
        }
        state.pushLocked = false;
      }
    });
    watch(
      () => action.coupon.visible,
      (val) => {
        if (!val) {
          action.coupon.push = false;
        }
      }
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(ssrRenderComponent(_component_ClientOnly, _attrs, {}, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/form/couponInfo.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const couponInfo = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-8b15e0a8"]]);

export { couponInfo as default };
