import { j as actionStore, r as useRequest, x as __nuxt_component_0$1 } from './server.mjs';
import { reactive, watch, useSSRContext } from 'vue';
import { ssrRenderComponent } from 'vue/server-renderer';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonFormCouponSelect",
  __ssrInlineRender: true,
  props: ["action", "args", "description", "title"],
  emits: ["picked", "cancel"],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const action = actionStore();
    const emit = __emit;
    const state = reactive({
      coupons: null,
      locked: false,
      showCoupon: false,
      pickCoupon: null,
      pickedCoupon: (index, coupon) => {
        state.pickCoupon = index;
        state.showCoupon = false;
        emit("picked", coupon);
      },
      cancel: () => {
        state.pickCoupon = null;
        state.showCoupon = false;
        emit("cancel");
      },
      show: () => {
        if (!state.showCoupon && !state.coupons) {
          state.getCoupons();
        }
        state.showCoupon = !state.showCoupon;
      },
      getCoupons: async () => {
        if (state.locked) {
          return;
        }
        state.locked = true;
        let data = {
          after: state.coupons?.pageInfo?.endCursor,
          first: 16
        };
        if (Object.keys(props.args).length > 0) {
          data = {
            ...props.args,
            ...data
          };
        }
        const res = await useRequest("/api/request", {
          body: {
            action: props.action
          }
        });
        if (res?.guaqi?.utils?.getPostCoupons || res?.guaqi?.account?.coupon?.canPushList) {
          if (!state.coupons) {
            state.coupons = res.guaqi.utils?.getPostCoupons || res.guaqi?.account?.coupon?.canPushList;
          } else {
            state.coupons.edges.push(
              ...res.guaqi.utils?.getPostCoupons?.edges || res.guaqi?.account?.coupon?.canPushList?.edges
            );
            state.coupons.pageInfo = res.guaqi.utils?.getPostCoupons?.pageInfo || res.guaqi?.account?.coupon?.canPushList?.pageInfo;
          }
        }
        state.locked = false;
      },
      loadMore: async () => {
        state.getCoupons();
      }
    });
    watch(() => action.currency.iso, (val) => {
      state.coupons = null;
      emit("cancel");
      state.getCoupons();
    });
    __expose({
      state
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(ssrRenderComponent(_component_ClientOnly, _attrs, {}, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/form/couponSelect.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
