import { E as ElButton } from './index-DYnTqrQe.mjs';
import { d as useRoute, f as useRouter, l as loadComponent } from './server.mjs';
import { computed, mergeProps, unref, withCtx, createTextVNode, toDisplayString, createVNode, resolveDynamicComponent, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderList, ssrRenderComponent, ssrInterpolate, ssrRenderVNode } from 'vue/server-renderer';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesProfileListCreate",
  __ssrInlineRender: true,
  setup(__props) {
    const types = ["post", "community", "comment", "communityAnswers"];
    const route = useRoute();
    const router = useRouter();
    const subTab = computed(() => {
      return route.query.subTab || "post";
    });
    const removeSubtab = () => {
      if ("subTab" in route.query) {
        const newQuery = { ...route.query };
        delete newQuery.subTab;
        router.push({ query: newQuery });
      }
    };
    const handleClick = (type) => {
      if (type == "post") {
        removeSubtab();
      } else {
        const newQuery = { ...route.query };
        newQuery.subTab = type;
        router.push({
          query: newQuery
        });
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      _push(`<div${ssrRenderAttrs(mergeProps({ id: "create" }, _attrs))}><div class="border-b -mr-[--tpr] -ml-[--tpl] pr-[--tpr] pl-[--tpl] py-1.5 bg-gradient-to-br from-[--el-color-info-light-10] to-[--el-color-info-light-10] border-t"><!--[-->`);
      ssrRenderList(types, (item) => {
        _push(ssrRenderComponent(_component_el_button, {
          bg: "",
          text: "",
          size: "small",
          class: ["!font-600", unref(subTab) == item ? "!bg-[--el-fill-color-dark]" : ""],
          key: item,
          onClick: ($event) => handleClick(item)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(_ctx.$t("page.profile.content.create.types." + item))}`);
            } else {
              return [
                createTextVNode(toDisplayString(_ctx.$t("page.profile.content.create.types." + item)), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
      });
      _push(`<!--]--></div>`);
      ssrRenderVNode(_push, createVNode(resolveDynamicComponent(("loadComponent" in _ctx ? _ctx.loadComponent : unref(loadComponent))("modules/profile/list/create", unref(subTab))), null, null), _parent);
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/profile/list/create.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
