import { E as ElButton } from './index-DYnTqrQe.mjs';
import { j as actionStore, d as useRoute, k as deviceStore, v as viewerStore, a as useI18n, u as useHead, e as useUtils, t as useThrottleFn, w as isLogin, _ as __nuxt_component_0$2, x as __nuxt_component_0$1, r as useRequest } from './server.mjs';
import _sfc_main$1 from './header-CJLIRmLU.mjs';
import _sfc_main$2 from './blink-DRvWMg-X.mjs';
import { _ as __nuxt_component_4 } from './Image-BE6Y-a3S.mjs';
import { E as ElSelect, a as ElOption } from './index-03hfIBa_.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import _sfc_main$3 from './upload-ByS8vTmr.mjs';
import { v as vLoading } from './directive-BPPM1aUC.mjs';
import { ref, computed, reactive, watch, mergeProps, unref, withCtx, createTextVNode, toDisplayString, openBlock, createBlock, Fragment, renderList, nextTick, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrGetDirectiveProps, ssrRenderList, ssrRenderStyle } from 'vue/server-renderer';
import Placeholder from '@tiptap/extension-placeholder';
import { useEditor, EditorContent } from '@tiptap/vue-3';
import CharacterCount from '@tiptap/extension-character-count';
import CodeBlockLowlight from '@tiptap/extension-code-block-lowlight';
import { createLowlight, all } from 'lowlight';
import { E as ElMessageBox } from './index-LpZkIxNc.mjs';
import { g as gqStarterKit, a as gqTable, b as gqLink, c as gqUserMention, d as gqIframe, e as gqTagMention, f as gqGallery, h as gqWpAudio, i as gqWpVideo, j as gqWpAttachment, k as gqWpImage } from './editor-DgXsVTk4.mjs';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'lodash-unified';
import 'quick-lru';
import './index-R6EFYpWa.mjs';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-DRiwogtD.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import './index-ChPMoinw.mjs';
import './vnode-l2ZP2UQa.mjs';
import './nuxt-link-Dd6LuEo9.mjs';
import './image-viewer-DG2qIWb8.mjs';
import './index-Di0Jlzch.mjs';
import './index-BKB3Djp4.mjs';
import './index-tCyBRCDx.mjs';
import './index-Bp-nwGzu.mjs';
import './event-BZTOGHfp.mjs';
import './index-BY8mj3AC.mjs';
import './progress-CBrKLnJJ.mjs';
import 'nanoid';
import '@tiptap/extension-table';
import '@tiptap/starter-kit';
import '@tiptap/extension-mention';
import '@tiptap/core';
import 'tippy.js';
import '@tiptap/pm/state';
import './gallery-D8A96_ES.mjs';
import './blockEditorTools-D3fubMyv.mjs';
import './input-number-ClYhMUuv.mjs';
import './index-D3BlhKEk.mjs';
import 'vue-draggable-plus';
import './wpAudio-BYMrm8di.mjs';
import './waveform-CcdD4iaE.mjs';
import './audio-CfS8Ng0x.mjs';
import './wpVideo-DOdXY0D3.mjs';
import './wpAttachment-D7mSEwUA.mjs';
import './wpImage-JJh5054c.mjs';

const _sfc_main = {
  __name: "create.client",
  __ssrInlineRender: true,
  setup(__props) {
    const lowlight = createLowlight(all);
    const action = actionStore();
    const route = useRoute();
    deviceStore();
    const viewer = viewerStore();
    const { t } = useI18n();
    const upload = ref(null);
    const type = computed(() => route.query?.type ?? "post");
    const id = computed(() => route.query?.id ?? 0);
    const nodeId = computed(() => route.query?.nodeId ?? 0);
    const topic = computed(() => route.query?.topic ?? 0);
    const showTips = computed(() => {
      if (!state.settings) return "loading";
      if (type.value == "post" || type.value == "topic") {
        if (!state.settings?.allowCreate) return "error";
        return "success";
      }
      if (type.value == "answer") {
        if (!state.editData?.canAnswer) return "error";
        return "success";
      }
      return "loading";
    });
    const title = computed(() => {
      if (type.value == "answer") {
        return t("page.create.title.editAnswer");
      }
      if (type.value == "topic") {
        if (id.value) {
          return t("page.create.title.editTopic");
        }
        return t("page.create.title.longTopic");
      }
      if (type.value == "post") {
        if (id.value) {
          return t("page.create.title.editPost");
        }
        return t("page.create.title.post");
      }
    });
    useHead(() => ({
      title: title.value
    }));
    const editorToolbar = ref(null);
    ref(null);
    const mediaLibrary = ref(null);
    const hasActivated = ref(false);
    const defaultState = () => ({
      loading: true,
      settings: null,
      editData: null,
      answerData: {
        topicData: {
          title: "",
          slug: "",
          content: ""
        }
      },
      data: {
        title: "",
        content: "",
        category: null,
        cover: null,
        coverId: null
      },
      locked: false,
      topic: {
        attrsPicked: [
          "icon",
          "name",
          "admin",
          "subscribe",
          "userAvatar",
          "userName",
          "longText",
          "join",
          "bounty",
          "vote",
          "allCats",
          "description",
          "currentUser",
          "menus",
          "publish",
          "count",
          "filter",
          "avatar",
          "nikeName",
          "level",
          "time",
          "views",
          "category",
          "loadMoreButton"
        ],
        isArchive: true,
        action: {
          loading: true,
          picked: 0,
          bountyUsers: [],
          inc: (types) => {
            return state.topic.attrsPicked.some((type2) => types.includes(type2));
          },
          menu: null,
          menuList: [],
          form: {
            title: "",
            content: "",
            type: "say",
            id: id.value,
            cat: "",
            bounty: {
              type: "credit",
              deadline: "",
              value: "",
              target: "all",
              targetList: []
            },
            vote: {
              type: "radio",
              deadline: "",
              list: [
                {
                  i: 0,
                  text: "",
                  vote: 0
                },
                {
                  i: 1,
                  text: "",
                  vote: 0
                }
              ]
            },
            image: [],
            video: [],
            audio: [],
            attachment: [],
            roles: {
              active: "public",
              money: "",
              credit: "",
              checkList: []
            }
          }
        }
      },
      menudata: {
        menu: {
          nodes: [
            {
              databaseId: 0,
              communityCatMetas: {
                name: {}
              },
              name: "",
              count: 0,
              thumb: {
                sourceUrl: ""
              }
            }
          ]
        }
      },
      selectCover: () => {
        mediaLibrary.value.libraryBox.show = true;
      },
      getSettings: async () => {
        try {
          const res = await useRequest("/api/request", {
            method: "POST",
            body: {
              action: "utils.createSettings",
              data: {
                type: type.value,
                id: id.value,
                topic: topic.value,
                nodeId: nodeId.value
              }
            }
          });
          if (res?.guaqi?.utils?.createSettings) {
            state.settings = res.guaqi?.utils?.createSettings.settings;
            state.editData = res.guaqi?.utils?.createSettings.data;
            if (type.value == "answer") {
              state.answerData.topicData.title = res.guaqi?.utils?.createSettings?.data?.title;
              state.answerData.topicData.slug = res.guaqi?.utils?.createSettings?.data?.slug;
            }
            if (res.guaqi?.utils?.createSettings?.data?.node) {
              state.menudata.menu.nodes[0] = JSON.parse(
                res.guaqi?.utils?.createSettings.data?.node
              );
              state.menudata.menu.nodes[0].communityCatMetas.name = JSON.parse(
                state.menudata.menu.nodes[0].communityCatMetas?.name
              );
              state.menudata.menu.nodes[0].communityCatMetas.isJoin = true;
              state.menudata.menu.nodes[0].communityCatMetas.settings = {
                allowBounty: res.guaqi?.utils?.createSettings?.settings?.allowBounty,
                allowVote: res.guaqi?.utils?.createSettings?.settings?.allowVote,
                allowImage: res.guaqi?.utils?.createSettings?.settings?.allowImage,
                allowVideo: res.guaqi?.utils?.createSettings?.settings?.allowVideo,
                allowAudio: res.guaqi?.utils?.createSettings?.settings?.allowAudio,
                allowFile: res.guaqi?.utils?.createSettings?.settings?.allowFile,
                topicCan: {
                  can: true
                }
              };
              state.topic.action.menu = state.menudata.menu.nodes[0];
              state.topic.action.menuList = state.menudata.menu.nodes;
            }
            if (res?.guaqi?.utils?.createSettings.data?.title) {
              state.topic.action.form.type = res.guaqi?.utils?.createSettings.data?.meta?.type ?? "say";
              if (state.topic.action.form.type != "say" && state.topic.action.form.type != "bounty") {
                state.topic.action.form.vote.type = res.guaqi?.utils?.createSettings.data.meta.vote.type;
                state.topic.action.form.vote.list = res.guaqi?.utils?.createSettings.data.meta.vote.value;
                state.topic.action.form.vote.deadline = gmtToLocal(
                  res.guaqi?.utils?.createSettings.data.meta.vote.deadline
                );
              }
              if (state.topic.action.form.type == "bounty") {
                state.topic.action.form.bounty.type = res.guaqi?.utils?.createSettings?.data?.meta?.bounty?.type;
                state.topic.action.form.bounty.currency = res.guaqi?.utils?.createSettings?.data?.meta?.bounty?.currency || "";
                try {
                  state.topic.action.form.bounty.value = JSON.parse(
                    res.guaqi?.utils?.createSettings?.data?.meta?.bounty?.value
                  )?.[action.currency.iso] || res.guaqi?.utils?.createSettings?.data?.meta?.bounty?.value;
                } catch (e) {
                  console.log(e);
                  state.topic.action.form.bounty.value = res.guaqi?.utils?.createSettings?.data?.meta?.bounty?.value;
                }
                state.topic.action.form.bounty.deadline = gmtToLocal(
                  res.guaqi?.utils?.createSettings?.data?.meta?.bounty?.deadline
                );
                state.topic.action.form.bounty.private = res.guaqi?.utils?.createSettings?.data?.meta?.bounty?.private ? 1 : 0;
                state.topic.action.form.bounty.target = res.guaqi?.utils?.createSettings?.data?.meta?.bounty?.target;
                state.topic.action.bountyUsers = res.guaqi?.utils?.createSettings?.data?.meta?.bounty?.targetList ?? [];
                state.topic.action.form.bounty.targetList = state.topic.action.bountyUsers.map((user) => user.databaseId);
              }
              state.data.title = res.guaqi?.utils?.createSettings.data.title;
              editor.value.commands.setContent(
                res.guaqi?.utils?.createSettings?.data?.content ?? ""
              );
              state.data.cover = res.guaqi?.utils?.createSettings.data.thumb?.sourceUrl;
              state.data.coverId = res.guaqi?.utils?.createSettings.data.thumb?.databaseId;
              if (!res.guaqi?.utils?.createSettings.settings?.allowCategories?.some(
                (item) => item.databaseId == res.guaqi?.utils?.createSettings.data?.categories[0]?.databaseId
              )) {
                res.guaqi?.utils?.createSettings.settings.allowCategories?.push({
                  databaseId: res.guaqi?.utils?.createSettings.data?.categories[0]?.databaseId,
                  name: res.guaqi?.utils?.createSettings.data?.categories[0]?.name
                });
              }
              state.data.category = res.guaqi?.utils?.createSettings.data?.categories?.[0]?.databaseId;
              if (res.guaqi?.utils?.createSettings.data.role) {
                state.topic.action.form.roles.active = res.guaqi?.utils?.createSettings.data.role.type;
                if (res.guaqi?.utils?.createSettings.data.role.type == "money") {
                  try {
                    state.topic.action.form.roles.money = JSON.parse(
                      res.guaqi?.utils?.createSettings.data.role.value
                    )[action.currency.iso];
                  } catch (e) {
                    state.topic.action.form.roles.money = res.guaqi?.utils?.createSettings.data.role.value;
                  }
                } else if (res.guaqi?.utils?.createSettings.data.role.type == "credit") {
                  state.topic.action.form.roles.credit = res.guaqi?.utils?.createSettings.data.role.value;
                } else if (res.guaqi?.utils?.createSettings.data.role.type == "level") {
                  state.topic.action.form.roles.checkList = res.guaqi?.utils?.createSettings.data.role.value.split(",");
                }
              }
            } else if (res.guaqi?.utils?.createSettings.settings.allowCategories?.[0]?.databaseId) {
              state.data.category = res.guaqi?.utils?.createSettings.settings.allowCategories?.[0]?.databaseId;
            }
          } else {
            state.settings = {};
            state.settings.allowCreate = false;
          }
          hasActivated.value = true;
        } catch (e) {
          console.error(e);
        }
      },
      submitAnswer: async () => {
        ({
          id: id.value,
          content: editor.value.getHTML(),
          topic: topic.value
        });
        const res = await useRequest("/api/request", {});
        if (res?.createCommunityAnswer?.communityAnswer) {
          editor.value.commands.setContent("");
          useUtils.navigateTo(`/account/creator?type=communityAnswers`);
        }
        state.locked = false;
      },
      getData: (type2) => {
        const form = state.topic.action.form;
        const args = {
          form,
          title: state.data.title,
          id: parseInt(id.value),
          content: editor.value.getHTML(),
          characterCount: characterCount.value,
          cat: state.menudata.menu.nodes[0].databaseId,
          type: type2,
          currentTime: (/* @__PURE__ */ new Date()).getTime()
        };
        if (type2 == "topic") {
          return args;
        }
        if (type2 == "post") {
          args["category"] = state.data.category;
          args["cover"] = state.data.coverId;
          args["coverUrl"] = state.data.cover;
          const roleValue = () => {
            switch (state.topic.action.form.roles.active) {
              case "money":
                return state.topic.action.form.roles.money;
              case "credit":
                return state.topic.action.form.roles.credit;
              case "level":
                return state.topic.action.form.roles.checkList.join(",");
            }
            return "";
          };
          args["roles"] = {
            type: state.topic.action.form.roles.active.toUpperCase(),
            value: roleValue()
          };
          return args;
        }
      },
      deleteDraft: () => {
        ElMessageBox.confirm("草稿删除后不能恢复，确定删除草稿吗？", "提示", {
          confirmButtonText: "确定",
          cancelButtonText: "取消",
          type: "warning",
          customStyle: {
            marginTop: "-40%"
            // 直接设置样式
          }
        }).then(() => {
          localStorage.removeItem(
            "autoSave_" + type.value + (nodeId.value ? "_" + nodeId.value : "")
          );
          draft.value = true;
        }).catch(() => {
          return;
        });
      },
      getDraft: computed(() => {
        try {
          draft.value;
          return localStorage.getItem(
            "autoSave_" + type.value + (nodeId.value ? "_" + nodeId.value : "")
          ) ? true : false;
        } catch (e) {
          return null;
        }
      }),
      setData: (data) => {
        state.topic.action.form = data.form;
        state.data.title = data.title;
        editor.value.commands.setContent(data.content);
        state.data.characterCount = data.characterCount;
        state.data.cat = data.cat;
        if (data.category) {
          state.data.category = data.category;
        }
        if (data.cover) {
          state.data.coverId = data.cover;
          state.data.cover = data.coverUrl;
        }
        if (data.roles) {
          state.topic.action.form.roles.active = data.roles.type;
          if (data.roles.type == "money") {
            state.topic.action.form.roles.money = data.roles.value;
          } else if (data.roles.type == "credit") {
            state.topic.action.form.roles.credit = data.roles.value;
          } else if (data.roles.type == "level") {
            state.topic.action.form.roles.checkList = data.roles.value.split(",");
          }
        }
      },
      submit: async () => {
        if (state.locked) return;
        state.locked = true;
        if (type.value == "answer") {
          state.submitAnswer();
          return;
        }
        const args = state.getData(type.value);
        if (type.value == "topic") {
          const res = await useUtils.submitTopic(args, t);
          if (res?.createCommunityTopic?.communityTopic?.status || res?.updateCommunityTopic?.communityTopic?.status) {
            useUtils.navigateTo(`/account/creator?type=community`);
          }
        }
        if (type.value == "post") {
          const res = await useRequest("/api/request", {});
          if (res?.createPost?.post?.gqSlug || res?.updatePost?.post?.gqSlug) {
            useUtils.navigateTo(`/account/creator?type=post`);
          }
        }
        localStorage.removeItem(
          "autoSave_" + type.value + (nodeId.value ? "_" + nodeId.value : "")
        );
        state.locked = false;
      },
      insertMedia: (media) => {
        state.data.cover = media[0]?.node.sourceUrl;
        state.data.coverId = media[0]?.node.databaseId;
      }
    });
    const state = reactive(defaultState());
    const gmtToLocal = (gmtStr) => {
      const isoStr = gmtStr.replace(" ", "T") + "Z";
      const date = new Date(isoStr);
      const year = date.getFullYear();
      const month = String(date.getMonth() + 1).padStart(2, "0");
      const day = String(date.getDate()).padStart(2, "0");
      const hours = String(date.getHours()).padStart(2, "0");
      const minutes = String(date.getMinutes()).padStart(2, "0");
      const seconds = String(date.getSeconds()).padStart(2, "0");
      return `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;
    };
    const draft = ref(false);
    const editor = useEditor({
      content: ``,
      extensions: [
        gqStarterKit,
        gqTable,
        // gqTableCell,
        // gqTableHeader,
        // gqTableRow,
        gqLink,
        Placeholder.configure({
          placeholder: t("common.editor.contentPlaceholder")
        }),
        CharacterCount.configure({
          limit: 9e4
        }),
        gqUserMention,
        gqIframe,
        gqTagMention,
        gqGallery,
        gqWpAudio,
        gqWpVideo,
        gqWpAttachment,
        gqWpImage,
        CodeBlockLowlight.configure({
          enableTabIndentation: true,
          defaultLanguage: "html",
          tabSize: 2,
          lowlight
        })
      ],
      onCreate({ editor: editor2 }) {
        const autoSave = JSON.parse(
          localStorage.getItem(
            "autoSave_" + type.value + (nodeId.value ? "_" + nodeId.value : "")
          )
        );
        if (autoSave && type.value == autoSave.type) {
          state.setData(autoSave);
        }
      },
      onUpdate({ editor: editor2 }) {
        if (!id.value) {
          saveDraft();
        }
      },
      editorProps: {
        handlePaste(view, event, slice) {
          return useUtils.autoPasetImage(view, event, slice, viewer, upload);
        }
      }
    });
    const saveDraft = useThrottleFn(() => {
      try {
        const draftData = state.getData(type.value);
        if (draftData?.content && draftData.title) {
          draft.value = true;
          localStorage.setItem(
            "autoSave_" + type.value + (nodeId.value ? "_" + nodeId.value : ""),
            JSON.stringify(draftData)
          );
          setTimeout(() => {
            draft.value = false;
          }, 1e3);
        }
      } catch (e) {
        console.error(e);
      }
    }, 3e3);
    const characterCount = computed(
      () => editor?.value.storage.characterCount.characters() || 0
    );
    const editorAffix1 = ref(null);
    const editorAffix2 = ref(null);
    const updateAffix = () => {
      if (editorAffix1.value) {
        nextTick(() => {
          editorAffix1.value.updateRoot();
          editorAffix2.value.updateRoot();
        });
      }
    };
    const init = () => {
      if (!isLogin.value) return;
      state.settings = null;
      state.editData = null;
      if (hasActivated.value) {
        Object.assign(state, defaultState());
        editor.value.commands.setContent("");
      }
      nextTick(() => {
        editor.value.editToolbar = editorToolbar.value;
        updateAffix();
      });
      state.getSettings();
    };
    watch(
      () => action.currency.iso,
      (value) => {
        if (state.topic.action.form.bounty.type == "money") {
          try {
            state.topic.action.form.bounty.value = JSON.parse(
              state.editData.meta.bounty.value
            )[value];
          } catch (e) {
            state.topic.action.form.bounty.value = state.editData.meta.bounty.value;
          }
        }
        if (state.editData.role.type == "money") {
          try {
            state.topic.action.form.roles.money = JSON.parse(
              state.editData.role.value
            )[value];
          } catch (e) {
            state.topic.action.form.roles.money = state.topic.action.form.roles.money;
          }
        }
      }
    );
    watch(isLogin, (value) => {
      if (value) {
        console.log("重新登录");
        init();
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      const _component_CommonEditorToolbar = __nuxt_component_0$2;
      const _component_ModulesCommonTopicFormHeader = _sfc_main$1;
      const _component_Blink = _sfc_main$2;
      const _component_Image = __nuxt_component_4;
      const _component_el_select = ElSelect;
      const _component_el_option = ElOption;
      const _component_el_input = ElInput;
      const _component_ClientOnly = __nuxt_component_0$1;
      const _component_CommonFormUpload = _sfc_main$3;
      const _component_CommonEditorMediaLibrary = __nuxt_component_0$2;
      const _directive_loading = vLoading;
      let _temp0;
      _push(`<div${ssrRenderAttrs(mergeProps({
        style: { "--edit-width": "var(--gq-header-width)" },
        class: "border-b max-w-full editor-container gap-2 flex-1 flex flex-col load-success w-full relative min-h-[calc(100vh-var(--gq-header-height))]",
        id: "editor-container"
      }, _attrs))} data-v-7d9ba0b4>`);
      if (unref(showTips) != "success" || !("isLogin" in _ctx ? _ctx.isLogin : unref(isLogin))) {
        _push(`<div class="absolute left-0 w-full h-full mask z-1 top-2" data-v-7d9ba0b4><div class="@md:mx-auto mx-2 w-[calc(100%-1rem)] @md:w-[48rem] max-w-full bg-[--el-bg-color] rounded-lg p-0 h-full" data-v-7d9ba0b4><div class="flex items-center justify-center flex-col gap-2 h-full" data-v-7d9ba0b4>`);
        if (!("isLogin" in _ctx ? _ctx.isLogin : unref(isLogin))) {
          _push(`<!--[--><i class="i-ph-pencil-circle-thin text-4xl text-[--el-color-primary]" data-v-7d9ba0b4></i><div class="text-sm" data-v-7d9ba0b4>${ssrInterpolate(_ctx.$t("page.create.login"))}</div>`);
          _push(ssrRenderComponent(_component_el_button, {
            type: "primary",
            class: "mt-4",
            onClick: ($event) => unref(action).showLogin = true
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("page.community.list.hidden.login"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("page.community.list.hidden.login")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`<!--]-->`);
        } else if (unref(showTips) == "loading") {
          _push(`<div${ssrRenderAttrs(_temp0 = mergeProps({ class: "w-20 h-20" }, ssrGetDirectiveProps(_ctx, _directive_loading, true)))} data-v-7d9ba0b4>${"textContent" in _temp0 ? ssrInterpolate(_temp0.textContent) : _temp0.innerHTML ?? ""}</div>`);
        } else {
          _push(`<div class="flex items-center justify-center flex-col gap-2" data-v-7d9ba0b4><i class="i-ph-pencil-circle-thin text-4xl text-[--el-color-primary]" data-v-7d9ba0b4></i><div class="text-sm font-600" data-v-7d9ba0b4>${ssrInterpolate(_ctx.$t("page.create.permission"))}</div><div class="text-xs" data-v-7d9ba0b4>${ssrInterpolate(_ctx.$t("page.create.permission_desc"))}</div></div>`);
        }
        _push(`</div></div></div>`);
      } else {
        _push(`<!--[--><div class="@md:h-19 h-16" data-v-7d9ba0b4><div class="create-affix border-t" data-v-7d9ba0b4>`);
        _push(ssrRenderComponent(_component_CommonEditorToolbar, {
          editor: unref(editor),
          ref_key: "editorToolbar",
          ref: editorToolbar,
          settings: unref(state).settings
        }, null, _parent));
        _push(`</div></div>`);
        if (unref(type) == "topic") {
          _push(`<div class="@md:mx-auto mx-2 w-[calc(100%-1rem)] @md:w-[48rem] border-[--gq-page-bg] community-bar max-w-full bg-[--el-bg-color] rounded" data-v-7d9ba0b4>`);
          _push(ssrRenderComponent(_component_ModulesCommonTopicFormHeader, {
            data: unref(state).menudata,
            settings: unref(state).topic,
            action: unref(state).topic.action,
            class: "!p-4 rounded"
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(type) == "answer") {
          _push(`<div class="@md:mx-auto mx-2 p-4 w-[calc(100%-1rem)] @md:w-[48rem] max-w-full bg-[--el-bg-color] rounded flex gap-2 items-center text-sm" data-v-7d9ba0b4><div class="opacity-80" data-v-7d9ba0b4>${ssrInterpolate(_ctx.$t("page.create.writeAnswer"))}:</div>`);
          _push(ssrRenderComponent(_component_Blink, {
            to: unref(state).answerData.topicData.slug,
            target: "_blank"
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(unref(state).answerData.topicData.title)}`);
              } else {
                return [
                  createTextVNode(toDisplayString(unref(state).answerData.topicData.title), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        if (unref(type) != "topic" && unref(type) != "answer") {
          _push(`<div class="@md:mx-auto mx-2 p-2 w-[calc(100%-1rem)] @md:w-[48rem] max-w-full bg-[--el-bg-color] rounded flex gap-4 items-center justify-between" data-v-7d9ba0b4><div class="w-20 h-13 cursor-pointer bg-[--el-color-info-light-10] rounded flex items-center justify-center border-1 border-dashed border-[--el-color-primary-light-7]" data-v-7d9ba0b4>`);
          if (unref(state).data.cover) {
            _push(ssrRenderComponent(_component_Image, {
              src: unref(state).data.cover,
              class: "w-full h-full object-cover"
            }, null, _parent));
          } else {
            _push(`<span class="opacity-50 text-xs" data-v-7d9ba0b4>${ssrInterpolate(_ctx.$t("page.create.cover"))}</span>`);
          }
          _push(`</div><div class="w-40" data-v-7d9ba0b4>`);
          _push(ssrRenderComponent(_component_el_select, {
            modelValue: unref(state).data.category,
            "onUpdate:modelValue": ($event) => unref(state).data.category = $event,
            placeholder: _ctx.$t("page.create.selectCategory")
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`<!--[-->`);
                ssrRenderList(unref(state).settings?.allowCategories, (item) => {
                  _push2(ssrRenderComponent(_component_el_option, {
                    key: item.databaseId,
                    label: item.name,
                    value: item.databaseId
                  }, null, _parent2, _scopeId));
                });
                _push2(`<!--]-->`);
              } else {
                return [
                  (openBlock(true), createBlock(Fragment, null, renderList(unref(state).settings?.allowCategories, (item) => {
                    return openBlock(), createBlock(_component_el_option, {
                      key: item.databaseId,
                      label: item.name,
                      value: item.databaseId
                    }, null, 8, ["label", "value"]);
                  }), 128))
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`<div class="@md:mx-auto mx-2 w-[calc(100%-1rem)] @md:w-[48rem] max-w-full bg-[--el-bg-color] p-4 @md:py-5 edit-content flex-1 h-full flex flex-col rounded" style="${ssrRenderStyle(`--gq-editor-content-placeholder:'${_ctx.$t(
          "common.editor.imagecaptionPlaceholder"
        )}'`)}" data-v-7d9ba0b4>`);
        if (unref(type) != "answer") {
          _push(`<div class="border-b pb-4 mb-4" data-v-7d9ba0b4>`);
          _push(ssrRenderComponent(_component_el_input, {
            modelValue: unref(state).data.title,
            "onUpdate:modelValue": ($event) => unref(state).data.title = $event,
            placeholder: _ctx.$t("common.editor.titlePlaceholder"),
            size: "large",
            class: "w-full !text-lg @md:!text-3xl font-600 !p-0",
            style: { "--el-border-color": "transparent", "--el-border-color-hover": "transparent", "--el-input-focus-border-color": "transparent", "--el-input-text-color": "var(--el-text-color-primary)" }
          }, null, _parent));
          _push(`</div>`);
        } else {
          _push(`<!---->`);
        }
        _push(ssrRenderComponent(unref(EditorContent), {
          editor: unref(editor),
          class: `${unref(type) == "answer" ? "mt-0" : "mt-5"} entry-content markdown-body single-content flex-1 flex flex-col`
        }, null, _parent));
        _push(`</div>`);
        _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
        _push(`<!--]-->`);
      }
      _push(ssrRenderComponent(_component_CommonFormUpload, {
        ref_key: "upload",
        ref: upload,
        class: "!hidden"
      }, null, _parent));
      _push(ssrRenderComponent(_component_CommonEditorMediaLibrary, {
        onInsertMedia: unref(state).insertMedia,
        where: "comment",
        limit: 1,
        ref_key: "mediaLibrary",
        ref: mediaLibrary,
        settings: unref(state).settings
      }, null, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/pages/create.client.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const create_client = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-7d9ba0b4"]]);

export { create_client as default };
