import { E as ElDialog } from './index-awVc4A7-.mjs';
import { E as ElAvatar } from './index-R6EFYpWa.mjs';
import _sfc_main$1 from './creditIcon-eOdkwofx.mjs';
import { _ as __nuxt_component_4 } from './Image-BE6Y-a3S.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { v as viewerStore, j as actionStore, r as useRequest, e as useUtils } from './server.mjs';
import { useSSRContext, reactive, mergeProps, unref, withCtx, createTextVNode, toDisplayString, createVNode, openBlock, createBlock, createCommentVNode } from 'vue';
import { ssrRenderComponent, ssrInterpolate } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './use-dialog-7J0bwlna.mjs';
import './focus-trap.vue-9ChHxs3Q.mjs';
import 'lodash-unified';
import './aria-BhThsKez.mjs';
import './event-BZTOGHfp.mjs';
import '@vue/shared';
import './vnode-l2ZP2UQa.mjs';
import './index-Di0Jlzch.mjs';
import './style-h263bamF.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-DRiwogtD.mjs';
import './index-ChPMoinw.mjs';
import './constants-hAKFmBbq.mjs';
import './svgIcon-BpIUCf-e.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './image-viewer-DG2qIWb8.mjs';
import './index-BKB3Djp4.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import '@ctrl/tinycolor';

const _sfc_main = {
  __name: "CommonFormCreditPay",
  __ssrInlineRender: true,
  props: {
    data: {
      type: Object,
      default: () => ({})
    },
    show: {
      type: Boolean,
      default: false
    }
  },
  emits: ["success"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const viewer = viewerStore();
    const action = actionStore();
    const emits = __emit;
    const state = reactive({
      data: props.data,
      show: props.show,
      locked: false,
      payMethod: "balance",
      successData: {},
      handleBuyCredit: () => {
        useUtils.navigateTo("/account/wealth", "_blank");
      },
      handlePay: async () => {
        if (state.locked) return;
        state.locked = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              args: JSON.stringify(state.data.args),
              postId: state.data.postId,
              type: state.data.type
            }
          }
        });
        if (res) {
          state.show = false;
          action.success.show = true;
          action.success.data = {
            finalPrice: state.data.finalPrice,
            symbol: "",
            data: state.data,
            coupon: null,
            payment: "credit"
          };
          emits("success", res);
        }
        state.locked = false;
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_dialog = ElDialog;
      const _component_el_avatar = ElAvatar;
      const _component_CommonCreditIcon = _sfc_main$1;
      const _component_Image = __nuxt_component_4;
      const _component_el_button = ElButton;
      _push(ssrRenderComponent(_component_el_dialog, mergeProps({
        modelValue: unref(state).show,
        "onUpdate:modelValue": ($event) => unref(state).show = $event,
        title: _ctx.$t("common.creditPay.title"),
        width: "290px",
        "lock-scroll": false,
        "close-on-click-modal": false,
        "append-to-body": true
      }, _attrs), {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex flex-col gap-5" data-v-02fa347d${_scopeId}><div class="flex items-center gap-2" data-v-02fa347d${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_avatar, {
              size: 40,
              src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(unref(viewer).data.avatar.url)
            }, null, _parent2, _scopeId));
            _push2(`<div data-v-02fa347d${_scopeId}><div class="text-sm" data-v-02fa347d${_scopeId}>${ssrInterpolate(unref(viewer).data.name)}</div><div class="flex items-center text-xs opacity-70" data-v-02fa347d${_scopeId}><span data-v-02fa347d${_scopeId}>${ssrInterpolate(_ctx.$t("common.creditPay.availableCredit"))}</span>`);
            _push2(ssrRenderComponent(_component_CommonCreditIcon, { class: "w-3 h-3" }, null, _parent2, _scopeId));
            _push2(`<span data-v-02fa347d${_scopeId}>${ssrInterpolate(unref(viewer).data.gqCredit)}</span></div></div></div><div class="flex items-center text-[--el-color-primary] leading-none font-600 pl-2" data-v-02fa347d${_scopeId}>`);
            _push2(ssrRenderComponent(_component_CommonCreditIcon, { class: "w-4 h-4 mt-3" }, null, _parent2, _scopeId));
            _push2(`<span class="text-4xl ml-1" data-v-02fa347d${_scopeId}>${ssrInterpolate(unref(state).data.finalPrice)}</span></div><div class="flex flex-col gap-2" data-v-02fa347d${_scopeId}>`);
            if (unref(state).data.price > unref(state).data.finalPrice) {
              _push2(`<div class="text-xs text-[--el-color-warning-dark-2] flex items-center" data-v-02fa347d${_scopeId}>${ssrInterpolate(_ctx.$t("common.creditPay.discount"))} `);
              _push2(ssrRenderComponent(_component_CommonCreditIcon, { class: "w-3 h-3" }, null, _parent2, _scopeId));
              _push2(` ${ssrInterpolate(unref(state).data.price - unref(state).data.finalPrice)}</div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="relative rounded p-2 overflow-hidden border-1 info" data-v-02fa347d${_scopeId}><div class="flex items-center gap-2" data-v-02fa347d${_scopeId}>`);
            if (unref(state).data?.thumb) {
              _push2(ssrRenderComponent(_component_Image, {
                src: unref(state).data.thumb,
                class: "w-6 h-6"
              }, null, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="flex-1 relative text-sm" data-v-02fa347d${_scopeId}><span class="line-clamp-1" data-v-02fa347d${_scopeId}>${ssrInterpolate(unref(state).data?.title)}</span></div></div></div><div class="text-xs flex items-center justify-between" data-v-02fa347d${_scopeId}>`);
            if (unref(viewer).data.gqCredit < unref(state).data.finalPrice) {
              _push2(`<span class="text-[--el-color-danger]" data-v-02fa347d${_scopeId}>${ssrInterpolate(_ctx.$t("common.creditPay.notEnoughCredit"))}</span>`);
            } else {
              _push2(`<!---->`);
            }
            if (unref(state).data.count) {
              _push2(`<span data-v-02fa347d${_scopeId}>${ssrInterpolate(_ctx.$t("common.creditPay.count", [unref(state).data.count]))}</span>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`</div></div><div class="flex items-center flex-col gap-2" data-v-02fa347d${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_button, {
              type: "primary",
              class: "w-full",
              onClick: unref(state).handlePay,
              loading: unref(state).locked,
              disabled: unref(viewer).data.gqCredit < unref(state).data.finalPrice || unref(state).locked
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("common.creditPay.exchange"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("common.creditPay.exchange")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(ssrRenderComponent(_component_el_button, {
              link: "",
              type: "primary",
              size: "small",
              class: "mt-2",
              onClick: unref(state).handleBuyCredit
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`${ssrInterpolate(_ctx.$t("common.creditPay.needMoreCredit"))}`);
                } else {
                  return [
                    createTextVNode(toDisplayString(_ctx.$t("common.creditPay.needMoreCredit")), 1)
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
            _push2(`</div></div>`);
          } else {
            return [
              createVNode("div", { class: "flex flex-col gap-5" }, [
                createVNode("div", { class: "flex items-center gap-2" }, [
                  createVNode(_component_el_avatar, {
                    size: 40,
                    src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(unref(viewer).data.avatar.url)
                  }, null, 8, ["src"]),
                  createVNode("div", null, [
                    createVNode("div", { class: "text-sm" }, toDisplayString(unref(viewer).data.name), 1),
                    createVNode("div", { class: "flex items-center text-xs opacity-70" }, [
                      createVNode("span", null, toDisplayString(_ctx.$t("common.creditPay.availableCredit")), 1),
                      createVNode(_component_CommonCreditIcon, { class: "w-3 h-3" }),
                      createVNode("span", null, toDisplayString(unref(viewer).data.gqCredit), 1)
                    ])
                  ])
                ]),
                createVNode("div", { class: "flex items-center text-[--el-color-primary] leading-none font-600 pl-2" }, [
                  createVNode(_component_CommonCreditIcon, { class: "w-4 h-4 mt-3" }),
                  createVNode("span", { class: "text-4xl ml-1" }, toDisplayString(unref(state).data.finalPrice), 1)
                ]),
                createVNode("div", { class: "flex flex-col gap-2" }, [
                  unref(state).data.price > unref(state).data.finalPrice ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "text-xs text-[--el-color-warning-dark-2] flex items-center"
                  }, [
                    createTextVNode(toDisplayString(_ctx.$t("common.creditPay.discount")) + " ", 1),
                    createVNode(_component_CommonCreditIcon, { class: "w-3 h-3" }),
                    createTextVNode(" " + toDisplayString(unref(state).data.price - unref(state).data.finalPrice), 1)
                  ])) : createCommentVNode("", true),
                  createVNode("div", { class: "relative rounded p-2 overflow-hidden border-1 info" }, [
                    createVNode("div", { class: "flex items-center gap-2" }, [
                      unref(state).data?.thumb ? (openBlock(), createBlock(_component_Image, {
                        key: 0,
                        src: unref(state).data.thumb,
                        class: "w-6 h-6"
                      }, null, 8, ["src"])) : createCommentVNode("", true),
                      createVNode("div", { class: "flex-1 relative text-sm" }, [
                        createVNode("span", { class: "line-clamp-1" }, toDisplayString(unref(state).data?.title), 1)
                      ])
                    ])
                  ]),
                  createVNode("div", { class: "text-xs flex items-center justify-between" }, [
                    unref(viewer).data.gqCredit < unref(state).data.finalPrice ? (openBlock(), createBlock("span", {
                      key: 0,
                      class: "text-[--el-color-danger]"
                    }, toDisplayString(_ctx.$t("common.creditPay.notEnoughCredit")), 1)) : createCommentVNode("", true),
                    unref(state).data.count ? (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("common.creditPay.count", [unref(state).data.count])), 1)) : createCommentVNode("", true)
                  ])
                ]),
                createVNode("div", { class: "flex items-center flex-col gap-2" }, [
                  createVNode(_component_el_button, {
                    type: "primary",
                    class: "w-full",
                    onClick: unref(state).handlePay,
                    loading: unref(state).locked,
                    disabled: unref(viewer).data.gqCredit < unref(state).data.finalPrice || unref(state).locked
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("common.creditPay.exchange")), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick", "loading", "disabled"]),
                  createVNode(_component_el_button, {
                    link: "",
                    type: "primary",
                    size: "small",
                    class: "mt-2",
                    onClick: unref(state).handleBuyCredit
                  }, {
                    default: withCtx(() => [
                      createTextVNode(toDisplayString(_ctx.$t("common.creditPay.needMoreCredit")), 1)
                    ]),
                    _: 1
                  }, 8, ["onClick"])
                ])
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/form/creditPay.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const creditPay = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-02fa347d"]]);

export { creditPay as default };
