import { E as ElPopover } from './index-CPT03ebO.mjs';
import { g as getServerSettings, j as actionStore } from './server.mjs';
import { ref, watch, unref, mergeProps, withCtx, createVNode, openBlock, createBlock, Fragment, renderList, toDisplayString, createTextVNode, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrRenderList, ssrInterpolate } from 'vue/server-renderer';
import './dropdown-cQfpmYSu.mjs';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-DRiwogtD.mjs';
import 'lodash-unified';
import './focus-trap.vue-9ChHxs3Q.mjs';
import './aria-BhThsKez.mjs';
import '@vue/shared';
import './index-ChPMoinw.mjs';
import './constants-hAKFmBbq.mjs';
import './style-h263bamF.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonFormCurrencyPopoer",
  __ssrInlineRender: true,
  emits: ["change"],
  setup(__props, { emit: __emit }) {
    const settingsStore = getServerSettings();
    const popover = ref(null);
    const emit = __emit;
    const action = actionStore();
    const symbolIso = ref(action.currency.iso);
    watch(() => action.currency.iso, () => {
      if (action.currency.iso) {
        changeCurrency(action.currency.iso);
      }
    });
    const changeCurrency = (iso) => {
      emit("change", iso);
      symbolIso.value = iso;
      popover.value.hide();
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_popover = ElPopover;
      if (unref(settingsStore).currency.length > 1) {
        _push(ssrRenderComponent(_component_el_popover, mergeProps({
          placement: "bottom",
          width: 160,
          "hide-after": 0,
          trigger: "click",
          ref_key: "popover",
          ref: popover
        }, _attrs), {
          reference: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<span class="text-xs ml-1 flex items-center gap-1 mt-1.7 cursor-pointer"${_scopeId}>${ssrInterpolate(unref(symbolIso))} <i class="i-ph-caret-down-fill text-[10px]"${_scopeId}></i></span>`);
            } else {
              return [
                createVNode("span", { class: "text-xs ml-1 flex items-center gap-1 mt-1.7 cursor-pointer" }, [
                  createTextVNode(toDisplayString(unref(symbolIso)) + " ", 1),
                  createVNode("i", { class: "i-ph-caret-down-fill text-[10px]" })
                ])
              ];
            }
          }),
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="flex flex-col gap-1"${_scopeId}><!--[-->`);
              ssrRenderList(unref(settingsStore).currency, (item, i) => {
                _push2(`<span class="text-xs flex items-center gap-1 cursor-pointer hover:text-[--el-color-primary] hover:bg-[--el-color-info-light-10] p-2 rounded-md"${_scopeId}>${ssrInterpolate(item.name?.[_ctx.$i18n.locale])}/${ssrInterpolate(item.symbol_iso)} (${ssrInterpolate(item.symbol)}) </span>`);
              });
              _push2(`<!--]--></div>`);
            } else {
              return [
                createVNode("div", { class: "flex flex-col gap-1" }, [
                  (openBlock(true), createBlock(Fragment, null, renderList(unref(settingsStore).currency, (item, i) => {
                    return openBlock(), createBlock("span", {
                      class: "text-xs flex items-center gap-1 cursor-pointer hover:text-[--el-color-primary] hover:bg-[--el-color-info-light-10] p-2 rounded-md",
                      onClick: ($event) => changeCurrency(item.symbol_iso),
                      key: i
                    }, toDisplayString(item.name?.[_ctx.$i18n.locale]) + "/" + toDisplayString(item.symbol_iso) + " (" + toDisplayString(item.symbol) + ") ", 9, ["onClick"]);
                  }), 128))
                ])
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/form/currencyPopoer.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
