import { TableKit } from '@tiptap/extension-table';
import StarterKit from '@tiptap/starter-kit';
import Mention from '@tiptap/extension-mention';
import { PasteRule, InputRule, Node, mergeAttributes } from '@tiptap/core';
import { VueNodeViewRenderer, VueRenderer } from '@tiptap/vue-3';
import tippy from 'tippy.js';
import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { E as ElAvatar } from './index-R6EFYpWa.mjs';
import { e as useUtils, aE as useDebounceFn, r as useRequest } from './server.mjs';
import { ref, mergeProps, withCtx, unref, createVNode, openBlock, createBlock, createCommentVNode, createTextVNode, toDisplayString, Fragment, renderList, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrInterpolate } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import { PluginKey } from '@tiptap/pm/state';
import _sfc_main$1 from './gallery-D8A96_ES.mjs';
import _sfc_main$2 from './wpAudio-BYMrm8di.mjs';
import _sfc_main$3 from './wpVideo-DOdXY0D3.mjs';
import _sfc_main$4 from './wpAttachment-D7mSEwUA.mjs';
import _sfc_main$5 from './wpImage-JJh5054c.mjs';

const table$1 = TableKit.configure({
  table: {
    HTMLAttributes: {
      class: "wp-block-table",
      width: "100%"
    },
    openOnClick: false,
    resizable: true
  }
});
const starterKit$1 = StarterKit.configure({
  blockquote: {
    HTMLAttributes: {
      class: "wp-block-quote is-layout-flow wp-block-quote-is-layout-flow"
    }
  },
  codeBlock: false,
  text: true,
  link: {
    HTMLAttributes: {
      class: "wp-block-link"
    },
    openOnClick: false
  }
});
const customKit = {
  // link,
  starterKit: starterKit$1,
  table: table$1
  // tableCell,
  // tableHeader,
  // tableRow,
};
const _sfc_main = {
  props: {
    items: {
      type: Array,
      required: true
    },
    isFetching: {
      type: Boolean,
      required: true
    },
    query: {
      type: String,
      required: false
    },
    pluginKey: {
      type: String,
      required: true
    },
    command: {
      type: Function,
      required: true
    }
  },
  data() {
    return {
      selectedIndex: 0
    };
  },
  watch: {
    items() {
      this.selectedIndex = 0;
    }
  },
  methods: {
    onKeyDown({ event }) {
      if (event.key === "ArrowUp") {
        this.upHandler();
        return true;
      }
      if (event.key === "ArrowDown") {
        this.downHandler();
        return true;
      }
      if (event.key === "Enter") {
        this.enterHandler();
        return true;
      }
      return false;
    },
    upHandler() {
      this.selectedIndex = (this.selectedIndex + this.items.length - 1) % this.items.length;
    },
    downHandler() {
      this.selectedIndex = (this.selectedIndex + 1) % this.items.length;
    },
    enterHandler() {
      this.selectItem(this.selectedIndex);
    },
    selectItem(index) {
      if (this.items.length == 0) return;
      const item = this.items[index].name;
      if (item) {
        this.command({ label: item, id: this.items[index].databaseId });
      }
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_el_scrollbar = ElScrollbar;
  const _component_el_button = ElButton;
  const _component_el_avatar = ElAvatar;
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "dropdown-menu" }, _attrs))} data-v-c12484cf>`);
  if ($props.items.length) {
    _push(`<div class="h-60 max-w-60" data-v-c12484cf>`);
    _push(ssrRenderComponent(_component_el_scrollbar, { height: "100%" }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          _push2(`<div class="flex flex-col gap-1 p-1" data-v-c12484cf${_scopeId}><!--[-->`);
          ssrRenderList($props.items, (item, index) => {
            _push2(ssrRenderComponent(_component_el_button, {
              text: "",
              bg: index === $data.selectedIndex,
              key: index,
              onClick: ($event) => $options.selectItem(index)
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  _push3(`<div class="flex items-center gap-1 line-clamp-1" data-v-c12484cf${_scopeId2}>`);
                  if (item?.avatar?.url) {
                    _push3(ssrRenderComponent(_component_el_avatar, {
                      src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item?.avatar?.url),
                      class: "!w-5 !h-5",
                      square: ""
                    }, null, _parent3, _scopeId2));
                  } else {
                    _push3(`<!---->`);
                  }
                  _push3(` ${ssrInterpolate(item.name)} <span class="text-xs opacity-70" data-v-c12484cf${_scopeId2}>(id:${ssrInterpolate(item.databaseId)})</span></div>`);
                } else {
                  return [
                    createVNode("div", { class: "flex items-center gap-1 line-clamp-1" }, [
                      item?.avatar?.url ? (openBlock(), createBlock(_component_el_avatar, {
                        key: 0,
                        src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item?.avatar?.url),
                        class: "!w-5 !h-5",
                        square: ""
                      }, null, 8, ["src"])) : createCommentVNode("", true),
                      createTextVNode(" " + toDisplayString(item.name) + " ", 1),
                      createVNode("span", { class: "text-xs opacity-70" }, "(id:" + toDisplayString(item.databaseId) + ")", 1)
                    ])
                  ];
                }
              }),
              _: 2
            }, _parent2, _scopeId));
          });
          _push2(`<!--]--></div>`);
        } else {
          return [
            createVNode("div", { class: "flex flex-col gap-1 p-1" }, [
              (openBlock(true), createBlock(Fragment, null, renderList($props.items, (item, index) => {
                return openBlock(), createBlock(_component_el_button, {
                  text: "",
                  bg: index === $data.selectedIndex,
                  key: index,
                  onClick: ($event) => $options.selectItem(index)
                }, {
                  default: withCtx(() => [
                    createVNode("div", { class: "flex items-center gap-1 line-clamp-1" }, [
                      item?.avatar?.url ? (openBlock(), createBlock(_component_el_avatar, {
                        key: 0,
                        src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item?.avatar?.url),
                        class: "!w-5 !h-5",
                        square: ""
                      }, null, 8, ["src"])) : createCommentVNode("", true),
                      createTextVNode(" " + toDisplayString(item.name) + " ", 1),
                      createVNode("span", { class: "text-xs opacity-70" }, "(id:" + toDisplayString(item.databaseId) + ")", 1)
                    ])
                  ]),
                  _: 2
                }, 1032, ["bg", "onClick"]);
              }), 128))
            ])
          ];
        }
      }),
      _: 1
    }, _parent));
    _push(`</div>`);
  } else {
    _push(`<div class="item text-xs p-2" data-v-c12484cf>`);
    if ($props.isFetching) {
      _push(ssrRenderComponent(_component_el_button, {
        loading: true,
        text: ""
      }, null, _parent));
    } else if ($props.query) {
      _push(`<span data-v-c12484cf>${ssrInterpolate(_ctx.$t("common.editor.mention.noresults", [$props.query]))}</span>`);
    } else {
      _push(`<span data-v-c12484cf>${ssrInterpolate(_ctx.$t("common.editor.mention.placeholder." + $props.pluginKey))}</span>`);
    }
    _push(`</div>`);
  }
  _push(`</div>`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/composables/editor/mentionList.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const MentionList = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender], ["__scopeId", "data-v-c12484cf"]]);
async function fetchMentionItems(query, char2, type2) {
  const res = await useRequest("/api/request", {});
  return res?.users?.nodes || res?.terms?.edges;
}
const isFetching = ref(false);
const isComposing = ref(false);
const debouncedFetchMentionItems = useDebounceFn(
  async (query, char2, type2, callback) => {
    isFetching.value = true;
    try {
      const items = await fetchMentionItems(query, char2, type2);
      if (items[0].node) {
        const newItems = items.map((item) => item.node);
        callback(newItems);
      } else {
        callback(items);
      }
    } catch (error) {
      callback([]);
    } finally {
      isFetching.value = false;
    }
  },
  300
);
function handleCompositionEnd(view, data) {
  const state = view.state;
  const { tr } = state;
  tr.insertText(data, state.selection.from, state.selection.to);
  view.dispatch(tr);
  const query = data;
  if (query) {
    debouncedFetchMentionItems(query, char, type, (items) => {
    });
  }
}
function suggestion(char2, type2, pluginKey) {
  return {
    char: char2,
    pluginKey: new PluginKey(pluginKey),
    char: char2,
    pluginKey: new PluginKey(pluginKey),
    items: ({ query }) => {
      return new Promise((resolve) => {
        debouncedFetchMentionItems(query || "", char2, type2, resolve);
      });
    },
    command: ({ editor, range, props }) => {
      const nodeAfter = editor.view.state.selection.$to.nodeAfter;
      const overrideSpace = nodeAfter?.text?.startsWith(" ");
      if (overrideSpace) {
        range.to += 1;
      }
      editor.chain().focus().insertContentAt(range, [
        {
          type: pluginKey,
          attrs: props
        },
        {
          type: "text",
          text: " "
        }
      ]).run();
      (void 0).getSelection()?.collapseToEnd();
    },
    render: () => {
      let component;
      let popup;
      return {
        onStart: (props) => {
          props.isFetching = isFetching;
          props.isComposing = isComposing;
          props.pluginKey = pluginKey;
          try {
            component = new VueRenderer(MentionList, {
              props,
              editor: props.editor
            });
          } catch (error) {
            console.error(error);
            component = null;
            return;
          }
          if (!props.clientRect || !component) {
            return;
          }
          popup = tippy("body", {
            getReferenceClientRect: props.clientRect,
            appendTo: () => (void 0).body,
            content: component.element,
            showOnCreate: true,
            interactive: true,
            trigger: "manual",
            placement: "bottom-start",
            hideOnClick: true
          });
        },
        onUpdate(props) {
          if (!component) {
            return;
          }
          component.updateProps(props);
          if (!props.clientRect) {
            return;
          }
          if (popup && popup[0]) {
            popup[0].setProps({
              getReferenceClientRect: props.clientRect
            });
          }
        },
        onKeyDown(props) {
          if (props.event.key === "Escape") {
            if (popup && popup[0]) {
              popup[0].hide();
            }
            return true;
          }
          if (!component || !component.ref) {
            return false;
          }
          return component.ref.onKeyDown(props);
        },
        onExit() {
          if (popup && popup[0]) {
            popup[0].destroy();
            popup = null;
          }
          if (component) {
            component.destroy();
            component = null;
          }
        }
      };
    },
    // 新增的事件监听函数
    addProseMirrorHandlers() {
      return {
        handleDOMEvents: {
          compositionstart(view, event) {
            isComposing.value = true;
            return false;
          },
          compositionend(view, event) {
            isComposing.value = false;
            handleCompositionEnd(view, event.data);
            return false;
          }
        }
      };
    }
  };
}
const tagMention$1 = Mention.extend({
  name: "tagMention",
  addOptions() {
    return {
      ...this.parent?.(),
      // 关键点：必须显式覆盖 char 属性，否则它默认为 '@'
      char: "#",
      suggestion: suggestion("#", "COMMUNITYTAG", "tagMention"),
      HTMLAttributes: {
        class: "mention-tag"
      },
      renderHTML({ options, node }) {
        return [
          "span",
          options.HTMLAttributes,
          [
            "b",
            { class: "mention-char" },
            // 这里可以直接使用 options.char，或者继续用 options.suggestion.char
            options.char
            // 建议改成 options.char
          ],
          `${node.attrs.label ?? node.attrs.id}`,
          [
            "b",
            { class: "mention-char" },
            options.char
            // 建议改成 options.char
          ]
        ];
      },
      // 建议：同时覆盖 renderText，确保复制粘贴或转纯文本时也是正确的
      renderText({ node }) {
        return `#${node.attrs.label ?? node.attrs.id}#`;
      }
    };
  },
  addInputRules() {
    return [
      new InputRule({
        // 修改后的正则核心逻辑：
        // 1. 不需要前面有空格 (移除了 (?:^|\s))
        // 2. 核心限制：MATCH[2] (标签内容) 的第一个字符 [^#\s] 不能是 # 也不能是空格
        // 3. 长度限制：后续字符 [^#]{0,29} 
        // 这样当输入 "#标签1# 后面接文本#" 时，因为 " 后面" 以空格开头，会被正则拒绝，从而保护了前面的文本
        find: /(#([^#\s][^#]{0,29})#)$/,
        handler: ({ state, range, match }) => {
          const label = match[2];
          if (label) {
            const { tr } = state;
            const start = range.from;
            const end = range.to;
            tr.replaceWith(
              start,
              end,
              this.type.create({
                id: label,
                label
              })
            );
            const mentionNodeSize = 1;
            tr.insert(start + mentionNodeSize, state.schema.text(" "));
          }
        }
      })
    ];
  },
  addPasteRules() {
    return [
      new PasteRule({
        find: /#([^#]{1,30})#/g,
        handler: ({ state, range }) => {
          const { tr } = state;
          const start = range.from;
          const end = range.to;
          const text = state.doc.textBetween(start, end, " ", " ");
          const matches = [];
          const regex = /#([^#]{1,30})#/g;
          let match;
          while ((match = regex.exec(text)) !== null) {
            const label = match[1].trim();
            if (label.length > 0 && label.length <= 30) {
              matches.push({
                label,
                index: match.index,
                length: match[0].length
              });
            }
          }
          if (matches.length === 0) {
            return null;
          }
          for (let i = matches.length - 1; i >= 0; i--) {
            const { label, index, length } = matches[i];
            const matchStart = start + index;
            const matchEnd = matchStart + length;
            tr.replaceWith(
              matchStart,
              matchEnd,
              this.type.create({
                id: label,
                label
              })
            );
          }
          return tr;
        }
      })
    ];
  },
  addKeyboardShortcuts() {
    return {
      // 覆盖默认的 backspace 行为，删除节点时不恢复触发字符
      Backspace: () => {
        const { state, dispatch } = this.editor.view;
        const { selection } = state;
        const { $from, empty } = selection;
        if (!empty) {
          return false;
        }
        const nodeBefore = $from.nodeBefore;
        if (nodeBefore && nodeBefore.type.name === this.name) {
          const tr = state.tr.delete($from.pos - nodeBefore.nodeSize, $from.pos);
          dispatch(tr);
          return true;
        }
        return false;
      }
    };
  }
});
const userMention$1 = Mention.extend({
  name: "userMention",
  addOptions() {
    return {
      ...this.parent?.(),
      char: "@",
      HTMLAttributes: {
        class: "mention"
      },
      suggestion: suggestion("@", "", "userMention"),
      renderHTML({ options, node }) {
        return [
          "span",
          options.HTMLAttributes,
          [
            "b",
            { class: "mention-char" },
            // 可选：添加一个类以便于样式化
            options.suggestion.char
          ],
          `${node.attrs.label ?? node.attrs.id}`
        ];
      }
    };
  },
  addKeyboardShortcuts() {
    return {
      // 覆盖默认的 backspace 行为，删除节点时不恢复触发字符
      Backspace: () => {
        const { state, dispatch } = this.editor.view;
        const { selection } = state;
        const { $from, empty } = selection;
        if (!empty) {
          return false;
        }
        const nodeBefore = $from.nodeBefore;
        if (nodeBefore && nodeBefore.type.name === this.name) {
          const tr = state.tr.delete($from.pos - nodeBefore.nodeSize, $from.pos);
          dispatch(tr);
          return true;
        }
        return false;
      }
    };
  }
});
const mention = { tagMention: tagMention$1, userMention: userMention$1 };
const iframe = Node.create({
  name: "iframe",
  group: "block",
  atom: true,
  draggable: true,
  addAttributes() {
    return {
      src: {
        default: null
      },
      scrolling: {
        default: "no"
      },
      width: {
        default: "100%"
      },
      height: {
        default: "500"
      },
      frameborder: {
        default: "0"
      },
      allowfullscreen: {
        default: true
      }
    };
  },
  parseHTML() {
    return [
      {
        tag: "iframe",
        getAttrs: (dom) => {
          return {
            src: dom.getAttribute("src"),
            width: dom.getAttribute("width"),
            height: dom.getAttribute("height")
          };
        }
      }
    ];
  },
  renderHTML({ HTMLAttributes, node }) {
    return [
      "figure",
      {
        class: "wp-block-iframe relative w-fit mx-auto",
        "data-node-type": "iframe"
      },
      ["iframe", mergeAttributes(HTMLAttributes, {})]
    ];
  }
});
const figure = Node.create({
  name: "gallery",
  group: "block",
  content: "image*",
  draggable: true,
  atom: true,
  selectable: false,
  editable: false,
  addAttributes() {
    return {
      class: { default: null },
      columns: { default: 4 }
      // Add columns attribute with a default value
    };
  },
  parseHTML() {
    return [
      {
        tag: "figure.wp-block-gallery",
        getAttrs: (node) => {
          const columnsMatch = node.className.match(/columns-(\d+)/);
          const columns = columnsMatch ? Number(columnsMatch[1]) : 4;
          return {
            class: `wp-block-gallery has-nested-images columns-${columns} is-cropped is-layout-flex wp-block-gallery-is-layout-flex`,
            columns
            // Extract columns value from class
          };
        }
      }
    ];
  },
  addNodeView() {
    return VueNodeViewRenderer(_sfc_main$1, { editor: this.editor });
  },
  renderHTML({ node }) {
    return [
      "figure",
      mergeAttributes(this.options.HTMLAttributes, {
        class: `wp-block-gallery has-nested-images columns-${node.attrs.columns} is-cropped wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex`
      }),
      0
    ];
  }
});
const Audio = Node.create({
  name: "audio",
  // 节点名称
  group: "block",
  // 属于块级元素
  draggable: true,
  // 允许拖动
  // 定义节点的属性（如 src）
  addAttributes() {
    return {
      src: {
        default: null
      },
      title: {
        default: null
      }
    };
  },
  // 解析 HTML 时匹配 <audio> 标签
  parseHTML() {
    return [
      {
        tag: "audio",
        // 匹配 <audio> 标签
        getAttrs: (dom) => {
          const src = dom.getAttribute("src");
          if (src) {
            let title = dom.getAttribute("data-title");
            if (!title) {
              title = useUtils.getFileName(src);
            }
            return { src, title };
          }
          const source = dom.querySelector("source");
          if (source) {
            const src2 = source.getAttribute("src");
            let title = dom.getAttribute("data-title");
            if (src2) {
              if (!title) {
                title = useUtils.getFileName(src2);
              }
              return { src: src2, title };
            }
          }
          const fallbackLink = dom.querySelector("a");
          if (fallbackLink) {
            const src2 = fallbackLink.getAttribute("href");
            let title = dom.getAttribute("data-title");
            if (src2) {
              if (!title) {
                title = useUtils.getFileName(src2);
              }
              return { src: src2, title };
            }
          }
          return null;
        }
      }
    ];
  },
  // 渲染为指定的 HTML 结构
  renderHTML({ HTMLAttributes }) {
    return [
      "figure",
      { class: "wp-block-audio" },
      // 外层 <figure> 包裹
      ["audio", mergeAttributes(HTMLAttributes, { controls: true })]
      // <audio controls src="...">
    ];
  },
  // （可选）用 React 组件渲染
  addNodeView() {
    return VueNodeViewRenderer(_sfc_main$2);
  }
});
const video = Node.create({
  name: "video",
  // 节点名称
  group: "block",
  // 属于块级元素
  draggable: true,
  // 允许拖动
  // 定义节点的属性（如 src）
  addAttributes() {
    return {
      src: {
        default: null
      },
      title: {
        default: null
      },
      width: {
        default: 0
      },
      height: {
        default: 0
      }
    };
  },
  // 解析 HTML 时匹配 <audio> 标签
  parseHTML() {
    return [
      {
        tag: "video",
        // 匹配 <audio> 标签
        getAttrs: (dom) => {
          const src = dom.getAttribute("src");
          if (src) {
            let title = dom.getAttribute("data-title");
            if (!title) {
              title = useUtils.getFileName(src);
            }
            let width = dom.getAttribute("width") || 0;
            let height = dom.getAttribute("height") || 0;
            return { src, title, width, height };
          }
          const source = dom.querySelector("source");
          if (source) {
            const src2 = source.getAttribute("src");
            let title = dom.getAttribute("data-title");
            if (src2) {
              if (!title) {
                title = useUtils.getFileName(src2);
              }
              let width = source.getAttribute("width") || 0;
              let height = source.getAttribute("height") || 0;
              return { src: src2, title, width, height };
            }
          }
          const fallbackLink = dom.querySelector("a");
          if (fallbackLink) {
            const src2 = fallbackLink.getAttribute("href");
            let title = dom.getAttribute("data-title");
            if (src2) {
              if (!title) {
                title = useUtils.getFileName(src2);
              }
              let width = fallbackLink.getAttribute("width") || 0;
              let height = fallbackLink.getAttribute("height") || 0;
              return { src: src2, title, width, height };
            }
          }
          return null;
        }
      }
    ];
  },
  // 渲染为指定的 HTML 结构
  renderHTML({ HTMLAttributes }) {
    return [
      "figure",
      { class: "wp-block-video" },
      // 外层 <figure> 包裹
      ["video", mergeAttributes(HTMLAttributes, { controls: true })]
      // <audio controls src="...">
    ];
  },
  // （可选）用 React 组件渲染
  addNodeView() {
    return VueNodeViewRenderer(_sfc_main$3);
  }
});
const attachment = Node.create({
  name: "attachment",
  // 节点名称
  group: "block",
  // 属于块级元素
  draggable: true,
  // 允许拖动
  // 定义节点的属性（如 src）
  addAttributes() {
    return {
      src: {
        default: null
      },
      title: {
        default: null
      },
      fileSize: {
        default: null
      },
      unzipPassword: {
        default: null
      },
      extractionCode: {
        default: null
      },
      ext: {
        default: null
      },
      href: {
        default: null
      }
    };
  },
  // 解析 HTML 时匹配 <a> 标签
  parseHTML() {
    return [
      {
        tag: "attachment",
        // 匹配 <a> 标签
        getAttrs: (dom) => {
          const src = dom.getAttribute("href");
          if (!src) {
            return null;
          }
          let title = "";
          if (src) {
            title = dom.getAttribute("data-title") || dom.innerText;
            if (!title) {
              title = useUtils.getFileName(src);
            }
          }
          const fileSize = dom.getAttribute("data-file-size");
          const unzipPassword = dom.getAttribute("data-unzip-password");
          const extractionCode = dom.getAttribute("data-extraction-code");
          const ext = useUtils.getFileExtension(src);
          return { src, title, fileSize, unzipPassword, extractionCode, ext };
        }
      }
    ];
  },
  // 渲染为指定的 HTML 结构
  renderHTML({ HTMLAttributes }) {
    return [
      "figure",
      { class: "wp-block-attachment" },
      // 外层 <figure> 包裹
      ["attachment", mergeAttributes(HTMLAttributes, { controls: true })]
      // <audio controls src="...">
    ];
  },
  // （可选）用 React 组件渲染
  addNodeView() {
    return VueNodeViewRenderer(_sfc_main$4);
  }
});
const image = Node.create({
  name: "image",
  // 节点名称
  group: "block",
  // 属于块级元素
  draggable: true,
  // 允许拖动
  // 定义节点的属性（如 src）
  addAttributes() {
    return {
      src: {
        default: null
      },
      caption: {
        default: null
      },
      width: {
        default: null
      },
      title: {
        default: null
      },
      height: {
        default: null
      },
      alt: {
        default: null
      },
      class: {
        default: null
      }
    };
  },
  // 解析 HTML 时匹配 <img> 标签
  parseHTML() {
    return [
      {
        tag: "img",
        // 匹配 <img> 标签
        getAttrs: (dom) => {
          let caption = dom.getAttribute("caption");
          const figcaption = dom.nextSibling;
          if (figcaption && figcaption.tagName === "FIGCAPTION") {
            caption = figcaption.textContent;
            figcaption.remove();
          }
          const parent = dom.closest(".gallery-item");
          if (parent) {
            const parentSibling = parent.querySelector("figcaption");
            if (parentSibling) {
              caption = parentSibling.textContent;
              parentSibling.remove();
            }
          }
          return {
            src: dom.getAttribute("src"),
            caption: caption || dom.getAttribute("alt"),
            width: dom.getAttribute("width"),
            height: dom.getAttribute("height"),
            alt: dom.getAttribute("alt"),
            class: dom.getAttribute("class"),
            title: dom.getAttribute("title")
          };
        }
      }
    ];
  },
  // 渲染为指定的 HTML 结构
  renderHTML({ HTMLAttributes, node }) {
    return [
      "figure",
      {
        class: "wp-block-image relative w-fit mx-auto",
        "data-node-type": "image"
      },
      ["img", mergeAttributes(HTMLAttributes, {})],
      // 添加 figcaption（如果 caption 存在）
      ["figcaption", {}, node.attrs.caption ?? ""]
    ];
  },
  addNodeView() {
    return VueNodeViewRenderer(_sfc_main$5);
  }
});
const { tagMention, userMention } = mention;
const {
  link,
  table,
  starterKit
  // tableCell,
  // tableHeader,
  // tableRow,
} = customKit;
const gqTagMention = tagMention;
const gqUserMention = userMention;
const gqLink = link;
const gqTable = table;
const gqStarterKit = starterKit;
const gqIframe = iframe;
const gqGallery = figure;
const gqWpAudio = Audio;
const gqWpVideo = video;
const gqWpAttachment = attachment;
const gqWpImage = image;

export { gqTable as a, gqLink as b, gqUserMention as c, gqIframe as d, gqTagMention as e, gqGallery as f, gqStarterKit as g, gqWpAudio as h, gqWpVideo as i, gqWpAttachment as j, gqWpImage as k };
