import { computed, mergeProps, unref, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderAttr, ssrInterpolate } from 'vue/server-renderer';

const _sfc_main = {
  __name: "ModulesCommonTopicFile",
  __ssrInlineRender: true,
  props: ["data"],
  setup(__props) {
    const props = __props;
    const fileName = computed(() => {
      return decodeURIComponent(
        props.data[0].src.split("/").pop().substring(0, props.data[0].src.split("/").pop().lastIndexOf("."))
      );
    });
    return (_ctx, _push, _parent, _attrs) => {
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative wp-block-file w-fit mx-auto @md:max-w-120 max-w-full" }, _attrs))}><div class="file-content flex"><div class="flex flex-col justify-center"><div class="flex items-center gap-2"><a${ssrRenderAttr("href", __props.data[0].src)} target="_blank" download>${ssrInterpolate(__props.data[0].name || unref(fileName))}</a>`);
      if (__props.data[0].size) {
        _push(`<div class="opacity-80 text-[10px] text-[--el-color-info-dark-2]">${ssrInterpolate(__props.data[0].size)}</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      if (__props.data[0].unzipPassword || __props.data[0].extractionCode) {
        _push(`<div class="text-xs opacity-80 flex items-center gap-3 mt-1">`);
        if (__props.data[0].unzipPassword) {
          _push(`<span>${ssrInterpolate(_ctx.$t("common.unzipPassword"))}:${ssrInterpolate(__props.data[0].unzipPassword)}</span>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.data[0].extractionCode) {
          _push(`<span>${ssrInterpolate(_ctx.$t("common.extractionCode"))}:${ssrInterpolate(__props.data[0].extractionCode)}</span>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="file-ext uppercase text-[10px]">${ssrInterpolate(__props.data[0].ext)}</div></div></div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/file.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
