import { E as ElButton } from './index-DYnTqrQe.mjs';
import { r as useRequest } from './server.mjs';
import { ref, mergeProps, unref, withCtx, openBlock, createBlock, createCommentVNode, createTextVNode, toDisplayString, useSSRContext } from 'vue';
import { ssrRenderComponent, ssrInterpolate } from 'vue/server-renderer';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonButtonFollow",
  __ssrInlineRender: true,
  props: ["data", "style"],
  setup(__props) {
    const props = __props;
    const hover = ref(false);
    const submitLocked = ref(false);
    const follow = async () => {
      if (submitLocked.value) {
        return;
      }
      submitLocked.value = true;
      const res = await useRequest("/api/request", {
        body: {
          data: {
            id: props.data.databaseId
          }
        }
      });
      if (res) {
        props.data.gqFollowed = res.gqToggleFollowUser?.followStatus;
        if (props.data.gqFollowed) {
          props.data.gqFollowers += 1;
        } else {
          props.data.gqFollowers -= 1;
        }
      }
      submitLocked.value = false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      if (!__props.data?.gqFollowed) {
        _push(ssrRenderComponent(_component_el_button, mergeProps({
          class: "overflow-hidden",
          type: "primary",
          onClick: follow,
          loading: unref(submitLocked)
        }, _attrs), {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (!unref(submitLocked)) {
                _push2(`<i class="i-ph-plus-bold mr-1"${_scopeId}></i>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`${ssrInterpolate(_ctx.$t("common.follow.follow"))}`);
            } else {
              return [
                !unref(submitLocked) ? (openBlock(), createBlock("i", {
                  key: 0,
                  class: "i-ph-plus-bold mr-1"
                })) : createCommentVNode("", true),
                createTextVNode(toDisplayString(_ctx.$t("common.follow.follow")), 1)
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(ssrRenderComponent(_component_el_button, mergeProps({
          class: "overflow-hidden",
          type: "info",
          plain: "",
          loading: unref(submitLocked),
          onMouseenter: ($event) => hover.value = true,
          onMouseleave: ($event) => hover.value = false,
          onClick: follow
        }, _attrs), {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (!unref(hover)) {
                _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("common.follow.followed"))}</span>`);
              } else {
                _push2(`<span class="opacity-80"${_scopeId}>${ssrInterpolate(_ctx.$t("common.follow.unfollow"))}</span>`);
              }
            } else {
              return [
                !unref(hover) ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("common.follow.followed")), 1)) : (openBlock(), createBlock("span", {
                  key: 1,
                  class: "opacity-80"
                }, toDisplayString(_ctx.$t("common.follow.unfollow")), 1))
              ];
            }
          }),
          _: 1
        }, _parent));
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/button/follow.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
