import { V as useNuxtApp, k as deviceStore, g as getServerSettings, j as actionStore, x as __nuxt_component_0$1 } from './server.mjs';
import { useSSRContext, computed, ref, mergeProps, unref } from 'vue';
import { ssrRenderAttrs, ssrRenderClass, ssrInterpolate, ssrRenderComponent, ssrRenderStyle } from 'vue/server-renderer';
import { a as audioStore } from './audio-CfS8Ng0x.mjs';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "Footer",
  __ssrInlineRender: true,
  setup(__props) {
    const { $serverSettings } = useNuxtApp();
    audioStore();
    const device = deviceStore();
    const settings = getServerSettings();
    computed(() => {
      return settings?.page_settings?.[device.currentDevice]?.global?.sideMenu || [];
    });
    actionStore();
    ref(false);
    ref(null);
    const getFooterStyle = computed(
      () => $serverSettings?.page_settings?.[device.currentDevice]?.footer || {}
    );
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(`<footer${ssrRenderAttrs(mergeProps({
        class: `w-full gq-footer container-box text-[var(--gq-footer-textColor)] dark:!text-[--el-text-color-primary]  relative dark:!bg-[--el-bg-color] bg-[var(--gq-footer-backgroundColor)] ${unref(device).isMobile ? "pb-16 pt-2" : ""}`,
        style: `
  --gq-footer-backgroundColor:${unref(getFooterStyle).backgroundColor};
    --gq-footer-textColor:${unref(getFooterStyle).textColor};
    --gq-footer-width:${unref(getFooterStyle).width};
  `
      }, _attrs))} data-v-248cd42d><div class="${ssrRenderClass(`w-full top-0 px-4 ${unref(device).isDesktop ? "h-20 w-[var(--gq-footer-width)]" : ""} mx-auto gruop text-${unref(getFooterStyle).textSize} relative grid max-w-full flex flex-col justify-center gap-2 py-2`)}" data-v-248cd42d>`);
      if (unref(getFooterStyle).textHtmlLastRow) {
        _push(`<div data-v-248cd42d>${unref(getFooterStyle).textHtmlLastRow ?? ""}</div>`);
      } else {
        _push(`<div class="flex items-center gap-2" data-v-248cd42d><span data-v-248cd42d>Copyright © 2026 ${ssrInterpolate(unref($serverSettings)?.name[_ctx.$i18n.locale])}</span></div>`);
      }
      _push(`</div>`);
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`<div class="grid-cols-4 font-bold p-1.6 -mt-[--tpt] -z-10 hover:shadow-lg grid-cols-3 grid-cols-2 grid-cols-1 grid-cols-5 p-4 !bg-transparent mt-6 mt-7 p-6 p-7 p-8 p-9 p-10 p-11 p-12 gap-8 mt-8 gap-9 mt-9 gap-10 mt-10 gap-11 mt-11 gap-12 mt-12 line-clamp-4 line-clamp-3 line-clamp-2 line-clamp-1 line-clamp-5 line-clamp-6 line-clamp-7 line-clamp-8 line-clamp-9 line-clamp-10 line-clamp-11 line-clamp-12" style="${ssrRenderStyle({ "display": "none" })}" data-v-248cd42d><i class="i-ph-crown-duotone" data-v-248cd42d></i><i class="i-ph-currency-circle-dollar-duotone" data-v-248cd42d></i><i class="i-ph-ticket-duotone" data-v-248cd42d></i><i class="i-ph-clipboard-text-duotone" data-v-248cd42d></i><i class="i-ph-shopping-cart-duotone" data-v-248cd42d></i><i class="i-ph-invoice-duotone" data-v-248cd42d></i><i class="i-ph-share-network-duotone" data-v-248cd42d></i><i class="i-ph-shield-checkered-duotone" data-v-248cd42d></i><i class="i-ph-calendar-heart-duotone" data-v-248cd42d></i><i class="i-ph-notebook-duotone" data-v-248cd42d></i><i class="i-ph-note-pencil-duotone" data-v-248cd42d></i><i class="i-ph-bell-duotone" data-v-248cd42d></i><i class="i-ph-gear-duotone" data-v-248cd42d></i><i class="i-ph-headset" data-v-248cd42d></i><i class="i-ph-question" data-v-248cd42d></i><i class="i-ph-chats" data-v-248cd42d></i><i class="i-ph-rocket" data-v-248cd42d></i><i class="i-ph-music-notes" data-v-248cd42d></i><i class="i-ph-download-simple" data-v-248cd42d></i></div></footer>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/footer.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_2 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-248cd42d"]]);

export { __nuxt_component_2 as default };
