import { E as ElForm, a as ElFormItem } from './index-DwNba9hO.mjs';
import { E as ElInput } from './index-Cs8YDU9s.mjs';
import { E as ElInputNumber } from './input-number-ClYhMUuv.mjs';
import { E as ElDatePicker } from './date-picker-panel-rcoVm3W9.mjs';
import { pick, debounce, isNil } from 'lodash-unified';
import { j as actionStore, a as useI18n, w as isLogin, e as useUtils, P as withInstall, r as useRequest, E as ElMessage, D as useLocale, C as useNamespace, aA as useEmptyValues, b2 as reactiveComputed, G as arrow_down_default, ag as close_default, a0 as buildProps, aD as useEmptyValuesProps, K as useSizeProp, a2 as definePropType, O as debugWarn } from './server.mjs';
import { u as useAriaProps } from './index-DRiwogtD.mjs';
import { E as ElTooltip, u as useTooltipContentProps } from './index-Cx5QSQzK.mjs';
import { isString, hasOwn } from '@vue/shared';
import { C as CHANGE_EVENT, U as UPDATE_MODEL_EVENT } from './event-BZTOGHfp.mjs';
import { ref, watch, computed, unref, withCtx, openBlock, createBlock, Fragment, renderList, createTextVNode, toDisplayString, createVNode, createCommentVNode, mergeProps, withDirectives, vShow, defineComponent, nextTick, provide, createElementVNode, normalizeClass, normalizeStyle, withKeys, reactive, inject, createElementBlock, renderSlot, getCurrentInstance, shallowRef, watchEffect, useSSRContext } from 'vue';
import { E as ElIcon } from './index-CRbm0e05.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import { a as addUnit } from './style-h263bamF.mjs';
import { g as getEventCode, b as EVENT_CODE } from './focus-trap.vue-9ChHxs3Q.mjs';
import { TinyColor } from '@ctrl/tinycolor';
import { a as useFormItem, b as useFormSize, u as useFormDisabled, c as useFormItemInputId } from './use-form-item-Cr81A1TZ.mjs';
import { C as ClickOutside } from './index-BY8mj3AC.mjs';
import { u as useFocusController } from './index-Bp-nwGzu.mjs';
import _sfc_main$7 from './phone-D8cBJ6ei.mjs';
import { E as ElSelect, a as ElOption } from './index-03hfIBa_.mjs';
import { E as ElRadioGroup, a as ElRadio } from './index-CCMOIr7X.mjs';
import { E as ElCheckboxGroup, a as ElCheckbox } from './index-VQeHi7JP.mjs';
import _sfc_main$8 from './file-DHwRUS-x.mjs';
import _sfc_main$9 from './pay-BTaGR_Lz.mjs';
import { v as vLoading } from './directive-BPPM1aUC.mjs';
import { ssrRenderAttrs, ssrRenderComponent, ssrRenderList, ssrInterpolate, ssrGetDirectiveProps } from 'vue/server-renderer';
import './constants-hAKFmBbq.mjs';
import 'async-validator';
import './index-ChPMoinw.mjs';
import './index-BKB3Djp4.mjs';
import './index-D3BlhKEk.mjs';
import 'dayjs';
import 'dayjs/plugin/customParseFormat.js';
import 'dayjs/plugin/advancedFormat.js';
import 'dayjs/plugin/localeData.js';
import 'dayjs/plugin/weekOfYear.js';
import 'dayjs/plugin/weekYear.js';
import 'dayjs/plugin/dayOfYear.js';
import 'dayjs/plugin/isSameOrAfter.js';
import 'dayjs/plugin/isSameOrBefore.js';
import './index-tCyBRCDx.mjs';
import '@popperjs/core';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './aria-BhThsKez.mjs';
import './index-31HAFSrO.mjs';
import './countryDialCodes-DK3oAU-H.mjs';
import './popover-B8HtRMY4.mjs';
import './vnode-l2ZP2UQa.mjs';
import './Image-BE6Y-a3S.mjs';
import './image-viewer-DG2qIWb8.mjs';
import './index-Di0Jlzch.mjs';
import './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './creditIcon-eOdkwofx.mjs';
import './svgIcon-BpIUCf-e.mjs';

const colorPickerPanelProps = buildProps({
  /**
   * @description binding value
   */
  modelValue: {
    type: definePropType(String),
    default: void 0
  },
  /**
   * @description whether the color picker is bordered
   */
  border: {
    type: Boolean,
    default: true
  },
  /**
   * @description whether to display the alpha slider
   */
  showAlpha: Boolean,
  /**
   * @description color format of v-model
   */
  colorFormat: String,
  /**
   * @description whether to disable the color picker
   */
  disabled: Boolean,
  /**
   * @description predefined color options
   */
  predefine: {
    type: definePropType(Array)
  },
  /**
   * @description whether to trigger form validation
   */
  validateEvent: {
    type: Boolean,
    default: true
  }
});
const colorPickerPanelEmits = {
  [UPDATE_MODEL_EVENT]: (val) => isString(val) || isNil(val)
};
const ROOT_COMMON_COLOR_INJECTION_KEY = /* @__PURE__ */ Symbol("colorCommonPickerKey");
const colorPickerPanelContextKey = /* @__PURE__ */ Symbol("colorPickerPanelContextKey");
const alphaSliderProps = buildProps({
  color: {
    type: definePropType(Object),
    required: true
  },
  vertical: Boolean,
  disabled: Boolean
});
const hueSliderProps = alphaSliderProps;
const getClientXY = (event) => {
  let clientX;
  let clientY;
  if (event.type === "touchend") {
    clientY = event.changedTouches[0].clientY;
    clientX = event.changedTouches[0].clientX;
  } else if (event.type.startsWith("touch")) {
    clientY = event.touches[0].clientY;
    clientX = event.touches[0].clientX;
  } else {
    clientY = event.clientY;
    clientX = event.clientX;
  }
  return {
    clientX,
    clientY
  };
};
const useSlider = (props, { key, minValue: minValue2, maxValue: maxValue2 }) => {
  const instance = getCurrentInstance();
  const thumb = shallowRef();
  const bar = shallowRef();
  const currentValue = computed(() => props.color.get(key));
  function handleClick(event) {
    var _a;
    if (props.disabled) return;
    const target = event.target;
    if (target !== thumb.value) {
      handleDrag(event);
    }
    (_a = thumb.value) == null ? void 0 : _a.focus();
  }
  function handleDrag(event) {
    if (!bar.value || !thumb.value || props.disabled) return;
    const el = instance.vnode.el;
    const rect = el.getBoundingClientRect();
    const { clientX, clientY } = getClientXY(event);
    let value;
    if (!props.vertical) {
      let left = clientX - rect.left;
      left = Math.max(thumb.value.offsetWidth / 2, left);
      left = Math.min(left, rect.width - thumb.value.offsetWidth / 2);
      value = Math.round(
        (left - thumb.value.offsetWidth / 2) / (rect.width - thumb.value.offsetWidth) * maxValue2
      );
    } else {
      let top = clientY - rect.top;
      top = Math.max(thumb.value.offsetHeight / 2, top);
      top = Math.min(top, rect.height - thumb.value.offsetHeight / 2);
      value = Math.round(
        (top - thumb.value.offsetHeight / 2) / (rect.height - thumb.value.offsetHeight) * maxValue2
      );
    }
    props.color.set(key, value);
  }
  function handleKeydown(event) {
    if (props.disabled) return;
    const { shiftKey } = event;
    const code = getEventCode(event);
    const step = shiftKey ? 10 : 1;
    const reverse = key === "hue" ? -1 : 1;
    let isPreventDefault = true;
    switch (code) {
      case EVENT_CODE.left:
      case EVENT_CODE.down:
        incrementPosition(-step * reverse);
        break;
      case EVENT_CODE.right:
      case EVENT_CODE.up:
        incrementPosition(step * reverse);
        break;
      case EVENT_CODE.home:
        props.color.set(key, key === "hue" ? maxValue2 : minValue2);
        break;
      case EVENT_CODE.end:
        props.color.set(key, key === "hue" ? minValue2 : maxValue2);
        break;
      case EVENT_CODE.pageDown:
        incrementPosition(-4 * reverse);
        break;
      case EVENT_CODE.pageUp:
        incrementPosition(4 * reverse);
        break;
      default:
        isPreventDefault = false;
        break;
    }
    isPreventDefault && event.preventDefault();
  }
  function incrementPosition(step) {
    let next = currentValue.value + step;
    next = next < minValue2 ? minValue2 : next > maxValue2 ? maxValue2 : next;
    props.color.set(key, next);
  }
  return {
    thumb,
    bar,
    currentValue,
    handleDrag,
    handleClick,
    handleKeydown
  };
};
const useSliderDOM = (props, {
  namespace,
  maxValue: maxValue2,
  bar,
  thumb,
  currentValue,
  handleDrag,
  getBackground
}) => {
  const instance = getCurrentInstance();
  const ns = useNamespace(namespace);
  const thumbLeft = ref(0);
  const thumbTop = ref(0);
  const background = ref();
  function getThumbLeft() {
    if (!thumb.value) return 0;
    if (props.vertical) return 0;
    const el = instance.vnode.el;
    const value = currentValue.value;
    if (!el) return 0;
    return Math.round(
      value * (el.offsetWidth - thumb.value.offsetWidth / 2) / maxValue2
    );
  }
  function getThumbTop() {
    if (!thumb.value) return 0;
    const el = instance.vnode.el;
    if (!props.vertical) return 0;
    const value = currentValue.value;
    if (!el) return 0;
    return Math.round(
      value * (el.offsetHeight - thumb.value.offsetHeight / 2) / maxValue2
    );
  }
  function update() {
    thumbLeft.value = getThumbLeft();
    thumbTop.value = getThumbTop();
    background.value = getBackground == null ? void 0 : getBackground();
  }
  watch(currentValue, () => update());
  watch(
    () => props.color.value,
    () => update()
  );
  const rootKls = computed(() => [
    ns.b(),
    ns.is("vertical", props.vertical),
    ns.is("disabled", props.disabled)
  ]);
  const barKls = computed(() => ns.e("bar"));
  const thumbKls = computed(() => ns.e("thumb"));
  const barStyle = computed(() => ({ background: background.value }));
  const thumbStyle = computed(() => ({
    left: addUnit(thumbLeft.value),
    top: addUnit(thumbTop.value)
  }));
  return {
    rootKls,
    barKls,
    barStyle,
    thumbKls,
    thumbStyle,
    thumbLeft,
    thumbTop,
    update
  };
};
const _hoisted_1$4 = ["aria-label", "aria-valuenow", "aria-valuetext", "aria-orientation", "tabindex", "aria-disabled"];
const minValue$1 = 0;
const maxValue$1 = 100;
var _sfc_main$6 = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElColorAlphaSlider"
  },
  __name: "alpha-slider",
  props: alphaSliderProps,
  setup(__props, { expose: __expose }) {
    const props = __props;
    const { currentValue, bar, thumb, handleDrag, handleClick, handleKeydown } = useSlider(props, { key: "alpha", minValue: minValue$1, maxValue: maxValue$1 });
    const { rootKls, barKls, barStyle, thumbKls, thumbStyle, update } = useSliderDOM(props, {
      namespace: "color-alpha-slider",
      maxValue: maxValue$1,
      currentValue,
      bar,
      thumb,
      handleDrag,
      getBackground
    });
    const { t } = useLocale();
    const ariaLabel = computed(() => t("el.colorpicker.alphaLabel"));
    const ariaValuetext = computed(() => {
      return t("el.colorpicker.alphaDescription", {
        alpha: currentValue.value,
        color: props.color.value
      });
    });
    function getBackground() {
      if (props.color && props.color.value) {
        const { r, g, b } = props.color.toRgb();
        return `linear-gradient(to right, rgba(${r}, ${g}, ${b}, 0) 0%, rgba(${r}, ${g}, ${b}, 1) 100%)`;
      }
      return "";
    }
    __expose({
      /**
       * @description update alpha slider manually
       * @type {Function}
       */
      update,
      /**
       * @description bar element ref
       * @type {HTMLElement}
       */
      bar,
      /**
       * @description thumb element ref
       * @type {HTMLElement}
       */
      thumb
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          class: normalizeClass(unref(rootKls))
        },
        [
          createElementVNode(
            "div",
            {
              ref_key: "bar",
              ref: bar,
              class: normalizeClass(unref(barKls)),
              style: normalizeStyle(unref(barStyle)),
              onClick: _cache[0] || (_cache[0] = //@ts-ignore
              (...args) => unref(handleClick) && unref(handleClick)(...args))
            },
            null,
            6
            /* CLASS, STYLE */
          ),
          createElementVNode("div", {
            ref_key: "thumb",
            ref: thumb,
            class: normalizeClass(unref(thumbKls)),
            style: normalizeStyle(unref(thumbStyle)),
            "aria-label": ariaLabel.value,
            "aria-valuenow": unref(currentValue),
            "aria-valuetext": ariaValuetext.value,
            "aria-orientation": __props.vertical ? "vertical" : "horizontal",
            "aria-valuemin": minValue$1,
            "aria-valuemax": maxValue$1,
            role: "slider",
            tabindex: __props.disabled ? void 0 : 0,
            "aria-disabled": __props.disabled,
            onKeydown: _cache[1] || (_cache[1] = //@ts-ignore
            (...args) => unref(handleKeydown) && unref(handleKeydown)(...args))
          }, null, 46, _hoisted_1$4)
        ],
        2
        /* CLASS */
      );
    };
  }
});
const _hoisted_1$3 = ["aria-label", "aria-valuenow", "aria-valuetext", "aria-orientation", "tabindex", "aria-disabled"];
const minValue = 0;
const maxValue = 360;
var _sfc_main$5 = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElColorHueSlider"
  },
  __name: "hue-slider",
  props: hueSliderProps,
  setup(__props, { expose: __expose }) {
    const props = __props;
    const { currentValue, bar, thumb, handleDrag, handleClick, handleKeydown } = useSlider(props, { key: "hue", minValue, maxValue });
    const { rootKls, barKls, thumbKls, thumbStyle, thumbTop, update } = useSliderDOM(props, {
      namespace: "color-hue-slider",
      maxValue,
      currentValue,
      bar,
      thumb,
      handleDrag
    });
    const { t } = useLocale();
    const ariaLabel = computed(() => t("el.colorpicker.hueLabel"));
    const ariaValuetext = computed(() => {
      return t("el.colorpicker.hueDescription", {
        hue: currentValue.value,
        color: props.color.value
      });
    });
    __expose({
      /**
       * @description bar element ref
       */
      bar,
      /**
       * @description thumb element ref
       */
      thumb,
      /**
       * @description thumb top position, only for vertical slider
       */
      thumbTop,
      /**
       * @description update hue slider manually
       */
      update
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          class: normalizeClass(unref(rootKls))
        },
        [
          createElementVNode(
            "div",
            {
              ref_key: "bar",
              ref: bar,
              class: normalizeClass(unref(barKls)),
              onClick: _cache[0] || (_cache[0] = //@ts-ignore
              (...args) => unref(handleClick) && unref(handleClick)(...args))
            },
            null,
            2
            /* CLASS */
          ),
          createElementVNode("div", {
            ref_key: "thumb",
            ref: thumb,
            class: normalizeClass(unref(thumbKls)),
            style: normalizeStyle(unref(thumbStyle)),
            "aria-label": ariaLabel.value,
            "aria-valuenow": unref(currentValue),
            "aria-valuetext": ariaValuetext.value,
            "aria-orientation": __props.vertical ? "vertical" : "horizontal",
            "aria-valuemin": minValue,
            "aria-valuemax": maxValue,
            role: "slider",
            tabindex: __props.disabled ? void 0 : 0,
            "aria-disabled": __props.disabled,
            onKeydown: _cache[1] || (_cache[1] = //@ts-ignore
            (...args) => unref(handleKeydown) && unref(handleKeydown)(...args))
          }, null, 46, _hoisted_1$3)
        ],
        2
        /* CLASS */
      );
    };
  }
});
const predefineProps = buildProps({
  colors: {
    type: definePropType(Array),
    required: true
  },
  color: {
    type: definePropType(Object),
    required: true
  },
  enableAlpha: {
    type: Boolean,
    required: true
  },
  disabled: Boolean
});
var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
class Color {
  constructor(options = {}) {
    __publicField(this, "_hue", 0);
    __publicField(this, "_saturation", 100);
    __publicField(this, "_value", 100);
    __publicField(this, "_alpha", 100);
    __publicField(this, "_tiny", new TinyColor());
    __publicField(this, "_isValid", false);
    __publicField(this, "enableAlpha", false);
    __publicField(this, "format", "");
    __publicField(this, "value", "");
    __publicField(this, "selected");
    for (const option in options) {
      if (hasOwn(options, option)) {
        this[option] = options[option];
      }
    }
    if (options.value) {
      this.fromString(options.value);
    } else {
      this.doOnChange();
    }
  }
  set(prop, value) {
    if (arguments.length === 1 && typeof prop === "object") {
      for (const p in prop) {
        if (hasOwn(prop, p)) {
          this.set(p, prop[p]);
        }
      }
      return;
    }
    this[`_${prop}`] = value;
    this._isValid = true;
    this.doOnChange();
  }
  get(prop) {
    if (["hue", "saturation", "value", "alpha"].includes(prop)) {
      return Math.round(this[`_${prop}`]);
    }
    return this[`_${prop}`];
  }
  toRgb() {
    return this._isValid ? this._tiny.toRgb() : { r: 255, g: 255, b: 255, a: 0 };
  }
  fromString(value) {
    const color = new TinyColor(value);
    this._isValid = color.isValid;
    if (color.isValid) {
      const { h, s, v, a } = color.toHsv();
      this._hue = h;
      this._saturation = s * 100;
      this._value = v * 100;
      this._alpha = a * 100;
    } else {
      this._hue = 0;
      this._saturation = 100;
      this._value = 100;
      this._alpha = 100;
    }
    this.doOnChange();
  }
  clear() {
    this._isValid = false;
    this.value = "";
    this._hue = 0;
    this._saturation = 100;
    this._value = 100;
    this._alpha = 100;
  }
  compare(color) {
    const compareColor = new TinyColor({
      h: color._hue,
      s: color._saturation / 100,
      v: color._value / 100,
      a: color._alpha / 100
    });
    return this._tiny.equals(compareColor);
  }
  doOnChange() {
    const { _hue, _saturation, _value, _alpha, format, enableAlpha } = this;
    let _format = format || (enableAlpha ? "rgb" : "hex");
    if (format === "hex" && enableAlpha) {
      _format = "hex8";
    }
    this._tiny = new TinyColor({
      h: _hue,
      s: _saturation / 100,
      v: _value / 100,
      a: _alpha / 100
    });
    this.value = this._isValid ? this._tiny.toString(_format) : "";
  }
}
const usePredefine = (props) => {
  const { currentColor } = inject(colorPickerPanelContextKey);
  const rgbaColors = ref(parseColors(props.colors, props.color));
  watch(
    () => currentColor.value,
    (val) => {
      const color = new Color({
        value: val,
        enableAlpha: props.enableAlpha
      });
      rgbaColors.value.forEach((item) => {
        item.selected = color.compare(item);
      });
    }
  );
  watchEffect(() => {
    rgbaColors.value = parseColors(props.colors, props.color);
  });
  function handleSelect(index) {
    props.color.fromString(props.colors[index]);
  }
  function parseColors(colors, color) {
    return colors.map((value) => {
      const c = new Color({
        value,
        enableAlpha: props.enableAlpha
      });
      c.selected = c.compare(color);
      return c;
    });
  }
  return {
    rgbaColors,
    handleSelect
  };
};
const usePredefineDOM = (props) => {
  const ns = useNamespace("color-predefine");
  const rootKls = computed(() => [ns.b(), ns.is("disabled", props.disabled)]);
  const colorsKls = computed(() => ns.e("colors"));
  function colorSelectorKls(item) {
    return [
      ns.e("color-selector"),
      ns.is("alpha", item.get("alpha") < 100),
      { selected: item.selected }
    ];
  }
  return {
    rootKls,
    colorsKls,
    colorSelectorKls
  };
};
const _hoisted_1$2 = ["disabled", "aria-label", "onClick"];
var _sfc_main$4 = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElColorPredefine"
  },
  __name: "predefine",
  props: predefineProps,
  setup(__props) {
    const props = __props;
    const { rgbaColors, handleSelect } = usePredefine(props);
    const { rootKls, colorsKls, colorSelectorKls } = usePredefineDOM(props);
    const { t } = useLocale();
    const ariaLabel = (value) => {
      return t("el.colorpicker.predefineDescription", { value });
    };
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          class: normalizeClass(unref(rootKls))
        },
        [
          createElementVNode(
            "div",
            {
              class: normalizeClass(unref(colorsKls))
            },
            [
              (openBlock(true), createElementBlock(
                Fragment,
                null,
                renderList(unref(rgbaColors), (item, index) => {
                  return openBlock(), createElementBlock("button", {
                    key: __props.colors[index],
                    type: "button",
                    disabled: __props.disabled,
                    "aria-label": ariaLabel(item.value),
                    class: normalizeClass(unref(colorSelectorKls)(item)),
                    onClick: ($event) => unref(handleSelect)(index)
                  }, [
                    createElementVNode(
                      "div",
                      {
                        style: normalizeStyle({ backgroundColor: item.value })
                      },
                      null,
                      4
                      /* STYLE */
                    )
                  ], 10, _hoisted_1$2);
                }),
                128
                /* KEYED_FRAGMENT */
              ))
            ],
            2
            /* CLASS */
          )
        ],
        2
        /* CLASS */
      );
    };
  }
});
const svPanelProps = buildProps({
  color: {
    type: definePropType(Object),
    required: true
  },
  disabled: Boolean
});
const useSvPanel = (props) => {
  const instance = getCurrentInstance();
  const cursorRef = ref();
  const cursorTop = ref(0);
  const cursorLeft = ref(0);
  const background = ref("hsl(0, 100%, 50%)");
  const saturation = computed(() => props.color.get("saturation"));
  const brightness = computed(() => props.color.get("value"));
  const hue = computed(() => props.color.get("hue"));
  function handleClick(event) {
    var _a;
    if (props.disabled) return;
    const target = event.target;
    if (target !== cursorRef.value) {
      handleDrag(event);
    }
    (_a = cursorRef.value) == null ? void 0 : _a.focus({ preventScroll: true });
  }
  function handleDrag(event) {
    if (props.disabled) return;
    const el = instance.vnode.el;
    const rect = el.getBoundingClientRect();
    const { clientX, clientY } = getClientXY(event);
    let left = clientX - rect.left;
    let top = clientY - rect.top;
    left = Math.max(0, left);
    left = Math.min(left, rect.width);
    top = Math.max(0, top);
    top = Math.min(top, rect.height);
    cursorLeft.value = left;
    cursorTop.value = top;
    props.color.set({
      saturation: left / rect.width * 100,
      value: 100 - top / rect.height * 100
    });
  }
  function handleKeydown(event) {
    if (props.disabled) return;
    const { shiftKey } = event;
    const code = getEventCode(event);
    const step = shiftKey ? 10 : 1;
    let isPreventDefault = true;
    switch (code) {
      case EVENT_CODE.left:
        incrementSaturation(-step);
        break;
      case EVENT_CODE.right:
        incrementSaturation(step);
        break;
      case EVENT_CODE.up:
        incrementBrightness(step);
        break;
      case EVENT_CODE.down:
        incrementBrightness(-step);
        break;
      default:
        isPreventDefault = false;
        break;
    }
    isPreventDefault && event.preventDefault();
  }
  function incrementSaturation(step) {
    let next = saturation.value + step;
    next = next < 0 ? 0 : next > 100 ? 100 : next;
    props.color.set("saturation", next);
  }
  function incrementBrightness(step) {
    let next = brightness.value + step;
    next = next < 0 ? 0 : next > 100 ? 100 : next;
    props.color.set("value", next);
  }
  return {
    cursorRef,
    cursorTop,
    cursorLeft,
    background,
    saturation,
    brightness,
    hue,
    handleClick,
    handleDrag,
    handleKeydown
  };
};
const useSvPanelDOM = (props, {
  cursorTop,
  cursorLeft,
  background,
  handleDrag
}) => {
  const instance = getCurrentInstance();
  const ns = useNamespace("color-svpanel");
  function update() {
    const saturation = props.color.get("saturation");
    const brightness = props.color.get("value");
    const el = instance.vnode.el;
    const { clientWidth: width, clientHeight: height } = el;
    cursorLeft.value = saturation * width / 100;
    cursorTop.value = (100 - brightness) * height / 100;
    background.value = `hsl(${props.color.get("hue")}, 100%, 50%)`;
  }
  watch(
    [
      () => props.color.get("hue"),
      () => props.color.get("value"),
      () => props.color.value
    ],
    () => update()
  );
  const rootKls = computed(() => ns.b());
  const cursorKls = computed(() => ns.e("cursor"));
  const rootStyle = computed(() => ({
    backgroundColor: background.value
  }));
  const cursorStyle = computed(() => ({
    top: addUnit(cursorTop.value),
    left: addUnit(cursorLeft.value)
  }));
  return {
    rootKls,
    cursorKls,
    rootStyle,
    cursorStyle,
    update
  };
};
const _hoisted_1$1 = ["tabindex", "aria-disabled", "aria-label", "aria-valuenow", "aria-valuetext"];
var _sfc_main$3 = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElSvPanel"
  },
  __name: "sv-panel",
  props: svPanelProps,
  setup(__props, { expose: __expose }) {
    const props = __props;
    const {
      cursorRef,
      cursorTop,
      cursorLeft,
      background,
      saturation,
      brightness,
      handleClick,
      handleDrag,
      handleKeydown
    } = useSvPanel(props);
    const { rootKls, cursorKls, rootStyle, cursorStyle, update } = useSvPanelDOM(
      props,
      {
        cursorTop,
        cursorLeft,
        background,
        handleDrag
      }
    );
    const { t } = useLocale();
    const ariaLabel = computed(() => t("el.colorpicker.svLabel"));
    const ariaValuetext = computed(() => {
      return t("el.colorpicker.svDescription", {
        saturation: saturation.value,
        brightness: brightness.value,
        color: props.color.value
      });
    });
    __expose({
      /**
       * @description update sv panel manually
       */
      update
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          class: normalizeClass(unref(rootKls)),
          style: normalizeStyle(unref(rootStyle)),
          onClick: _cache[1] || (_cache[1] = //@ts-ignore
          (...args) => unref(handleClick) && unref(handleClick)(...args))
        },
        [
          createElementVNode("div", {
            ref_key: "cursorRef",
            ref: cursorRef,
            class: normalizeClass(unref(cursorKls)),
            style: normalizeStyle(unref(cursorStyle)),
            tabindex: __props.disabled ? void 0 : 0,
            "aria-disabled": __props.disabled,
            role: "slider",
            "aria-valuemin": "0,0",
            "aria-valuemax": "100,100",
            "aria-label": ariaLabel.value,
            "aria-valuenow": `${unref(saturation)},${unref(brightness)}`,
            "aria-valuetext": ariaValuetext.value,
            onKeydown: _cache[0] || (_cache[0] = //@ts-ignore
            (...args) => unref(handleKeydown) && unref(handleKeydown)(...args))
          }, null, 46, _hoisted_1$1)
        ],
        6
        /* CLASS, STYLE */
      );
    };
  }
});
const useCommonColor = (props, emit) => {
  const color = reactive(
    new Color({
      enableAlpha: props.showAlpha,
      format: props.colorFormat || "",
      value: props.modelValue
    })
  );
  watch(
    () => [props.colorFormat, props.showAlpha],
    () => {
      color.enableAlpha = props.showAlpha;
      color.format = props.colorFormat || color.format;
      color.doOnChange();
      emit(UPDATE_MODEL_EVENT, color.value);
    }
  );
  return {
    color
  };
};
var _sfc_main$2 = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElColorPickerPanel"
  },
  __name: "color-picker-panel",
  props: colorPickerPanelProps,
  emits: colorPickerPanelEmits,
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const ns = useNamespace("color-picker-panel");
    const { formItem } = useFormItem();
    const disabled = useFormDisabled();
    const hueRef = ref();
    const svRef = ref();
    const alphaRef = ref();
    const inputRef = ref();
    const customInput = ref("");
    const { color } = inject(
      ROOT_COMMON_COLOR_INJECTION_KEY,
      () => useCommonColor(props, emit),
      true
    );
    function handleConfirm() {
      color.fromString(customInput.value);
      if (color.value !== customInput.value) {
        customInput.value = color.value;
      }
    }
    function handleFocusout() {
      var _a;
      if (props.validateEvent) {
        (_a = formItem == null ? void 0 : formItem.validate) == null ? void 0 : _a.call(formItem, "blur").catch((err) => debugWarn());
      }
    }
    function update() {
      var _a, _b, _c;
      (_a = hueRef.value) == null ? void 0 : _a.update();
      (_b = svRef.value) == null ? void 0 : _b.update();
      (_c = alphaRef.value) == null ? void 0 : _c.update();
    }
    watch(
      () => props.modelValue,
      (newVal) => {
        if (newVal !== color.value) {
          newVal ? color.fromString(newVal) : color.clear();
        }
      }
    );
    watch(
      () => color.value,
      (val) => {
        emit(UPDATE_MODEL_EVENT, val);
        customInput.value = val;
        if (props.validateEvent) {
          formItem == null ? void 0 : formItem.validate("change").catch((err) => debugWarn());
        }
      }
    );
    provide(colorPickerPanelContextKey, {
      currentColor: computed(() => color.value)
    });
    __expose({
      /**
       * @description current color object
       */
      color,
      /**
       * @description custom input ref
       */
      inputRef,
      /**
       * @description update sub components
       */
      update
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          class: normalizeClass([unref(ns).b(), unref(ns).is("disabled", unref(disabled)), unref(ns).is("border", __props.border)]),
          onFocusout: handleFocusout
        },
        [
          createElementVNode(
            "div",
            {
              class: normalizeClass(unref(ns).e("wrapper"))
            },
            [
              createVNode(_sfc_main$5, {
                ref_key: "hueRef",
                ref: hueRef,
                class: "hue-slider",
                color: unref(color),
                vertical: "",
                disabled: unref(disabled)
              }, null, 8, ["color", "disabled"]),
              createVNode(_sfc_main$3, {
                ref_key: "svRef",
                ref: svRef,
                color: unref(color),
                disabled: unref(disabled)
              }, null, 8, ["color", "disabled"])
            ],
            2
            /* CLASS */
          ),
          __props.showAlpha ? (openBlock(), createBlock(_sfc_main$6, {
            key: 0,
            ref_key: "alphaRef",
            ref: alphaRef,
            color: unref(color),
            disabled: unref(disabled)
          }, null, 8, ["color", "disabled"])) : createCommentVNode("v-if", true),
          __props.predefine ? (openBlock(), createBlock(_sfc_main$4, {
            key: 1,
            ref: "predefine",
            "enable-alpha": __props.showAlpha,
            color: unref(color),
            colors: __props.predefine,
            disabled: unref(disabled)
          }, null, 8, ["enable-alpha", "color", "colors", "disabled"])) : createCommentVNode("v-if", true),
          createElementVNode(
            "div",
            {
              class: normalizeClass(unref(ns).e("footer"))
            },
            [
              createVNode(unref(ElInput), {
                ref_key: "inputRef",
                ref: inputRef,
                modelValue: customInput.value,
                "onUpdate:modelValue": _cache[0] || (_cache[0] = ($event) => customInput.value = $event),
                "validate-event": false,
                size: "small",
                disabled: unref(disabled),
                onChange: handleConfirm
              }, null, 8, ["modelValue", "disabled"]),
              renderSlot(_ctx.$slots, "footer")
            ],
            2
            /* CLASS */
          )
        ],
        34
        /* CLASS, NEED_HYDRATION */
      );
    };
  }
});
const ElColorPickerPanel = withInstall(_sfc_main$2);
const colorPickerProps = buildProps({
  /**
   * @description when color-picker inactive and persistent is false, the color panel will be destroyed
   */
  persistent: {
    type: Boolean,
    default: true
  },
  /**
   * @description binding value
   */
  modelValue: {
    type: definePropType(String),
    default: void 0
  },
  /**
   * @description ColorPicker id
   */
  id: String,
  /**
   * @description whether to display the alpha slider
   */
  showAlpha: Boolean,
  /**
   * @description color format of v-model
   */
  colorFormat: String,
  /**
   * @description whether to disable the ColorPicker
   */
  disabled: {
    type: Boolean,
    default: void 0
  },
  /**
   * @description whether to show clear button
   */
  clearable: {
    type: Boolean,
    default: true
  },
  /**
   * @description size of ColorPicker
   */
  size: useSizeProp,
  /**
   * @description custom class name for ColorPicker's dropdown
   */
  popperClass: useTooltipContentProps.popperClass,
  /**
   * @description custom style for ColorPicker's dropdown
   */
  popperStyle: useTooltipContentProps.popperStyle,
  /**
   * @description ColorPicker tabindex
   */
  tabindex: {
    type: [String, Number],
    default: 0
  },
  /**
   * @description whether color-picker popper is teleported to the body
   */
  teleported: useTooltipContentProps.teleported,
  /**
   * @description which color-picker panel appends to
   */
  appendTo: useTooltipContentProps.appendTo,
  /**
   * @description predefined color options
   */
  predefine: {
    type: definePropType(Array)
  },
  /**
   * @description whether to trigger form validation
   */
  validateEvent: {
    type: Boolean,
    default: true
  },
  ...useEmptyValuesProps,
  ...useAriaProps(["ariaLabel"])
});
const colorPickerEmits = {
  [UPDATE_MODEL_EVENT]: (val) => isString(val) || isNil(val),
  [CHANGE_EVENT]: (val) => isString(val) || isNil(val),
  activeChange: (val) => isString(val) || isNil(val),
  focus: (evt) => evt instanceof FocusEvent,
  blur: (evt) => evt instanceof FocusEvent,
  clear: () => true
};
const _hoisted_1 = ["id", "aria-label", "aria-labelledby", "aria-description", "aria-disabled", "tabindex"];
var _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElColorPicker"
  },
  __name: "color-picker",
  props: colorPickerProps,
  emits: colorPickerEmits,
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const { t } = useLocale();
    const ns = useNamespace("color");
    const { formItem } = useFormItem();
    const colorSize = useFormSize();
    const colorDisabled = useFormDisabled();
    const { valueOnClear, isEmptyValue } = useEmptyValues(props, null);
    const commonColor = useCommonColor(props, emit);
    const { inputId: buttonId, isLabeledByFormItem } = useFormItemInputId(props, {
      formItemContext: formItem
    });
    const popper = ref();
    const triggerRef = ref();
    const pickerPanelRef = ref();
    const showPicker = ref(false);
    const showPanelColor = ref(false);
    let shouldActiveChange = true;
    const { isFocused, handleFocus, handleBlur } = useFocusController(triggerRef, {
      disabled: colorDisabled,
      beforeBlur(event) {
        var _a;
        return (_a = popper.value) == null ? void 0 : _a.isFocusInsideContent(event);
      },
      afterBlur() {
        var _a;
        setShowPicker(false);
        resetColor();
        if (props.validateEvent) {
          (_a = formItem == null ? void 0 : formItem.validate) == null ? void 0 : _a.call(formItem, "blur").catch((err) => debugWarn());
        }
      }
    });
    const color = reactiveComputed(
      () => {
        var _a, _b;
        return (_b = (_a = pickerPanelRef.value) == null ? void 0 : _a.color) != null ? _b : commonColor.color;
      }
    );
    const panelProps = computed(
      () => pick(props, Object.keys(colorPickerPanelProps))
    );
    const displayedColor = computed(() => {
      if (!props.modelValue && !showPanelColor.value) {
        return "transparent";
      }
      return displayedRgb(color, props.showAlpha);
    });
    const currentColor = computed(() => {
      return !props.modelValue && !showPanelColor.value ? "" : color.value;
    });
    const buttonAriaLabel = computed(() => {
      return !isLabeledByFormItem.value ? props.ariaLabel || t("el.colorpicker.defaultLabel") : void 0;
    });
    const buttonAriaLabelledby = computed(() => {
      return isLabeledByFormItem.value ? formItem == null ? void 0 : formItem.labelId : void 0;
    });
    const btnKls = computed(() => {
      return [
        ns.b("picker"),
        ns.is("disabled", colorDisabled.value),
        ns.bm("picker", colorSize.value),
        ns.is("focused", isFocused.value)
      ];
    });
    function displayedRgb(color2, showAlpha) {
      const { r, g, b, a } = color2.toRgb();
      return showAlpha ? `rgba(${r}, ${g}, ${b}, ${a})` : `rgb(${r}, ${g}, ${b})`;
    }
    function setShowPicker(value) {
      showPicker.value = value;
    }
    const debounceSetShowPicker = debounce(setShowPicker, 100, { leading: true });
    function show() {
      if (colorDisabled.value) return;
      setShowPicker(true);
    }
    function hide() {
      debounceSetShowPicker(false);
      resetColor();
    }
    function resetColor() {
      nextTick(() => {
        if (props.modelValue) {
          color.fromString(props.modelValue);
        } else {
          color.value = "";
          nextTick(() => {
            showPanelColor.value = false;
          });
        }
      });
    }
    function handleTrigger() {
      if (colorDisabled.value) return;
      if (showPicker.value) {
        resetColor();
      }
      debounceSetShowPicker(!showPicker.value);
    }
    function confirmValue() {
      const value = isEmptyValue(color.value) ? valueOnClear.value : color.value;
      emit(UPDATE_MODEL_EVENT, value);
      emit(CHANGE_EVENT, value);
      if (props.validateEvent) {
        formItem == null ? void 0 : formItem.validate("change").catch((err) => debugWarn());
      }
      debounceSetShowPicker(false);
      nextTick(() => {
        const newColor = new Color({
          enableAlpha: props.showAlpha,
          format: props.colorFormat || "",
          value: props.modelValue
        });
        if (!color.compare(newColor)) {
          resetColor();
        }
      });
    }
    function clear() {
      debounceSetShowPicker(false);
      emit(UPDATE_MODEL_EVENT, valueOnClear.value);
      emit(CHANGE_EVENT, valueOnClear.value);
      if (props.modelValue !== valueOnClear.value && props.validateEvent) {
        formItem == null ? void 0 : formItem.validate("change").catch((err) => debugWarn());
      }
      resetColor();
      emit("clear");
    }
    function handleShowTooltip() {
      var _a, _b;
      (_b = (_a = pickerPanelRef == null ? void 0 : pickerPanelRef.value) == null ? void 0 : _a.inputRef) == null ? void 0 : _b.focus();
    }
    function handleClickOutside() {
      if (!showPicker.value) return;
      hide();
      isFocused.value && focus();
    }
    function handleEsc(event) {
      event.preventDefault();
      event.stopPropagation();
      setShowPicker(false);
      resetColor();
    }
    function handleKeyDown(event) {
      const code = getEventCode(event);
      switch (code) {
        case EVENT_CODE.enter:
        case EVENT_CODE.numpadEnter:
        case EVENT_CODE.space:
          event.preventDefault();
          event.stopPropagation();
          show();
          break;
        case EVENT_CODE.esc:
          handleEsc(event);
          break;
      }
    }
    function focus() {
      triggerRef.value.focus();
    }
    function blur() {
      triggerRef.value.blur();
    }
    watch(
      () => currentColor.value,
      (val) => {
        shouldActiveChange && emit("activeChange", val);
        shouldActiveChange = true;
      }
    );
    watch(
      () => color.value,
      () => {
        if (!props.modelValue && !showPanelColor.value) {
          showPanelColor.value = true;
        }
      }
    );
    watch(
      () => props.modelValue,
      (newVal) => {
        if (!newVal) {
          showPanelColor.value = false;
        } else if (newVal && newVal !== color.value) {
          shouldActiveChange = false;
          color.fromString(newVal);
        }
      }
    );
    watch(
      () => showPicker.value,
      () => {
        pickerPanelRef.value && nextTick(pickerPanelRef.value.update);
      }
    );
    provide(ROOT_COMMON_COLOR_INJECTION_KEY, commonColor);
    __expose({
      /**
       * @description current color object
       */
      color,
      /**
       * @description manually show ColorPicker
       */
      show,
      /**
       * @description manually hide ColorPicker
       */
      hide,
      /**
       * @description focus the input element
       */
      focus,
      /**
       * @description blur the input element
       */
      blur
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(ElTooltip), {
        ref_key: "popper",
        ref: popper,
        visible: showPicker.value,
        "show-arrow": false,
        "fallback-placements": ["bottom", "top", "right", "left"],
        offset: 0,
        "gpu-acceleration": false,
        "popper-class": [unref(ns).be("picker", "panel"), __props.popperClass],
        "popper-style": __props.popperStyle,
        "stop-popper-mouse-event": false,
        pure: "",
        loop: "",
        role: "dialog",
        effect: "light",
        trigger: "click",
        teleported: __props.teleported,
        transition: `${unref(ns).namespace.value}-zoom-in-top`,
        persistent: __props.persistent,
        "append-to": __props.appendTo,
        onShow: handleShowTooltip,
        onHide: _cache[2] || (_cache[2] = ($event) => setShowPicker(false))
      }, {
        content: withCtx(() => [
          withDirectives((openBlock(), createBlock(
            unref(ElColorPickerPanel),
            mergeProps({
              ref_key: "pickerPanelRef",
              ref: pickerPanelRef
            }, panelProps.value, {
              border: false,
              "validate-event": false,
              onKeydown: withKeys(handleEsc, ["esc"])
            }),
            {
              footer: withCtx(() => [
                createElementVNode("div", null, [
                  __props.clearable ? (openBlock(), createBlock(unref(ElButton), {
                    key: 0,
                    class: normalizeClass(unref(ns).be("footer", "link-btn")),
                    text: "",
                    size: "small",
                    onClick: clear
                  }, {
                    default: withCtx(() => [
                      createTextVNode(
                        toDisplayString(unref(t)("el.colorpicker.clear")),
                        1
                        /* TEXT */
                      )
                    ]),
                    _: 1
                    /* STABLE */
                  }, 8, ["class"])) : createCommentVNode("v-if", true),
                  createVNode(unref(ElButton), {
                    plain: "",
                    size: "small",
                    class: normalizeClass(unref(ns).be("footer", "btn")),
                    onClick: confirmValue
                  }, {
                    default: withCtx(() => [
                      createTextVNode(
                        toDisplayString(unref(t)("el.colorpicker.confirm")),
                        1
                        /* TEXT */
                      )
                    ]),
                    _: 1
                    /* STABLE */
                  }, 8, ["class"])
                ])
              ]),
              _: 1
              /* STABLE */
            },
            16
            /* FULL_PROPS */
          )), [
            [unref(ClickOutside), handleClickOutside, triggerRef.value]
          ])
        ]),
        default: withCtx(() => [
          createElementVNode("div", mergeProps({
            id: unref(buttonId),
            ref_key: "triggerRef",
            ref: triggerRef
          }, _ctx.$attrs, {
            class: btnKls.value,
            role: "button",
            "aria-label": buttonAriaLabel.value,
            "aria-labelledby": buttonAriaLabelledby.value,
            "aria-description": unref(t)("el.colorpicker.description", { color: __props.modelValue || "" }),
            "aria-disabled": unref(colorDisabled),
            tabindex: unref(colorDisabled) ? void 0 : __props.tabindex,
            onKeydown: handleKeyDown,
            onFocus: _cache[0] || (_cache[0] = //@ts-ignore
            (...args) => unref(handleFocus) && unref(handleFocus)(...args)),
            onBlur: _cache[1] || (_cache[1] = //@ts-ignore
            (...args) => unref(handleBlur) && unref(handleBlur)(...args))
          }), [
            createElementVNode(
              "div",
              {
                class: normalizeClass(unref(ns).be("picker", "trigger")),
                onClick: handleTrigger
              },
              [
                createElementVNode(
                  "span",
                  {
                    class: normalizeClass([unref(ns).be("picker", "color"), unref(ns).is("alpha", __props.showAlpha)])
                  },
                  [
                    createElementVNode(
                      "span",
                      {
                        class: normalizeClass(unref(ns).be("picker", "color-inner")),
                        style: normalizeStyle({
                          backgroundColor: displayedColor.value
                        })
                      },
                      [
                        withDirectives(createVNode(unref(ElIcon), {
                          class: normalizeClass([unref(ns).be("picker", "icon"), unref(ns).is("icon-arrow-down")])
                        }, {
                          default: withCtx(() => [
                            createVNode(unref(arrow_down_default))
                          ]),
                          _: 1
                          /* STABLE */
                        }, 8, ["class"]), [
                          [vShow, __props.modelValue || showPanelColor.value]
                        ]),
                        withDirectives(createVNode(unref(ElIcon), {
                          class: normalizeClass([unref(ns).be("picker", "empty"), unref(ns).is("icon-close")])
                        }, {
                          default: withCtx(() => [
                            createVNode(unref(close_default))
                          ]),
                          _: 1
                          /* STABLE */
                        }, 8, ["class"]), [
                          [vShow, !__props.modelValue && !showPanelColor.value]
                        ])
                      ],
                      6
                      /* CLASS, STYLE */
                    )
                  ],
                  2
                  /* CLASS */
                )
              ],
              2
              /* CLASS */
            )
          ], 16, _hoisted_1)
        ]),
        _: 1
        /* STABLE */
      }, 8, ["visible", "popper-class", "popper-style", "teleported", "transition", "persistent", "append-to"]);
    };
  }
});
const ElColorPicker = withInstall(_sfc_main$1);
const _sfc_main = {
  __name: "ModulesCommonForm",
  __ssrInlineRender: true,
  props: [
    "form",
    "id",
    "verifyKey",
    "type",
    "title",
    "subTitle",
    "showResult",
    "size",
    "settings"
  ],
  emits: ["submitSuccess"],
  setup(__props, { emit: __emit }) {
    const props = __props;
    const payRef = ref(null);
    const locked = ref(false);
    const action = actionStore();
    const { locale } = useI18n();
    const success = ref(false);
    const emit = __emit;
    const formData = ref({});
    const disabledArr = ref([]);
    function stringToArray(input) {
      return input.split(/\r?\n/).map((line) => line.trim()).filter((line) => line !== "");
    }
    const reload = async () => {
      const res = await useRequest("/api/request", {
        body: {
          data: {
            id: props.form.id
          }
        }
      });
      emit("submitSuccess", formData.value);
      success.value = true;
      if (res?.guaqi?.utils?.getForm) {
        try {
          const form = JSON.parse(res?.guaqi?.utils?.getForm);
          props.form.dataHistory = form.dataHistory;
          props.form.form = form.form;
          reloadForm(form.form);
        } catch (error) {
          console.log(error);
        }
      } else {
        console.log(res);
      }
    };
    const reloadForm = (val) => {
      val.forEach((item) => {
        let options = stringToArray(item.options?.[locale.value] ?? "");
        if (item.type == "radio" || item.type == "select") {
          formData.value[item.key] = options[0];
        }
        if (item.newFormData) {
          for (let key in item.newFormData) {
            formData.value[key] = item.newFormData[key];
            disabledArr.value.push(key);
          }
        }
      });
    };
    watch(
      () => props.form?.form_data?.form,
      (val) => {
        if (val?.length > 0) {
          reloadForm(val);
        }
      },
      { immediate: true, deep: true }
    );
    const ready = ref(false);
    const disabledSubmit = computed(() => {
      if (!ready.value) return false;
      if (!isLogin.value && props.form?.form_data?.pay_open == 1 && props.form?.form_data?.pay_type == "credit") {
        return "login";
      }
      if (props.form?.form_data?.pay_open == 1 && props.form?.form_data?.pay_type == "money" && !isLogin.value && !props.form?.form_data?.payMoney?.final[action.currency.iso]) {
        return "login";
      }
      if (isLogin.value && props.form?.form_data?.pay_open == 1 && props.form?.form_data?.pay_type == "money" && !props.form?.form_data?.payMoney?.final[action.currency.iso]) {
        return "notallow";
      }
      if (isLogin.value && props.form?.form_data?.pay_open == 1 && props.form?.form_data?.pay_type == "credit" && !props.form?.form_data?.payCredit) {
        return "notallow";
      }
      return false;
    });
    const submit = async () => {
      if (props.verifyKey) {
        formData.value.verifyKey = props.verifyKey;
      }
      const requiredFields = props.form?.form_data?.form?.filter(
        (item) => item.required == 1
      );
      const requiredFieldsValues = requiredFields.filter((item) => item.type != "content").map((item) => formData.value[item.key]);
      if (requiredFieldsValues.some((value) => !value)) {
        ElMessage.error("请填写必填项");
        return;
      }
      if (props.form?.form_data?.pay_open == 1) {
        payRef.value.pay();
        return;
      }
      const res = await useRequest("/api/request", {
        body: {
          data: {
            formId: props.form.id,
            type: props.type,
            verifyId: props.verifyKey,
            data: JSON.stringify(formData.value)
          }
        }
      });
      if (res?.gqSubmitForm?.success) {
        emit("submitSuccess", formData.value);
        success.value = true;
      }
      locked.value = false;
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_form = ElForm;
      const _component_el_form_item = ElFormItem;
      const _component_el_input = ElInput;
      const _component_el_input_number = ElInputNumber;
      const _component_el_date_picker = ElDatePicker;
      const _component_el_color_picker = ElColorPicker;
      const _component_ModulesCommonFormPhone = _sfc_main$7;
      const _component_el_select = ElSelect;
      const _component_el_option = ElOption;
      const _component_el_radio_group = ElRadioGroup;
      const _component_el_radio = ElRadio;
      const _component_el_checkbox_group = ElCheckboxGroup;
      const _component_el_checkbox = ElCheckbox;
      const _component_ModulesCommonFormFile = _sfc_main$8;
      const _component_ModulesCommonFormPay = _sfc_main$9;
      const _component_el_button = ElButton;
      const _directive_loading = vLoading;
      let _temp0;
      _push(`<div${ssrRenderAttrs(_attrs)}>`);
      _push(ssrRenderComponent(_component_el_form, {
        size: __props.size || "large",
        model: unref(formData),
        "label-width": "auto",
        "label-position": "top",
        style: { "--el-text-color-regular": "var(--el-text-color-primary)", "--el-input-border-color": "var(--el-border-color-darker)" },
        "show-message": false,
        class: "flex flex-col w-full h-full relative"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<!--[-->`);
            ssrRenderList(__props.form?.form_data?.form, (item) => {
              _push2(ssrRenderComponent(_component_el_form_item, {
                key: `${item.key}`,
                prop: item.key,
                required: item.required == 1 ? true : false,
                class: `w-full border-b border-dashed pl-[--tpl] pr-[--tpr] pt-[calc(var(--tpl)*0.5)] pb-[calc(var(--tpl)*0.5)] ${item.type == "confirm" ? "!py-2" : ""}`,
                id: `${item.key}`,
                "aria-labelledby": `${item.key}`,
                style: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).checkCondition(item.dependency, unref(formData)) ? null : { display: "none" }
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    if (item.type != "content" && item.type != "confirm") {
                      _push3(`<label class="font-600"${_scopeId2}>${ssrInterpolate(item.type != "content" && item.type != "confirm" ? item.name?.[unref(locale)] ?? "" : "")}`);
                      if (parseInt(item.required) == 1) {
                        _push3(`<span class="text-red-500 ml-1"${_scopeId2}>*</span>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`</label>`);
                    } else {
                      _push3(`<!---->`);
                    }
                    _push3(`<div class="flex flex-col w-full"${_scopeId2}>`);
                    if (item.type == "text") {
                      _push3(`<!--[-->`);
                      if (item.inputType == "text") {
                        _push3(`<!--[-->`);
                        _push3(ssrRenderComponent(_component_el_input, {
                          placeholder: item.placeholder?.[unref(locale)] ?? "",
                          type: item.inputType,
                          modelValue: unref(formData)[item.key],
                          "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                          id: `${item.key}-input`,
                          "aria-labelledby": `${item.key}-input`,
                          disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false),
                          required: parseInt(item.required) == 1 ? true : false
                        }, null, _parent3, _scopeId2));
                        _push3(`<div class="text-xs mt-2 opacity-80"${_scopeId2}>${item.description?.[unref(locale)] ?? "" ?? ""}</div><!--]-->`);
                      } else {
                        _push3(`<!---->`);
                      }
                      if (item.inputType == "number") {
                        _push3(`<!--[-->`);
                        _push3(ssrRenderComponent(_component_el_input_number, {
                          modelValue: unref(formData)[item.key],
                          "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                          placeholder: item.placeholder?.[unref(locale)] ?? "",
                          disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                        }, null, _parent3, _scopeId2));
                        if (item.description?.[unref(locale)]) {
                          _push3(`<div class="text-xs mt-2 opacity-80"${_scopeId2}>${item.description?.[unref(locale)] ?? "" ?? ""}</div>`);
                        } else {
                          _push3(`<!---->`);
                        }
                        _push3(`<!--]-->`);
                      } else if (item.inputType == "date") {
                        _push3(`<!--[-->`);
                        _push3(ssrRenderComponent(_component_el_date_picker, {
                          modelValue: unref(formData)[item.key],
                          "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                          disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false),
                          type: "datetime",
                          placeholder: item.placeholder?.[unref(locale)] ?? ""
                        }, null, _parent3, _scopeId2));
                        if (item.description?.[unref(locale)]) {
                          _push3(`<div class="text-xs mt-2 opacity-80"${_scopeId2}>${item.description?.[unref(locale)] ?? "" ?? ""}</div>`);
                        } else {
                          _push3(`<!---->`);
                        }
                        _push3(`<!--]-->`);
                      } else if (item.inputType == "color") {
                        _push3(`<!--[-->`);
                        _push3(ssrRenderComponent(_component_el_color_picker, {
                          modelValue: unref(formData)[item.key],
                          "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                          disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                        }, null, _parent3, _scopeId2));
                        if (item.description?.[unref(locale)]) {
                          _push3(`<div class="text-xs mt-2 opacity-80"${_scopeId2}>${item.description?.[unref(locale)] ?? "" ?? ""}</div>`);
                        } else {
                          _push3(`<!---->`);
                        }
                        _push3(`<!--]-->`);
                      } else if (item.inputType == "phone") {
                        _push3(`<!--[-->`);
                        _push3(ssrRenderComponent(_component_ModulesCommonFormPhone, {
                          modelValue: unref(formData)[item.key],
                          "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                          settings: item,
                          disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                        }, null, _parent3, _scopeId2));
                        if (item.description?.[unref(locale)]) {
                          _push3(`<div class="text-xs mt-2 opacity-80"${_scopeId2}>${item.description?.[unref(locale)] ?? "" ?? ""}</div>`);
                        } else {
                          _push3(`<!---->`);
                        }
                        _push3(`<!--]-->`);
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`<!--]-->`);
                    } else if (item.type == "textarea") {
                      _push3(`<!--[-->`);
                      _push3(ssrRenderComponent(_component_el_input, {
                        modelValue: unref(formData)[item.key],
                        "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                        placeholder: item.placeholder?.[unref(locale)] ?? "",
                        type: "textarea",
                        autosize: { minRows: 4, maxRows: 8 },
                        disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                      }, null, _parent3, _scopeId2));
                      if (item.description?.[unref(locale)]) {
                        _push3(`<div class="text-xs mt-2 opacity-80"${_scopeId2}>${item.description?.[unref(locale)] ?? "" ?? ""}</div>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`<!--]-->`);
                    } else if (item.type == "select") {
                      _push3(`<!--[-->`);
                      _push3(ssrRenderComponent(_component_el_select, {
                        modelValue: unref(formData)[item.key],
                        "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                        placeholder: item.placeholder?.[unref(locale)] ?? "",
                        disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(`<!--[-->`);
                            ssrRenderList(stringToArray(item.options?.[unref(locale)] ?? "") ?? [], (_item) => {
                              _push4(ssrRenderComponent(_component_el_option, {
                                key: _item,
                                value: _item,
                                label: _item
                              }, null, _parent4, _scopeId3));
                            });
                            _push4(`<!--]-->`);
                          } else {
                            return [
                              (openBlock(true), createBlock(Fragment, null, renderList(stringToArray(item.options?.[unref(locale)] ?? "") ?? [], (_item) => {
                                return openBlock(), createBlock(_component_el_option, {
                                  key: _item,
                                  value: _item,
                                  label: _item
                                }, null, 8, ["value", "label"]);
                              }), 128))
                            ];
                          }
                        }),
                        _: 2
                      }, _parent3, _scopeId2));
                      if (item.description?.[unref(locale)]) {
                        _push3(`<div class="text-xs mt-2 opacity-80"${_scopeId2}>${item.description?.[unref(locale)] ?? "" ?? ""}</div>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`<!--]-->`);
                    } else if (item.type == "radio") {
                      _push3(`<!--[-->`);
                      _push3(ssrRenderComponent(_component_el_radio_group, {
                        modelValue: unref(formData)[item.key],
                        "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                        disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(`<!--[-->`);
                            ssrRenderList(stringToArray(item.options?.[unref(locale)] ?? "") ?? [], (_item) => {
                              _push4(ssrRenderComponent(_component_el_radio, {
                                value: _item,
                                border: "",
                                key: _item
                              }, {
                                default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                  if (_push5) {
                                    _push5(`${ssrInterpolate(_item)}`);
                                  } else {
                                    return [
                                      createTextVNode(toDisplayString(_item), 1)
                                    ];
                                  }
                                }),
                                _: 2
                              }, _parent4, _scopeId3));
                            });
                            _push4(`<!--]-->`);
                          } else {
                            return [
                              (openBlock(true), createBlock(Fragment, null, renderList(stringToArray(item.options?.[unref(locale)] ?? "") ?? [], (_item) => {
                                return openBlock(), createBlock(_component_el_radio, {
                                  value: _item,
                                  border: "",
                                  key: _item
                                }, {
                                  default: withCtx(() => [
                                    createTextVNode(toDisplayString(_item), 1)
                                  ]),
                                  _: 2
                                }, 1032, ["value"]);
                              }), 128))
                            ];
                          }
                        }),
                        _: 2
                      }, _parent3, _scopeId2));
                      if (item.description?.[unref(locale)]) {
                        _push3(`<div class="text-xs mt-2 opacity-80"${_scopeId2}>${item.description?.[unref(locale)] ?? "" ?? ""}</div>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`<!--]-->`);
                    } else if (item.type == "checkbox") {
                      _push3(`<!--[-->`);
                      _push3(ssrRenderComponent(_component_el_checkbox_group, {
                        modelValue: unref(formData)[item.key],
                        "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                        disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(`<!--[-->`);
                            ssrRenderList(stringToArray(item.options?.[unref(locale)] ?? "") ?? [], (_item) => {
                              _push4(ssrRenderComponent(_component_el_checkbox, {
                                value: _item,
                                border: "",
                                key: _item
                              }, {
                                default: withCtx((_4, _push5, _parent5, _scopeId4) => {
                                  if (_push5) {
                                    _push5(`${ssrInterpolate(_item)}`);
                                  } else {
                                    return [
                                      createTextVNode(toDisplayString(_item), 1)
                                    ];
                                  }
                                }),
                                _: 2
                              }, _parent4, _scopeId3));
                            });
                            _push4(`<!--]-->`);
                          } else {
                            return [
                              (openBlock(true), createBlock(Fragment, null, renderList(stringToArray(item.options?.[unref(locale)] ?? "") ?? [], (_item) => {
                                return openBlock(), createBlock(_component_el_checkbox, {
                                  value: _item,
                                  border: "",
                                  key: _item
                                }, {
                                  default: withCtx(() => [
                                    createTextVNode(toDisplayString(_item), 1)
                                  ]),
                                  _: 2
                                }, 1032, ["value"]);
                              }), 128))
                            ];
                          }
                        }),
                        _: 2
                      }, _parent3, _scopeId2));
                      if (item.description?.[unref(locale)]) {
                        _push3(`<div class="text-xs mt-2 opacity-80"${_scopeId2}>${item.description?.[unref(locale)] ?? "" ?? ""}</div>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`<!--]-->`);
                    } else if (item.type == "file") {
                      _push3(`<!--[-->`);
                      _push3(ssrRenderComponent(_component_ModulesCommonFormFile, {
                        settings: item,
                        modelValue: unref(formData)[item.key],
                        "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                        files: unref(formData)[item.key + "-file"],
                        disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                      }, null, _parent3, _scopeId2));
                      if (item.description?.[unref(locale)]) {
                        _push3(`<div class="text-xs mt-2 opacity-80"${_scopeId2}>${item.description?.[unref(locale)] ?? "" ?? ""}</div>`);
                      } else {
                        _push3(`<!---->`);
                      }
                      _push3(`<!--]-->`);
                    } else if (item.type == "content") {
                      _push3(`<div${_scopeId2}>${item.content?.[unref(locale)] ?? "" ?? ""}</div>`);
                    } else if (item.type == "confirm") {
                      _push3(ssrRenderComponent(_component_el_checkbox, {
                        modelValue: unref(formData)[item.key],
                        "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                        disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false),
                        class: "confirm-checkbox"
                      }, {
                        default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                          if (_push4) {
                            _push4(`<div${_scopeId3}>${item.confirmType?.[unref(locale)] ?? "" ?? ""}</div>`);
                          } else {
                            return [
                              createVNode("div", {
                                innerHTML: item.confirmType?.[unref(locale)] ?? ""
                              }, null, 8, ["innerHTML"])
                            ];
                          }
                        }),
                        _: 2
                      }, _parent3, _scopeId2));
                    } else {
                      _push3(`<!---->`);
                    }
                    _push3(`</div>`);
                  } else {
                    return [
                      item.type != "content" && item.type != "confirm" ? (openBlock(), createBlock("label", {
                        key: 0,
                        class: "font-600"
                      }, [
                        createTextVNode(toDisplayString(item.type != "content" && item.type != "confirm" ? item.name?.[unref(locale)] ?? "" : ""), 1),
                        parseInt(item.required) == 1 ? (openBlock(), createBlock("span", {
                          key: 0,
                          class: "text-red-500 ml-1"
                        }, "*")) : createCommentVNode("", true)
                      ])) : createCommentVNode("", true),
                      createVNode("div", { class: "flex flex-col w-full" }, [
                        item.type == "text" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                          item.inputType == "text" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                            createVNode(_component_el_input, {
                              placeholder: item.placeholder?.[unref(locale)] ?? "",
                              type: item.inputType,
                              modelValue: unref(formData)[item.key],
                              "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                              id: `${item.key}-input`,
                              "aria-labelledby": `${item.key}-input`,
                              disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false),
                              required: parseInt(item.required) == 1 ? true : false
                            }, null, 8, ["placeholder", "type", "modelValue", "onUpdate:modelValue", "id", "aria-labelledby", "disabled", "required"]),
                            createVNode("div", {
                              innerHTML: item.description?.[unref(locale)] ?? "",
                              class: "text-xs mt-2 opacity-80"
                            }, null, 8, ["innerHTML"])
                          ], 64)) : createCommentVNode("", true),
                          item.inputType == "number" ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                            createVNode(_component_el_input_number, {
                              modelValue: unref(formData)[item.key],
                              "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                              placeholder: item.placeholder?.[unref(locale)] ?? "",
                              disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "disabled"]),
                            item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                              key: 0,
                              innerHTML: item.description?.[unref(locale)] ?? "",
                              class: "text-xs mt-2 opacity-80"
                            }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                          ], 64)) : item.inputType == "date" ? (openBlock(), createBlock(Fragment, { key: 2 }, [
                            createVNode(_component_el_date_picker, {
                              modelValue: unref(formData)[item.key],
                              "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                              disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false),
                              type: "datetime",
                              placeholder: item.placeholder?.[unref(locale)] ?? ""
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "placeholder"]),
                            item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                              key: 0,
                              innerHTML: item.description?.[unref(locale)] ?? "",
                              class: "text-xs mt-2 opacity-80"
                            }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                          ], 64)) : item.inputType == "color" ? (openBlock(), createBlock(Fragment, { key: 3 }, [
                            createVNode(_component_el_color_picker, {
                              modelValue: unref(formData)[item.key],
                              "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                              disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled"]),
                            item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                              key: 0,
                              innerHTML: item.description?.[unref(locale)] ?? "",
                              class: "text-xs mt-2 opacity-80"
                            }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                          ], 64)) : item.inputType == "phone" ? (openBlock(), createBlock(Fragment, { key: 4 }, [
                            createVNode(_component_ModulesCommonFormPhone, {
                              modelValue: unref(formData)[item.key],
                              "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                              settings: item,
                              disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                            }, null, 8, ["modelValue", "onUpdate:modelValue", "settings", "disabled"]),
                            item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                              key: 0,
                              innerHTML: item.description?.[unref(locale)] ?? "",
                              class: "text-xs mt-2 opacity-80"
                            }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                          ], 64)) : createCommentVNode("", true)
                        ], 64)) : item.type == "textarea" ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                          createVNode(_component_el_input, {
                            modelValue: unref(formData)[item.key],
                            "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                            placeholder: item.placeholder?.[unref(locale)] ?? "",
                            type: "textarea",
                            autosize: { minRows: 4, maxRows: 8 },
                            disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "disabled"]),
                          item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                            key: 0,
                            innerHTML: item.description?.[unref(locale)] ?? "",
                            class: "text-xs mt-2 opacity-80"
                          }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                        ], 64)) : item.type == "select" ? (openBlock(), createBlock(Fragment, { key: 2 }, [
                          createVNode(_component_el_select, {
                            modelValue: unref(formData)[item.key],
                            "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                            placeholder: item.placeholder?.[unref(locale)] ?? "",
                            disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                          }, {
                            default: withCtx(() => [
                              (openBlock(true), createBlock(Fragment, null, renderList(stringToArray(item.options?.[unref(locale)] ?? "") ?? [], (_item) => {
                                return openBlock(), createBlock(_component_el_option, {
                                  key: _item,
                                  value: _item,
                                  label: _item
                                }, null, 8, ["value", "label"]);
                              }), 128))
                            ]),
                            _: 2
                          }, 1032, ["modelValue", "onUpdate:modelValue", "placeholder", "disabled"]),
                          item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                            key: 0,
                            innerHTML: item.description?.[unref(locale)] ?? "",
                            class: "text-xs mt-2 opacity-80"
                          }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                        ], 64)) : item.type == "radio" ? (openBlock(), createBlock(Fragment, { key: 3 }, [
                          createVNode(_component_el_radio_group, {
                            modelValue: unref(formData)[item.key],
                            "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                            disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                          }, {
                            default: withCtx(() => [
                              (openBlock(true), createBlock(Fragment, null, renderList(stringToArray(item.options?.[unref(locale)] ?? "") ?? [], (_item) => {
                                return openBlock(), createBlock(_component_el_radio, {
                                  value: _item,
                                  border: "",
                                  key: _item
                                }, {
                                  default: withCtx(() => [
                                    createTextVNode(toDisplayString(_item), 1)
                                  ]),
                                  _: 2
                                }, 1032, ["value"]);
                              }), 128))
                            ]),
                            _: 2
                          }, 1032, ["modelValue", "onUpdate:modelValue", "disabled"]),
                          item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                            key: 0,
                            innerHTML: item.description?.[unref(locale)] ?? "",
                            class: "text-xs mt-2 opacity-80"
                          }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                        ], 64)) : item.type == "checkbox" ? (openBlock(), createBlock(Fragment, { key: 4 }, [
                          createVNode(_component_el_checkbox_group, {
                            modelValue: unref(formData)[item.key],
                            "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                            disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                          }, {
                            default: withCtx(() => [
                              (openBlock(true), createBlock(Fragment, null, renderList(stringToArray(item.options?.[unref(locale)] ?? "") ?? [], (_item) => {
                                return openBlock(), createBlock(_component_el_checkbox, {
                                  value: _item,
                                  border: "",
                                  key: _item
                                }, {
                                  default: withCtx(() => [
                                    createTextVNode(toDisplayString(_item), 1)
                                  ]),
                                  _: 2
                                }, 1032, ["value"]);
                              }), 128))
                            ]),
                            _: 2
                          }, 1032, ["modelValue", "onUpdate:modelValue", "disabled"]),
                          item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                            key: 0,
                            innerHTML: item.description?.[unref(locale)] ?? "",
                            class: "text-xs mt-2 opacity-80"
                          }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                        ], 64)) : item.type == "file" ? (openBlock(), createBlock(Fragment, { key: 5 }, [
                          createVNode(_component_ModulesCommonFormFile, {
                            settings: item,
                            modelValue: unref(formData)[item.key],
                            "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                            files: unref(formData)[item.key + "-file"],
                            disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                          }, null, 8, ["settings", "modelValue", "onUpdate:modelValue", "files", "disabled"]),
                          item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                            key: 0,
                            innerHTML: item.description?.[unref(locale)] ?? "",
                            class: "text-xs mt-2 opacity-80"
                          }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                        ], 64)) : item.type == "content" ? (openBlock(), createBlock("div", {
                          key: 6,
                          innerHTML: item.content?.[unref(locale)] ?? ""
                        }, null, 8, ["innerHTML"])) : item.type == "confirm" ? (openBlock(), createBlock(_component_el_checkbox, {
                          key: 7,
                          modelValue: unref(formData)[item.key],
                          "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                          disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false),
                          class: "confirm-checkbox"
                        }, {
                          default: withCtx(() => [
                            createVNode("div", {
                              innerHTML: item.confirmType?.[unref(locale)] ?? ""
                            }, null, 8, ["innerHTML"])
                          ]),
                          _: 2
                        }, 1032, ["modelValue", "onUpdate:modelValue", "disabled"])) : createCommentVNode("", true)
                      ])
                    ];
                  }
                }),
                _: 2
              }, _parent2, _scopeId));
            });
            _push2(`<!--]-->`);
            if (__props.form?.form_data?.pay_open == 1) {
              _push2(ssrRenderComponent(_component_el_form_item, {
                class: "border-b border-dashed",
                id: "form-pay",
                "aria-labelledby": "form-pay"
              }, {
                default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                  if (_push3) {
                    _push3(ssrRenderComponent(_component_ModulesCommonFormPay, {
                      class: "flex flex-col w-full h-full pl-[--tpl] pr-[--tpr] pt-[calc(var(--tpl)*0.7)] pb-[calc(var(--tpl)*0.7)]",
                      settings: __props.form?.form_data,
                      formData: unref(formData),
                      id: __props.form.id,
                      verifyKey: __props.verifyKey,
                      title: __props.title,
                      type: __props.type,
                      size: __props.size || "default",
                      ref_key: "payRef",
                      ref: payRef,
                      "onUpdate:formData": reload
                    }, null, _parent3, _scopeId2));
                  } else {
                    return [
                      createVNode(_component_ModulesCommonFormPay, {
                        class: "flex flex-col w-full h-full pl-[--tpl] pr-[--tpr] pt-[calc(var(--tpl)*0.7)] pb-[calc(var(--tpl)*0.7)]",
                        settings: __props.form?.form_data,
                        formData: unref(formData),
                        id: __props.form.id,
                        verifyKey: __props.verifyKey,
                        title: __props.title,
                        type: __props.type,
                        size: __props.size || "default",
                        ref_key: "payRef",
                        ref: payRef,
                        "onUpdate:formData": reload
                      }, null, 8, ["settings", "formData", "id", "verifyKey", "title", "type", "size"])
                    ];
                  }
                }),
                _: 1
              }, _parent2, _scopeId));
            } else {
              _push2(`<!---->`);
            }
            _push2(ssrRenderComponent(_component_el_form_item, {
              id: "form-submit",
              "aria-labelledby": "form-submit"
            }, {
              default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                if (_push3) {
                  if (__props.form) {
                    _push3(`<div class="flex items-center justify-start w-full h-full pl-[--tpl] pr-[--tpr] pt-[calc(var(--tpl)*0.7)] pb-[calc(var(--tpl)*0.7)]"${_scopeId2}>`);
                    _push3(ssrRenderComponent(_component_el_button, {
                      type: "primary",
                      onClick: submit,
                      class: "w-full",
                      loading: unref(locked),
                      disabled: __props.form?.form_data?.hasSubmit >= parseInt(__props.form?.form_data?.max_submit) && __props.form?.form_data?.max_submit != 0 || unref(disabledSubmit) ? true : false
                    }, {
                      default: withCtx((_3, _push4, _parent4, _scopeId3) => {
                        if (_push4) {
                          if (unref(disabledSubmit) == "login") {
                            _push4(`<span${_scopeId3}>请先登录后再</span>`);
                          } else if (unref(disabledSubmit) == "notallow") {
                            _push4(`<span${_scopeId3}>暂无权限</span>`);
                          } else {
                            _push4(`<!---->`);
                          }
                          if (__props.form?.form_data?.hasSubmit >= parseInt(__props.form?.form_data?.max_submit) && __props.form?.form_data?.max_submit != 0) {
                            _push4(`<span${_scopeId3}>${ssrInterpolate(_ctx.$t("page.modules.form.hasSubmit", [__props.form?.form_data?.max_submit]))}</span>`);
                          } else {
                            _push4(`<span${_scopeId3}>${ssrInterpolate(__props.form?.form_submit_text?.[unref(locale)] ?? "")}</span>`);
                          }
                        } else {
                          return [
                            unref(disabledSubmit) == "login" ? (openBlock(), createBlock("span", { key: 0 }, "请先登录后再")) : unref(disabledSubmit) == "notallow" ? (openBlock(), createBlock("span", { key: 1 }, "暂无权限")) : createCommentVNode("", true),
                            __props.form?.form_data?.hasSubmit >= parseInt(__props.form?.form_data?.max_submit) && __props.form?.form_data?.max_submit != 0 ? (openBlock(), createBlock("span", { key: 2 }, toDisplayString(_ctx.$t("page.modules.form.hasSubmit", [__props.form?.form_data?.max_submit])), 1)) : (openBlock(), createBlock("span", { key: 3 }, toDisplayString(__props.form?.form_submit_text?.[unref(locale)] ?? ""), 1))
                          ];
                        }
                      }),
                      _: 1
                    }, _parent3, _scopeId2));
                    _push3(`</div>`);
                  } else {
                    _push3(`<div${ssrRenderAttrs(_temp0 = mergeProps({ class: "h-60 w-full" }, ssrGetDirectiveProps(_ctx, _directive_loading, true)))}${_scopeId2}>${"textContent" in _temp0 ? ssrInterpolate(_temp0.textContent) : _temp0.innerHTML ?? ""}</div>`);
                  }
                } else {
                  return [
                    __props.form ? (openBlock(), createBlock("div", {
                      key: 0,
                      class: "flex items-center justify-start w-full h-full pl-[--tpl] pr-[--tpr] pt-[calc(var(--tpl)*0.7)] pb-[calc(var(--tpl)*0.7)]"
                    }, [
                      createVNode(_component_el_button, {
                        type: "primary",
                        onClick: submit,
                        class: "w-full",
                        loading: unref(locked),
                        disabled: __props.form?.form_data?.hasSubmit >= parseInt(__props.form?.form_data?.max_submit) && __props.form?.form_data?.max_submit != 0 || unref(disabledSubmit) ? true : false
                      }, {
                        default: withCtx(() => [
                          unref(disabledSubmit) == "login" ? (openBlock(), createBlock("span", { key: 0 }, "请先登录后再")) : unref(disabledSubmit) == "notallow" ? (openBlock(), createBlock("span", { key: 1 }, "暂无权限")) : createCommentVNode("", true),
                          __props.form?.form_data?.hasSubmit >= parseInt(__props.form?.form_data?.max_submit) && __props.form?.form_data?.max_submit != 0 ? (openBlock(), createBlock("span", { key: 2 }, toDisplayString(_ctx.$t("page.modules.form.hasSubmit", [__props.form?.form_data?.max_submit])), 1)) : (openBlock(), createBlock("span", { key: 3 }, toDisplayString(__props.form?.form_submit_text?.[unref(locale)] ?? ""), 1))
                        ]),
                        _: 1
                      }, 8, ["loading", "disabled"])
                    ])) : withDirectives((openBlock(), createBlock("div", {
                      key: 1,
                      class: "h-60 w-full"
                    }, null, 512)), [
                      [_directive_loading, true]
                    ])
                  ];
                }
              }),
              _: 1
            }, _parent2, _scopeId));
          } else {
            return [
              (openBlock(true), createBlock(Fragment, null, renderList(__props.form?.form_data?.form, (item) => {
                return withDirectives((openBlock(), createBlock(_component_el_form_item, {
                  key: `${item.key}`,
                  prop: item.key,
                  required: item.required == 1 ? true : false,
                  class: `w-full border-b border-dashed pl-[--tpl] pr-[--tpr] pt-[calc(var(--tpl)*0.5)] pb-[calc(var(--tpl)*0.5)] ${item.type == "confirm" ? "!py-2" : ""}`,
                  id: `${item.key}`,
                  "aria-labelledby": `${item.key}`
                }, {
                  default: withCtx(() => [
                    item.type != "content" && item.type != "confirm" ? (openBlock(), createBlock("label", {
                      key: 0,
                      class: "font-600"
                    }, [
                      createTextVNode(toDisplayString(item.type != "content" && item.type != "confirm" ? item.name?.[unref(locale)] ?? "" : ""), 1),
                      parseInt(item.required) == 1 ? (openBlock(), createBlock("span", {
                        key: 0,
                        class: "text-red-500 ml-1"
                      }, "*")) : createCommentVNode("", true)
                    ])) : createCommentVNode("", true),
                    createVNode("div", { class: "flex flex-col w-full" }, [
                      item.type == "text" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                        item.inputType == "text" ? (openBlock(), createBlock(Fragment, { key: 0 }, [
                          createVNode(_component_el_input, {
                            placeholder: item.placeholder?.[unref(locale)] ?? "",
                            type: item.inputType,
                            modelValue: unref(formData)[item.key],
                            "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                            id: `${item.key}-input`,
                            "aria-labelledby": `${item.key}-input`,
                            disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false),
                            required: parseInt(item.required) == 1 ? true : false
                          }, null, 8, ["placeholder", "type", "modelValue", "onUpdate:modelValue", "id", "aria-labelledby", "disabled", "required"]),
                          createVNode("div", {
                            innerHTML: item.description?.[unref(locale)] ?? "",
                            class: "text-xs mt-2 opacity-80"
                          }, null, 8, ["innerHTML"])
                        ], 64)) : createCommentVNode("", true),
                        item.inputType == "number" ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                          createVNode(_component_el_input_number, {
                            modelValue: unref(formData)[item.key],
                            "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                            placeholder: item.placeholder?.[unref(locale)] ?? "",
                            disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "disabled"]),
                          item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                            key: 0,
                            innerHTML: item.description?.[unref(locale)] ?? "",
                            class: "text-xs mt-2 opacity-80"
                          }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                        ], 64)) : item.inputType == "date" ? (openBlock(), createBlock(Fragment, { key: 2 }, [
                          createVNode(_component_el_date_picker, {
                            modelValue: unref(formData)[item.key],
                            "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                            disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false),
                            type: "datetime",
                            placeholder: item.placeholder?.[unref(locale)] ?? ""
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled", "placeholder"]),
                          item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                            key: 0,
                            innerHTML: item.description?.[unref(locale)] ?? "",
                            class: "text-xs mt-2 opacity-80"
                          }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                        ], 64)) : item.inputType == "color" ? (openBlock(), createBlock(Fragment, { key: 3 }, [
                          createVNode(_component_el_color_picker, {
                            modelValue: unref(formData)[item.key],
                            "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                            disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "disabled"]),
                          item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                            key: 0,
                            innerHTML: item.description?.[unref(locale)] ?? "",
                            class: "text-xs mt-2 opacity-80"
                          }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                        ], 64)) : item.inputType == "phone" ? (openBlock(), createBlock(Fragment, { key: 4 }, [
                          createVNode(_component_ModulesCommonFormPhone, {
                            modelValue: unref(formData)[item.key],
                            "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                            settings: item,
                            disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                          }, null, 8, ["modelValue", "onUpdate:modelValue", "settings", "disabled"]),
                          item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                            key: 0,
                            innerHTML: item.description?.[unref(locale)] ?? "",
                            class: "text-xs mt-2 opacity-80"
                          }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                        ], 64)) : createCommentVNode("", true)
                      ], 64)) : item.type == "textarea" ? (openBlock(), createBlock(Fragment, { key: 1 }, [
                        createVNode(_component_el_input, {
                          modelValue: unref(formData)[item.key],
                          "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                          placeholder: item.placeholder?.[unref(locale)] ?? "",
                          type: "textarea",
                          autosize: { minRows: 4, maxRows: 8 },
                          disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                        }, null, 8, ["modelValue", "onUpdate:modelValue", "placeholder", "disabled"]),
                        item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                          key: 0,
                          innerHTML: item.description?.[unref(locale)] ?? "",
                          class: "text-xs mt-2 opacity-80"
                        }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                      ], 64)) : item.type == "select" ? (openBlock(), createBlock(Fragment, { key: 2 }, [
                        createVNode(_component_el_select, {
                          modelValue: unref(formData)[item.key],
                          "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                          placeholder: item.placeholder?.[unref(locale)] ?? "",
                          disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                        }, {
                          default: withCtx(() => [
                            (openBlock(true), createBlock(Fragment, null, renderList(stringToArray(item.options?.[unref(locale)] ?? "") ?? [], (_item) => {
                              return openBlock(), createBlock(_component_el_option, {
                                key: _item,
                                value: _item,
                                label: _item
                              }, null, 8, ["value", "label"]);
                            }), 128))
                          ]),
                          _: 2
                        }, 1032, ["modelValue", "onUpdate:modelValue", "placeholder", "disabled"]),
                        item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                          key: 0,
                          innerHTML: item.description?.[unref(locale)] ?? "",
                          class: "text-xs mt-2 opacity-80"
                        }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                      ], 64)) : item.type == "radio" ? (openBlock(), createBlock(Fragment, { key: 3 }, [
                        createVNode(_component_el_radio_group, {
                          modelValue: unref(formData)[item.key],
                          "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                          disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                        }, {
                          default: withCtx(() => [
                            (openBlock(true), createBlock(Fragment, null, renderList(stringToArray(item.options?.[unref(locale)] ?? "") ?? [], (_item) => {
                              return openBlock(), createBlock(_component_el_radio, {
                                value: _item,
                                border: "",
                                key: _item
                              }, {
                                default: withCtx(() => [
                                  createTextVNode(toDisplayString(_item), 1)
                                ]),
                                _: 2
                              }, 1032, ["value"]);
                            }), 128))
                          ]),
                          _: 2
                        }, 1032, ["modelValue", "onUpdate:modelValue", "disabled"]),
                        item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                          key: 0,
                          innerHTML: item.description?.[unref(locale)] ?? "",
                          class: "text-xs mt-2 opacity-80"
                        }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                      ], 64)) : item.type == "checkbox" ? (openBlock(), createBlock(Fragment, { key: 4 }, [
                        createVNode(_component_el_checkbox_group, {
                          modelValue: unref(formData)[item.key],
                          "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                          disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                        }, {
                          default: withCtx(() => [
                            (openBlock(true), createBlock(Fragment, null, renderList(stringToArray(item.options?.[unref(locale)] ?? "") ?? [], (_item) => {
                              return openBlock(), createBlock(_component_el_checkbox, {
                                value: _item,
                                border: "",
                                key: _item
                              }, {
                                default: withCtx(() => [
                                  createTextVNode(toDisplayString(_item), 1)
                                ]),
                                _: 2
                              }, 1032, ["value"]);
                            }), 128))
                          ]),
                          _: 2
                        }, 1032, ["modelValue", "onUpdate:modelValue", "disabled"]),
                        item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                          key: 0,
                          innerHTML: item.description?.[unref(locale)] ?? "",
                          class: "text-xs mt-2 opacity-80"
                        }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                      ], 64)) : item.type == "file" ? (openBlock(), createBlock(Fragment, { key: 5 }, [
                        createVNode(_component_ModulesCommonFormFile, {
                          settings: item,
                          modelValue: unref(formData)[item.key],
                          "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                          files: unref(formData)[item.key + "-file"],
                          disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false)
                        }, null, 8, ["settings", "modelValue", "onUpdate:modelValue", "files", "disabled"]),
                        item.description?.[unref(locale)] ? (openBlock(), createBlock("div", {
                          key: 0,
                          innerHTML: item.description?.[unref(locale)] ?? "",
                          class: "text-xs mt-2 opacity-80"
                        }, null, 8, ["innerHTML"])) : createCommentVNode("", true)
                      ], 64)) : item.type == "content" ? (openBlock(), createBlock("div", {
                        key: 6,
                        innerHTML: item.content?.[unref(locale)] ?? ""
                      }, null, 8, ["innerHTML"])) : item.type == "confirm" ? (openBlock(), createBlock(_component_el_checkbox, {
                        key: 7,
                        modelValue: unref(formData)[item.key],
                        "onUpdate:modelValue": ($event) => unref(formData)[item.key] = $event,
                        disabled: (unref(disabledArr).includes(item.key) ? true : false) || (parseInt(item.readonly) == 1 ? true : false),
                        class: "confirm-checkbox"
                      }, {
                        default: withCtx(() => [
                          createVNode("div", {
                            innerHTML: item.confirmType?.[unref(locale)] ?? ""
                          }, null, 8, ["innerHTML"])
                        ]),
                        _: 2
                      }, 1032, ["modelValue", "onUpdate:modelValue", "disabled"])) : createCommentVNode("", true)
                    ])
                  ]),
                  _: 2
                }, 1032, ["prop", "required", "class", "id", "aria-labelledby"])), [
                  [vShow, ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).checkCondition(item.dependency, unref(formData))]
                ]);
              }), 128)),
              __props.form?.form_data?.pay_open == 1 ? (openBlock(), createBlock(_component_el_form_item, {
                key: 0,
                class: "border-b border-dashed",
                id: "form-pay",
                "aria-labelledby": "form-pay"
              }, {
                default: withCtx(() => [
                  createVNode(_component_ModulesCommonFormPay, {
                    class: "flex flex-col w-full h-full pl-[--tpl] pr-[--tpr] pt-[calc(var(--tpl)*0.7)] pb-[calc(var(--tpl)*0.7)]",
                    settings: __props.form?.form_data,
                    formData: unref(formData),
                    id: __props.form.id,
                    verifyKey: __props.verifyKey,
                    title: __props.title,
                    type: __props.type,
                    size: __props.size || "default",
                    ref_key: "payRef",
                    ref: payRef,
                    "onUpdate:formData": reload
                  }, null, 8, ["settings", "formData", "id", "verifyKey", "title", "type", "size"])
                ]),
                _: 1
              })) : createCommentVNode("", true),
              createVNode(_component_el_form_item, {
                id: "form-submit",
                "aria-labelledby": "form-submit"
              }, {
                default: withCtx(() => [
                  __props.form ? (openBlock(), createBlock("div", {
                    key: 0,
                    class: "flex items-center justify-start w-full h-full pl-[--tpl] pr-[--tpr] pt-[calc(var(--tpl)*0.7)] pb-[calc(var(--tpl)*0.7)]"
                  }, [
                    createVNode(_component_el_button, {
                      type: "primary",
                      onClick: submit,
                      class: "w-full",
                      loading: unref(locked),
                      disabled: __props.form?.form_data?.hasSubmit >= parseInt(__props.form?.form_data?.max_submit) && __props.form?.form_data?.max_submit != 0 || unref(disabledSubmit) ? true : false
                    }, {
                      default: withCtx(() => [
                        unref(disabledSubmit) == "login" ? (openBlock(), createBlock("span", { key: 0 }, "请先登录后再")) : unref(disabledSubmit) == "notallow" ? (openBlock(), createBlock("span", { key: 1 }, "暂无权限")) : createCommentVNode("", true),
                        __props.form?.form_data?.hasSubmit >= parseInt(__props.form?.form_data?.max_submit) && __props.form?.form_data?.max_submit != 0 ? (openBlock(), createBlock("span", { key: 2 }, toDisplayString(_ctx.$t("page.modules.form.hasSubmit", [__props.form?.form_data?.max_submit])), 1)) : (openBlock(), createBlock("span", { key: 3 }, toDisplayString(__props.form?.form_submit_text?.[unref(locale)] ?? ""), 1))
                      ]),
                      _: 1
                    }, 8, ["loading", "disabled"])
                  ])) : withDirectives((openBlock(), createBlock("div", {
                    key: 1,
                    class: "h-60 w-full"
                  }, null, 512)), [
                    [_directive_loading, true]
                  ])
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/form/form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
