import { E as ElAvatar } from './index-R6EFYpWa.mjs';
import { pick, castArray } from 'lodash-unified';
import { a0 as buildProps, a2 as definePropType, P as withInstall, C as useNamespace, ay as useId, v as viewerStore, k as deviceStore, j as actionStore, d as useRoute, r as useRequest, e as useUtils, x as __nuxt_component_0$1, D as useLocale, aM as getLoginData } from './server.mjs';
import { u as useTooltipContentProps, E as ElTooltip } from './index-Cx5QSQzK.mjs';
import { i as inputProps, E as ElInput } from './index-Cs8YDU9s.mjs';
import { isFunction, isString, isObject } from '@vue/shared';
import { U as UPDATE_MODEL_EVENT, I as INPUT_EVENT } from './event-BZTOGHfp.mjs';
import { useSSRContext, defineComponent, computed, ref, nextTick, openBlock, createElementBlock, normalizeClass, unref, createVNode, mergeProps, createSlots, renderList, withCtx, renderSlot, normalizeProps, guardReactiveProps, withModifiers, createElementVNode, normalizeStyle, inject, toDisplayString, createBlock, Fragment, createTextVNode, watch, createCommentVNode, withDirectives, vShow } from 'vue';
import { E as ElScrollbar } from './index-tCyBRCDx.mjs';
import { u as useFormDisabled } from './use-form-item-Cr81A1TZ.mjs';
import { u as useFocusController } from './index-Bp-nwGzu.mjs';
import { g as getEventCode, b as EVENT_CODE } from './focus-trap.vue-9ChHxs3Q.mjs';
import { _ as __nuxt_component_4 } from './Image-BE6Y-a3S.mjs';
import { E as ElButton } from './index-DYnTqrQe.mjs';
import __nuxt_component_3 from './smileButton-HPVl__f7.mjs';
import __nuxt_component_1 from './locked-zq4kuCSC.mjs';
import { ssrRenderAttrs, ssrRenderClass, ssrRenderStyle, ssrRenderAttr, ssrRenderComponent, ssrInterpolate, ssrRenderList } from 'vue/server-renderer';
import { VueDraggable } from 'vue-draggable-plus';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@popperjs/core';
import './vnode-l2ZP2UQa.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'quick-lru';
import './index-DRiwogtD.mjs';
import './aria-BhThsKez.mjs';
import './index-ChPMoinw.mjs';
import './constants-hAKFmBbq.mjs';
import './index-BKB3Djp4.mjs';
import './image-viewer-DG2qIWb8.mjs';
import './index-Di0Jlzch.mjs';
import './index-31HAFSrO.mjs';
import '@ctrl/tinycolor';
import './popover-B8HtRMY4.mjs';

/* empty css                 */
const filterOption = (pattern, option) => {
  const lowerCase = pattern.toLowerCase();
  const label = option.label || option.value || "";
  return label.toLowerCase().includes(lowerCase);
};
const getMentionCtx = (inputEl, prefix, split) => {
  const { selectionEnd } = inputEl;
  if (selectionEnd === null) return;
  const inputValue = inputEl.value;
  const prefixArray = castArray(prefix);
  let splitIndex = -1;
  let mentionCtx;
  for (let i = selectionEnd - 1; i >= 0; --i) {
    const char = inputValue[i];
    if (char === split || char === "\n" || char === "\r") {
      splitIndex = i;
      continue;
    }
    if (prefixArray.includes(char)) {
      const end = splitIndex === -1 ? selectionEnd : splitIndex;
      const pattern = inputValue.slice(i + 1, end);
      mentionCtx = {
        pattern,
        start: i + 1,
        end,
        prefix: char,
        prefixIndex: i,
        splitIndex,
        selectionEnd
      };
      break;
    }
  }
  return mentionCtx;
};
const getCursorPosition = (element, options = {
  debug: false,
  useSelectionEnd: false
}) => {
  const selectionStart = element.selectionStart !== null ? element.selectionStart : 0;
  const selectionEnd = element.selectionEnd !== null ? element.selectionEnd : 0;
  const position = options.useSelectionEnd ? selectionEnd : selectionStart;
  const properties = [
    "direction",
    // RTL support
    "boxSizing",
    "width",
    // on Chrome and IE, exclude the scrollbar, so the mirror div wraps exactly as the textarea does
    "height",
    "overflowX",
    "overflowY",
    // copy the scrollbar for IE
    "borderTopWidth",
    "borderRightWidth",
    "borderBottomWidth",
    "borderLeftWidth",
    "borderStyle",
    "paddingTop",
    "paddingRight",
    "paddingBottom",
    "paddingLeft",
    // https://developer.mozilla.org/en-US/docs/Web/CSS/font
    "fontStyle",
    "fontVariant",
    "fontWeight",
    "fontStretch",
    "fontSize",
    "fontSizeAdjust",
    "lineHeight",
    "fontFamily",
    "textAlign",
    "textTransform",
    "textIndent",
    "textDecoration",
    // might not make a difference, but better be safe
    "letterSpacing",
    "wordSpacing",
    "tabSize",
    "MozTabSize"
  ];
  if (options.debug) {
    const el = (void 0).querySelector(
      "#input-textarea-caret-position-mirror-div"
    );
    if (el == null ? void 0 : el.parentNode) el.parentNode.removeChild(el);
  }
  const div = (void 0).createElement("div");
  div.id = "input-textarea-caret-position-mirror-div";
  (void 0).body.appendChild(div);
  const style = div.style;
  const computed2 = (void 0).getComputedStyle(element);
  const isInput = element.nodeName === "INPUT";
  style.whiteSpace = isInput ? "nowrap" : "pre-wrap";
  if (!isInput) style.wordWrap = "break-word";
  style.position = "absolute";
  if (!options.debug) style.visibility = "hidden";
  properties.forEach((prop) => {
    if (isInput && prop === "lineHeight") {
      if (computed2.boxSizing === "border-box") {
        const height = Number.parseInt(computed2.height);
        const outerHeight = Number.parseInt(computed2.paddingTop) + Number.parseInt(computed2.paddingBottom) + Number.parseInt(computed2.borderTopWidth) + Number.parseInt(computed2.borderBottomWidth);
        const targetHeight = outerHeight + Number.parseInt(computed2.lineHeight);
        if (height > targetHeight) {
          style.lineHeight = `${height - outerHeight}px`;
        } else if (height === targetHeight) {
          style.lineHeight = computed2.lineHeight;
        } else {
          style.lineHeight = "0";
        }
      } else {
        style.lineHeight = computed2.height;
      }
    } else {
      style[prop] = computed2[prop];
    }
  });
  {
    style.overflow = "hidden";
  }
  div.textContent = element.value.slice(0, Math.max(0, position));
  if (isInput && div.textContent) {
    div.textContent = div.textContent.replace(/\s/g, " ");
  }
  const span = (void 0).createElement("span");
  span.textContent = element.value.slice(Math.max(0, position)) || ".";
  span.style.position = "relative";
  span.style.left = `${-element.scrollLeft}px`;
  span.style.top = `${-element.scrollTop}px`;
  div.appendChild(span);
  const relativePosition = {
    top: span.offsetTop + Number.parseInt(computed2.borderTopWidth),
    left: span.offsetLeft + Number.parseInt(computed2.borderLeftWidth),
    // We don't use line-height since it may be too large for position. Eg. 34px
    // for input
    height: Number.parseInt(computed2.fontSize) * 1.5
  };
  if (options.debug) {
    span.style.backgroundColor = "#aaa";
  } else {
    (void 0).body.removeChild(div);
  }
  if (relativePosition.left >= element.clientWidth) {
    relativePosition.left = element.clientWidth;
  }
  return relativePosition;
};
const mentionProps = buildProps({
  ...inputProps,
  /**
   * @description mention options list
   */
  options: {
    type: definePropType(Array),
    default: () => []
  },
  /**
   * @description prefix character to trigger mentions. The string length must be exactly 1.
   */
  prefix: {
    type: definePropType([String, Array]),
    default: "@",
    validator: (val) => {
      if (isString(val)) return val.length === 1;
      return val.every((v) => isString(v) && v.length === 1);
    }
  },
  /**
   * @description character to split mentions. The string length must be exactly 1.
   */
  split: {
    type: String,
    default: " ",
    validator: (val) => val.length === 1
  },
  /**
   * @description customize filter option logic.
   */
  filterOption: {
    type: definePropType([Boolean, Function]),
    default: () => filterOption,
    validator: (val) => {
      if (val === false) return true;
      return isFunction(val);
    }
  },
  /**
   * @description set popup placement
   */
  placement: {
    type: definePropType(String),
    default: "bottom"
  },
  /**
   * @description whether the dropdown panel has an arrow
   */
  showArrow: Boolean,
  /**
   * @description offset of the dropdown panel
   */
  offset: {
    type: Number,
    default: 0
  },
  /**
   * @description when backspace is pressed to delete, whether the mention content is deleted as a whole
   */
  whole: Boolean,
  /**
   * @description when backspace is pressed to delete, check if the mention is a whole
   */
  checkIsWhole: {
    type: definePropType(
      Function
    )
  },
  /**
   * @description input value
   */
  modelValue: String,
  /**
   * @description whether the dropdown panel of mentions is in a loading state.
   */
  loading: Boolean,
  /**
   * @description custom class name for dropdown panel
   */
  popperClass: useTooltipContentProps.popperClass,
  /**
   * @description custom style for dropdown panel
   */
  popperStyle: useTooltipContentProps.popperStyle,
  /**
   * @description [popper.js](https://popper.js.org/docs/v2/) parameters
   */
  popperOptions: {
    type: definePropType(Object),
    default: () => ({})
  },
  /**
   * @description configuration options
   */
  props: {
    type: definePropType(Object),
    default: () => mentionDefaultProps
  }
});
const mentionEmits = {
  [UPDATE_MODEL_EVENT]: (value) => isString(value),
  "whole-remove": (pattern, prefix) => isString(pattern) && isString(prefix),
  input: (value) => isString(value),
  search: (pattern, prefix) => isString(pattern) && isString(prefix),
  select: (option, prefix) => isObject(option) && isString(prefix),
  focus: (evt) => evt instanceof FocusEvent,
  blur: (evt) => evt instanceof FocusEvent
};
const mentionDefaultProps = {
  value: "value",
  label: "label",
  disabled: "disabled"
};
const mentionDropdownProps = buildProps({
  options: {
    type: definePropType(Array),
    default: () => []
  },
  loading: Boolean,
  disabled: Boolean,
  contentId: String,
  ariaLabel: String
});
const mentionDropdownEmits = {
  select: (option) => isString(option.value)
};
const _hoisted_1 = ["id", "aria-disabled", "aria-selected", "onMousemove", "onClick"];
var _sfc_main$2 = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElMentionDropdown"
  },
  __name: "mention-dropdown",
  props: mentionDropdownProps,
  emits: mentionDropdownEmits,
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const ns = useNamespace("mention");
    const { t } = useLocale();
    const hoveringIndex = ref(-1);
    const scrollbarRef = ref();
    const optionRefs = ref();
    const dropdownRef = ref();
    const optionkls = (item, index) => [
      ns.be("dropdown", "item"),
      ns.is("hovering", hoveringIndex.value === index),
      ns.is("disabled", item.disabled || props.disabled)
    ];
    const handleSelect = (item) => {
      if (item.disabled || props.disabled) return;
      emit("select", item);
    };
    const handleMouseEnter = (index) => {
      hoveringIndex.value = index;
    };
    const filteredAllDisabled = computed(
      () => props.disabled || props.options.every((item) => item.disabled)
    );
    const hoverOption = computed(() => props.options[hoveringIndex.value]);
    const selectHoverOption = () => {
      if (!hoverOption.value) return;
      emit("select", hoverOption.value);
    };
    const navigateOptions = (direction) => {
      const { options } = props;
      if (options.length === 0 || filteredAllDisabled.value) return;
      if (direction === "next") {
        hoveringIndex.value++;
        if (hoveringIndex.value === options.length) {
          hoveringIndex.value = 0;
        }
      } else if (direction === "prev") {
        hoveringIndex.value--;
        if (hoveringIndex.value < 0) {
          hoveringIndex.value = options.length - 1;
        }
      }
      const option = options[hoveringIndex.value];
      if (option.disabled) {
        navigateOptions(direction);
        return;
      }
      nextTick(() => scrollToOption(option));
    };
    const scrollToOption = (option) => {
      var _a, _b, _c, _d;
      const { options } = props;
      const index = options.findIndex((item) => item.value === option.value);
      const target = (_a = optionRefs.value) == null ? void 0 : _a[index];
      if (target) {
        (_c = (_b = dropdownRef.value) == null ? void 0 : _b.querySelector) == null ? void 0 : _c.call(
          _b,
          `.${ns.be("dropdown", "wrap")}`
        );
      }
      (_d = scrollbarRef.value) == null ? void 0 : _d.handleScroll();
    };
    const resetHoveringIndex = () => {
      if (filteredAllDisabled.value || props.options.length === 0) {
        hoveringIndex.value = -1;
      } else {
        hoveringIndex.value = 0;
      }
    };
    watch(() => props.options, resetHoveringIndex, {
      immediate: true
    });
    __expose({
      hoveringIndex,
      navigateOptions,
      selectHoverOption,
      hoverOption
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          ref_key: "dropdownRef",
          ref: dropdownRef,
          class: normalizeClass(unref(ns).b("dropdown"))
        },
        [
          _ctx.$slots.header ? (openBlock(), createElementBlock(
            "div",
            {
              key: 0,
              class: normalizeClass(unref(ns).be("dropdown", "header"))
            },
            [
              renderSlot(_ctx.$slots, "header")
            ],
            2
            /* CLASS */
          )) : createCommentVNode("v-if", true),
          withDirectives(createVNode(unref(ElScrollbar), {
            id: __props.contentId,
            ref_key: "scrollbarRef",
            ref: scrollbarRef,
            tag: "ul",
            "wrap-class": unref(ns).be("dropdown", "wrap"),
            "view-class": unref(ns).be("dropdown", "list"),
            role: "listbox",
            "aria-label": __props.ariaLabel,
            "aria-orientation": "vertical"
          }, {
            default: withCtx(() => [
              (openBlock(true), createElementBlock(
                Fragment,
                null,
                renderList(__props.options, (item, index) => {
                  return openBlock(), createElementBlock("li", {
                    id: `${__props.contentId}-${index}`,
                    ref_for: true,
                    ref_key: "optionRefs",
                    ref: optionRefs,
                    key: index,
                    class: normalizeClass(optionkls(item, index)),
                    role: "option",
                    "aria-disabled": item.disabled || __props.disabled || void 0,
                    "aria-selected": hoveringIndex.value === index,
                    onMousemove: ($event) => handleMouseEnter(index),
                    onClick: withModifiers(($event) => handleSelect(item), ["stop"])
                  }, [
                    renderSlot(_ctx.$slots, "label", {
                      item,
                      index
                    }, () => {
                      var _a;
                      return [
                        createElementVNode(
                          "span",
                          null,
                          toDisplayString((_a = item.label) != null ? _a : item.value),
                          1
                          /* TEXT */
                        )
                      ];
                    })
                  ], 42, _hoisted_1);
                }),
                128
                /* KEYED_FRAGMENT */
              ))
            ]),
            _: 3
            /* FORWARDED */
          }, 8, ["id", "wrap-class", "view-class", "aria-label"]), [
            [vShow, __props.options.length > 0 && !__props.loading]
          ]),
          __props.loading ? (openBlock(), createElementBlock(
            "div",
            {
              key: 1,
              class: normalizeClass(unref(ns).be("dropdown", "loading"))
            },
            [
              renderSlot(_ctx.$slots, "loading", {}, () => [
                createTextVNode(
                  toDisplayString(unref(t)("el.mention.loading")),
                  1
                  /* TEXT */
                )
              ])
            ],
            2
            /* CLASS */
          )) : createCommentVNode("v-if", true),
          _ctx.$slots.footer ? (openBlock(), createElementBlock(
            "div",
            {
              key: 2,
              class: normalizeClass(unref(ns).be("dropdown", "footer"))
            },
            [
              renderSlot(_ctx.$slots, "footer")
            ],
            2
            /* CLASS */
          )) : createCommentVNode("v-if", true)
        ],
        2
        /* CLASS */
      );
    };
  }
});
var _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElMention",
    inheritAttrs: false
  },
  __name: "mention",
  props: mentionProps,
  emits: mentionEmits,
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const passInputProps = computed(() => pick(props, Object.keys(inputProps)));
    const ns = useNamespace("mention");
    const disabled = useFormDisabled();
    const contentId = useId();
    const elInputRef = ref();
    const tooltipRef = ref();
    const dropdownRef = ref();
    const visible = ref(false);
    const cursorStyle = ref();
    const mentionCtx = ref();
    const computedPlacement = computed(
      () => props.showArrow ? props.placement : `${props.placement}-start`
    );
    const computedFallbackPlacements = computed(
      () => props.showArrow ? ["bottom", "top"] : ["bottom-start", "top-start"]
    );
    const aliasProps = computed(() => ({
      ...mentionDefaultProps,
      ...props.props
    }));
    const mapOption = (option) => {
      const base = {
        label: option[aliasProps.value.label],
        value: option[aliasProps.value.value],
        disabled: option[aliasProps.value.disabled]
      };
      return { ...option, ...base };
    };
    const options = computed(() => props.options.map(mapOption));
    const filteredOptions = computed(() => {
      const { filterOption: filterOption2 } = props;
      if (!mentionCtx.value || !filterOption2) return options.value;
      return options.value.filter(
        (option) => filterOption2(mentionCtx.value.pattern, option)
      );
    });
    const dropdownVisible = computed(() => {
      return visible.value && (!!filteredOptions.value.length || props.loading);
    });
    const hoveringId = computed(() => {
      var _a;
      return `${contentId.value}-${(_a = dropdownRef.value) == null ? void 0 : _a.hoveringIndex}`;
    });
    const handleInputChange = (value) => {
      emit(UPDATE_MODEL_EVENT, value);
      emit(INPUT_EVENT, value);
      syncAfterCursorMove();
    };
    const handleInputKeyDown = (event) => {
      var _a, _b, _c, _d;
      if ((_a = elInputRef.value) == null ? void 0 : _a.isComposing) return;
      const code = getEventCode(event);
      switch (code) {
        case EVENT_CODE.left:
        case EVENT_CODE.right:
          syncAfterCursorMove();
          break;
        case EVENT_CODE.up:
        case EVENT_CODE.down:
          if (!visible.value) return;
          event.preventDefault();
          (_b = dropdownRef.value) == null ? void 0 : _b.navigateOptions(
            code === EVENT_CODE.up ? "prev" : "next"
          );
          break;
        case EVENT_CODE.enter:
        case EVENT_CODE.numpadEnter:
          if (!visible.value) {
            props.type !== "textarea" && syncAfterCursorMove();
            return;
          }
          event.preventDefault();
          if ((_c = dropdownRef.value) == null ? void 0 : _c.hoverOption) {
            (_d = dropdownRef.value) == null ? void 0 : _d.selectHoverOption();
          } else {
            visible.value = false;
          }
          break;
        case EVENT_CODE.esc:
          if (!visible.value) return;
          event.preventDefault();
          visible.value = false;
          break;
        case EVENT_CODE.backspace:
          if (props.whole && mentionCtx.value) {
            const { splitIndex, selectionEnd, pattern, prefixIndex, prefix } = mentionCtx.value;
            const inputEl = getInputEl();
            if (!inputEl) return;
            const inputValue = inputEl.value;
            const matchOption = options.value.find((item) => item.value === pattern);
            const isWhole = isFunction(props.checkIsWhole) ? props.checkIsWhole(pattern, prefix) : matchOption;
            if (isWhole && splitIndex !== -1 && splitIndex + 1 === selectionEnd) {
              event.preventDefault();
              const newValue = inputValue.slice(0, prefixIndex) + inputValue.slice(splitIndex + 1);
              emit(UPDATE_MODEL_EVENT, newValue);
              emit(INPUT_EVENT, newValue);
              emit("whole-remove", pattern, prefix);
              const newSelectionEnd = prefixIndex;
              nextTick(() => {
                inputEl.selectionStart = newSelectionEnd;
                inputEl.selectionEnd = newSelectionEnd;
                syncDropdownVisible();
              });
            }
          }
      }
    };
    const { wrapperRef } = useFocusController(elInputRef, {
      disabled,
      afterFocus() {
        syncAfterCursorMove();
      },
      beforeBlur(event) {
        var _a;
        return (_a = tooltipRef.value) == null ? void 0 : _a.isFocusInsideContent(event);
      },
      afterBlur() {
        visible.value = false;
      }
    });
    const handleInputMouseDown = () => {
      syncAfterCursorMove();
    };
    const getOriginalOption = (mentionOption) => {
      return props.options.find((option) => {
        return mentionOption.value === option[aliasProps.value.value];
      });
    };
    const handleSelect = (item) => {
      if (!mentionCtx.value) return;
      const inputEl = getInputEl();
      if (!inputEl) return;
      const inputValue = inputEl.value;
      const { split } = props;
      const newEndPart = inputValue.slice(mentionCtx.value.end);
      const alreadySeparated = newEndPart.startsWith(split);
      const newMiddlePart = `${item.value}${alreadySeparated ? "" : split}`;
      const newValue = inputValue.slice(0, mentionCtx.value.start) + newMiddlePart + newEndPart;
      emit(UPDATE_MODEL_EVENT, newValue);
      emit(INPUT_EVENT, newValue);
      emit("select", getOriginalOption(item), mentionCtx.value.prefix);
      const newSelectionEnd = mentionCtx.value.start + newMiddlePart.length + (alreadySeparated ? 1 : 0);
      nextTick(() => {
        inputEl.selectionStart = newSelectionEnd;
        inputEl.selectionEnd = newSelectionEnd;
        inputEl.focus();
        syncDropdownVisible();
      });
    };
    const getInputEl = () => {
      var _a, _b;
      return props.type === "textarea" ? (_a = elInputRef.value) == null ? void 0 : _a.textarea : (_b = elInputRef.value) == null ? void 0 : _b.input;
    };
    const syncAfterCursorMove = () => {
      setTimeout(() => {
        syncCursor();
        syncDropdownVisible();
        nextTick(() => {
          var _a;
          return (_a = tooltipRef.value) == null ? void 0 : _a.updatePopper();
        });
      }, 0);
    };
    const syncCursor = () => {
      const inputEl = getInputEl();
      if (!inputEl) return;
      const caretPosition = getCursorPosition(inputEl);
      const inputRect = inputEl.getBoundingClientRect();
      const wrapperRect = wrapperRef.value.getBoundingClientRect();
      cursorStyle.value = {
        position: "absolute",
        width: 0,
        height: `${caretPosition.height}px`,
        left: `${caretPosition.left + inputRect.left - wrapperRect.left}px`,
        top: `${caretPosition.top + inputRect.top - wrapperRect.top}px`
      };
    };
    const syncDropdownVisible = () => {
      const inputEl = getInputEl();
      if ((void 0).activeElement !== inputEl) {
        visible.value = false;
        return;
      }
      const { prefix, split } = props;
      mentionCtx.value = getMentionCtx(inputEl, prefix, split);
      if (mentionCtx.value && mentionCtx.value.splitIndex === -1) {
        visible.value = true;
        emit("search", mentionCtx.value.pattern, mentionCtx.value.prefix);
        return;
      }
      visible.value = false;
    };
    __expose({
      input: elInputRef,
      tooltip: tooltipRef,
      dropdownVisible
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          ref_key: "wrapperRef",
          ref: wrapperRef,
          class: normalizeClass(unref(ns).b())
        },
        [
          createVNode(unref(ElInput), mergeProps(mergeProps(passInputProps.value, _ctx.$attrs), {
            ref_key: "elInputRef",
            ref: elInputRef,
            "model-value": __props.modelValue,
            disabled: unref(disabled),
            role: dropdownVisible.value ? "combobox" : void 0,
            "aria-activedescendant": dropdownVisible.value ? hoveringId.value || "" : void 0,
            "aria-controls": dropdownVisible.value ? unref(contentId) : void 0,
            "aria-expanded": dropdownVisible.value || void 0,
            "aria-label": __props.ariaLabel,
            "aria-autocomplete": dropdownVisible.value ? "none" : void 0,
            "aria-haspopup": dropdownVisible.value ? "listbox" : void 0,
            onInput: handleInputChange,
            onKeydown: handleInputKeyDown,
            onMousedown: handleInputMouseDown
          }), createSlots({
            _: 2
            /* DYNAMIC */
          }, [
            renderList(_ctx.$slots, (_, name) => {
              return {
                name,
                fn: withCtx((slotProps) => [
                  renderSlot(_ctx.$slots, name, normalizeProps(guardReactiveProps(slotProps)))
                ])
              };
            })
          ]), 1040, ["model-value", "disabled", "role", "aria-activedescendant", "aria-controls", "aria-expanded", "aria-label", "aria-autocomplete", "aria-haspopup"]),
          createVNode(unref(ElTooltip), {
            ref_key: "tooltipRef",
            ref: tooltipRef,
            visible: dropdownVisible.value,
            "popper-class": [unref(ns).e("popper"), __props.popperClass],
            "popper-style": __props.popperStyle,
            "popper-options": __props.popperOptions,
            placement: computedPlacement.value,
            "fallback-placements": computedFallbackPlacements.value,
            effect: "light",
            pure: "",
            offset: __props.offset,
            "show-arrow": __props.showArrow
          }, {
            default: withCtx(() => [
              createElementVNode(
                "div",
                {
                  style: normalizeStyle(cursorStyle.value)
                },
                null,
                4
                /* STYLE */
              )
            ]),
            content: withCtx(() => [
              createVNode(_sfc_main$2, {
                ref_key: "dropdownRef",
                ref: dropdownRef,
                options: filteredOptions.value,
                disabled: unref(disabled),
                loading: __props.loading,
                "content-id": unref(contentId),
                "aria-label": __props.ariaLabel,
                onSelect: handleSelect,
                onClick: _cache[0] || (_cache[0] = withModifiers(($event) => {
                  var _a;
                  return (_a = elInputRef.value) == null ? void 0 : _a.focus();
                }, ["stop"]))
              }, createSlots({
                _: 2
                /* DYNAMIC */
              }, [
                renderList(_ctx.$slots, (_, name) => {
                  return {
                    name,
                    fn: withCtx((slotProps) => [
                      renderSlot(_ctx.$slots, name, normalizeProps(guardReactiveProps(slotProps)))
                    ])
                  };
                })
              ]), 1032, ["options", "disabled", "loading", "content-id", "aria-label"])
            ]),
            _: 3
            /* FORWARDED */
          }, 8, ["visible", "popper-class", "popper-style", "popper-options", "placement", "fallback-placements", "offset", "show-arrow"])
        ],
        2
        /* CLASS */
      );
    };
  }
});
const ElMention = withInstall(_sfc_main$1);
const _sfc_main = {
  __name: "ModulesSingleCommentForm",
  __ssrInlineRender: true,
  props: [
    "data",
    "settings",
    "postId",
    "singlePath",
    "id",
    "singleType"
  ],
  emits: [
    "upload-comment",
    "closeCommentForm",
    "submitSuccess"
  ],
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const viewer = viewerStore();
    const device = deviceStore();
    const pageState = inject("pageState");
    const topicCanRead = computed(() => pageState.topicCanRead);
    ref(null);
    const sketchpadBox = ref(null);
    const simileTextarea = computed(() => {
      return { textarea: sketchpadBox.value?.querySelector("textarea") };
    });
    const action = actionStore();
    const route = useRoute();
    const _postId = computed(
      () => parseInt(props.postId || route.params.page?.split(".")?.[0] || route.meta.pageSettings?.id || route.params.name?.[1]?.split(".")?.[0])
    );
    const locked = ref(false);
    const upload = ref(null);
    const parent = ref(0);
    const mediaLibrary = ref(null);
    const width = ref(0);
    const resetSketchpadWidth = (size) => {
      setTimeout(() => {
        if (sketchpadBox.value) {
          width.value = sketchpadBox.value.offsetWidth;
          form.value.sketchpad.reset(width.value, width.value * 0.3);
        }
      }, 10);
    };
    __expose({ resetSketchpadWidth });
    const replyCancel = async () => {
      await nextTick();
      const commentForm = (void 0).querySelector(`#comment-form-in-${props.id}`);
      commentForm.removeAttribute("data-parent");
      const comment = (void 0).querySelector(`#comment-form-${props.id}`);
      comment.appendChild(commentForm);
      resetSketchpadWidth();
    };
    const emit = __emit;
    const form = ref({
      content: "",
      images: [],
      imageList: [],
      sketchpad: 0,
      sketch: 0,
      sketchSwitch: false,
      options: [],
      loading: false,
      closeCommentForm: () => {
        emit("closeCommentForm");
      },
      handleSearch: async (query) => {
        let ids = [];
        if (!query) {
          ids = props.data.edges.map((item) => item.node.commentAuthor.databaseId);
          ids = [...new Set(ids)];
        }
        form.value.loading = true;
        form.value.options = [];
        const res = await useRequest("/api/request", {
          body: {
            data: {
              ids: !query ? ids.join(",") : ""
            }
          }
        });
        if (res?.users?.nodes?.length > 0) {
          form.value.options = res.users.nodes.map((item) => ({
            label: item.name,
            value: item.name,
            avatar: item.avatar.url,
            id: item.databaseId
          }));
        }
        form.value.loading = false;
      }
    });
    const createComment = async () => {
      if (locked.value) return;
      locked.value = true;
      const svgBlob = form.value.sketchpad.exportAsSVG();
      if (svgBlob.size > 100) {
        upload.value.showMsg = false;
        try {
          const up = await upload.value.handleFiles([svgBlob]);
          form.value.sketch = up[0].mediaItem.databaseId;
        } catch (error) {
          locked.value = false;
          return;
        }
      }
      if (form.value.imageList.length > 0) {
        form.value.images = form.value.imageList.map(
          (item) => item.node.databaseId
        );
      }
      const commentForm = (void 0).querySelector(`#comment-form-in-${props.id}`);
      parent.value = commentForm.getAttribute("data-parent");
      const res = await useRequest("/api/request", {
        body: {
          path: props.singlePath || route.path,
          data: {
            content: form.value.content + (form.value.sketch ? "Sketch(" + form.value.sketch + ")" : "") + (form.value.images.length > 0 ? "Image(" + form.value.images.join(",") + ")" : ""),
            images: form.value.images,
            date: useUtils.getCurrentTime(),
            sketch: form.value.sketch,
            parent: parseInt(parent.value) || 0,
            commentOn: _postId.value
          }
        }
      });
      if (res?.createComment?.comment) {
        res.createComment.comment.new = true;
        if (props.postId && !props.data) {
          emit("submitSuccess", res.createComment.comment);
        } else {
          uploadComment(res.createComment.comment);
          getLoginData(action.pageData[route.path]);
        }
        await replyCancel();
        form.value.content = "";
        form.value.images = [];
        form.value.imageList = [];
        form.value.sketch = 0;
        form.value.sketchpad.clearAll();
      }
      locked.value = false;
    };
    const findIndex = (list, id) => {
      for (const k in list) {
        if (list[k].node.databaseId == id) {
          return k;
        }
        if (list[k].node.flatReplies) {
          const result = findIndex(list[k].node.flatReplies.edges, id);
          if (result) {
            return k + "." + result;
          }
        }
      }
      return null;
    };
    const uploadComment = (comment) => {
      props.data.commentCount++;
      const newComment = {
        cursor: null,
        node: comment
      };
      if (comment.parentDatabaseId) {
        const parentIndex = findIndex(props.data.edges, comment.parentDatabaseId);
        if (parentIndex !== null) {
          if (parentIndex.includes(".")) {
            const parentIndexArr = parentIndex.split(".");
            props.data.edges[parentIndexArr[0]].node.flatReplies.edges.splice(
              parentIndexArr[1] + 1,
              0,
              newComment
            );
          } else {
            if (props.data.edges[parentIndex].node.flatReplies?.edges?.length > 0) {
              props.data.edges[parentIndex].node.flatReplies.edges.unshift(
                newComment
              );
            } else {
              props.data.edges[parentIndex].node.flatReplies = {
                commentCount: 1,
                edges: [newComment]
              };
            }
          }
        }
      } else {
        props.data.edges.unshift(newComment);
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_avatar = ElAvatar;
      const _component_el_mention = ElMention;
      const _component_Image = __nuxt_component_4;
      const _component_el_button = ElButton;
      const _component_CommonFormSmileButton = __nuxt_component_3;
      const _component_CommonLocked = __nuxt_component_1;
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(`<div${ssrRenderAttrs(mergeProps({
        id: `comment-form-${__props.id}`
      }, _attrs))} data-v-7606a806><div class="${ssrRenderClass(`flex comment-form-in container-box relative ${__props.settings.gap ? "mb-" + __props.settings.gap : "mb-0 border-b !rounded-b-none"} flex-col overflow-hidden comment-rounded`)}" style="${ssrRenderStyle(`${__props.settings?.box?.backgroundCSS}`)}"${ssrRenderAttr("id", `comment-form-in-${__props.id}`)} data-v-7606a806><div class="${ssrRenderClass(`gq-gs comment-textarea rounded relative border-1 bg-[--el-color-info-light-10] ${unref(form).sketchSwitch ? "hidden" : "p-2"}`)}" data-v-7606a806>`);
      _push(ssrRenderComponent(_component_el_avatar, {
        src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(unref(viewer).data.avatar.url),
        shape: "square",
        size: 28,
        class: "!absolute top-2 left-2 border-2 border-[--el-bg-color] shadow-sm !w-6.4 !h-6.4",
        style: !unref(form).sketchSwitch ? null : { display: "none" }
      }, null, _parent));
      _push(ssrRenderComponent(_component_el_mention, {
        type: "textarea",
        autosize: { minRows: unref(device).isMobile ? 1 : 3, maxRows: 40 },
        rows: unref(device).isMobile ? 1 : 3,
        maxlength: __props.settings.limitWord || 500,
        resize: "none",
        "show-word-limit": "",
        name: "comment-form-input",
        options: unref(form).options,
        loading: unref(form).loading,
        modelValue: unref(form).content,
        "onUpdate:modelValue": ($event) => unref(form).content = $event,
        onSearch: unref(form).handleSearch,
        class: "!text-sm @md:min-h-24 !min-h-14 @xs:ml-[34px] @xs:!w-[calc(100%-34px)] ml-[30px] !w-[calc(100%-30px)]",
        style: [
          !unref(form).sketchSwitch ? null : { display: "none" },
          { "--el-input-border-color": "transparent", "--el-border-color": "transparent", "--el-input-focus-border-color": "transparent", "--el-input-bg-color": "transparent", "--el-input-hover-border-color": "transparent", "--el-fill-color-blank": "var(--el-color-info-light-10)" }
        ],
        ref: "textarea",
        placeholder: _ctx.$t("common.comment.placeholder")
      }, {
        label: withCtx(({ item }, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div style="${ssrRenderStyle({ "display": "flex", "align-items": "center" })}" data-v-7606a806${_scopeId}>`);
            _push2(ssrRenderComponent(_component_el_avatar, {
              size: 24,
              src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item.avatar.url)
            }, null, _parent2, _scopeId));
            _push2(`<span style="${ssrRenderStyle({ "margin-left": "6px" })}" data-v-7606a806${_scopeId}>${ssrInterpolate(item.value)}</span><span class="text-[11px] opacity-70" data-v-7606a806${_scopeId}>(id:${ssrInterpolate(item.id)})</span></div>`);
          } else {
            return [
              createVNode("div", { style: { "display": "flex", "align-items": "center" } }, [
                createVNode(_component_el_avatar, {
                  size: 24,
                  src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(item.avatar.url)
                }, null, 8, ["src"]),
                createVNode("span", { style: { "margin-left": "6px" } }, toDisplayString(item.value), 1),
                createVNode("span", { class: "text-[11px] opacity-70" }, "(id:" + toDisplayString(item.id) + ")", 1)
              ])
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div><div class="sketchpad flex flex-col overflow-hidden gap-2 mb-3" style="${ssrRenderStyle(unref(form).sketchSwitch ? null : { display: "none" })}" data-v-7606a806><div class="flex justify-between items-center gap-3" data-v-7606a806><div class="items-center flex @xs:gap-6 gap-2" data-v-7606a806><div id="avatar-box" class="flex" data-v-7606a806>`);
      _push(ssrRenderComponent(_component_el_avatar, {
        src: ("useUtils" in _ctx ? _ctx.useUtils : unref(useUtils)).avatar(unref(viewer).data.avatar.url),
        shape: "square",
        size: 32,
        class: "min-w-[32px]"
      }, null, _parent));
      _push(`</div><div class="flex gap-3 items-center" data-v-7606a806><span class="${ssrRenderClass(`bg-[#121212] block w-3.5 h-3.5 cursor-pointer ${unref(form).sketchpad && unref(form).sketchpad.color == "#121212" ? "rounded-sm" : "rounded-full"}`)}" data-v-7606a806></span><span class="${ssrRenderClass(`bg-[#FF3355] block w-3.5 h-3.5 cursor-pointer ${unref(form).sketchpad && unref(form).sketchpad.color == "#FF3355" ? "rounded-sm" : "rounded-full"}`)}" data-v-7606a806></span><span class="${ssrRenderClass(`bg-[#71a257] block w-3.5 h-3.5 cursor-pointer ${unref(form).sketchpad && unref(form).sketchpad.color == "#71a257" ? "rounded-sm" : "rounded-full"}`)}" data-v-7606a806></span><span class="${ssrRenderClass(`bg-[#ff9900] block w-3.5 h-3.5 cursor-pointer ${unref(form).sketchpad && unref(form).sketchpad.color == "#ff9900" ? "rounded-sm" : "rounded-full"}`)}" data-v-7606a806></span></div><div class="gap-3 items-center text-sm @md:flex hidden" data-v-7606a806><span class="${ssrRenderClass(`rounded-sm cursor-pointer ${unref(form).sketchpad && unref(form).sketchpad.penSize == 1 ? "font-600 text-[--el-color-primary]" : ""}`)}" data-v-7606a806>${ssrInterpolate(_ctx.$t("common.comment.sketchpad.penSize.small"))}</span><span class="${ssrRenderClass(`rounded-sm cursor-pointer ${unref(form).sketchpad && unref(form).sketchpad.penSize == 3 ? "font-600 text-[--el-color-primary]" : ""}`)}" data-v-7606a806>${ssrInterpolate(_ctx.$t("common.comment.sketchpad.penSize.medium"))}</span><span class="${ssrRenderClass(`rounded-sm cursor-pointer ${unref(form).sketchpad && unref(form).sketchpad.penSize == 5 ? "font-600 text-[--el-color-primary]" : ""}`)}" data-v-7606a806>${ssrInterpolate(_ctx.$t("common.comment.sketchpad.penSize.large"))}</span></div></div><div class="flex items-center gap-7 opacity-70" data-v-7606a806><div class="@xs:gap-4 gap-2 flex" data-v-7606a806><i class="i-ph-arrow-counter-clockwise-bold cursor-pointer hover:text-[color:var(--el-color-primary)]" data-v-7606a806></i><i class="i-ph-arrow-clockwise-bold cursor-pointer hover:text-[color:var(--el-color-primary)]" data-v-7606a806></i></div><div class="flex" data-v-7606a806><i class="i-ph-eraser-fill cursor-pointer hover:text-[color:var(--el-color-primary)]" data-v-7606a806></i></div><div class="flex" data-v-7606a806><i class="i-ph-shooting-star-fill cursor-pointer hover:text-[color:var(--el-color-primary)]" data-v-7606a806></i></div></div></div><canvas class="bg-[--el-color-info-light-10] rounded w-full" data-v-7606a806></canvas></div><div class="${ssrRenderClass(`flex flex-col gap-4 ${!unref(form).sketchSwitch ? "pt-4" : ""}`)}" data-v-7606a806>`);
      if (unref(form).imageList.length > 0 && !unref(form).sketchSwitch) {
        _push(`<div class="max-w-[70%]" data-v-7606a806>`);
        _push(ssrRenderComponent(unref(VueDraggable), {
          class: "grid grid-cols-6 gap-2",
          modelValue: unref(form).imageList,
          "onUpdate:modelValue": ($event) => unref(form).imageList = $event
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<!--[-->`);
              ssrRenderList(unref(form).imageList, (item, i) => {
                _push2(`<div class="border h-0 rounded pt-[70%] relative" data-v-7606a806${_scopeId}>`);
                _push2(ssrRenderComponent(_component_Image, {
                  src: item.node.sourceUrl,
                  class: "!absolute inset-0 comment-img"
                }, null, _parent2, _scopeId));
                _push2(ssrRenderComponent(_component_el_button, {
                  circle: "",
                  size: "small",
                  class: "absolute -top-1 -right-1 !w-4 !h-4",
                  onClick: ($event) => unref(form).imageList.splice(i, 1)
                }, {
                  default: withCtx((_2, _push3, _parent3, _scopeId2) => {
                    if (_push3) {
                      _push3(`<i class="i-ph-x text-[10px]" data-v-7606a806${_scopeId2}></i>`);
                    } else {
                      return [
                        createVNode("i", { class: "i-ph-x text-[10px]" })
                      ];
                    }
                  }),
                  _: 2
                }, _parent2, _scopeId));
                _push2(`</div>`);
              });
              _push2(`<!--]-->`);
            } else {
              return [
                (openBlock(true), createBlock(Fragment, null, renderList(unref(form).imageList, (item, i) => {
                  return openBlock(), createBlock("div", { class: "border h-0 rounded pt-[70%] relative" }, [
                    createVNode(_component_Image, {
                      src: item.node.sourceUrl,
                      class: "!absolute inset-0 comment-img"
                    }, null, 8, ["src"]),
                    createVNode(_component_el_button, {
                      circle: "",
                      size: "small",
                      class: "absolute -top-1 -right-1 !w-4 !h-4",
                      onClick: ($event) => unref(form).imageList.splice(i, 1)
                    }, {
                      default: withCtx(() => [
                        createVNode("i", { class: "i-ph-x text-[10px]" })
                      ]),
                      _: 1
                    }, 8, ["onClick"])
                  ]);
                }), 256))
              ];
            }
          }),
          _: 1
        }, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<div class="flex justify-between items-center w-full" data-v-7606a806><div class="flex @xs:gap-5 @md:gap-6 gap-3 items-center gq-gs" data-v-7606a806>`);
      _push(ssrRenderComponent(_component_CommonFormSmileButton, {
        class: "!p-0 !m-0 @xs:!w-6.4 @xs:!h-6.4 !w-5 !h-5",
        textarea: unref(simileTextarea),
        style: !unref(form).sketchSwitch && __props.settings.attrsPicked.includes("emoji") ? null : { display: "none" }
      }, null, _parent));
      if (__props.settings.attrsPicked.includes("image") && !unref(form).sketchSwitch) {
        _push(ssrRenderComponent(_component_el_button, {
          class: "!p-0 !m-0",
          link: "",
          onClick: ($event) => unref(mediaLibrary).libraryBox.show = true
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<i class="i-ph-image-square @xs:w-6.4 @xs:h-6.4 w-5 h-5" data-v-7606a806${_scopeId}></i>`);
            } else {
              return [
                createVNode("i", { class: "i-ph-image-square @xs:w-6.4 @xs:h-6.4 w-5 h-5" })
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      if (__props.settings.attrsPicked.includes("draw")) {
        _push(ssrRenderComponent(_component_el_button, {
          class: "!p-0 !m-0",
          link: "",
          disabled: !unref(viewer).data?.gqRoles?.media?.image.can,
          onClick: ($event) => unref(form).sketchSwitch = !unref(form).sketchSwitch
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (unref(form).sketchSwitch) {
                _push2(`<span class="flex items-center text-[--el-color-primary] @xs:text-sm text-xs" data-v-7606a806${_scopeId}><i class="i-ph-caret-left" data-v-7606a806${_scopeId}></i> 返回 </span>`);
              } else {
                _push2(`<span class="relative flex" data-v-7606a806${_scopeId}><i class="i-ph-palette @xs:w-6.4 @xs:h-6.4 w-5 h-5" data-v-7606a806${_scopeId}></i></span>`);
              }
            } else {
              return [
                unref(form).sketchSwitch ? (openBlock(), createBlock("span", {
                  key: 0,
                  class: "flex items-center text-[--el-color-primary] @xs:text-sm text-xs"
                }, [
                  createVNode("i", { class: "i-ph-caret-left" }),
                  createTextVNode(" 返回 ")
                ])) : (openBlock(), createBlock("span", {
                  key: 1,
                  class: "relative flex"
                }, [
                  createVNode("i", { class: "i-ph-palette @xs:w-6.4 @xs:h-6.4 w-5 h-5" })
                ]))
              ];
            }
          }),
          _: 1
        }, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</div><div class="flex items-center gq-gs @md:gap-2 gap-1" data-v-7606a806>`);
      _push(ssrRenderComponent(_component_el_button, {
        text: "",
        onClick: replyCancel,
        class: "comment-cancel !p-1 !px-2 !m-0 !h-auto @xs:!p-2 @xs:!px-3"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`${ssrInterpolate(_ctx.$t("common.edit.cancel"))}`);
          } else {
            return [
              createTextVNode(toDisplayString(_ctx.$t("common.edit.cancel")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_el_button, {
        link: "",
        onClick: unref(form).closeCommentForm,
        class: "comment-close @xs:!text-sm !text-xs !p-0 mr-3 @xs:mr-5 !hidden"
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(` 取消 `);
          } else {
            return [
              createTextVNode(" 取消 ")
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(ssrRenderComponent(_component_el_button, {
        type: "primary",
        class: "!p-1 !px-2 !m-0 !h-auto @xs:!p-2 @xs:!px-3",
        onClick: createComment,
        loading: unref(locked)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<span data-v-7606a806${_scopeId}>${ssrInterpolate(_ctx.$t("common.publish.publish"))}</span>`);
          } else {
            return [
              createVNode("span", null, toDisplayString(_ctx.$t("common.publish.publish")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</div></div></div>`);
      if (!unref(viewer).data?.databaseId || !unref(viewer).data?.gqRoles?.userCan.includes("comment") || __props.singleType == "topic" && !unref(topicCanRead)) {
        _push(`<div class="bg-[--tbg] absolute rounded-tl-[--trtl] rounded-tr-[--trtr] rounded-br-[--trbr] rounded-bl-[--trbl] inset-0 items-center justify-center flex-col gap-3" data-v-7606a806>`);
        if (unref(pageState).loginDataReady) {
          _push(`<!--[-->`);
          if (unref(viewer).data?.databaseId == 0) {
            _push(`<div class="flex items-center justify-center h-full flex-col" data-v-7606a806><div class="flex" data-v-7606a806><i class="i-ph-wave-sine-bold w-16 h-16 opacity-10" data-v-7606a806></i></div><div class="text-sm" data-v-7606a806>${ssrInterpolate(_ctx.$t("common.comment.welcome"))} <span class="ml-2 text-[--el-color-primary] cursor-pointer" data-v-7606a806>${ssrInterpolate(_ctx.$t("common.login.action.login"))}/${ssrInterpolate(_ctx.$t("common.login.action.signup"))}</span></div></div>`);
          } else if (__props.singleType == "topic" && unref(pageState).topicCanRead !== false) {
            _push(ssrRenderComponent(_component_CommonLocked, {
              title: _ctx.$t("common.comment.noPermission")
            }, null, _parent));
          } else {
            _push(ssrRenderComponent(_component_CommonLocked, {
              title: _ctx.$t("common.comment.noPermission")
            }, null, _parent));
          }
          _push(`<!--]-->`);
        } else {
          _push(`<!---->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/single/comment/form.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_8 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-7606a806"]]);

export { __nuxt_component_8 as default };
