import { g as getServerSettings, a as useI18n, v as viewerStore, l as loadComponent, e as useUtils } from './server.mjs';
import { useSSRContext, ref, unref, mergeProps, createVNode, resolveDynamicComponent } from 'vue';
import { ssrRenderAttrs, ssrInterpolate, ssrRenderClass, ssrRenderVNode } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonFormList",
  __ssrInlineRender: true,
  props: [
    "form",
    "id",
    "verifyKey",
    "type",
    "title",
    "subTitle",
    "showResult",
    "size",
    "settings"
  ],
  setup(__props) {
    const success = ref(false);
    const settingStore = getServerSettings();
    const { locale } = useI18n();
    const viewer = viewerStore();
    const levelName = (level) => {
      return useUtils.findNameAndIconByKey(level, settingStore)?.name?.[locale.value];
    };
    const roleCheck = (roles, data) => {
      const vip = data.gqVIP;
      const lv = data.gqLevel;
      return roles.includes(vip) || roles.includes(lv);
    };
    const compareTime = (time, min_day) => {
      const now = /* @__PURE__ */ new Date();
      const registeredDate = new Date(time);
      return now.getTime() - registeredDate.getTime() >= parseInt(min_day) * 24 * 60 * 60 * 1e3;
    };
    const submitSuccess = (data) => {
      success.value = true;
    };
    return (_ctx, _push, _parent, _attrs) => {
      if (!unref(success)) {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative" }, _attrs))} data-v-2f452cf3>`);
        if (__props.title) {
          _push(`<div class="pl-[--tpl] pr-[--tpr] pt-[calc(var(--tpl)*0.7)] pb-[calc(var(--tpl)*0.7)] border-b gq-bg-green flex flex-col text-sm" data-v-2f452cf3><span data-v-2f452cf3>${ssrInterpolate(__props.title)}</span><span class="text-xs opacity-80" data-v-2f452cf3>${ssrInterpolate(__props.subTitle)}</span></div>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.form?.requirements?.role?.length > 0 || parseInt(__props.form?.requirements?.min_days) > 0) {
          _push(`<div class="${ssrRenderClass(`flex flex-col gap-2 pl-[--tpl] pr-[--tpr] pt-[calc(var(--tpl)*0.7)] pb-[calc(var(--tpl)*0.7)] border-b`)}" data-v-2f452cf3><div class="flex items-center gap-1 text-xs font-600" data-v-2f452cf3><i class="i-ph-approximate-equals-duotone text-[--el-color-primary]" data-v-2f452cf3></i>${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.precondition"))}</div><div class="text-xs flex flex-col gap-1" data-v-2f452cf3>`);
          if (__props.form?.requirements?.role?.length > 0) {
            _push(`<div class="flex items-start gap-1" data-v-2f452cf3>`);
            if (roleCheck(__props.form?.requirements?.role, unref(viewer).data)) {
              _push(`<span class="flex" data-v-2f452cf3><i class="i-ph-check-circle-duotone text-green-500" data-v-2f452cf3></i></span>`);
            } else {
              _push(`<span class="flex mt-0.5" data-v-2f452cf3><i class="i-ph-x-circle-duotone text-red-500" data-v-2f452cf3></i></span>`);
            }
            _push(`<div data-v-2f452cf3>`);
            if (__props.form?.requirements?.role?.length == 1) {
              _push(`<span data-v-2f452cf3>${ssrInterpolate(_ctx.$t("page.account.verify.step.step2.desc", [
                levelName(__props.form?.requirements.role[0])
              ]))}</span>`);
            } else {
              _push(`<span data-v-2f452cf3>${_ctx.$t("page.account.verify.step.step2.desc", [
                __props.form?.requirements.role.map((item) => levelName(item)).join("、")
              ]) ?? ""}</span>`);
            }
            _push(`</div></div>`);
          } else {
            _push(`<!---->`);
          }
          if (parseInt(__props.form?.requirements?.min_days) > 0) {
            _push(`<div class="flex items-center" data-v-2f452cf3>`);
            if (compareTime(
              unref(viewer).data.gqRegisteredDate,
              __props.form?.requirements?.min_days
            )) {
              _push(`<span class="flex mr-1" data-v-2f452cf3><i class="i-ph-check-circle-duotone text-green-500" data-v-2f452cf3></i></span>`);
            } else {
              _push(`<span class="flex mr-1" data-v-2f452cf3><i class="i-ph-x-circle-duotone text-red-500" data-v-2f452cf3></i></span>`);
            }
            _push(`<div data-v-2f452cf3>${ssrInterpolate(_ctx.$t("page.account.verify.step.step1.registerTime", [
              __props.form?.requirements.min_days
            ]))}</div></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.form?.form_desc?.[unref(locale)]) {
          _push(`<div class="border-b @md:text-sm text-xs pl-[--tpl] pr-[--tpr] pt-[calc(var(--tpl)*0.7)] pb-[calc(var(--tpl)*0.7)] bg-[--el-color-info-light-10]" data-v-2f452cf3>${__props.form?.form_desc?.[unref(locale)] ?? ""}</div>`);
        } else {
          _push(`<!---->`);
        }
        if (__props.form?.form_type == "form") {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(("loadComponent" in _ctx ? _ctx.loadComponent : unref(loadComponent))("modules/common/form", "form")), {
            form: __props.form,
            id: __props.id,
            verifyKey: __props.verifyKey,
            type: __props.type,
            title: __props.title,
            subTitle: __props.subTitle,
            showResult: __props.showResult,
            size: __props.size,
            settings: __props.settings,
            onSubmitSuccess: submitSuccess
          }, null), _parent);
        } else if (__props.form?.form_type == "vote") {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(("loadComponent" in _ctx ? _ctx.loadComponent : unref(loadComponent))("modules/common/topic", "vote")), {
            vote: __props.form.vote,
            settings: __props.form?.settings,
            class: "bg-transparent border-0 !p-0 !w-full !gap-0 form-vote"
          }, null), _parent);
        } else {
          ssrRenderVNode(_push, createVNode(resolveDynamicComponent(("loadComponent" in _ctx ? _ctx.loadComponent : unref(loadComponent))("modules/common/form", __props.form?.form_type || null)), {
            form: ("ref" in _ctx ? _ctx.ref : unref(ref))(__props.form)?.value,
            collapse: __props.form?.collapse,
            podcast: __props.form?.podcast,
            settings: __props.settings,
            changelogs: __props.form?.changelogs_data
          }, null), _parent);
        }
        _push(`</div>`);
      } else {
        _push(`<div${ssrRenderAttrs(mergeProps({ class: "flex flex-col items-center justify-center p-6 min-h-100" }, _attrs))} data-v-2f452cf3><div class="flex items-center justify-center" data-v-2f452cf3><i class="i-ph-check-circle text-4xl text-green-500" data-v-2f452cf3></i></div><div class="text-lg font-600 mt-4" data-v-2f452cf3>${ssrInterpolate(_ctx.$t("page.account.verify.submitSuccess"))}</div><div class="mt-4 text-sm" data-v-2f452cf3><div data-v-2f452cf3>${__props.form?.submit_success_text?.[unref(locale)] ?? "" ?? ""}</div></div></div>`);
      }
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/form/formList.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_0 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-2f452cf3"]]);

export { __nuxt_component_0 as default };
