import { t as teleportProps, E as ElTeleport } from './focus-trap.vue-9ChHxs3Q.mjs';
import { a0 as buildProps, a2 as definePropType, P as withInstall, C as useNamespace, d as useRoute, V as useNuxtApp, k as deviceStore, j as actionStore, A as isBoolean$1, L as isNumber$1 } from './server.mjs';
import { C as CHANGE_EVENT } from './event-BZTOGHfp.mjs';
import { useSSRContext, defineComponent, shallowRef, ref, computed, watch, watchEffect, openBlock, createElementBlock, normalizeStyle, normalizeClass, unref, createVNode, withCtx, createElementVNode, renderSlot, mergeProps, Transition, createBlock, nextTick } from 'vue';
import { c as useWindowSize, d as useElementBounding, a as useEventListener } from './index-ChPMoinw.mjs';
import { a as addUnit } from './style-h263bamF.mjs';
import _sfc_main$2 from './accountIndex-_Cdiqro6.mjs';
import __nuxt_component_2 from './default-BEiBA27o.mjs';
import _sfc_main$3 from './mobileHeader-CYAMLCW8.mjs';
import { ssrRenderAttrs, ssrRenderComponent } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import 'lodash-unified';
import './aria-BhThsKez.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'quick-lru';
import './index-DYnTqrQe.mjs';
import './index-CRbm0e05.mjs';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './index-R6EFYpWa.mjs';
import './index-Cx5QSQzK.mjs';
import '@popperjs/core';
import './index-DRiwogtD.mjs';
import './vnode-l2ZP2UQa.mjs';
import './localeButton-DnyltRa0.mjs';
import './index-CPT03ebO.mjs';
import './dropdown-cQfpmYSu.mjs';
import './Image-BE6Y-a3S.mjs';
import './image-viewer-DG2qIWb8.mjs';
import './index-Di0Jlzch.mjs';
import './index-BKB3Djp4.mjs';
import './index-03hfIBa_.mjs';
import './index-tCyBRCDx.mjs';
import './index-Bp-nwGzu.mjs';
import './index-BY8mj3AC.mjs';
import './colorMode-DKKdznde.mjs';
import './composables-1jje8stA.mjs';
import './announcement-ChD74u-B.mjs';
import './blink-DRvWMg-X.mjs';
import './nuxt-link-Dd6LuEo9.mjs';
import './index-awVc4A7-.mjs';
import './use-dialog-7J0bwlna.mjs';
import './menu1-DKBcMl-T.mjs';
import './svgIcon-BpIUCf-e.mjs';
import './mobileMenu-DxejVI8C.mjs';
import './index-DIFZyfOG.mjs';
import './vipButton-BMGOcamp.mjs';
import './creditIcon-eOdkwofx.mjs';

/* empty css                */
const affixProps = buildProps({
  /**
   * @description affix element zIndex value
   * */
  zIndex: {
    type: definePropType([Number, String]),
    default: 100
  },
  /**
   * @description target container. (CSS selector)
   */
  target: {
    type: String,
    default: ""
  },
  /**
   * @description offset distance
   * */
  offset: {
    type: Number,
    default: 0
  },
  /**
   * @description position of affix
   * */
  position: {
    type: String,
    values: ["top", "bottom"],
    default: "top"
  },
  /**
   * @description whether affix element is teleported, if `true` it will be teleported to where `append-to` sets
   * */
  teleported: Boolean,
  /**
   * @description which element the affix element appends to
   * */
  appendTo: {
    type: teleportProps.to.type,
    default: "body"
  }
});
const affixEmits = {
  scroll: ({ scrollTop, fixed }) => isNumber$1(scrollTop) && isBoolean$1(fixed),
  [CHANGE_EVENT]: (fixed) => isBoolean$1(fixed)
};
const COMPONENT_NAME = "ElAffix";
var _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{
    name: COMPONENT_NAME
  },
  __name: "affix",
  props: affixProps,
  emits: affixEmits,
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const ns = useNamespace("affix");
    const target = shallowRef();
    const root = shallowRef();
    const scrollContainer = shallowRef();
    const { height: windowHeight } = useWindowSize();
    const {
      height: rootHeight,
      width: rootWidth,
      top: rootTop,
      bottom: rootBottom,
      left: rootLeft,
      update: updateRoot
    } = useElementBounding(root, { windowScroll: false });
    const targetRect = useElementBounding(target);
    const fixed = ref(false);
    const scrollTop = ref(0);
    const transform = ref(0);
    const teleportDisabled = computed(() => {
      return !props.teleported || !fixed.value;
    });
    const rootStyle = computed(() => {
      return {
        height: fixed.value ? `${rootHeight.value}px` : "",
        width: fixed.value ? `${rootWidth.value}px` : ""
      };
    });
    const affixStyle = computed(() => {
      if (!fixed.value) return {};
      const offset = addUnit(props.offset);
      return {
        height: `${rootHeight.value}px`,
        width: `${rootWidth.value}px`,
        top: props.position === "top" ? offset : "",
        bottom: props.position === "bottom" ? offset : "",
        left: props.teleported ? `${rootLeft.value}px` : "",
        transform: transform.value ? `translateY(${transform.value}px)` : "",
        zIndex: props.zIndex
      };
    });
    const update = () => {
      if (!scrollContainer.value) return;
      scrollTop.value = scrollContainer.value instanceof Window ? (void 0).documentElement.scrollTop : scrollContainer.value.scrollTop || 0;
      const { position, target: target2, offset } = props;
      const rootHeightOffset = offset + rootHeight.value;
      if (position === "top") {
        if (target2) {
          const difference = targetRect.bottom.value - rootHeightOffset;
          fixed.value = offset > rootTop.value && targetRect.bottom.value > 0;
          transform.value = difference < 0 ? difference : 0;
        } else {
          fixed.value = offset > rootTop.value;
        }
      } else if (target2) {
        const difference = windowHeight.value - targetRect.top.value - rootHeightOffset;
        fixed.value = windowHeight.value - offset < rootBottom.value && windowHeight.value > targetRect.top.value;
        transform.value = difference < 0 ? -difference : 0;
      } else {
        fixed.value = windowHeight.value - offset < rootBottom.value;
      }
    };
    const updateRootRect = async () => {
      if (!fixed.value) {
        updateRoot();
        return;
      }
      fixed.value = false;
      await nextTick();
      updateRoot();
      fixed.value = true;
    };
    const handleScroll = async () => {
      updateRoot();
      await nextTick();
      emit("scroll", {
        scrollTop: scrollTop.value,
        fixed: fixed.value
      });
    };
    watch(fixed, (val) => emit(CHANGE_EVENT, val));
    useEventListener(scrollContainer, "scroll", handleScroll);
    watchEffect(update);
    __expose({
      /** @description update affix status */
      update,
      /** @description update rootRect info */
      updateRoot: updateRootRect
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          ref_key: "root",
          ref: root,
          class: normalizeClass(unref(ns).b()),
          style: normalizeStyle(rootStyle.value)
        },
        [
          createVNode(unref(ElTeleport), {
            disabled: teleportDisabled.value,
            to: __props.appendTo
          }, {
            default: withCtx(() => [
              createElementVNode(
                "div",
                {
                  class: normalizeClass({ [unref(ns).m("fixed")]: fixed.value }),
                  style: normalizeStyle(affixStyle.value)
                },
                [
                  renderSlot(_ctx.$slots, "default")
                ],
                6
                /* CLASS, STYLE */
              )
            ]),
            _: 3
            /* FORWARDED */
          }, 8, ["disabled", "to"])
        ],
        6
        /* CLASS, STYLE */
      );
    };
  }
});
const ElAffix = withInstall(_sfc_main$1);
const _sfc_main = {
  __name: "Header",
  __ssrInlineRender: true,
  props: ["data"],
  setup(__props) {
    const props = __props;
    const route = useRoute();
    const data = ref(null);
    if (route.path.includes("builder")) {
      data.value = props.data;
    } else {
      const { $serverSettings: _data } = useNuxtApp();
      data.value = _data;
    }
    const device = deviceStore();
    const action = actionStore();
    const hideHeader = computed(() => {
      if (device.isMobile) {
        return route.meta?.pageSettings?.postType != "profile" && (route.meta?.pageSettings?.pageType == "single" || route.meta?.pageSettings?.pageType == "answer" || route.meta?.pageSettings?.pageType == "archive");
      } else {
        return route.meta?.pageSettings?.hideHeader || false;
      }
    });
    const lastY = ref(0);
    const showCarouselBg = computed(() => {
      return action.carouselBg?.bg && route.fullPath == action.carouselBg.fullPath;
    });
    watch(
      () => route.path,
      () => {
        action.isScrollingDown = false;
        lastY.value = 0;
      },
      { immediate: true }
    );
    const getHeaderStyle = data.value?.page_settings?.[device.currentDevice]?.header || {};
    const headerStyle = computed(() => {
      return {
        backgroundColor: getHeaderStyle.backgroundColor || "transparent",
        textColor: getHeaderStyle.textColor || "var(--el-text-color-regular)",
        textColorSecondary: "var(--el-text-color-regular)"
      };
    });
    const showAvatar = ref(false);
    const locked = ref(false);
    const handleScroll = (event) => {
      const newY = event.scrollTop;
      const viewH = (void 0).innerHeight;
      const pageH = (void 0).documentElement.scrollHeight;
      if (newY > 50) {
        showAvatar.value = true;
      } else {
        showAvatar.value = false;
      }
      if (newY + viewH >= pageH - 2) return;
      if (newY > lastY.value && newY > 100) {
        action.isScrollingDown = true;
        locked.value = true;
      } else {
        action.isScrollingDown = false;
      }
      lastY.value = newY;
      if (newY <= 3 && showCarouselBg.value) {
        action.isTop = true;
      } else {
        action.isTop = false;
      }
    };
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_affix = ElAffix;
      const _component_HeaderAccountIndex = _sfc_main$2;
      const _component_HeaderDefault = __nuxt_component_2;
      const _component_MobileHeader = _sfc_main$3;
      _push(`<header${ssrRenderAttrs(mergeProps({
        class: `block top-0 left-0 gq-header z-7 relative ${unref(route).path.includes("account") && unref(device).isMobile ? "account-header" : unref(hideHeader) ? "mobile-header" : ""}`,
        style: `--gq-header-backgroundColor-default:${unref(headerStyle).backgroundColor};
    --el-text-color-regular-default:${unref(headerStyle).textColor};
    --el-text-color-secondary-default:${unref(headerStyle).textColorSecondary};
    --el-inner-width:${unref(route).path.includes("builder") ? "100%" : "100vw"};
    --el-input-icon-color:var(--el-text-color-regular);
    --el-text-color-placeholder:${unref(headerStyle).textColor};
    `
      }, _attrs))} data-v-bdfbeda4>`);
      _push(ssrRenderComponent(_component_el_affix, {
        offset: unref(action).isScrollingDown ? -unref(action).announcement.top.height : 0,
        class: `w-full header-affix-wrapper  ${unref(showCarouselBg) && unref(action).isTop ? "header-show-carousel-bg" : ""} ${unref(action).isTop ? "header-top" : ""}`,
        onScroll: handleScroll
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(``);
            if (unref(route).path.includes("account") && unref(device).isMobile) {
              _push2(ssrRenderComponent(_component_HeaderAccountIndex, {
                showAvatar: unref(showAvatar),
                route: unref(route)
              }, null, _parent2, _scopeId));
            } else if (!unref(hideHeader)) {
              _push2(ssrRenderComponent(_component_HeaderDefault, {
                key: "default",
                data: unref(data),
                getHeaderStyle: unref(getHeaderStyle),
                showCarouselBg: unref(showCarouselBg)
              }, null, _parent2, _scopeId));
            } else {
              _push2(ssrRenderComponent(_component_MobileHeader, {
                key: "mobile",
                pageSettings: unref(route).meta.pageSettings,
                data: null
              }, null, _parent2, _scopeId));
            }
          } else {
            return [
              createVNode(Transition, { name: "header-cross" }, {
                default: withCtx(() => [
                  unref(route).path.includes("account") && unref(device).isMobile ? (openBlock(), createBlock(_component_HeaderAccountIndex, {
                    key: 0,
                    showAvatar: unref(showAvatar),
                    route: unref(route)
                  }, null, 8, ["showAvatar", "route"])) : !unref(hideHeader) ? (openBlock(), createBlock(_component_HeaderDefault, {
                    key: "default",
                    data: unref(data),
                    getHeaderStyle: unref(getHeaderStyle),
                    showCarouselBg: unref(showCarouselBg)
                  }, null, 8, ["data", "getHeaderStyle", "showCarouselBg"])) : (openBlock(), createBlock(_component_MobileHeader, {
                    key: "mobile",
                    pageSettings: unref(route).meta.pageSettings,
                    data: null
                  }, null, 8, ["pageSettings"]))
                ]),
                _: 1
              })
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</header>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/header.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_1 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-bdfbeda4"]]);

export { __nuxt_component_1 as default };
