import { E as ElButton } from './index-DYnTqrQe.mjs';
import _sfc_main$1 from './creditIcon-eOdkwofx.mjs';
import { j as actionStore, a as useI18n, d as useRoute, r as useRequest, w as isLogin, aM as getLoginData, e as useUtils, x as __nuxt_component_0$1 } from './server.mjs';
import { inject, ref, reactive, mergeProps, unref, withCtx, createTextVNode, toDisplayString, openBlock, createBlock, createCommentVNode, useSSRContext } from 'vue';
import { ssrRenderAttrs, ssrRenderClass, ssrRenderStyle, ssrInterpolate, ssrRenderComponent } from 'vue/server-renderer';
import './index-CRbm0e05.mjs';
import './style-h263bamF.mjs';
import '@vue/shared';
import './index-31HAFSrO.mjs';
import './use-form-item-Cr81A1TZ.mjs';
import './constants-hAKFmBbq.mjs';
import '@ctrl/tinycolor';
import './svgIcon-BpIUCf-e.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonTopicHidden",
  __ssrInlineRender: true,
  props: ["role", "item", "action"],
  setup(__props) {
    const actionState = actionStore();
    const { t } = useI18n();
    const pageState = inject("pageState");
    const props = __props;
    const joinRef = ref(null);
    const route = useRoute();
    const roleValue = (role) => {
      if (role.type == "money") {
        try {
          const money = JSON.parse(role.value);
          return money[actionState.currency.iso];
        } catch (error) {
          return role.value;
        }
      }
      return role.value;
    };
    const payRef = ref(null);
    const state = reactive({
      followLocked: false,
      pay: () => {
        if (props.role.type == "money" || props.role.type == "credit") {
          state.payAction(props.role.type);
        }
        if (props.role.type == "level") {
          state.levels();
        }
        if (props.role.type == "followed") {
          state.follow();
        }
        if (props.role.type == "login") {
          actionState.showLogin = true;
        }
        if (props.role.type == "comment") {
          if (props.item?.node?.gqSlug) {
            useUtils.navigateTo(props.item?.node?.gqSlug);
          } else {
            useUtils.scrollToAndHighlight("comment-form");
          }
        }
      },
      follow: async () => {
        if (state.followLocked) {
          return;
        }
        state.followLocked = true;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              id: props.item?.role?.postAuthor || props.item?.node?.topicContent?.role?.postAuthor
            }
          }
        });
        if (res?.gqToggleFollowUser?.followStatus) {
          if (props.item?.node?.topicContent?.role?.postAuthor) {
            state.reload();
          } else {
            getLoginData(actionState.pageData[route.path]);
          }
        }
        state.followLocked = false;
      },
      levels: () => {
        actionState.levelTips.show = true;
        actionState.levelTips.title = t("page.community.header.userToRead");
        actionState.levelTips.levels = props.role.value?.split(",");
      },
      payAction: (type) => {
        payRef.value.state.show({
          title: t("page.community.header.readHidden"),
          thumb: "",
          postId: props.role.postId,
          args: {
            index: 0
          },
          payment: type,
          count: 0,
          type: "topic",
          finalPrice: roleValue(props.role),
          price: roleValue(props.role)
        });
      },
      join: () => {
        if (!isLogin.value) {
          actionState.showLogin = true;
          return;
        }
        joinRef.value.showJoin = true;
      },
      reload: async (id) => {
        if (!props.item?.node?.databaseId) return;
        const res = await useRequest("/api/request", {
          body: {
            data: {
              id: props.item.node.databaseId ? props.item.node.databaseId : id
            }
          }
        });
        if (res?.communityTopic?.topicContent) {
          props.item.node.topicContent = res.communityTopic.topicContent;
          props.item.node.new = true;
        }
      }
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_el_button = ElButton;
      const _component_CommonCreditIcon = _sfc_main$1;
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(`<div${ssrRenderAttrs(mergeProps({ class: "relative z-1" }, _attrs))}>`);
      if (!__props.role.can) {
        _push(`<div class="${ssrRenderClass(`flex w-82 flex-col p-3 border rounded  max-w-full gap-3 gq-gs text-sm ${unref(pageState).loginDataReady ? "child-load-success " : "child-load"}`)}" style="${ssrRenderStyle({ "--el-border-color": "var(--el-color-primary-light-9)", "--gq-vote-bg": "var(--el-fill-color-extra-light)" })}">`);
        if (__props.role.type === "private") {
          _push(`<!--[--><div class="flex justify-between border-b pb-2 text-xs"><span class="flex items-center gq-gs"><i class="i-ph-lock-key mr-1 text-[var(--el-color-primary)]"></i> ${ssrInterpolate(_ctx.$t("page.community.header.private"))}</span></div><div class="flex flex-col gap-4"><span class="!opacity-70 gq-gs">${ssrInterpolate(_ctx.$t("page.community.header.joinToRead"))}</span>`);
          _push(ssrRenderComponent(_component_el_button, {
            plain: "",
            size: "small",
            class: "w-fit is-active gq-gs",
            onClick: ($event) => unref(state).join()
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                _push2(`${ssrInterpolate(_ctx.$t("page.community.header.joinNode"))}`);
              } else {
                return [
                  createTextVNode(toDisplayString(_ctx.$t("page.community.header.joinNode")), 1)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div><!--]-->`);
        } else {
          _push(`<!--[--><div class="flex justify-between border-b pb-2 text-xs"><span class="flex items-center gq-gs"><i class="i-ph-lock-key mr-1 text-[var(--el-color-primary)]"></i> ${ssrInterpolate(_ctx.$t("page.community.list.hidden.title"))}</span></div>`);
          if (__props.role.type === "money") {
            _push(`<div><span class="gq-gs">${ssrInterpolate(unref(actionState).currency.symbol)}</span><span class="gq-gs">${ssrInterpolate(roleValue(__props.role))}</span><div class="opacity-70 text-xs mt-1 gq-gs">${ssrInterpolate(_ctx.$t("page.community.list.hidden.has", [10]))}</div></div>`);
          } else {
            _push(`<!---->`);
          }
          if (__props.role.type === "credit") {
            _push(`<div><div class="flex items-center gq-gs"><span class="gq-gs">`);
            _push(ssrRenderComponent(_component_CommonCreditIcon, { class: "w-3 h-3 flex" }, null, _parent));
            _push(`</span><span class="gq-gs">${ssrInterpolate(__props.role.value)}</span></div><div class="opacity-70 text-xs mt-1 gq-gs">${ssrInterpolate(_ctx.$t("page.community.list.hidden.exchange", [10]))}</div></div>`);
          } else {
            _push(`<!---->`);
          }
          if (__props.role.type === "level") {
            _push(`<div class="gq-gs"><span class="!opacity-70">${ssrInterpolate(_ctx.$t("page.community.list.hidden.level"))}</span></div>`);
          } else {
            _push(`<!---->`);
          }
          if (__props.role.type === "comment") {
            _push(`<div class="gq-gs"><span class="!opacity-70">${ssrInterpolate(_ctx.$t("page.community.list.hidden.comment"))}</span></div>`);
          } else {
            _push(`<!---->`);
          }
          if (__props.role.type === "login") {
            _push(`<div class="gq-gs"><span class="!opacity-70">${ssrInterpolate(_ctx.$t("page.community.list.hidden.login"))}</span></div>`);
          } else {
            _push(`<!---->`);
          }
          if (__props.role.type === "followed") {
            _push(`<div class="gq-gs"><span class="!opacity-70">${ssrInterpolate(_ctx.$t("page.community.list.hidden.followed"))}</span></div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div>`);
          _push(ssrRenderComponent(_component_el_button, {
            plain: "",
            size: "small",
            class: "is-active gq-gs",
            onClick: ($event) => unref(state).pay()
          }, {
            default: withCtx((_, _push2, _parent2, _scopeId) => {
              if (_push2) {
                if (__props.role.type === "money") {
                  _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.list.hidden.pay"))}</span>`);
                } else {
                  _push2(`<!---->`);
                }
                if (__props.role.type === "credit") {
                  _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.list.hidden.exchange"))}</span>`);
                } else {
                  _push2(`<!---->`);
                }
                if (__props.role.type === "level") {
                  _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.list.hidden.check"))}</span>`);
                } else {
                  _push2(`<!---->`);
                }
                if (__props.role.type === "comment") {
                  _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.list.hidden.comment"))}</span>`);
                } else {
                  _push2(`<!---->`);
                }
                if (__props.role.type === "login") {
                  _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.list.hidden.login"))}</span>`);
                } else {
                  _push2(`<!---->`);
                }
                if (__props.role.type === "followed") {
                  _push2(`<span${_scopeId}>${ssrInterpolate(_ctx.$t("page.community.list.hidden.follow"))}</span>`);
                } else {
                  _push2(`<!---->`);
                }
              } else {
                return [
                  __props.role.type === "money" ? (openBlock(), createBlock("span", { key: 0 }, toDisplayString(_ctx.$t("page.community.list.hidden.pay")), 1)) : createCommentVNode("", true),
                  __props.role.type === "credit" ? (openBlock(), createBlock("span", { key: 1 }, toDisplayString(_ctx.$t("page.community.list.hidden.exchange")), 1)) : createCommentVNode("", true),
                  __props.role.type === "level" ? (openBlock(), createBlock("span", { key: 2 }, toDisplayString(_ctx.$t("page.community.list.hidden.check")), 1)) : createCommentVNode("", true),
                  __props.role.type === "comment" ? (openBlock(), createBlock("span", { key: 3 }, toDisplayString(_ctx.$t("page.community.list.hidden.comment")), 1)) : createCommentVNode("", true),
                  __props.role.type === "login" ? (openBlock(), createBlock("span", { key: 4 }, toDisplayString(_ctx.$t("page.community.list.hidden.login")), 1)) : createCommentVNode("", true),
                  __props.role.type === "followed" ? (openBlock(), createBlock("span", { key: 5 }, toDisplayString(_ctx.$t("page.community.list.hidden.follow")), 1)) : createCommentVNode("", true)
                ];
              }
            }),
            _: 1
          }, _parent));
          _push(`</div><!--]-->`);
        }
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/hidden.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
