import { P as withInstall, ac as scale_to_original_default, ad as full_screen_default, D as useLocale, C as useNamespace, ae as useZIndex, af as clamp, ag as close_default, ah as arrow_left_default, M as arrow_right_default, ai as zoom_out_default, aj as zoom_in_default, ak as refresh_left_default, al as refresh_right_default, L as isNumber$1, a0 as buildProps, a2 as definePropType, a7 as mutable, am as keysOf } from './server.mjs';
import { defineComponent, markRaw, ref, effectScope, computed, shallowRef, watch, nextTick, openBlock, createBlock, unref, withCtx, createVNode, Transition, createElementVNode, normalizeStyle, normalizeClass, withModifiers, createCommentVNode, createElementBlock, Fragment, renderSlot, createTextVNode, toDisplayString, resolveDynamicComponent } from 'vue';
import { a as useEventListener } from './index-ChPMoinw.mjs';
import { throttle } from 'lodash-unified';
import { E as ElTeleport, a as ElFocusTrap } from './focus-trap.vue-9ChHxs3Q.mjs';
import { E as ElIcon } from './index-CRbm0e05.mjs';
import { u as useLockscreen } from './index-Di0Jlzch.mjs';

const imageViewerProps = buildProps({
  /**
   * @description preview link list.
   */
  urlList: {
    type: definePropType(Array),
    default: () => mutable([])
  },
  /**
   * @description preview backdrop z-index.
   */
  zIndex: {
    type: Number
  },
  /**
   * @description the initial preview image index, less than or equal to the length of `url-list`.
   */
  initialIndex: {
    type: Number,
    default: 0
  },
  /**
   * @description whether preview is infinite.
   */
  infinite: {
    type: Boolean,
    default: true
  },
  /**
   * @description whether user can emit close event when clicking backdrop.
   */
  hideOnClickModal: Boolean,
  /**
   * @description whether to append image itself to body. A nested parent element attribute transform should have this attribute set to `true`.
   */
  teleported: Boolean,
  /**
   * @description whether the image-viewer can be closed by pressing ESC.
   */
  closeOnPressEscape: {
    type: Boolean,
    default: true
  },
  /**
   * @description the zoom rate of the image viewer zoom event.
   */
  zoomRate: {
    type: Number,
    default: 1.2
  },
  /**
   * @description preview image scale.
   */
  scale: {
    type: Number,
    default: 1
  },
  /**
   * @description the min scale of the image viewer zoom event.
   */
  minScale: {
    type: Number,
    default: 0.2
  },
  /**
   * @description the max scale of the image viewer zoom event.
   */
  maxScale: {
    type: Number,
    default: 7
  },
  /**
   * @description show preview image progress content.
   */
  showProgress: Boolean,
  /**
   * @description set HTML attribute: crossorigin.
   */
  crossorigin: {
    type: definePropType(String)
  }
});
const imageViewerEmits = {
  close: () => true,
  error: (evt) => evt instanceof Event,
  switch: (index) => isNumber$1(index),
  rotate: (deg) => isNumber$1(deg)
};
const _hoisted_1 = ["src", "crossorigin"];
var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElImageViewer"
  },
  __name: "image-viewer",
  props: imageViewerProps,
  emits: imageViewerEmits,
  setup(__props, { expose: __expose, emit: __emit }) {
    var _a;
    const modes = {
      CONTAIN: {
        name: "contain",
        icon: markRaw(full_screen_default)
      },
      ORIGINAL: {
        name: "original",
        icon: markRaw(scale_to_original_default)
      }
    };
    const props = __props;
    const emit = __emit;
    const { t } = useLocale();
    const ns = useNamespace("image-viewer");
    const { nextZIndex } = useZIndex();
    const wrapper = ref();
    const imgRef = ref();
    const scopeEventListener = effectScope();
    const scaleClamped = computed(() => {
      const { scale, minScale, maxScale } = props;
      return clamp(scale, minScale, maxScale);
    });
    const loading = ref(true);
    const loadError = ref(false);
    const visible = ref(false);
    const activeIndex = ref(props.initialIndex);
    const mode = shallowRef(modes.CONTAIN);
    const transform = ref({
      scale: scaleClamped.value,
      deg: 0,
      offsetX: 0,
      offsetY: 0,
      enableTransition: false
    });
    const zIndex = ref((_a = props.zIndex) != null ? _a : nextZIndex());
    useLockscreen(visible, { ns });
    const isSingle = computed(() => {
      const { urlList } = props;
      return urlList.length <= 1;
    });
    const isFirst = computed(() => activeIndex.value === 0);
    const isLast = computed(() => activeIndex.value === props.urlList.length - 1);
    const currentImg = computed(() => props.urlList[activeIndex.value]);
    const arrowPrevKls = computed(() => [
      ns.e("btn"),
      ns.e("prev"),
      ns.is("disabled", !props.infinite && isFirst.value)
    ]);
    const arrowNextKls = computed(() => [
      ns.e("btn"),
      ns.e("next"),
      ns.is("disabled", !props.infinite && isLast.value)
    ]);
    const imgStyle = computed(() => {
      const { scale, deg, offsetX, offsetY, enableTransition } = transform.value;
      let translateX = offsetX / scale;
      let translateY = offsetY / scale;
      const radian = deg * Math.PI / 180;
      const cosRadian = Math.cos(radian);
      const sinRadian = Math.sin(radian);
      translateX = translateX * cosRadian + translateY * sinRadian;
      translateY = translateY * cosRadian - offsetX / scale * sinRadian;
      const style = {
        transform: `scale(${scale}) rotate(${deg}deg) translate(${translateX}px, ${translateY}px)`,
        transition: enableTransition ? "transform .3s" : ""
      };
      if (mode.value.name === modes.CONTAIN.name) {
        style.maxWidth = style.maxHeight = "100%";
      }
      return style;
    });
    const progress = computed(
      () => `${activeIndex.value + 1} / ${props.urlList.length}`
    );
    function hide() {
      unregisterEventListener();
      visible.value = false;
      emit("close");
    }
    function unregisterEventListener() {
      scopeEventListener.stop();
    }
    function handleImgLoad() {
      loading.value = false;
    }
    function handleImgError(e) {
      loadError.value = true;
      loading.value = false;
      emit("error", e);
      e.target.alt = t("el.image.error");
    }
    function handleMouseDown(e) {
      if (loading.value || e.button !== 0 || !wrapper.value) return;
      transform.value.enableTransition = false;
      const { offsetX, offsetY } = transform.value;
      const startX = e.pageX;
      const startY = e.pageY;
      const dragHandler = throttle((ev) => {
        transform.value = {
          ...transform.value,
          offsetX: offsetX + ev.pageX - startX,
          offsetY: offsetY + ev.pageY - startY
        };
      });
      const removeMousemove = useEventListener(void 0, "mousemove", dragHandler);
      const removeMouseup = useEventListener(void 0, "mouseup", () => {
        removeMousemove();
        removeMouseup();
      });
      e.preventDefault();
    }
    function handleTouchStart(e) {
      if (loading.value || !wrapper.value || e.touches.length !== 1) return;
      transform.value.enableTransition = false;
      const { offsetX, offsetY } = transform.value;
      const { pageX: startX, pageY: startY } = e.touches[0];
      const dragHandler = throttle((ev) => {
        const targetTouch = ev.touches[0];
        transform.value = {
          ...transform.value,
          offsetX: offsetX + targetTouch.pageX - startX,
          offsetY: offsetY + targetTouch.pageY - startY
        };
      });
      const removeTouchmove = useEventListener(void 0, "touchmove", dragHandler);
      const removeTouchend = useEventListener(void 0, "touchend", () => {
        removeTouchmove();
        removeTouchend();
      });
      e.preventDefault();
    }
    function reset() {
      transform.value = {
        scale: scaleClamped.value,
        deg: 0,
        offsetX: 0,
        offsetY: 0,
        enableTransition: false
      };
    }
    function toggleMode() {
      if (loading.value || loadError.value) return;
      const modeNames = keysOf(modes);
      const modeValues = Object.values(modes);
      const currentMode = mode.value.name;
      const index = modeValues.findIndex((i) => i.name === currentMode);
      const nextIndex = (index + 1) % modeNames.length;
      mode.value = modes[modeNames[nextIndex]];
      reset();
    }
    function setActiveItem(index) {
      loadError.value = false;
      const len = props.urlList.length;
      activeIndex.value = (index + len) % len;
    }
    function prev() {
      if (isFirst.value && !props.infinite) return;
      setActiveItem(activeIndex.value - 1);
    }
    function next() {
      if (isLast.value && !props.infinite) return;
      setActiveItem(activeIndex.value + 1);
    }
    function handleActions(action, options = {}) {
      if (loading.value || loadError.value) return;
      const { minScale, maxScale } = props;
      const { zoomRate, rotateDeg, enableTransition } = {
        zoomRate: props.zoomRate,
        rotateDeg: 90,
        enableTransition: true,
        ...options
      };
      switch (action) {
        case "zoomOut":
          if (transform.value.scale > minScale) {
            transform.value.scale = Number.parseFloat(
              (transform.value.scale / zoomRate).toFixed(3)
            );
          }
          break;
        case "zoomIn":
          if (transform.value.scale < maxScale) {
            transform.value.scale = Number.parseFloat(
              (transform.value.scale * zoomRate).toFixed(3)
            );
          }
          break;
        case "clockwise":
          transform.value.deg += rotateDeg;
          emit("rotate", transform.value.deg);
          break;
        case "anticlockwise":
          transform.value.deg -= rotateDeg;
          emit("rotate", transform.value.deg);
          break;
      }
      transform.value.enableTransition = enableTransition;
    }
    function onFocusoutPrevented(event) {
      var _a2;
      if (((_a2 = event.detail) == null ? void 0 : _a2.focusReason) === "pointer") {
        event.preventDefault();
      }
    }
    function onCloseRequested() {
      if (props.closeOnPressEscape) {
        hide();
      }
    }
    watch(
      () => scaleClamped.value,
      (val) => {
        transform.value.scale = val;
      }
    );
    watch(currentImg, () => {
      nextTick(() => {
        const $img = imgRef.value;
        if (!($img == null ? void 0 : $img.complete)) {
          loading.value = true;
        }
      });
    });
    watch(activeIndex, (val) => {
      reset();
      emit("switch", val);
    });
    __expose({
      /**
       * @description manually switch image
       */
      setActiveItem
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(ElTeleport), {
        to: "body",
        disabled: !__props.teleported
      }, {
        default: withCtx(() => [
          createVNode(Transition, {
            name: "viewer-fade",
            appear: ""
          }, {
            default: withCtx(() => [
              createElementVNode(
                "div",
                {
                  ref_key: "wrapper",
                  ref: wrapper,
                  tabindex: -1,
                  class: normalizeClass(unref(ns).e("wrapper")),
                  style: normalizeStyle({ zIndex: zIndex.value })
                },
                [
                  createVNode(unref(ElFocusTrap), {
                    loop: "",
                    trapped: "",
                    "focus-trap-el": wrapper.value,
                    "focus-start-el": "container",
                    onFocusoutPrevented,
                    onReleaseRequested: onCloseRequested
                  }, {
                    default: withCtx(() => [
                      createElementVNode(
                        "div",
                        {
                          class: normalizeClass(unref(ns).e("mask")),
                          onClick: _cache[0] || (_cache[0] = withModifiers(($event) => __props.hideOnClickModal && hide(), ["self"]))
                        },
                        null,
                        2
                        /* CLASS */
                      ),
                      createCommentVNode(" CLOSE "),
                      createElementVNode(
                        "span",
                        {
                          class: normalizeClass([unref(ns).e("btn"), unref(ns).e("close")]),
                          onClick: hide
                        },
                        [
                          createVNode(unref(ElIcon), null, {
                            default: withCtx(() => [
                              createVNode(unref(close_default))
                            ]),
                            _: 1
                            /* STABLE */
                          })
                        ],
                        2
                        /* CLASS */
                      ),
                      createCommentVNode(" ARROW "),
                      !isSingle.value ? (openBlock(), createElementBlock(
                        Fragment,
                        { key: 0 },
                        [
                          createElementVNode(
                            "span",
                            {
                              class: normalizeClass(arrowPrevKls.value),
                              onClick: prev
                            },
                            [
                              createVNode(unref(ElIcon), null, {
                                default: withCtx(() => [
                                  createVNode(unref(arrow_left_default))
                                ]),
                                _: 1
                                /* STABLE */
                              })
                            ],
                            2
                            /* CLASS */
                          ),
                          createElementVNode(
                            "span",
                            {
                              class: normalizeClass(arrowNextKls.value),
                              onClick: next
                            },
                            [
                              createVNode(unref(ElIcon), null, {
                                default: withCtx(() => [
                                  createVNode(unref(arrow_right_default))
                                ]),
                                _: 1
                                /* STABLE */
                              })
                            ],
                            2
                            /* CLASS */
                          )
                        ],
                        64
                        /* STABLE_FRAGMENT */
                      )) : createCommentVNode("v-if", true),
                      _ctx.$slots.progress || __props.showProgress ? (openBlock(), createElementBlock(
                        "div",
                        {
                          key: 1,
                          class: normalizeClass([unref(ns).e("btn"), unref(ns).e("progress")])
                        },
                        [
                          renderSlot(_ctx.$slots, "progress", {
                            activeIndex: activeIndex.value,
                            total: __props.urlList.length
                          }, () => [
                            createTextVNode(
                              toDisplayString(progress.value),
                              1
                              /* TEXT */
                            )
                          ])
                        ],
                        2
                        /* CLASS */
                      )) : createCommentVNode("v-if", true),
                      createCommentVNode(" ACTIONS "),
                      createElementVNode(
                        "div",
                        {
                          class: normalizeClass([unref(ns).e("btn"), unref(ns).e("actions")])
                        },
                        [
                          createElementVNode(
                            "div",
                            {
                              class: normalizeClass(unref(ns).e("actions__inner"))
                            },
                            [
                              renderSlot(_ctx.$slots, "toolbar", {
                                actions: handleActions,
                                prev,
                                next,
                                reset: toggleMode,
                                activeIndex: activeIndex.value,
                                setActiveItem
                              }, () => [
                                createVNode(unref(ElIcon), {
                                  onClick: _cache[1] || (_cache[1] = ($event) => handleActions("zoomOut"))
                                }, {
                                  default: withCtx(() => [
                                    createVNode(unref(zoom_out_default))
                                  ]),
                                  _: 1
                                  /* STABLE */
                                }),
                                createVNode(unref(ElIcon), {
                                  onClick: _cache[2] || (_cache[2] = ($event) => handleActions("zoomIn"))
                                }, {
                                  default: withCtx(() => [
                                    createVNode(unref(zoom_in_default))
                                  ]),
                                  _: 1
                                  /* STABLE */
                                }),
                                createElementVNode(
                                  "i",
                                  {
                                    class: normalizeClass(unref(ns).e("actions__divider"))
                                  },
                                  null,
                                  2
                                  /* CLASS */
                                ),
                                createVNode(unref(ElIcon), { onClick: toggleMode }, {
                                  default: withCtx(() => [
                                    (openBlock(), createBlock(resolveDynamicComponent(mode.value.icon)))
                                  ]),
                                  _: 1
                                  /* STABLE */
                                }),
                                createElementVNode(
                                  "i",
                                  {
                                    class: normalizeClass(unref(ns).e("actions__divider"))
                                  },
                                  null,
                                  2
                                  /* CLASS */
                                ),
                                createVNode(unref(ElIcon), {
                                  onClick: _cache[3] || (_cache[3] = ($event) => handleActions("anticlockwise"))
                                }, {
                                  default: withCtx(() => [
                                    createVNode(unref(refresh_left_default))
                                  ]),
                                  _: 1
                                  /* STABLE */
                                }),
                                createVNode(unref(ElIcon), {
                                  onClick: _cache[4] || (_cache[4] = ($event) => handleActions("clockwise"))
                                }, {
                                  default: withCtx(() => [
                                    createVNode(unref(refresh_right_default))
                                  ]),
                                  _: 1
                                  /* STABLE */
                                })
                              ])
                            ],
                            2
                            /* CLASS */
                          )
                        ],
                        2
                        /* CLASS */
                      ),
                      createCommentVNode(" CANVAS "),
                      createElementVNode(
                        "div",
                        {
                          class: normalizeClass(unref(ns).e("canvas"))
                        },
                        [
                          loadError.value && _ctx.$slots["viewer-error"] ? renderSlot(_ctx.$slots, "viewer-error", {
                            key: 0,
                            activeIndex: activeIndex.value,
                            src: currentImg.value
                          }) : (openBlock(), createElementBlock("img", {
                            ref_key: "imgRef",
                            ref: imgRef,
                            key: currentImg.value,
                            src: currentImg.value,
                            style: normalizeStyle(imgStyle.value),
                            class: normalizeClass(unref(ns).e("img")),
                            crossorigin: __props.crossorigin,
                            onLoad: handleImgLoad,
                            onError: handleImgError,
                            onMousedown: handleMouseDown,
                            onTouchstart: handleTouchStart
                          }, null, 46, _hoisted_1))
                        ],
                        2
                        /* CLASS */
                      ),
                      renderSlot(_ctx.$slots, "default")
                    ]),
                    _: 3
                    /* FORWARDED */
                  }, 8, ["focus-trap-el"])
                ],
                6
                /* CLASS, STYLE */
              )
            ]),
            _: 3
            /* FORWARDED */
          })
        ]),
        _: 3
        /* FORWARDED */
      }, 8, ["disabled"]);
    };
  }
});
const ElImageViewer = withInstall(_sfc_main);

export { ElImageViewer as E };
