import { defineComponent, computed, unref, reactive, toRefs, getCurrentInstance, inject, ref, provide, watch, openBlock, createElementBlock, normalizeStyle, normalizeClass, createElementVNode, renderSlot, withModifiers, createVNode, withCtx, createCommentVNode, createBlock, Transition, toRaw, withDirectives, toDisplayString, vShow, useSlots, watchEffect, nextTick, shallowRef, resolveComponent, resolveDirective, mergeProps, toHandlerKey, Fragment, renderList, createTextVNode, resolveDynamicComponent, isVNode } from 'vue';
import { u as useTooltipContentProps, E as ElTooltip } from './index-Cx5QSQzK.mjs';
import { s as scrollbarEmits, E as ElScrollbar } from './index-tCyBRCDx.mjs';
import { P as withInstall, Q as withNoopInstall, a0 as buildProps, at as componentSizes, C as useNamespace, ay as useId, aD as useEmptyValuesProps, G as arrow_down_default, a1 as iconPropType, a6 as circle_close_default, K as useSizeProp, a2 as definePropType, D as useLocale, ag as close_default, z as throwError, aA as useEmptyValues, O as debugWarn, a8 as ValidateComponentsMap, aB as isEmpty, y as isUndefined, L as isNumber$1, aC as useDebounceFn$1 } from './server.mjs';
import { E as ElIcon } from './index-CRbm0e05.mjs';
import { b as useFormSize, a as useFormItem, c as useFormItemInputId, u as useFormDisabled } from './use-form-item-Cr81A1TZ.mjs';
import { isEqual, castArray, get, isNil, clamp, findLastIndex } from 'lodash-unified';
import { isArray, isObject, isString, isFunction, isPlainObject } from '@vue/shared';
import { _ as _export_sfc, g as getEventCode, b as EVENT_CODE } from './focus-trap.vue-9ChHxs3Q.mjs';
import { b as useMutationObserver, u as useResizeObserver } from './index-ChPMoinw.mjs';
import { a as useComposition, u as useFocusController } from './index-Bp-nwGzu.mjs';
import { U as UPDATE_MODEL_EVENT, C as CHANGE_EVENT } from './event-BZTOGHfp.mjs';
import { placements } from '@popperjs/core';
import { u as useAriaProps } from './index-DRiwogtD.mjs';
import { C as ClickOutside } from './index-BY8mj3AC.mjs';
import { f as flattedChildren } from './vnode-l2ZP2UQa.mjs';

const tagProps = buildProps({
  /**
   * @description type of Tag
   */
  type: {
    type: String,
    values: ["primary", "success", "info", "warning", "danger"],
    default: "primary"
  },
  /**
   * @description whether Tag can be removed
   */
  closable: Boolean,
  /**
   * @description whether to disable animations
   */
  disableTransitions: Boolean,
  /**
   * @description whether Tag has a highlighted border
   */
  hit: Boolean,
  /**
   * @description background color of the Tag
   */
  color: String,
  /**
   * @description size of Tag
   */
  size: {
    type: String,
    values: componentSizes
  },
  /**
   * @description theme of Tag
   */
  effect: {
    type: String,
    values: ["dark", "light", "plain"],
    default: "light"
  },
  /**
   * @description whether Tag is rounded
   */
  round: Boolean
});
const tagEmits = {
  close: (evt) => evt instanceof MouseEvent,
  click: (evt) => evt instanceof MouseEvent
};
const _hoisted_1$2 = ["aria-label"];
const _hoisted_2$1 = ["aria-label"];
var _sfc_main$4 = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElTag"
  },
  __name: "tag",
  props: tagProps,
  emits: tagEmits,
  setup(__props, { emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const tagSize = useFormSize();
    const { t } = useLocale();
    const ns = useNamespace("tag");
    const containerKls = computed(() => {
      const { type, hit, effect, closable, round } = props;
      return [
        ns.b(),
        ns.is("closable", closable),
        ns.m(type || "primary"),
        ns.m(tagSize.value),
        ns.m(effect),
        ns.is("hit", hit),
        ns.is("round", round)
      ];
    });
    const handleClose = (event) => {
      emit("close", event);
    };
    const handleClick = (event) => {
      emit("click", event);
    };
    const handleVNodeMounted = (vnode) => {
      var _a, _b, _c;
      if ((_c = (_b = (_a = vnode == null ? void 0 : vnode.component) == null ? void 0 : _a.subTree) == null ? void 0 : _b.component) == null ? void 0 : _c.bum) {
        vnode.component.subTree.component.bum = null;
      }
    };
    return (_ctx, _cache) => {
      return __props.disableTransitions ? (openBlock(), createElementBlock(
        "span",
        {
          key: 0,
          class: normalizeClass(containerKls.value),
          style: normalizeStyle({ backgroundColor: __props.color }),
          onClick: handleClick
        },
        [
          createElementVNode(
            "span",
            {
              class: normalizeClass(unref(ns).e("content"))
            },
            [
              renderSlot(_ctx.$slots, "default")
            ],
            2
            /* CLASS */
          ),
          __props.closable ? (openBlock(), createElementBlock("button", {
            key: 0,
            "aria-label": unref(t)("el.tag.close"),
            class: normalizeClass(unref(ns).e("close")),
            type: "button",
            onClick: withModifiers(handleClose, ["stop"])
          }, [
            createVNode(unref(ElIcon), null, {
              default: withCtx(() => [
                createVNode(unref(close_default))
              ]),
              _: 1
              /* STABLE */
            })
          ], 10, _hoisted_1$2)) : createCommentVNode("v-if", true)
        ],
        6
        /* CLASS, STYLE */
      )) : (openBlock(), createBlock(Transition, {
        key: 1,
        name: `${unref(ns).namespace.value}-zoom-in-center`,
        appear: "",
        onVnodeMounted: handleVNodeMounted
      }, {
        default: withCtx(() => [
          createElementVNode(
            "span",
            {
              class: normalizeClass(containerKls.value),
              style: normalizeStyle({ backgroundColor: __props.color }),
              onClick: handleClick
            },
            [
              createElementVNode(
                "span",
                {
                  class: normalizeClass(unref(ns).e("content"))
                },
                [
                  renderSlot(_ctx.$slots, "default")
                ],
                2
                /* CLASS */
              ),
              __props.closable ? (openBlock(), createElementBlock("button", {
                key: 0,
                "aria-label": unref(t)("el.tag.close"),
                class: normalizeClass(unref(ns).e("close")),
                type: "button",
                onClick: withModifiers(handleClose, ["stop"])
              }, [
                createVNode(unref(ElIcon), null, {
                  default: withCtx(() => [
                    createVNode(unref(close_default))
                  ]),
                  _: 1
                  /* STABLE */
                })
              ], 10, _hoisted_2$1)) : createCommentVNode("v-if", true)
            ],
            6
            /* CLASS, STYLE */
          )
        ]),
        _: 3
        /* FORWARDED */
      }, 8, ["name"]));
    };
  }
});
const ElTag = withInstall(_sfc_main$4);
const defaultProps = {
  label: "label",
  value: "value",
  disabled: "disabled",
  options: "options"
};
function useProps(props) {
  const aliasProps = ref({ ...defaultProps, ...props.props });
  let cache = { ...props.props };
  watch(
    () => props.props,
    (val) => {
      if (!isEqual(val, cache)) {
        aliasProps.value = { ...defaultProps, ...val };
        cache = { ...val };
      }
    },
    { deep: true }
  );
  const getLabel = (option) => get(option, aliasProps.value.label);
  const getValue = (option) => get(option, aliasProps.value.value);
  const getDisabled = (option) => get(option, aliasProps.value.disabled);
  const getOptions = (option) => get(option, aliasProps.value.options);
  return {
    aliasProps,
    getLabel,
    getValue,
    getDisabled,
    getOptions
  };
}
const selectGroupKey = /* @__PURE__ */ Symbol("ElSelectGroup");
const selectKey = /* @__PURE__ */ Symbol("ElSelect");
const COMPONENT_NAME$1 = "ElOption";
const optionProps = buildProps({
  /**
   * @description value of option
   */
  value: {
    type: [String, Number, Boolean, Object],
    required: true
  },
  /**
   * @description label of option, same as `value` if omitted
   */
  label: {
    type: [String, Number]
  },
  created: Boolean,
  /**
   * @description whether option is disabled
   */
  disabled: Boolean
});
const escapeStringRegexp = (string = "") => string.replace(/[|\\{}()[\]^$+*?.]/g, "\\$&").replace(/-/g, "\\x2d");
function useOption(props, states) {
  const select = inject(selectKey);
  if (!select) {
    throwError(COMPONENT_NAME$1, "usage: <el-select><el-option /></el-select/>");
  }
  const selectGroup = inject(selectGroupKey, { disabled: false });
  const itemSelected = computed(() => {
    return contains(castArray(select.props.modelValue), props.value);
  });
  const limitReached = computed(() => {
    var _a;
    if (select.props.multiple) {
      const modelValue = castArray((_a = select.props.modelValue) != null ? _a : []);
      return !itemSelected.value && modelValue.length >= select.props.multipleLimit && select.props.multipleLimit > 0;
    } else {
      return false;
    }
  });
  const currentLabel = computed(() => {
    var _a;
    return (_a = props.label) != null ? _a : isObject(props.value) ? "" : props.value;
  });
  const currentValue = computed(() => {
    return props.value || props.label || "";
  });
  const isDisabled = computed(() => {
    return props.disabled || states.groupDisabled || limitReached.value;
  });
  const instance = getCurrentInstance();
  const contains = (arr = [], target) => {
    if (!isObject(props.value)) {
      return arr && arr.includes(target);
    } else {
      const valueKey = select.props.valueKey;
      return arr && arr.some((item) => {
        return toRaw(get(item, valueKey)) === get(target, valueKey);
      });
    }
  };
  const hoverItem = () => {
    if (!isDisabled.value) {
      select.states.hoveringIndex = select.optionsArray.indexOf(instance.proxy);
    }
  };
  const updateOption = (query) => {
    const regexp = new RegExp(escapeStringRegexp(query), "i");
    states.visible = regexp.test(String(currentLabel.value)) || props.created;
  };
  watch(
    () => currentLabel.value,
    () => {
      if (!props.created && !select.props.remote) select.setSelected();
    }
  );
  watch(
    () => props.value,
    (val, oldVal) => {
      const { remote, valueKey } = select.props;
      const shouldUpdate = remote ? val !== oldVal : !isEqual(val, oldVal);
      if (shouldUpdate) {
        select.onOptionDestroy(oldVal, instance.proxy);
        select.onOptionCreate(instance.proxy);
      }
      if (!props.created && !remote) {
        if (valueKey && isObject(val) && isObject(oldVal) && val[valueKey] === oldVal[valueKey]) {
          return;
        }
        select.setSelected();
      }
    }
  );
  watch(
    () => selectGroup.disabled,
    () => {
      states.groupDisabled = selectGroup.disabled;
    },
    { immediate: true }
  );
  return {
    select,
    currentLabel,
    currentValue,
    itemSelected,
    isDisabled,
    hoverItem,
    updateOption
  };
}
var _sfc_main$3 = defineComponent({
  name: COMPONENT_NAME$1,
  componentName: COMPONENT_NAME$1,
  props: optionProps,
  setup(props) {
    const ns = useNamespace("select");
    const id = useId();
    const containerKls = computed(() => [
      ns.be("dropdown", "item"),
      ns.is("disabled", unref(isDisabled)),
      ns.is("selected", unref(itemSelected)),
      ns.is("hovering", unref(hover))
    ]);
    const states = reactive({
      index: -1,
      groupDisabled: false,
      visible: true,
      hover: false
    });
    const {
      currentLabel,
      itemSelected,
      isDisabled,
      select,
      hoverItem,
      updateOption
    } = useOption(props, states);
    const { visible, hover } = toRefs(states);
    const vm = getCurrentInstance().proxy;
    select.onOptionCreate(vm);
    function selectOptionClick() {
      if (!isDisabled.value) {
        select.handleOptionSelect(vm);
      }
    }
    return {
      ns,
      id,
      containerKls,
      currentLabel,
      itemSelected,
      isDisabled,
      select,
      visible,
      hover,
      states,
      hoverItem,
      updateOption,
      selectOptionClick
    };
  }
});
const _hoisted_1$1 = ["id", "aria-disabled", "aria-selected"];
function _sfc_render$3(_ctx, _cache, $props, $setup, $data, $options) {
  return withDirectives((openBlock(), createElementBlock("li", {
    id: _ctx.id,
    class: normalizeClass(_ctx.containerKls),
    role: "option",
    "aria-disabled": _ctx.isDisabled || void 0,
    "aria-selected": _ctx.itemSelected,
    onMousemove: _cache[0] || (_cache[0] = (...args) => _ctx.hoverItem && _ctx.hoverItem(...args)),
    onClick: _cache[1] || (_cache[1] = withModifiers((...args) => _ctx.selectOptionClick && _ctx.selectOptionClick(...args), ["stop"]))
  }, [
    renderSlot(_ctx.$slots, "default", {}, () => [
      createElementVNode(
        "span",
        null,
        toDisplayString(_ctx.currentLabel),
        1
        /* TEXT */
      )
    ])
  ], 42, _hoisted_1$1)), [
    [vShow, _ctx.visible]
  ]);
}
var Option = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["render", _sfc_render$3]]);
const MINIMUM_INPUT_WIDTH = 11;
var _sfc_main$2 = defineComponent({
  name: "ElSelectDropdown",
  componentName: "ElSelectDropdown",
  setup() {
    const select = inject(selectKey);
    const ns = useNamespace("select");
    const popperClass = computed(() => select.props.popperClass);
    const isMultiple = computed(() => select.props.multiple);
    const isFitInputWidth = computed(() => select.props.fitInputWidth);
    const minWidth = ref("");
    return {
      ns,
      minWidth,
      popperClass,
      isMultiple,
      isFitInputWidth
    };
  }
});
function _sfc_render$2(_ctx, _cache, $props, $setup, $data, $options) {
  return openBlock(), createElementBlock(
    "div",
    {
      class: normalizeClass([_ctx.ns.b("dropdown"), _ctx.ns.is("multiple", _ctx.isMultiple), _ctx.popperClass]),
      style: normalizeStyle({ [_ctx.isFitInputWidth ? "width" : "minWidth"]: _ctx.minWidth })
    },
    [
      _ctx.$slots.header ? (openBlock(), createElementBlock(
        "div",
        {
          key: 0,
          class: normalizeClass(_ctx.ns.be("dropdown", "header"))
        },
        [
          renderSlot(_ctx.$slots, "header")
        ],
        2
        /* CLASS */
      )) : createCommentVNode("v-if", true),
      renderSlot(_ctx.$slots, "default"),
      _ctx.$slots.footer ? (openBlock(), createElementBlock(
        "div",
        {
          key: 1,
          class: normalizeClass(_ctx.ns.be("dropdown", "footer"))
        },
        [
          renderSlot(_ctx.$slots, "footer")
        ],
        2
        /* CLASS */
      )) : createCommentVNode("v-if", true)
    ],
    6
    /* CLASS, STYLE */
  );
}
var ElSelectMenu = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["render", _sfc_render$2]]);
const useSelect = (props, emit) => {
  const { t } = useLocale();
  const slots = useSlots();
  const contentId = useId();
  const nsSelect = useNamespace("select");
  const nsInput = useNamespace("input");
  const states = reactive({
    inputValue: "",
    options: /* @__PURE__ */ new Map(),
    cachedOptions: /* @__PURE__ */ new Map(),
    optionValues: [],
    // sorted value of options
    selected: [],
    selectionWidth: 0,
    collapseItemWidth: 0,
    selectedLabel: "",
    hoveringIndex: -1,
    previousQuery: null,
    inputHovering: false,
    menuVisibleOnFocus: false,
    isBeforeHide: false
  });
  const selectRef = ref();
  const selectionRef = ref();
  const tooltipRef = ref();
  const tagTooltipRef = ref();
  const inputRef = ref();
  const prefixRef = ref();
  const suffixRef = ref();
  const menuRef = ref();
  const tagMenuRef = ref();
  const collapseItemRef = ref();
  const scrollbarRef = ref();
  const expanded = ref(false);
  const hoverOption = ref();
  const debouncing = ref(false);
  const { form, formItem } = useFormItem();
  const { inputId } = useFormItemInputId(props, {
    formItemContext: formItem
  });
  const { valueOnClear, isEmptyValue } = useEmptyValues(props);
  const {
    isComposing,
    handleCompositionStart,
    handleCompositionUpdate,
    handleCompositionEnd
  } = useComposition({
    afterComposition: (e) => onInput(e)
  });
  const selectDisabled = useFormDisabled();
  const { wrapperRef, isFocused, handleBlur } = useFocusController(inputRef, {
    disabled: selectDisabled,
    afterFocus() {
      if (props.automaticDropdown && !expanded.value) {
        expanded.value = true;
        states.menuVisibleOnFocus = true;
      }
    },
    beforeBlur(event) {
      var _a, _b;
      return ((_a = tooltipRef.value) == null ? void 0 : _a.isFocusInsideContent(event)) || ((_b = tagTooltipRef.value) == null ? void 0 : _b.isFocusInsideContent(event));
    },
    afterBlur() {
      var _a;
      expanded.value = false;
      states.menuVisibleOnFocus = false;
      if (props.validateEvent) {
        (_a = formItem == null ? void 0 : formItem.validate) == null ? void 0 : _a.call(formItem, "blur").catch((err) => debugWarn());
      }
    }
  });
  const hasModelValue = computed(() => {
    return isArray(props.modelValue) ? props.modelValue.length > 0 : !isEmptyValue(props.modelValue);
  });
  const needStatusIcon = computed(() => {
    var _a;
    return (_a = form == null ? void 0 : form.statusIcon) != null ? _a : false;
  });
  const showClearBtn = computed(() => {
    return props.clearable && !selectDisabled.value && hasModelValue.value && (isFocused.value || states.inputHovering);
  });
  const iconComponent = computed(
    () => props.remote && props.filterable && !props.remoteShowSuffix ? "" : props.suffixIcon
  );
  const iconReverse = computed(
    () => nsSelect.is("reverse", !!(iconComponent.value && expanded.value))
  );
  const validateState = computed(() => (formItem == null ? void 0 : formItem.validateState) || "");
  const validateIcon = computed(
    () => validateState.value && ValidateComponentsMap[validateState.value]
  );
  const debounce = computed(() => props.remote ? props.debounce : 0);
  const isRemoteSearchEmpty = computed(
    () => props.remote && !states.inputValue && states.options.size === 0
  );
  const emptyText = computed(() => {
    if (props.loading) {
      return props.loadingText || t("el.select.loading");
    } else {
      if (props.filterable && states.inputValue && states.options.size > 0 && filteredOptionsCount.value === 0) {
        return props.noMatchText || t("el.select.noMatch");
      }
      if (states.options.size === 0) {
        return props.noDataText || t("el.select.noData");
      }
    }
    return null;
  });
  const filteredOptionsCount = computed(
    () => optionsArray.value.filter((option) => option.visible).length
  );
  const optionsArray = computed(() => {
    const list = Array.from(states.options.values());
    const newList = [];
    states.optionValues.forEach((item) => {
      const index = list.findIndex((i) => i.value === item);
      if (index > -1) {
        newList.push(list[index]);
      }
    });
    return newList.length >= list.length ? newList : list;
  });
  const cachedOptionsArray = computed(
    () => Array.from(states.cachedOptions.values())
  );
  const showNewOption = computed(() => {
    const hasExistingOption = optionsArray.value.filter((option) => {
      return !option.created;
    }).some((option) => {
      return option.currentLabel === states.inputValue;
    });
    return props.filterable && props.allowCreate && states.inputValue !== "" && !hasExistingOption;
  });
  const updateOptions = () => {
    if (props.filterable && isFunction(props.filterMethod)) return;
    if (props.filterable && props.remote && isFunction(props.remoteMethod))
      return;
    optionsArray.value.forEach((option) => {
      var _a;
      (_a = option.updateOption) == null ? void 0 : _a.call(option, states.inputValue);
    });
  };
  const selectSize = useFormSize();
  const collapseTagSize = computed(
    () => ["small"].includes(selectSize.value) ? "small" : "default"
  );
  const dropdownMenuVisible = computed({
    get() {
      return expanded.value && (props.loading || !isRemoteSearchEmpty.value || props.remote && !!slots.empty) && (!debouncing.value || !isEmpty(states.previousQuery));
    },
    set(val) {
      expanded.value = val;
    }
  });
  const shouldShowPlaceholder = computed(() => {
    if (props.multiple && !isUndefined(props.modelValue)) {
      return castArray(props.modelValue).length === 0 && !states.inputValue;
    }
    const value = isArray(props.modelValue) ? props.modelValue[0] : props.modelValue;
    return props.filterable || isUndefined(value) ? !states.inputValue : true;
  });
  const currentPlaceholder = computed(() => {
    var _a;
    const _placeholder = (_a = props.placeholder) != null ? _a : t("el.select.placeholder");
    return props.multiple || !hasModelValue.value ? _placeholder : states.selectedLabel;
  });
  const mouseEnterEventName = computed(() => "mouseenter");
  watch(
    () => props.modelValue,
    (val, oldVal) => {
      if (props.multiple) {
        if (props.filterable && !props.reserveKeyword) {
          states.inputValue = "";
          handleQueryChange("");
        }
      }
      setSelected();
      if (!isEqual(val, oldVal) && props.validateEvent) {
        formItem == null ? void 0 : formItem.validate("change").catch((err) => debugWarn());
      }
    },
    {
      flush: "post",
      deep: true
    }
  );
  watch(
    () => expanded.value,
    (val) => {
      if (val) {
        handleQueryChange(states.inputValue);
      } else {
        states.inputValue = "";
        states.previousQuery = null;
        states.isBeforeHide = true;
        states.menuVisibleOnFocus = false;
      }
    }
  );
  watch(
    // fix `Array.prototype.push/splice/..` cannot trigger non-deep watcher
    // https://github.com/vuejs/vue-next/issues/2116
    () => states.options.entries(),
    () => {
      return;
    },
    {
      flush: "post"
    }
  );
  watch([() => states.hoveringIndex, optionsArray], ([val]) => {
    if (isNumber$1(val) && val > -1) {
      hoverOption.value = optionsArray.value[val] || {};
    } else {
      hoverOption.value = {};
    }
    optionsArray.value.forEach((option) => {
      option.hover = hoverOption.value === option;
    });
  });
  watchEffect(() => {
    if (states.isBeforeHide) return;
    updateOptions();
  });
  const handleQueryChange = (val) => {
    if (states.previousQuery === val || isComposing.value) {
      return;
    }
    states.previousQuery = val;
    if (props.filterable && isFunction(props.filterMethod)) {
      props.filterMethod(val);
    } else if (props.filterable && props.remote && isFunction(props.remoteMethod)) {
      props.remoteMethod(val);
    }
    if (props.defaultFirstOption && (props.filterable || props.remote) && filteredOptionsCount.value) {
      nextTick(checkDefaultFirstOption);
    } else {
      nextTick(updateHoveringIndex);
    }
  };
  const checkDefaultFirstOption = () => {
    const optionsInDropdown = optionsArray.value.filter(
      (n) => n.visible && !n.disabled && !n.states.groupDisabled
    );
    const userCreatedOption = optionsInDropdown.find((n) => n.created);
    const firstOriginOption = optionsInDropdown[0];
    const valueList = optionsArray.value.map((item) => item.value);
    states.hoveringIndex = getValueIndex(
      valueList,
      userCreatedOption || firstOriginOption
    );
  };
  const setSelected = () => {
    if (!props.multiple) {
      const value = isArray(props.modelValue) ? props.modelValue[0] : props.modelValue;
      const option = getOption(value);
      states.selectedLabel = option.currentLabel;
      states.selected = [option];
      return;
    } else {
      states.selectedLabel = "";
    }
    const result = [];
    if (!isUndefined(props.modelValue)) {
      castArray(props.modelValue).forEach((value) => {
        result.push(getOption(value));
      });
    }
    states.selected = result;
  };
  const getOption = (value) => {
    let option;
    const isObjectValue = isPlainObject(value);
    for (let i = states.cachedOptions.size - 1; i >= 0; i--) {
      const cachedOption = cachedOptionsArray.value[i];
      const isEqualValue = isObjectValue ? get(cachedOption.value, props.valueKey) === get(value, props.valueKey) : cachedOption.value === value;
      if (isEqualValue) {
        option = {
          index: optionsArray.value.filter((opt) => !opt.created).indexOf(cachedOption),
          value,
          currentLabel: cachedOption.currentLabel,
          get isDisabled() {
            return cachedOption.isDisabled;
          }
        };
        break;
      }
    }
    if (option) return option;
    const label = isObjectValue ? value.label : value != null ? value : "";
    const newOption = {
      index: -1,
      value,
      currentLabel: label
    };
    return newOption;
  };
  const updateHoveringIndex = () => {
    const length = states.selected.length;
    if (length > 0) {
      const lastOption = states.selected[length - 1];
      states.hoveringIndex = optionsArray.value.findIndex(
        (item) => getValueKey(lastOption) === getValueKey(item)
      );
    } else {
      states.hoveringIndex = -1;
    }
  };
  const resetSelectionWidth = () => {
    states.selectionWidth = Number.parseFloat(
      (void 0).getComputedStyle(selectionRef.value).width
    );
  };
  const resetCollapseItemWidth = () => {
    states.collapseItemWidth = collapseItemRef.value.getBoundingClientRect().width;
  };
  const updateTooltip = () => {
    var _a, _b;
    (_b = (_a = tooltipRef.value) == null ? void 0 : _a.updatePopper) == null ? void 0 : _b.call(_a);
  };
  const updateTagTooltip = () => {
    var _a, _b;
    (_b = (_a = tagTooltipRef.value) == null ? void 0 : _a.updatePopper) == null ? void 0 : _b.call(_a);
  };
  const onInputChange = () => {
    if (states.inputValue.length > 0 && !expanded.value) {
      expanded.value = true;
    }
    handleQueryChange(states.inputValue);
  };
  const onInput = (event) => {
    states.inputValue = event.target.value;
    if (props.remote) {
      debouncing.value = true;
      debouncedOnInputChange();
    } else {
      return onInputChange();
    }
  };
  const debouncedOnInputChange = useDebounceFn$1(() => {
    onInputChange();
    debouncing.value = false;
  }, debounce);
  const emitChange = (val) => {
    if (!isEqual(props.modelValue, val)) {
      emit(CHANGE_EVENT, val);
    }
  };
  const getLastNotDisabledIndex = (value) => findLastIndex(value, (it) => {
    const option = states.cachedOptions.get(it);
    return !(option == null ? void 0 : option.disabled) && !(option == null ? void 0 : option.states.groupDisabled);
  });
  const deletePrevTag = (e) => {
    const code = getEventCode(e);
    if (!props.multiple) return;
    if (code === EVENT_CODE.delete) return;
    if (e.target.value.length <= 0) {
      const value = castArray(props.modelValue).slice();
      const lastNotDisabledIndex = getLastNotDisabledIndex(value);
      if (lastNotDisabledIndex < 0) return;
      const removeTagValue = value[lastNotDisabledIndex];
      value.splice(lastNotDisabledIndex, 1);
      emit(UPDATE_MODEL_EVENT, value);
      emitChange(value);
      emit("remove-tag", removeTagValue);
    }
  };
  const deleteTag = (event, tag) => {
    const index = states.selected.indexOf(tag);
    if (index > -1 && !selectDisabled.value) {
      const value = castArray(props.modelValue).slice();
      value.splice(index, 1);
      emit(UPDATE_MODEL_EVENT, value);
      emitChange(value);
      emit("remove-tag", tag.value);
    }
    event.stopPropagation();
    focus();
  };
  const deleteSelected = (event) => {
    event.stopPropagation();
    const value = props.multiple ? [] : valueOnClear.value;
    if (props.multiple) {
      for (const item of states.selected) {
        if (item.isDisabled) value.push(item.value);
      }
    }
    emit(UPDATE_MODEL_EVENT, value);
    emitChange(value);
    states.hoveringIndex = -1;
    expanded.value = false;
    emit("clear");
    focus();
  };
  const handleOptionSelect = (option) => {
    var _a;
    if (props.multiple) {
      const value = castArray((_a = props.modelValue) != null ? _a : []).slice();
      const optionIndex = getValueIndex(value, option);
      if (optionIndex > -1) {
        value.splice(optionIndex, 1);
      } else if (props.multipleLimit <= 0 || value.length < props.multipleLimit) {
        value.push(option.value);
      }
      emit(UPDATE_MODEL_EVENT, value);
      emitChange(value);
      if (option.created) {
        handleQueryChange("");
      }
      if (props.filterable && !props.reserveKeyword) {
        states.inputValue = "";
      }
    } else {
      !isEqual(props.modelValue, option.value) && emit(UPDATE_MODEL_EVENT, option.value);
      emitChange(option.value);
      expanded.value = false;
    }
    focus();
    if (expanded.value) return;
    nextTick(() => {
      scrollToOption(option);
    });
  };
  const getValueIndex = (arr, option) => {
    if (isUndefined(option)) return -1;
    if (!isObject(option.value)) return arr.indexOf(option.value);
    return arr.findIndex((item) => {
      return isEqual(get(item, props.valueKey), getValueKey(option));
    });
  };
  const scrollToOption = (option) => {
    var _a, _b, _c, _d, _e;
    const targetOption = isArray(option) ? option[option.length - 1] : option;
    let target = null;
    if (!isNil(targetOption == null ? void 0 : targetOption.value)) {
      const options = optionsArray.value.filter(
        (item) => item.value === targetOption.value
      );
      if (options.length > 0) {
        target = options[0].$el;
      }
    }
    if (tooltipRef.value && target) {
      (_d = (_c = (_b = (_a = tooltipRef.value) == null ? void 0 : _a.popperRef) == null ? void 0 : _b.contentRef) == null ? void 0 : _c.querySelector) == null ? void 0 : _d.call(
        _c,
        `.${nsSelect.be("dropdown", "wrap")}`
      );
    }
    (_e = scrollbarRef.value) == null ? void 0 : _e.handleScroll();
  };
  const onOptionCreate = (vm) => {
    states.options.set(vm.value, vm);
    states.cachedOptions.set(vm.value, vm);
  };
  const onOptionDestroy = (key, vm) => {
    if (states.options.get(key) === vm) {
      states.options.delete(key);
    }
  };
  const popperRef = computed(() => {
    var _a, _b;
    return (_b = (_a = tooltipRef.value) == null ? void 0 : _a.popperRef) == null ? void 0 : _b.contentRef;
  });
  const handleMenuEnter = () => {
    states.isBeforeHide = false;
    nextTick(() => {
      var _a;
      (_a = scrollbarRef.value) == null ? void 0 : _a.update();
      scrollToOption(states.selected);
    });
  };
  const focus = () => {
    var _a;
    (_a = inputRef.value) == null ? void 0 : _a.focus();
  };
  const blur = () => {
    var _a;
    if (expanded.value) {
      expanded.value = false;
      nextTick(() => {
        var _a2;
        return (_a2 = inputRef.value) == null ? void 0 : _a2.blur();
      });
      return;
    }
    (_a = inputRef.value) == null ? void 0 : _a.blur();
  };
  const handleClearClick = (event) => {
    deleteSelected(event);
  };
  const handleClickOutside = (event) => {
    expanded.value = false;
    if (isFocused.value) {
      const _event = new FocusEvent("blur", event);
      nextTick(() => handleBlur(_event));
    }
  };
  const handleEsc = () => {
    if (states.inputValue.length > 0) {
      states.inputValue = "";
    } else {
      expanded.value = false;
    }
  };
  const toggleMenu = (event) => {
    var _a;
    if (selectDisabled.value || props.filterable && expanded.value && event && !((_a = suffixRef.value) == null ? void 0 : _a.contains(event.target)))
      return;
    if (states.menuVisibleOnFocus) {
      states.menuVisibleOnFocus = false;
    } else {
      expanded.value = !expanded.value;
    }
  };
  const selectOption = () => {
    if (!expanded.value) {
      toggleMenu();
    } else {
      const option = optionsArray.value[states.hoveringIndex];
      if (option && !option.isDisabled) {
        handleOptionSelect(option);
      }
    }
  };
  const getValueKey = (item) => {
    return isObject(item.value) ? get(item.value, props.valueKey) : item.value;
  };
  const optionsAllDisabled = computed(
    () => optionsArray.value.filter((option) => option.visible).every((option) => option.isDisabled)
  );
  const showTagList = computed(() => {
    if (!props.multiple) {
      return [];
    }
    return props.collapseTags ? states.selected.slice(0, props.maxCollapseTags) : states.selected;
  });
  const collapseTagList = computed(() => {
    if (!props.multiple) {
      return [];
    }
    return props.collapseTags ? states.selected.slice(props.maxCollapseTags) : [];
  });
  const navigateOptions = (direction) => {
    if (!expanded.value) {
      expanded.value = true;
      return;
    }
    if (states.options.size === 0 || filteredOptionsCount.value === 0 || isComposing.value)
      return;
    if (!optionsAllDisabled.value) {
      if (direction === "next") {
        states.hoveringIndex++;
        if (states.hoveringIndex === states.options.size) {
          states.hoveringIndex = 0;
        }
      } else if (direction === "prev") {
        states.hoveringIndex--;
        if (states.hoveringIndex < 0) {
          states.hoveringIndex = states.options.size - 1;
        }
      }
      const option = optionsArray.value[states.hoveringIndex];
      if (option.isDisabled || !option.visible) {
        navigateOptions(direction);
      }
      nextTick(() => scrollToOption(hoverOption.value));
    }
  };
  const findFocusableIndex = (arr, start, step, len) => {
    for (let i = start; i >= 0 && i < len; i += step) {
      const obj = arr[i];
      if (!(obj == null ? void 0 : obj.isDisabled) && (obj == null ? void 0 : obj.visible)) {
        return i;
      }
    }
    return null;
  };
  const focusOption = (targetIndex, mode) => {
    var _a;
    const len = states.options.size;
    if (len === 0) return;
    const start = clamp(targetIndex, 0, len - 1);
    const options = optionsArray.value;
    const direction = mode === "up" ? -1 : 1;
    const newIndex = (_a = findFocusableIndex(options, start, direction, len)) != null ? _a : findFocusableIndex(options, start - direction, -direction, len);
    if (newIndex != null) {
      states.hoveringIndex = newIndex;
      nextTick(() => scrollToOption(hoverOption.value));
    }
  };
  const handleKeydown = (e) => {
    const code = getEventCode(e);
    let isPreventDefault = true;
    switch (code) {
      case EVENT_CODE.up:
        navigateOptions("prev");
        break;
      case EVENT_CODE.down:
        navigateOptions("next");
        break;
      case EVENT_CODE.enter:
      case EVENT_CODE.numpadEnter:
        if (!isComposing.value) {
          selectOption();
        }
        break;
      case EVENT_CODE.esc:
        handleEsc();
        break;
      case EVENT_CODE.backspace:
        isPreventDefault = false;
        deletePrevTag(e);
        return;
      case EVENT_CODE.home:
        if (!expanded.value) return;
        focusOption(0, "down");
        break;
      case EVENT_CODE.end:
        if (!expanded.value) return;
        focusOption(states.options.size - 1, "up");
        break;
      case EVENT_CODE.pageUp:
        if (!expanded.value) return;
        focusOption(states.hoveringIndex - 10, "up");
        break;
      case EVENT_CODE.pageDown:
        if (!expanded.value) return;
        focusOption(states.hoveringIndex + 10, "down");
        break;
      default:
        isPreventDefault = false;
        break;
    }
    if (isPreventDefault) {
      e.preventDefault();
      e.stopPropagation();
    }
  };
  const getGapWidth = () => {
    if (!selectionRef.value) return 0;
    const style = (void 0).getComputedStyle(selectionRef.value);
    return Number.parseFloat(style.gap || "6px");
  };
  const tagStyle = computed(() => {
    const gapWidth = getGapWidth();
    const inputSlotWidth = props.filterable ? gapWidth + MINIMUM_INPUT_WIDTH : 0;
    const maxWidth = collapseItemRef.value && props.maxCollapseTags === 1 ? states.selectionWidth - states.collapseItemWidth - gapWidth - inputSlotWidth : states.selectionWidth - inputSlotWidth;
    return { maxWidth: `${maxWidth}px` };
  });
  const collapseTagStyle = computed(() => {
    return { maxWidth: `${states.selectionWidth}px` };
  });
  const popupScroll = (data) => {
    emit("popup-scroll", data);
  };
  useResizeObserver(selectionRef, resetSelectionWidth);
  useResizeObserver(wrapperRef, updateTooltip);
  useResizeObserver(tagMenuRef, updateTagTooltip);
  useResizeObserver(collapseItemRef, resetCollapseItemWidth);
  let stop;
  watch(
    () => dropdownMenuVisible.value,
    (newVal) => {
      if (newVal) {
        stop = useResizeObserver(menuRef, updateTooltip).stop;
      } else {
        stop == null ? void 0 : stop();
        stop = void 0;
      }
      emit("visible-change", newVal);
    }
  );
  return {
    inputId,
    contentId,
    nsSelect,
    nsInput,
    states,
    isFocused,
    expanded,
    optionsArray,
    hoverOption,
    selectSize,
    filteredOptionsCount,
    updateTooltip,
    updateTagTooltip,
    debouncedOnInputChange,
    onInput,
    deletePrevTag,
    deleteTag,
    deleteSelected,
    handleOptionSelect,
    scrollToOption,
    hasModelValue,
    shouldShowPlaceholder,
    currentPlaceholder,
    mouseEnterEventName,
    needStatusIcon,
    showClearBtn,
    iconComponent,
    iconReverse,
    validateState,
    validateIcon,
    showNewOption,
    updateOptions,
    collapseTagSize,
    setSelected,
    selectDisabled,
    emptyText,
    handleCompositionStart,
    handleCompositionUpdate,
    handleCompositionEnd,
    handleKeydown,
    onOptionCreate,
    onOptionDestroy,
    handleMenuEnter,
    focus,
    blur,
    handleClearClick,
    handleClickOutside,
    handleEsc,
    toggleMenu,
    selectOption,
    getValueKey,
    navigateOptions,
    dropdownMenuVisible,
    showTagList,
    collapseTagList,
    popupScroll,
    getOption,
    // computed style
    tagStyle,
    collapseTagStyle,
    // DOM ref
    popperRef,
    inputRef,
    tooltipRef,
    tagTooltipRef,
    prefixRef,
    suffixRef,
    selectRef,
    wrapperRef,
    selectionRef,
    scrollbarRef,
    menuRef,
    tagMenuRef,
    collapseItemRef
  };
};
var ElOptions = defineComponent({
  name: "ElOptions",
  setup(_, { slots }) {
    const select = inject(selectKey);
    let cachedValueList = [];
    return () => {
      var _a, _b;
      const children = (_a = slots.default) == null ? void 0 : _a.call(slots);
      const valueList = [];
      function filterOptions(children2) {
        if (!isArray(children2)) return;
        children2.forEach((item) => {
          var _a2, _b2, _c, _d;
          const name = (_a2 = (item == null ? void 0 : item.type) || {}) == null ? void 0 : _a2.name;
          if (name === "ElOptionGroup") {
            filterOptions(
              !isString(item.children) && !isArray(item.children) && isFunction((_b2 = item.children) == null ? void 0 : _b2.default) ? (_c = item.children) == null ? void 0 : _c.default() : item.children
            );
          } else if (name === "ElOption") {
            valueList.push((_d = item.props) == null ? void 0 : _d.value);
          } else if (isArray(item.children)) {
            filterOptions(item.children);
          }
        });
      }
      if (children.length) {
        filterOptions((_b = children[0]) == null ? void 0 : _b.children);
      }
      if (!isEqual(valueList, cachedValueList)) {
        cachedValueList = valueList;
        if (select) {
          select.states.optionValues = valueList;
        }
      }
      return children;
    };
  }
});
const selectProps = buildProps({
  /**
   * @description the name attribute of select input
   */
  name: String,
  /**
   * @description native input id
   */
  id: String,
  /**
   * @description binding value
   */
  modelValue: {
    type: definePropType([
      Array,
      String,
      Number,
      Boolean,
      Object
    ]),
    default: void 0
  },
  /**
   * @description the autocomplete attribute of select input
   */
  autocomplete: {
    type: String,
    default: "off"
  },
  /**
   * @description for non-filterable Select, this prop decides if the option menu pops up when the input is focused
   */
  automaticDropdown: Boolean,
  /**
   * @description size of Input
   */
  size: useSizeProp,
  /**
   * @description tooltip theme, built-in theme: `dark` / `light`
   */
  effect: {
    type: definePropType(String),
    default: "light"
  },
  /**
   * @description whether Select is disabled
   */
  disabled: {
    type: Boolean,
    default: void 0
  },
  /**
   * @description whether select can be cleared
   */
  clearable: Boolean,
  /**
   * @description whether Select is filterable
   */
  filterable: Boolean,
  /**
   * @description whether creating new items is allowed. To use this, `filterable` must be true
   */
  allowCreate: Boolean,
  /**
   * @description whether Select is loading data from server
   */
  loading: Boolean,
  /**
   * @description custom class name for Select's dropdown
   */
  popperClass: {
    type: String,
    default: ""
  },
  /**
   * @description custom style for Select's dropdown
   */
  popperStyle: {
    type: definePropType([String, Object])
  },
  /**
   * @description [popper.js](https://popper.js.org/docs/v2/) parameters
   */
  popperOptions: {
    type: definePropType(Object),
    default: () => ({})
  },
  /**
   * @description whether options are loaded from server
   */
  remote: Boolean,
  /**
   * @description debounce delay during remote search, in milliseconds
   */
  debounce: {
    type: Number,
    default: 300
  },
  /**
   * @description displayed text while loading data from server, default is 'Loading'
   */
  loadingText: String,
  /**
   * @description displayed text when no data matches the filtering query, you can also use slot `empty`, default is 'No matching data'
   */
  noMatchText: String,
  /**
   * @description displayed text when there is no options, you can also use slot `empty`, default is 'No data'
   */
  noDataText: String,
  /**
   * @description function that gets called when the input value changes. Its parameter is the current input value. To use this, `filterable` must be true
   */
  remoteMethod: {
    type: definePropType(Function)
  },
  /**
   * @description custom filter method, the first parameter is the current input value. To use this, `filterable` must be true
   */
  filterMethod: {
    type: definePropType(Function)
  },
  /**
   * @description whether multiple-select is activated
   */
  multiple: Boolean,
  /**
   * @description maximum number of options user can select when `multiple` is `true`. No limit when set to 0
   */
  multipleLimit: {
    type: Number,
    default: 0
  },
  /**
   * @description placeholder, default is 'Select'
   */
  placeholder: {
    type: String
  },
  /**
   * @description select first matching option on enter key. Use with `filterable` or `remote`
   */
  defaultFirstOption: Boolean,
  /**
   * @description when `multiple` and `filter` is true, whether to reserve current keyword after selecting an option
   */
  reserveKeyword: {
    type: Boolean,
    default: true
  },
  /**
   * @description unique identity key name for value, required when value is an object
   */
  valueKey: {
    type: String,
    default: "value"
  },
  /**
   * @description whether to collapse tags to a text when multiple selecting
   */
  collapseTags: Boolean,
  /**
   * @description whether show all selected tags when mouse hover text of collapse-tags. To use this, `collapse-tags` must be true
   */
  collapseTagsTooltip: Boolean,
  /**
   * @description the max tags number to be shown. To use this, `collapse-tags` must be true
   */
  maxCollapseTags: {
    type: Number,
    default: 1
  },
  /**
   * @description whether select dropdown is teleported, if `true` it will be teleported to where `append-to` sets
   */
  teleported: useTooltipContentProps.teleported,
  /**
   * @description when select dropdown is inactive and `persistent` is `false`, select dropdown will be destroyed
   */
  persistent: {
    type: Boolean,
    default: true
  },
  /**
   * @description custom clear icon component
   */
  clearIcon: {
    type: iconPropType,
    default: circle_close_default
  },
  /**
   * @description whether the width of the dropdown is the same as the input
   */
  fitInputWidth: Boolean,
  /**
   * @description custom suffix icon component
   */
  suffixIcon: {
    type: iconPropType,
    default: arrow_down_default
  },
  /**
   * @description tag type
   */
  tagType: { ...tagProps.type, default: "info" },
  /**
   * @description tag effect
   */
  tagEffect: { ...tagProps.effect, default: "light" },
  /**
   * @description whether to trigger form validation
   */
  validateEvent: {
    type: Boolean,
    default: true
  },
  /**
   * @description in remote search method show suffix icon
   */
  remoteShowSuffix: Boolean,
  /**
   * @description determines whether the arrow is displayed
   */
  showArrow: {
    type: Boolean,
    default: true
  },
  /**
   * @description offset of the dropdown
   */
  offset: {
    type: Number,
    default: 12
  },
  /**
   * @description position of dropdown
   */
  placement: {
    type: definePropType(String),
    values: placements,
    default: "bottom-start"
  },
  /**
   * @description list of possible positions for dropdown
   */
  fallbackPlacements: {
    type: definePropType(Array),
    default: ["bottom-start", "top-start", "right", "left"]
  },
  /**
   * @description tabindex for input
   */
  tabindex: {
    type: [String, Number],
    default: 0
  },
  /**
   * @description which element the selection dropdown appends to
   */
  appendTo: useTooltipContentProps.appendTo,
  options: {
    type: definePropType(Array)
  },
  props: {
    type: definePropType(Object),
    default: () => defaultProps
  },
  ...useEmptyValuesProps,
  ...useAriaProps(["ariaLabel"])
});
({
  "popup-scroll": scrollbarEmits.scroll
});
var _sfc_main$1 = defineComponent({
  name: "ElOptionGroup",
  componentName: "ElOptionGroup",
  props: {
    /**
     * @description name of the group
     */
    label: String,
    /**
     * @description whether to disable all options in this group
     */
    disabled: Boolean
  },
  setup(props) {
    const ns = useNamespace("select");
    const groupRef = ref();
    const instance = getCurrentInstance();
    const children = ref([]);
    provide(
      selectGroupKey,
      reactive({
        ...toRefs(props)
      })
    );
    const visible = computed(
      () => children.value.some((option) => option.visible === true)
    );
    const isOption = (node) => {
      var _a;
      return node.type.name === "ElOption" && !!((_a = node.component) == null ? void 0 : _a.proxy);
    };
    const flattedChildren2 = (node) => {
      const nodes = castArray(node);
      const children2 = [];
      nodes.forEach((child) => {
        var _a;
        if (!isVNode(child)) return;
        if (isOption(child)) {
          children2.push(child.component.proxy);
        } else if (isArray(child.children) && child.children.length) {
          children2.push(...flattedChildren2(child.children));
        } else if ((_a = child.component) == null ? void 0 : _a.subTree) {
          children2.push(...flattedChildren2(child.component.subTree));
        }
      });
      return children2;
    };
    const updateChildren = () => {
      children.value = flattedChildren2(instance.subTree);
    };
    useMutationObserver(groupRef, updateChildren, {
      attributes: true,
      subtree: true,
      childList: true
    });
    return {
      groupRef,
      visible,
      ns
    };
  }
});
function _sfc_render$1(_ctx, _cache, $props, $setup, $data, $options) {
  return withDirectives((openBlock(), createElementBlock(
    "ul",
    {
      ref: "groupRef",
      class: normalizeClass(_ctx.ns.be("group", "wrap"))
    },
    [
      createElementVNode(
        "li",
        {
          class: normalizeClass(_ctx.ns.be("group", "title"))
        },
        toDisplayString(_ctx.label),
        3
        /* TEXT, CLASS */
      ),
      createElementVNode("li", null, [
        createElementVNode(
          "ul",
          {
            class: normalizeClass(_ctx.ns.b("group"))
          },
          [
            renderSlot(_ctx.$slots, "default")
          ],
          2
          /* CLASS */
        )
      ])
    ],
    2
    /* CLASS */
  )), [
    [vShow, _ctx.visible]
  ]);
}
var OptionGroup = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["render", _sfc_render$1]]);
function useCalcInputWidth() {
  const calculatorRef = shallowRef();
  const calculatorWidth = ref(0);
  const inputStyle = computed(() => ({
    minWidth: `${Math.max(calculatorWidth.value, MINIMUM_INPUT_WIDTH)}px`
  }));
  const resetCalculatorWidth = () => {
    var _a, _b;
    calculatorWidth.value = (_b = (_a = calculatorRef.value) == null ? void 0 : _a.getBoundingClientRect().width) != null ? _b : 0;
  };
  useResizeObserver(calculatorRef, resetCalculatorWidth);
  return {
    calculatorRef,
    calculatorWidth,
    inputStyle
  };
}
const COMPONENT_NAME = "ElSelect";
const warnHandlerMap = /* @__PURE__ */ new WeakMap();
const createSelectWarnHandler = (appContext) => {
  return (...args) => {
    var _a, _b;
    const message = args[0];
    if (!message || message.includes(
      'Slot "default" invoked outside of the render function'
    ) && ((_a = args[2]) == null ? void 0 : _a.includes("ElTreeSelect")))
      return;
    const original = (_b = warnHandlerMap.get(appContext)) == null ? void 0 : _b.originalWarnHandler;
    if (original) {
      original(...args);
      return;
    }
    console.warn(...args);
  };
};
const getWarnHandlerRecord = (appContext) => {
  let record = warnHandlerMap.get(appContext);
  if (!record) {
    record = {
      originalWarnHandler: appContext.config.warnHandler,
      handler: createSelectWarnHandler(appContext),
      count: 0
    };
    warnHandlerMap.set(appContext, record);
  }
  return record;
};
var _sfc_main = defineComponent({
  name: COMPONENT_NAME,
  componentName: COMPONENT_NAME,
  components: {
    ElSelectMenu,
    ElOption: Option,
    ElOptions,
    ElOptionGroup: OptionGroup,
    ElTag,
    ElScrollbar,
    ElTooltip,
    ElIcon
  },
  directives: { ClickOutside },
  props: selectProps,
  emits: [
    UPDATE_MODEL_EVENT,
    CHANGE_EVENT,
    "remove-tag",
    "clear",
    "visible-change",
    "focus",
    "blur",
    "popup-scroll"
  ],
  setup(props, { emit, slots }) {
    const instance = getCurrentInstance();
    const warnRecord = getWarnHandlerRecord(instance.appContext);
    warnRecord.count += 1;
    instance.appContext.config.warnHandler = warnRecord.handler;
    const modelValue = computed(() => {
      const { modelValue: rawModelValue, multiple } = props;
      const fallback = multiple ? [] : void 0;
      if (isArray(rawModelValue)) {
        return multiple ? rawModelValue : fallback;
      }
      return multiple ? fallback : rawModelValue;
    });
    const _props = reactive({
      ...toRefs(props),
      modelValue
    });
    const API = useSelect(_props, emit);
    const { calculatorRef, inputStyle } = useCalcInputWidth();
    const { getLabel, getValue, getOptions, getDisabled } = useProps(props);
    const getOptionProps = (option) => ({
      label: getLabel(option),
      value: getValue(option),
      disabled: getDisabled(option)
    });
    const flatTreeSelectData = (data) => {
      return data.reduce((acc, item) => {
        acc.push(item);
        if (item.children && item.children.length > 0) {
          acc.push(...flatTreeSelectData(item.children));
        }
        return acc;
      }, []);
    };
    const manuallyRenderSlots = (vnodes) => {
      const children = flattedChildren(vnodes || []);
      children.forEach((item) => {
        var _a;
        if (isObject(item) && // @ts-expect-error
        (item.type.name === "ElOption" || item.type.name === "ElTree")) {
          const _name = item.type.name;
          if (_name === "ElTree") {
            const treeData = ((_a = item.props) == null ? void 0 : _a.data) || [];
            const flatData = flatTreeSelectData(treeData);
            flatData.forEach((treeItem) => {
              treeItem.currentLabel = treeItem.label || (isObject(treeItem.value) ? "" : treeItem.value);
              API.onOptionCreate(treeItem);
            });
          } else if (_name === "ElOption") {
            const obj = { ...item.props };
            obj.currentLabel = obj.label || (isObject(obj.value) ? "" : obj.value);
            API.onOptionCreate(obj);
          }
        }
      });
    };
    watch(
      () => {
        var _a;
        return [(_a = slots.default) == null ? void 0 : _a.call(slots), modelValue.value];
      },
      () => {
        var _a;
        if (props.persistent || API.expanded.value) {
          return;
        }
        API.states.options.clear();
        manuallyRenderSlots((_a = slots.default) == null ? void 0 : _a.call(slots));
      },
      {
        immediate: true
      }
    );
    provide(
      selectKey,
      reactive({
        props: _props,
        states: API.states,
        selectRef: API.selectRef,
        optionsArray: API.optionsArray,
        setSelected: API.setSelected,
        handleOptionSelect: API.handleOptionSelect,
        onOptionCreate: API.onOptionCreate,
        onOptionDestroy: API.onOptionDestroy
      })
    );
    const selectedLabel = computed(() => {
      if (!props.multiple) {
        return API.states.selectedLabel;
      }
      return API.states.selected.map((i) => i.currentLabel);
    });
    return {
      ...API,
      modelValue,
      selectedLabel,
      calculatorRef,
      inputStyle,
      getLabel,
      getValue,
      getOptions,
      getDisabled,
      getOptionProps
    };
  }
});
const _hoisted_1 = ["id", "value", "name", "disabled", "autocomplete", "tabindex", "readonly", "aria-activedescendant", "aria-controls", "aria-expanded", "aria-label"];
const _hoisted_2 = ["textContent"];
const _hoisted_3 = { key: 1 };
function _sfc_render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_el_tag = resolveComponent("el-tag");
  const _component_el_tooltip = resolveComponent("el-tooltip");
  const _component_el_icon = resolveComponent("el-icon");
  const _component_el_option = resolveComponent("el-option");
  const _component_el_option_group = resolveComponent("el-option-group");
  const _component_el_options = resolveComponent("el-options");
  const _component_el_scrollbar = resolveComponent("el-scrollbar");
  const _component_el_select_menu = resolveComponent("el-select-menu");
  const _directive_click_outside = resolveDirective("click-outside");
  return withDirectives((openBlock(), createElementBlock(
    "div",
    mergeProps({
      ref: "selectRef",
      class: [_ctx.nsSelect.b(), _ctx.nsSelect.m(_ctx.selectSize)]
    }, {
      [toHandlerKey(_ctx.mouseEnterEventName)]: _cache[10] || (_cache[10] = ($event) => _ctx.states.inputHovering = true)
    }, {
      onMouseleave: _cache[11] || (_cache[11] = ($event) => _ctx.states.inputHovering = false)
    }),
    [
      createVNode(_component_el_tooltip, {
        ref: "tooltipRef",
        visible: _ctx.dropdownMenuVisible,
        placement: _ctx.placement,
        teleported: _ctx.teleported,
        "popper-class": [_ctx.nsSelect.e("popper"), _ctx.popperClass],
        "popper-style": _ctx.popperStyle,
        "popper-options": _ctx.popperOptions,
        "fallback-placements": _ctx.fallbackPlacements,
        effect: _ctx.effect,
        pure: "",
        trigger: "click",
        transition: `${_ctx.nsSelect.namespace.value}-zoom-in-top`,
        "stop-popper-mouse-event": false,
        "gpu-acceleration": false,
        persistent: _ctx.persistent,
        "append-to": _ctx.appendTo,
        "show-arrow": _ctx.showArrow,
        offset: _ctx.offset,
        onBeforeShow: _ctx.handleMenuEnter,
        onHide: _cache[9] || (_cache[9] = ($event) => _ctx.states.isBeforeHide = false)
      }, {
        default: withCtx(() => {
          var _a;
          return [
            createElementVNode(
              "div",
              {
                ref: "wrapperRef",
                class: normalizeClass([
                  _ctx.nsSelect.e("wrapper"),
                  _ctx.nsSelect.is("focused", _ctx.isFocused),
                  _ctx.nsSelect.is("hovering", _ctx.states.inputHovering),
                  _ctx.nsSelect.is("filterable", _ctx.filterable),
                  _ctx.nsSelect.is("disabled", _ctx.selectDisabled)
                ]),
                onClick: _cache[6] || (_cache[6] = withModifiers((...args) => _ctx.toggleMenu && _ctx.toggleMenu(...args), ["prevent"]))
              },
              [
                _ctx.$slots.prefix ? (openBlock(), createElementBlock(
                  "div",
                  {
                    key: 0,
                    ref: "prefixRef",
                    class: normalizeClass(_ctx.nsSelect.e("prefix"))
                  },
                  [
                    renderSlot(_ctx.$slots, "prefix")
                  ],
                  2
                  /* CLASS */
                )) : createCommentVNode("v-if", true),
                createElementVNode(
                  "div",
                  {
                    ref: "selectionRef",
                    class: normalizeClass([
                      _ctx.nsSelect.e("selection"),
                      _ctx.nsSelect.is(
                        "near",
                        _ctx.multiple && !_ctx.$slots.prefix && !!_ctx.states.selected.length
                      )
                    ])
                  },
                  [
                    _ctx.multiple ? renderSlot(_ctx.$slots, "tag", {
                      key: 0,
                      data: _ctx.states.selected,
                      deleteTag: _ctx.deleteTag,
                      selectDisabled: _ctx.selectDisabled
                    }, () => [
                      (openBlock(true), createElementBlock(
                        Fragment,
                        null,
                        renderList(_ctx.showTagList, (item) => {
                          return openBlock(), createElementBlock(
                            "div",
                            {
                              key: _ctx.getValueKey(item),
                              class: normalizeClass(_ctx.nsSelect.e("selected-item"))
                            },
                            [
                              createVNode(_component_el_tag, {
                                closable: !_ctx.selectDisabled && !item.isDisabled,
                                size: _ctx.collapseTagSize,
                                type: _ctx.tagType,
                                effect: _ctx.tagEffect,
                                "disable-transitions": "",
                                style: normalizeStyle(_ctx.tagStyle),
                                onClose: ($event) => _ctx.deleteTag($event, item)
                              }, {
                                default: withCtx(() => [
                                  createElementVNode(
                                    "span",
                                    {
                                      class: normalizeClass(_ctx.nsSelect.e("tags-text"))
                                    },
                                    [
                                      renderSlot(_ctx.$slots, "label", {
                                        index: item.index,
                                        label: item.currentLabel,
                                        value: item.value
                                      }, () => [
                                        createTextVNode(
                                          toDisplayString(item.currentLabel),
                                          1
                                          /* TEXT */
                                        )
                                      ])
                                    ],
                                    2
                                    /* CLASS */
                                  )
                                ]),
                                _: 2
                                /* DYNAMIC */
                              }, 1032, ["closable", "size", "type", "effect", "style", "onClose"])
                            ],
                            2
                            /* CLASS */
                          );
                        }),
                        128
                        /* KEYED_FRAGMENT */
                      )),
                      _ctx.collapseTags && _ctx.states.selected.length > _ctx.maxCollapseTags ? (openBlock(), createBlock(_component_el_tooltip, {
                        key: 0,
                        ref: "tagTooltipRef",
                        disabled: _ctx.dropdownMenuVisible || !_ctx.collapseTagsTooltip,
                        "fallback-placements": ["bottom", "top", "right", "left"],
                        effect: _ctx.effect,
                        placement: "bottom",
                        "popper-class": _ctx.popperClass,
                        "popper-style": _ctx.popperStyle,
                        teleported: _ctx.teleported,
                        "popper-options": _ctx.popperOptions
                      }, {
                        default: withCtx(() => [
                          createElementVNode(
                            "div",
                            {
                              ref: "collapseItemRef",
                              class: normalizeClass(_ctx.nsSelect.e("selected-item"))
                            },
                            [
                              createVNode(_component_el_tag, {
                                closable: false,
                                size: _ctx.collapseTagSize,
                                type: _ctx.tagType,
                                effect: _ctx.tagEffect,
                                "disable-transitions": "",
                                style: normalizeStyle(_ctx.collapseTagStyle)
                              }, {
                                default: withCtx(() => [
                                  createElementVNode(
                                    "span",
                                    {
                                      class: normalizeClass(_ctx.nsSelect.e("tags-text"))
                                    },
                                    " + " + toDisplayString(_ctx.states.selected.length - _ctx.maxCollapseTags),
                                    3
                                    /* TEXT, CLASS */
                                  )
                                ]),
                                _: 1
                                /* STABLE */
                              }, 8, ["size", "type", "effect", "style"])
                            ],
                            2
                            /* CLASS */
                          )
                        ]),
                        content: withCtx(() => [
                          createElementVNode(
                            "div",
                            {
                              ref: "tagMenuRef",
                              class: normalizeClass(_ctx.nsSelect.e("selection"))
                            },
                            [
                              (openBlock(true), createElementBlock(
                                Fragment,
                                null,
                                renderList(_ctx.collapseTagList, (item) => {
                                  return openBlock(), createElementBlock(
                                    "div",
                                    {
                                      key: _ctx.getValueKey(item),
                                      class: normalizeClass(_ctx.nsSelect.e("selected-item"))
                                    },
                                    [
                                      createVNode(_component_el_tag, {
                                        class: "in-tooltip",
                                        closable: !_ctx.selectDisabled && !item.isDisabled,
                                        size: _ctx.collapseTagSize,
                                        type: _ctx.tagType,
                                        effect: _ctx.tagEffect,
                                        "disable-transitions": "",
                                        onClose: ($event) => _ctx.deleteTag($event, item)
                                      }, {
                                        default: withCtx(() => [
                                          createElementVNode(
                                            "span",
                                            {
                                              class: normalizeClass(_ctx.nsSelect.e("tags-text"))
                                            },
                                            [
                                              renderSlot(_ctx.$slots, "label", {
                                                index: item.index,
                                                label: item.currentLabel,
                                                value: item.value
                                              }, () => [
                                                createTextVNode(
                                                  toDisplayString(item.currentLabel),
                                                  1
                                                  /* TEXT */
                                                )
                                              ])
                                            ],
                                            2
                                            /* CLASS */
                                          )
                                        ]),
                                        _: 2
                                        /* DYNAMIC */
                                      }, 1032, ["closable", "size", "type", "effect", "onClose"])
                                    ],
                                    2
                                    /* CLASS */
                                  );
                                }),
                                128
                                /* KEYED_FRAGMENT */
                              ))
                            ],
                            2
                            /* CLASS */
                          )
                        ]),
                        _: 3
                        /* FORWARDED */
                      }, 8, ["disabled", "effect", "popper-class", "popper-style", "teleported", "popper-options"])) : createCommentVNode("v-if", true)
                    ]) : createCommentVNode("v-if", true),
                    createElementVNode(
                      "div",
                      {
                        class: normalizeClass([
                          _ctx.nsSelect.e("selected-item"),
                          _ctx.nsSelect.e("input-wrapper"),
                          _ctx.nsSelect.is("hidden", !_ctx.filterable || _ctx.selectDisabled)
                        ])
                      },
                      [
                        createElementVNode("input", {
                          id: _ctx.inputId,
                          ref: "inputRef",
                          value: _ctx.states.inputValue,
                          type: "text",
                          name: _ctx.name,
                          class: normalizeClass([_ctx.nsSelect.e("input"), _ctx.nsSelect.is(_ctx.selectSize)]),
                          disabled: _ctx.selectDisabled,
                          autocomplete: _ctx.autocomplete,
                          style: normalizeStyle(_ctx.inputStyle),
                          tabindex: _ctx.tabindex,
                          role: "combobox",
                          readonly: !_ctx.filterable,
                          spellcheck: "false",
                          "aria-activedescendant": ((_a = _ctx.hoverOption) == null ? void 0 : _a.id) || "",
                          "aria-controls": _ctx.contentId,
                          "aria-expanded": _ctx.dropdownMenuVisible,
                          "aria-label": _ctx.ariaLabel,
                          "aria-autocomplete": "none",
                          "aria-haspopup": "listbox",
                          onKeydown: _cache[0] || (_cache[0] = (...args) => _ctx.handleKeydown && _ctx.handleKeydown(...args)),
                          onCompositionstart: _cache[1] || (_cache[1] = (...args) => _ctx.handleCompositionStart && _ctx.handleCompositionStart(...args)),
                          onCompositionupdate: _cache[2] || (_cache[2] = (...args) => _ctx.handleCompositionUpdate && _ctx.handleCompositionUpdate(...args)),
                          onCompositionend: _cache[3] || (_cache[3] = (...args) => _ctx.handleCompositionEnd && _ctx.handleCompositionEnd(...args)),
                          onInput: _cache[4] || (_cache[4] = (...args) => _ctx.onInput && _ctx.onInput(...args)),
                          onClick: _cache[5] || (_cache[5] = withModifiers((...args) => _ctx.toggleMenu && _ctx.toggleMenu(...args), ["stop"]))
                        }, null, 46, _hoisted_1),
                        _ctx.filterable ? (openBlock(), createElementBlock("span", {
                          key: 0,
                          ref: "calculatorRef",
                          "aria-hidden": "true",
                          class: normalizeClass(_ctx.nsSelect.e("input-calculator")),
                          textContent: toDisplayString(_ctx.states.inputValue)
                        }, null, 10, _hoisted_2)) : createCommentVNode("v-if", true)
                      ],
                      2
                      /* CLASS */
                    ),
                    _ctx.shouldShowPlaceholder ? (openBlock(), createElementBlock(
                      "div",
                      {
                        key: 1,
                        class: normalizeClass([
                          _ctx.nsSelect.e("selected-item"),
                          _ctx.nsSelect.e("placeholder"),
                          _ctx.nsSelect.is(
                            "transparent",
                            !_ctx.hasModelValue || _ctx.expanded && !_ctx.states.inputValue
                          )
                        ])
                      },
                      [
                        _ctx.hasModelValue ? renderSlot(_ctx.$slots, "label", {
                          key: 0,
                          index: _ctx.getOption(_ctx.modelValue).index,
                          label: _ctx.currentPlaceholder,
                          value: _ctx.modelValue
                        }, () => [
                          createElementVNode(
                            "span",
                            null,
                            toDisplayString(_ctx.currentPlaceholder),
                            1
                            /* TEXT */
                          )
                        ]) : (openBlock(), createElementBlock(
                          "span",
                          _hoisted_3,
                          toDisplayString(_ctx.currentPlaceholder),
                          1
                          /* TEXT */
                        ))
                      ],
                      2
                      /* CLASS */
                    )) : createCommentVNode("v-if", true)
                  ],
                  2
                  /* CLASS */
                ),
                createElementVNode(
                  "div",
                  {
                    ref: "suffixRef",
                    class: normalizeClass(_ctx.nsSelect.e("suffix"))
                  },
                  [
                    _ctx.iconComponent && !_ctx.showClearBtn ? (openBlock(), createBlock(_component_el_icon, {
                      key: 0,
                      class: normalizeClass([_ctx.nsSelect.e("caret"), _ctx.nsSelect.e("icon"), _ctx.iconReverse])
                    }, {
                      default: withCtx(() => [
                        (openBlock(), createBlock(resolveDynamicComponent(_ctx.iconComponent)))
                      ]),
                      _: 1
                      /* STABLE */
                    }, 8, ["class"])) : createCommentVNode("v-if", true),
                    _ctx.showClearBtn && _ctx.clearIcon ? (openBlock(), createBlock(_component_el_icon, {
                      key: 1,
                      class: normalizeClass([
                        _ctx.nsSelect.e("caret"),
                        _ctx.nsSelect.e("icon"),
                        _ctx.nsSelect.e("clear")
                      ]),
                      onClick: _ctx.handleClearClick
                    }, {
                      default: withCtx(() => [
                        (openBlock(), createBlock(resolveDynamicComponent(_ctx.clearIcon)))
                      ]),
                      _: 1
                      /* STABLE */
                    }, 8, ["class", "onClick"])) : createCommentVNode("v-if", true),
                    _ctx.validateState && _ctx.validateIcon && _ctx.needStatusIcon ? (openBlock(), createBlock(_component_el_icon, {
                      key: 2,
                      class: normalizeClass([
                        _ctx.nsInput.e("icon"),
                        _ctx.nsInput.e("validateIcon"),
                        _ctx.nsInput.is("loading", _ctx.validateState === "validating")
                      ])
                    }, {
                      default: withCtx(() => [
                        (openBlock(), createBlock(resolveDynamicComponent(_ctx.validateIcon)))
                      ]),
                      _: 1
                      /* STABLE */
                    }, 8, ["class"])) : createCommentVNode("v-if", true)
                  ],
                  2
                  /* CLASS */
                )
              ],
              2
              /* CLASS */
            )
          ];
        }),
        content: withCtx(() => [
          createVNode(
            _component_el_select_menu,
            { ref: "menuRef" },
            {
              default: withCtx(() => [
                _ctx.$slots.header ? (openBlock(), createElementBlock(
                  "div",
                  {
                    key: 0,
                    class: normalizeClass(_ctx.nsSelect.be("dropdown", "header")),
                    onClick: _cache[7] || (_cache[7] = withModifiers(() => {
                    }, ["stop"]))
                  },
                  [
                    renderSlot(_ctx.$slots, "header")
                  ],
                  2
                  /* CLASS */
                )) : createCommentVNode("v-if", true),
                withDirectives(createVNode(_component_el_scrollbar, {
                  id: _ctx.contentId,
                  ref: "scrollbarRef",
                  tag: "ul",
                  "wrap-class": _ctx.nsSelect.be("dropdown", "wrap"),
                  "view-class": _ctx.nsSelect.be("dropdown", "list"),
                  class: normalizeClass([_ctx.nsSelect.is("empty", _ctx.filteredOptionsCount === 0)]),
                  role: "listbox",
                  "aria-label": _ctx.ariaLabel,
                  "aria-orientation": "vertical",
                  onScroll: _ctx.popupScroll
                }, {
                  default: withCtx(() => [
                    _ctx.showNewOption ? (openBlock(), createBlock(_component_el_option, {
                      key: 0,
                      value: _ctx.states.inputValue,
                      created: true
                    }, null, 8, ["value"])) : createCommentVNode("v-if", true),
                    createVNode(_component_el_options, null, {
                      default: withCtx(() => [
                        renderSlot(_ctx.$slots, "default", {}, () => [
                          (openBlock(true), createElementBlock(
                            Fragment,
                            null,
                            renderList(_ctx.options, (option, index) => {
                              var _a;
                              return openBlock(), createElementBlock(
                                Fragment,
                                { key: index },
                                [
                                  ((_a = _ctx.getOptions(option)) == null ? void 0 : _a.length) ? (openBlock(), createBlock(_component_el_option_group, {
                                    key: 0,
                                    label: _ctx.getLabel(option),
                                    disabled: _ctx.getDisabled(option)
                                  }, {
                                    default: withCtx(() => [
                                      (openBlock(true), createElementBlock(
                                        Fragment,
                                        null,
                                        renderList(_ctx.getOptions(option), (item) => {
                                          return openBlock(), createBlock(
                                            _component_el_option,
                                            mergeProps({
                                              key: _ctx.getValue(item)
                                            }, { ref_for: true }, _ctx.getOptionProps(item)),
                                            null,
                                            16
                                            /* FULL_PROPS */
                                          );
                                        }),
                                        128
                                        /* KEYED_FRAGMENT */
                                      ))
                                    ]),
                                    _: 2
                                    /* DYNAMIC */
                                  }, 1032, ["label", "disabled"])) : (openBlock(), createBlock(
                                    _component_el_option,
                                    mergeProps({
                                      key: 1,
                                      ref_for: true
                                    }, _ctx.getOptionProps(option)),
                                    null,
                                    16
                                    /* FULL_PROPS */
                                  ))
                                ],
                                64
                                /* STABLE_FRAGMENT */
                              );
                            }),
                            128
                            /* KEYED_FRAGMENT */
                          ))
                        ])
                      ]),
                      _: 3
                      /* FORWARDED */
                    })
                  ]),
                  _: 3
                  /* FORWARDED */
                }, 8, ["id", "wrap-class", "view-class", "class", "aria-label", "onScroll"]), [
                  [vShow, _ctx.states.options.size > 0 && !_ctx.loading]
                ]),
                _ctx.$slots.loading && _ctx.loading ? (openBlock(), createElementBlock(
                  "div",
                  {
                    key: 1,
                    class: normalizeClass(_ctx.nsSelect.be("dropdown", "loading"))
                  },
                  [
                    renderSlot(_ctx.$slots, "loading")
                  ],
                  2
                  /* CLASS */
                )) : _ctx.loading || _ctx.filteredOptionsCount === 0 ? (openBlock(), createElementBlock(
                  "div",
                  {
                    key: 2,
                    class: normalizeClass(_ctx.nsSelect.be("dropdown", "empty"))
                  },
                  [
                    renderSlot(_ctx.$slots, "empty", {}, () => [
                      createElementVNode(
                        "span",
                        null,
                        toDisplayString(_ctx.emptyText),
                        1
                        /* TEXT */
                      )
                    ])
                  ],
                  2
                  /* CLASS */
                )) : createCommentVNode("v-if", true),
                _ctx.$slots.footer ? (openBlock(), createElementBlock(
                  "div",
                  {
                    key: 3,
                    class: normalizeClass(_ctx.nsSelect.be("dropdown", "footer")),
                    onClick: _cache[8] || (_cache[8] = withModifiers(() => {
                    }, ["stop"]))
                  },
                  [
                    renderSlot(_ctx.$slots, "footer")
                  ],
                  2
                  /* CLASS */
                )) : createCommentVNode("v-if", true)
              ]),
              _: 3
              /* FORWARDED */
            },
            512
            /* NEED_PATCH */
          )
        ]),
        _: 3
        /* FORWARDED */
      }, 8, ["visible", "placement", "teleported", "popper-class", "popper-style", "popper-options", "fallback-placements", "effect", "transition", "persistent", "append-to", "show-arrow", "offset", "onBeforeShow"])
    ],
    16
    /* FULL_PROPS */
  )), [
    [_directive_click_outside, _ctx.handleClickOutside, _ctx.popperRef]
  ]);
}
var Select = /* @__PURE__ */ _export_sfc(_sfc_main, [["render", _sfc_render]]);
const ElSelect = withInstall(Select, {
  Option,
  OptionGroup
});
const ElOption = withNoopInstall(Option);
withNoopInstall(OptionGroup);

export { ElSelect as E, ElOption as a };
