import { defineComponent, useAttrs, useSlots, computed, shallowRef, ref, watch, nextTick, toRef, openBlock, createElementBlock, normalizeStyle, normalizeClass, unref, createCommentVNode, Fragment, renderSlot, createElementVNode, createBlock, withCtx, resolveDynamicComponent, mergeProps, withModifiers, toDisplayString, markRaw } from 'vue';
import { P as withInstall, C as useNamespace, a8 as ValidateComponentsMap, a9 as view_default, aa as hide_default, O as debugWarn, a0 as buildProps, a1 as iconPropType, a6 as circle_close_default, K as useSizeProp, a2 as definePropType, a7 as mutable } from './server.mjs';
import { U as UPDATE_MODEL_EVENT, C as CHANGE_EVENT, I as INPUT_EVENT } from './event-BZTOGHfp.mjs';
import { u as useAriaProps } from './index-DRiwogtD.mjs';
import { NOOP, isString } from '@vue/shared';
import { u as useResizeObserver } from './index-ChPMoinw.mjs';
import { isNil } from 'lodash-unified';
import { E as ElIcon } from './index-CRbm0e05.mjs';
import { u as useAttrs$1 } from './index-BKB3Djp4.mjs';
import { a as useFormItem, c as useFormItemInputId, b as useFormSize, u as useFormDisabled } from './use-form-item-Cr81A1TZ.mjs';
import { u as useFocusController, a as useComposition } from './index-Bp-nwGzu.mjs';

const inputProps = buildProps({
  /**
   * @description native input id
   */
  id: {
    type: String,
    default: void 0
  },
  /**
   * @description input box size
   */
  size: useSizeProp,
  /**
   * @description whether to disable
   */
  disabled: {
    type: Boolean,
    default: void 0
  },
  /**
   * @description binding value
   */
  modelValue: {
    type: definePropType([
      String,
      Number,
      Object
    ]),
    default: ""
  },
  /**
   * @description v-model modifiers, reference [Vue modifiers](https://vuejs.org/guide/essentials/forms.html#modifiers)
   */
  modelModifiers: {
    type: definePropType(Object),
    default: () => ({})
  },
  /**
   * @description same as `maxlength` in native input
   */
  maxlength: {
    type: [String, Number]
  },
  /**
   * @description same as `minlength` in native input
   */
  minlength: {
    type: [String, Number]
  },
  /**
   * @description type of input, see more in [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Form_%3Cinput%3E_types)
   */
  type: {
    type: definePropType(String),
    default: "text"
  },
  /**
   * @description control the resizability
   */
  resize: {
    type: String,
    values: ["none", "both", "horizontal", "vertical"]
  },
  /**
   * @description whether textarea has an adaptive height
   */
  autosize: {
    type: definePropType([Boolean, Object]),
    default: false
  },
  /**
   * @description native input autocomplete
   */
  autocomplete: {
    type: definePropType(String),
    default: "off"
  },
  /**
   * @description format content
   */
  formatter: {
    type: Function
  },
  /**
   * @description parse content
   */
  parser: {
    type: Function
  },
  /**
   * @description placeholder
   */
  placeholder: {
    type: String
  },
  /**
   * @description native input form
   */
  form: {
    type: String
  },
  /**
   * @description native input readonly
   */
  readonly: Boolean,
  /**
   * @description whether to show clear button
   */
  clearable: Boolean,
  /**
   * @description custom clear icon component
   */
  clearIcon: {
    type: iconPropType,
    default: circle_close_default
  },
  /**
   * @description toggleable password input
   */
  showPassword: Boolean,
  /**
   * @description word count
   */
  showWordLimit: Boolean,
  /**
   * @description word count position, valid when `show-word-limit` is true
   */
  wordLimitPosition: {
    type: String,
    values: ["inside", "outside"],
    default: "inside"
  },
  /**
   * @description suffix icon
   */
  suffixIcon: {
    type: iconPropType
  },
  /**
   * @description prefix icon
   */
  prefixIcon: {
    type: iconPropType
  },
  /**
   * @description container role, internal properties provided for use by the picker component
   */
  containerRole: {
    type: String,
    default: void 0
  },
  /**
   * @description input tabindex
   */
  tabindex: {
    type: [String, Number],
    default: 0
  },
  /**
   * @description whether to trigger form validation
   */
  validateEvent: {
    type: Boolean,
    default: true
  },
  /**
   * @description input or textarea element style
   */
  inputStyle: {
    type: definePropType([Object, Array, String]),
    default: () => mutable({})
  },
  /**
   * @description native input autofocus
   */
  autofocus: Boolean,
  rows: {
    type: Number,
    default: 2
  },
  ...useAriaProps(["ariaLabel"]),
  /**
   * @description native input mode for virtual keyboards
   */
  inputmode: {
    type: definePropType(String),
    default: void 0
  },
  /**
   * @description same as `name` in native input
   */
  name: String
});
const inputEmits = {
  [UPDATE_MODEL_EVENT]: (value) => isString(value),
  input: (value) => isString(value),
  change: (value, evt) => isString(value) && (evt instanceof Event || evt === void 0),
  focus: (evt) => evt instanceof FocusEvent,
  blur: (evt) => evt instanceof FocusEvent,
  clear: () => true,
  mouseleave: (evt) => evt instanceof MouseEvent,
  mouseenter: (evt) => evt instanceof MouseEvent,
  // NOTE: when autofill by browser, the keydown event is instanceof Event, not KeyboardEvent
  // relative bug report https://github.com/element-plus/element-plus/issues/6665
  keydown: (evt) => evt instanceof Event,
  compositionstart: (evt) => evt instanceof CompositionEvent,
  compositionupdate: (evt) => evt instanceof CompositionEvent,
  compositionend: (evt) => evt instanceof CompositionEvent
};
({
  clearIcon: markRaw(circle_close_default)
});
const looseToNumber = (val) => {
  const n = Number.parseFloat(val);
  return Number.isNaN(n) ? val : n;
};
function useCursor(input) {
  let selectionInfo;
  function recordCursor() {
    if (input.value == void 0) return;
    const { selectionStart, selectionEnd, value } = input.value;
    if (selectionStart == null || selectionEnd == null) return;
    const beforeTxt = value.slice(0, Math.max(0, selectionStart));
    const afterTxt = value.slice(Math.max(0, selectionEnd));
    selectionInfo = {
      selectionStart,
      selectionEnd,
      value,
      beforeTxt,
      afterTxt
    };
  }
  function setCursor() {
    if (input.value == void 0 || selectionInfo == void 0) return;
    const { value } = input.value;
    const { beforeTxt, afterTxt, selectionStart } = selectionInfo;
    if (beforeTxt == void 0 || afterTxt == void 0 || selectionStart == void 0)
      return;
    let startPos = value.length;
    if (value.endsWith(afterTxt)) {
      startPos = value.length - afterTxt.length;
    } else if (value.startsWith(beforeTxt)) {
      startPos = beforeTxt.length;
    } else {
      const beforeLastChar = beforeTxt[selectionStart - 1];
      const newIndex = value.indexOf(beforeLastChar, selectionStart - 1);
      if (newIndex !== -1) {
        startPos = newIndex + 1;
      }
    }
    input.value.setSelectionRange(startPos, startPos);
  }
  return [recordCursor, setCursor];
}
const _hoisted_1 = ["id", "name", "minlength", "maxlength", "type", "disabled", "readonly", "autocomplete", "tabindex", "aria-label", "placeholder", "form", "autofocus", "role", "inputmode"];
const _hoisted_2 = ["id", "name", "minlength", "maxlength", "tabindex", "disabled", "readonly", "autocomplete", "aria-label", "placeholder", "form", "autofocus", "rows", "role"];
const COMPONENT_NAME = "ElInput";
var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: COMPONENT_NAME,
    inheritAttrs: false
  },
  __name: "input",
  props: inputProps,
  emits: inputEmits,
  setup(__props, { expose: __expose, emit: __emit }) {
    const props = __props;
    const emit = __emit;
    const rawAttrs = useAttrs();
    const attrs = useAttrs$1();
    const slots = useSlots();
    const containerKls = computed(() => [
      props.type === "textarea" ? nsTextarea.b() : nsInput.b(),
      nsInput.m(inputSize.value),
      nsInput.is("disabled", inputDisabled.value),
      nsInput.is("exceed", inputExceed.value),
      {
        [nsInput.b("group")]: slots.prepend || slots.append,
        [nsInput.m("prefix")]: slots.prefix || props.prefixIcon,
        [nsInput.m("suffix")]: slots.suffix || props.suffixIcon || props.clearable || props.showPassword,
        [nsInput.bm("suffix", "password-clear")]: showClear.value && showPwdVisible.value,
        [nsInput.b("hidden")]: props.type === "hidden"
      },
      rawAttrs.class
    ]);
    const wrapperKls = computed(() => [
      nsInput.e("wrapper"),
      nsInput.is("focus", isFocused.value)
    ]);
    const { form: elForm, formItem: elFormItem } = useFormItem();
    const { inputId } = useFormItemInputId(props, {
      formItemContext: elFormItem
    });
    const inputSize = useFormSize();
    const inputDisabled = useFormDisabled();
    const nsInput = useNamespace("input");
    const nsTextarea = useNamespace("textarea");
    const input = shallowRef();
    const textarea = shallowRef();
    const hovering = ref(false);
    const passwordVisible = ref(false);
    const countStyle = ref();
    const textareaCalcStyle = shallowRef(props.inputStyle);
    const _ref = computed(() => input.value || textarea.value);
    const { wrapperRef, isFocused, handleFocus, handleBlur } = useFocusController(
      _ref,
      {
        disabled: inputDisabled,
        afterBlur() {
          var _a;
          if (props.validateEvent) {
            (_a = elFormItem == null ? void 0 : elFormItem.validate) == null ? void 0 : _a.call(elFormItem, "blur").catch((err) => debugWarn());
          }
        }
      }
    );
    const needStatusIcon = computed(() => {
      var _a;
      return (_a = elForm == null ? void 0 : elForm.statusIcon) != null ? _a : false;
    });
    const validateState = computed(() => (elFormItem == null ? void 0 : elFormItem.validateState) || "");
    const validateIcon = computed(
      () => validateState.value && ValidateComponentsMap[validateState.value]
    );
    const passwordIcon = computed(
      () => passwordVisible.value ? view_default : hide_default
    );
    const containerStyle = computed(() => [
      rawAttrs.style
    ]);
    const textareaStyle = computed(() => [
      props.inputStyle,
      textareaCalcStyle.value,
      { resize: props.resize }
    ]);
    const nativeInputValue = computed(
      () => isNil(props.modelValue) ? "" : String(props.modelValue)
    );
    const showClear = computed(
      () => props.clearable && !inputDisabled.value && !props.readonly && !!nativeInputValue.value && (isFocused.value || hovering.value)
    );
    const showPwdVisible = computed(
      () => props.showPassword && !inputDisabled.value && !!nativeInputValue.value
    );
    const isWordLimitVisible = computed(
      () => props.showWordLimit && !!props.maxlength && (props.type === "text" || props.type === "textarea") && !inputDisabled.value && !props.readonly && !props.showPassword
    );
    const textLength = computed(() => nativeInputValue.value.length);
    const inputExceed = computed(
      () => (
        // show exceed style if length of initial value greater then maxlength
        !!isWordLimitVisible.value && textLength.value > Number(props.maxlength)
      )
    );
    const suffixVisible = computed(
      () => !!slots.suffix || !!props.suffixIcon || showClear.value || props.showPassword || isWordLimitVisible.value || !!validateState.value && needStatusIcon.value
    );
    const hasModelModifiers = computed(
      () => !!Object.keys(props.modelModifiers).length
    );
    const [recordCursor, setCursor] = useCursor(input);
    useResizeObserver(textarea, (entries) => {
      onceInitSizeTextarea();
      if (!isWordLimitVisible.value || props.resize !== "both" && props.resize !== "horizontal")
        return;
      const entry = entries[0];
      const { width } = entry.contentRect;
      countStyle.value = {
        /** right: 100% - width + padding(22) - right(10) */
        right: `calc(100% - ${width + 22 - 10}px)`
      };
    });
    const resizeTextarea = () => {
      const { type, autosize } = props;
      return;
    };
    const createOnceInitResize = (resizeTextarea2) => {
      let isInit = false;
      return () => {
        var _a;
        if (isInit || !props.autosize) return;
        const isElHidden = ((_a = textarea.value) == null ? void 0 : _a.offsetParent) === null;
        if (!isElHidden) {
          setTimeout(resizeTextarea2);
          isInit = true;
        }
      };
    };
    const onceInitSizeTextarea = createOnceInitResize(resizeTextarea);
    const setNativeInputValue = () => {
      const input2 = _ref.value;
      const formatterValue = props.formatter ? props.formatter(nativeInputValue.value) : nativeInputValue.value;
      if (!input2 || input2.value === formatterValue || props.type === "file") return;
      input2.value = formatterValue;
    };
    const formatValue = (value) => {
      const { trim, number } = props.modelModifiers;
      if (trim) {
        value = value.trim();
      }
      if (number) {
        value = `${looseToNumber(value)}`;
      }
      if (props.formatter && props.parser) {
        value = props.parser(value);
      }
      return value;
    };
    const handleInput = async (event) => {
      if (isComposing.value) return;
      const { lazy } = props.modelModifiers;
      let { value } = event.target;
      if (lazy) {
        emit(INPUT_EVENT, value);
        return;
      }
      value = formatValue(value);
      if (String(value) === nativeInputValue.value) {
        if (props.formatter) {
          setNativeInputValue();
        }
        return;
      }
      recordCursor();
      emit(UPDATE_MODEL_EVENT, value);
      emit(INPUT_EVENT, value);
      await nextTick();
      if (props.formatter && props.parser || !hasModelModifiers.value) {
        setNativeInputValue();
      }
      setCursor();
    };
    const handleChange = async (event) => {
      let { value } = event.target;
      value = formatValue(value);
      if (props.modelModifiers.lazy) {
        emit(UPDATE_MODEL_EVENT, value);
      }
      emit(CHANGE_EVENT, value, event);
      await nextTick();
      setNativeInputValue();
    };
    const {
      isComposing,
      handleCompositionStart,
      handleCompositionUpdate,
      handleCompositionEnd
    } = useComposition({ emit, afterComposition: handleInput });
    const handlePasswordVisible = () => {
      passwordVisible.value = !passwordVisible.value;
    };
    const focus = () => {
      var _a;
      return (_a = _ref.value) == null ? void 0 : _a.focus();
    };
    const blur = () => {
      var _a;
      return (_a = _ref.value) == null ? void 0 : _a.blur();
    };
    const handleMouseLeave = (evt) => {
      hovering.value = false;
      emit("mouseleave", evt);
    };
    const handleMouseEnter = (evt) => {
      hovering.value = true;
      emit("mouseenter", evt);
    };
    const handleKeydown = (evt) => {
      emit("keydown", evt);
    };
    const select = () => {
      var _a;
      (_a = _ref.value) == null ? void 0 : _a.select();
    };
    const clear = () => {
      emit(UPDATE_MODEL_EVENT, "");
      emit(CHANGE_EVENT, "");
      emit("clear");
      emit(INPUT_EVENT, "");
    };
    watch(
      () => props.modelValue,
      () => {
        var _a;
        nextTick(() => resizeTextarea());
        if (props.validateEvent) {
          (_a = elFormItem == null ? void 0 : elFormItem.validate) == null ? void 0 : _a.call(elFormItem, "change").catch((err) => debugWarn());
        }
      }
    );
    watch(nativeInputValue, (newValue) => {
      if (!_ref.value) {
        return;
      }
      const { trim, number } = props.modelModifiers;
      const elValue = _ref.value.value;
      const displayValue = (number || props.type === "number") && !/^0\d/.test(elValue) ? `${looseToNumber(elValue)}` : elValue;
      if (displayValue === newValue) {
        return;
      }
      if ((void 0).activeElement === _ref.value && _ref.value.type !== "range") {
        if (trim && displayValue.trim() === newValue) {
          return;
        }
      }
      setNativeInputValue();
    });
    watch(
      () => props.type,
      async () => {
        await nextTick();
        setNativeInputValue();
        resizeTextarea();
      }
    );
    __expose({
      /** @description HTML input element */
      input,
      /** @description HTML textarea element */
      textarea,
      /** @description HTML element, input or textarea */
      ref: _ref,
      /** @description style of textarea. */
      textareaStyle,
      /** @description from props (used on unit test) */
      autosize: toRef(props, "autosize"),
      /** @description is input composing */
      isComposing,
      /** @description HTML input element native method */
      focus,
      /** @description HTML input element native method */
      blur,
      /** @description HTML input element native method */
      select,
      /** @description clear input value */
      clear,
      /** @description resize textarea. */
      resizeTextarea
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          class: normalizeClass([
            containerKls.value,
            {
              [unref(nsInput).bm("group", "append")]: _ctx.$slots.append,
              [unref(nsInput).bm("group", "prepend")]: _ctx.$slots.prepend
            }
          ]),
          style: normalizeStyle(containerStyle.value),
          onMouseenter: handleMouseEnter,
          onMouseleave: handleMouseLeave
        },
        [
          createCommentVNode(" input "),
          __props.type !== "textarea" ? (openBlock(), createElementBlock(
            Fragment,
            { key: 0 },
            [
              createCommentVNode(" prepend slot "),
              _ctx.$slots.prepend ? (openBlock(), createElementBlock(
                "div",
                {
                  key: 0,
                  class: normalizeClass(unref(nsInput).be("group", "prepend"))
                },
                [
                  renderSlot(_ctx.$slots, "prepend")
                ],
                2
                /* CLASS */
              )) : createCommentVNode("v-if", true),
              createElementVNode(
                "div",
                {
                  ref_key: "wrapperRef",
                  ref: wrapperRef,
                  class: normalizeClass(wrapperKls.value)
                },
                [
                  createCommentVNode(" prefix slot "),
                  _ctx.$slots.prefix || __props.prefixIcon ? (openBlock(), createElementBlock(
                    "span",
                    {
                      key: 0,
                      class: normalizeClass(unref(nsInput).e("prefix"))
                    },
                    [
                      createElementVNode(
                        "span",
                        {
                          class: normalizeClass(unref(nsInput).e("prefix-inner"))
                        },
                        [
                          renderSlot(_ctx.$slots, "prefix"),
                          __props.prefixIcon ? (openBlock(), createBlock(unref(ElIcon), {
                            key: 0,
                            class: normalizeClass(unref(nsInput).e("icon"))
                          }, {
                            default: withCtx(() => [
                              (openBlock(), createBlock(resolveDynamicComponent(__props.prefixIcon)))
                            ]),
                            _: 1
                            /* STABLE */
                          }, 8, ["class"])) : createCommentVNode("v-if", true)
                        ],
                        2
                        /* CLASS */
                      )
                    ],
                    2
                    /* CLASS */
                  )) : createCommentVNode("v-if", true),
                  createElementVNode("input", mergeProps({
                    id: unref(inputId),
                    ref_key: "input",
                    ref: input,
                    class: unref(nsInput).e("inner")
                  }, unref(attrs), {
                    name: __props.name,
                    minlength: __props.minlength,
                    maxlength: __props.maxlength,
                    type: __props.showPassword ? passwordVisible.value ? "text" : "password" : __props.type,
                    disabled: unref(inputDisabled),
                    readonly: __props.readonly,
                    autocomplete: __props.autocomplete,
                    tabindex: __props.tabindex,
                    "aria-label": __props.ariaLabel,
                    placeholder: __props.placeholder,
                    style: __props.inputStyle,
                    form: __props.form,
                    autofocus: __props.autofocus,
                    role: __props.containerRole,
                    inputmode: __props.inputmode,
                    onCompositionstart: _cache[0] || (_cache[0] = //@ts-ignore
                    (...args) => unref(handleCompositionStart) && unref(handleCompositionStart)(...args)),
                    onCompositionupdate: _cache[1] || (_cache[1] = //@ts-ignore
                    (...args) => unref(handleCompositionUpdate) && unref(handleCompositionUpdate)(...args)),
                    onCompositionend: _cache[2] || (_cache[2] = //@ts-ignore
                    (...args) => unref(handleCompositionEnd) && unref(handleCompositionEnd)(...args)),
                    onInput: handleInput,
                    onChange: handleChange,
                    onKeydown: handleKeydown
                  }), null, 16, _hoisted_1),
                  createCommentVNode(" suffix slot "),
                  suffixVisible.value ? (openBlock(), createElementBlock(
                    "span",
                    {
                      key: 1,
                      class: normalizeClass(unref(nsInput).e("suffix"))
                    },
                    [
                      createElementVNode(
                        "span",
                        {
                          class: normalizeClass(unref(nsInput).e("suffix-inner"))
                        },
                        [
                          !showClear.value || !showPwdVisible.value || !isWordLimitVisible.value ? (openBlock(), createElementBlock(
                            Fragment,
                            { key: 0 },
                            [
                              renderSlot(_ctx.$slots, "suffix"),
                              __props.suffixIcon ? (openBlock(), createBlock(unref(ElIcon), {
                                key: 0,
                                class: normalizeClass(unref(nsInput).e("icon"))
                              }, {
                                default: withCtx(() => [
                                  (openBlock(), createBlock(resolveDynamicComponent(__props.suffixIcon)))
                                ]),
                                _: 1
                                /* STABLE */
                              }, 8, ["class"])) : createCommentVNode("v-if", true)
                            ],
                            64
                            /* STABLE_FRAGMENT */
                          )) : createCommentVNode("v-if", true),
                          showClear.value ? (openBlock(), createBlock(unref(ElIcon), {
                            key: 1,
                            class: normalizeClass([unref(nsInput).e("icon"), unref(nsInput).e("clear")]),
                            onMousedown: withModifiers(unref(NOOP), ["prevent"]),
                            onClick: clear
                          }, {
                            default: withCtx(() => [
                              (openBlock(), createBlock(resolveDynamicComponent(__props.clearIcon)))
                            ]),
                            _: 1
                            /* STABLE */
                          }, 8, ["class", "onMousedown"])) : createCommentVNode("v-if", true),
                          showPwdVisible.value ? (openBlock(), createBlock(unref(ElIcon), {
                            key: 2,
                            class: normalizeClass([unref(nsInput).e("icon"), unref(nsInput).e("password")]),
                            onClick: handlePasswordVisible,
                            onMousedown: withModifiers(unref(NOOP), ["prevent"]),
                            onMouseup: withModifiers(unref(NOOP), ["prevent"])
                          }, {
                            default: withCtx(() => [
                              (openBlock(), createBlock(resolveDynamicComponent(passwordIcon.value)))
                            ]),
                            _: 1
                            /* STABLE */
                          }, 8, ["class", "onMousedown", "onMouseup"])) : createCommentVNode("v-if", true),
                          isWordLimitVisible.value ? (openBlock(), createElementBlock(
                            "span",
                            {
                              key: 3,
                              class: normalizeClass([
                                unref(nsInput).e("count"),
                                unref(nsInput).is("outside", __props.wordLimitPosition === "outside")
                              ])
                            },
                            [
                              createElementVNode(
                                "span",
                                {
                                  class: normalizeClass(unref(nsInput).e("count-inner"))
                                },
                                toDisplayString(textLength.value) + " / " + toDisplayString(__props.maxlength),
                                3
                                /* TEXT, CLASS */
                              )
                            ],
                            2
                            /* CLASS */
                          )) : createCommentVNode("v-if", true),
                          validateState.value && validateIcon.value && needStatusIcon.value ? (openBlock(), createBlock(unref(ElIcon), {
                            key: 4,
                            class: normalizeClass([
                              unref(nsInput).e("icon"),
                              unref(nsInput).e("validateIcon"),
                              unref(nsInput).is("loading", validateState.value === "validating")
                            ])
                          }, {
                            default: withCtx(() => [
                              (openBlock(), createBlock(resolveDynamicComponent(validateIcon.value)))
                            ]),
                            _: 1
                            /* STABLE */
                          }, 8, ["class"])) : createCommentVNode("v-if", true)
                        ],
                        2
                        /* CLASS */
                      )
                    ],
                    2
                    /* CLASS */
                  )) : createCommentVNode("v-if", true)
                ],
                2
                /* CLASS */
              ),
              createCommentVNode(" append slot "),
              _ctx.$slots.append ? (openBlock(), createElementBlock(
                "div",
                {
                  key: 1,
                  class: normalizeClass(unref(nsInput).be("group", "append"))
                },
                [
                  renderSlot(_ctx.$slots, "append")
                ],
                2
                /* CLASS */
              )) : createCommentVNode("v-if", true)
            ],
            64
            /* STABLE_FRAGMENT */
          )) : (openBlock(), createElementBlock(
            Fragment,
            { key: 1 },
            [
              createCommentVNode(" textarea "),
              createElementVNode("textarea", mergeProps({
                id: unref(inputId),
                ref_key: "textarea",
                ref: textarea,
                class: [unref(nsTextarea).e("inner"), unref(nsInput).is("focus", unref(isFocused))]
              }, unref(attrs), {
                name: __props.name,
                minlength: __props.minlength,
                maxlength: __props.maxlength,
                tabindex: __props.tabindex,
                disabled: unref(inputDisabled),
                readonly: __props.readonly,
                autocomplete: __props.autocomplete,
                style: textareaStyle.value,
                "aria-label": __props.ariaLabel,
                placeholder: __props.placeholder,
                form: __props.form,
                autofocus: __props.autofocus,
                rows: __props.rows,
                role: __props.containerRole,
                onCompositionstart: _cache[3] || (_cache[3] = //@ts-ignore
                (...args) => unref(handleCompositionStart) && unref(handleCompositionStart)(...args)),
                onCompositionupdate: _cache[4] || (_cache[4] = //@ts-ignore
                (...args) => unref(handleCompositionUpdate) && unref(handleCompositionUpdate)(...args)),
                onCompositionend: _cache[5] || (_cache[5] = //@ts-ignore
                (...args) => unref(handleCompositionEnd) && unref(handleCompositionEnd)(...args)),
                onInput: handleInput,
                onFocus: _cache[6] || (_cache[6] = //@ts-ignore
                (...args) => unref(handleFocus) && unref(handleFocus)(...args)),
                onBlur: _cache[7] || (_cache[7] = //@ts-ignore
                (...args) => unref(handleBlur) && unref(handleBlur)(...args)),
                onChange: handleChange,
                onKeydown: handleKeydown
              }), null, 16, _hoisted_2),
              isWordLimitVisible.value ? (openBlock(), createElementBlock(
                "span",
                {
                  key: 0,
                  style: normalizeStyle(countStyle.value),
                  class: normalizeClass([
                    unref(nsInput).e("count"),
                    unref(nsInput).is("outside", __props.wordLimitPosition === "outside")
                  ])
                },
                toDisplayString(textLength.value) + " / " + toDisplayString(__props.maxlength),
                7
                /* TEXT, CLASS, STYLE */
              )) : createCommentVNode("v-if", true)
            ],
            64
            /* STABLE_FRAGMENT */
          ))
        ],
        38
        /* CLASS, STYLE, NEED_HYDRATION */
      );
    };
  }
});
const ElInput = withInstall(_sfc_main);

export { ElInput as E, inputProps as i };
