import { d as dialogEmits, a as dialogProps, u as useDialog, b as dialogInjectionKey, E as ElOverlay, c as useSameTarget, e as dialogContentEmits, f as dialogContentProps } from './use-dialog-7J0bwlna.mjs';
import { defineComponent, useSlots, computed, ref, provide, openBlock, createBlock, unref, withCtx, createVNode, Transition, mergeProps, withDirectives, createElementVNode, normalizeStyle, normalizeClass, createSlots, renderSlot, createCommentVNode, vShow, inject, createElementBlock, toDisplayString, resolveDynamicComponent } from 'vue';
import { E as ElTeleport, a as ElFocusTrap, F as FOCUS_TRAP_INJECTION_KEY } from './focus-trap.vue-9ChHxs3Q.mjs';
import { E as ElIcon } from './index-CRbm0e05.mjs';
import { a as addUnit } from './style-h263bamF.mjs';
import { P as withInstall, C as useNamespace, D as useLocale, aS as CloseComponents } from './server.mjs';
import { u as useDeprecated } from './index-31HAFSrO.mjs';

const composeRefs = (...refs) => {
  return (el) => {
    refs.forEach((ref2) => {
      ref2.value = el;
    });
  };
};
const useDraggable = (targetRef, dragRef, draggable, overflow) => {
  const transform = {
    offsetX: 0,
    offsetY: 0
  };
  const isDragging = ref(false);
  const adjustPosition = (moveX, moveY) => {
    if (targetRef.value) {
      const { offsetX, offsetY } = transform;
      const targetRect = targetRef.value.getBoundingClientRect();
      const targetLeft = targetRect.left;
      const targetTop = targetRect.top;
      const targetWidth = targetRect.width;
      const targetHeight = targetRect.height;
      const clientWidth = (void 0).documentElement.clientWidth;
      const clientHeight = (void 0).documentElement.clientHeight;
      const minLeft = -targetLeft + offsetX;
      const minTop = -targetTop + offsetY;
      const maxLeft = clientWidth - targetLeft - targetWidth + offsetX;
      const maxTop = clientHeight - targetTop - (targetHeight < clientHeight ? targetHeight : 0) + offsetY;
      if (!(overflow == null ? void 0 : overflow.value)) {
        moveX = Math.min(Math.max(moveX, minLeft), maxLeft);
        moveY = Math.min(Math.max(moveY, minTop), maxTop);
      }
      transform.offsetX = moveX;
      transform.offsetY = moveY;
      targetRef.value.style.transform = `translate(${addUnit(moveX)}, ${addUnit(
        moveY
      )})`;
    }
  };
  const resetPosition = () => {
    transform.offsetX = 0;
    transform.offsetY = 0;
    if (targetRef.value) {
      targetRef.value.style.transform = "";
    }
  };
  const updatePosition = () => {
    const { offsetX, offsetY } = transform;
    adjustPosition(offsetX, offsetY);
  };
  return {
    isDragging,
    resetPosition,
    updatePosition
  };
};
const _hoisted_1$1 = ["aria-level"];
const _hoisted_2 = ["aria-label"];
const _hoisted_3 = ["id"];
var _sfc_main$1 = /* @__PURE__ */ defineComponent({
  ...{ name: "ElDialogContent" },
  __name: "dialog-content",
  props: dialogContentProps,
  emits: dialogContentEmits,
  setup(__props, { expose: __expose }) {
    const { t } = useLocale();
    const { Close } = CloseComponents;
    const props = __props;
    const { dialogRef, headerRef, bodyId, ns, style } = inject(dialogInjectionKey);
    const { focusTrapRef } = inject(FOCUS_TRAP_INJECTION_KEY);
    const composedDialogRef = composeRefs(focusTrapRef, dialogRef);
    const draggable = computed(() => !!props.draggable);
    const overflow = computed(() => !!props.overflow);
    const { resetPosition, updatePosition, isDragging } = useDraggable(
      dialogRef,
      headerRef,
      draggable,
      overflow
    );
    const dialogKls = computed(() => [
      ns.b(),
      ns.is("fullscreen", props.fullscreen),
      ns.is("draggable", draggable.value),
      ns.is("dragging", isDragging.value),
      ns.is("align-center", !!props.alignCenter),
      { [ns.m("center")]: props.center }
    ]);
    __expose({
      resetPosition,
      updatePosition
    });
    return (_ctx, _cache) => {
      return openBlock(), createElementBlock(
        "div",
        {
          ref: unref(composedDialogRef),
          class: normalizeClass(dialogKls.value),
          style: normalizeStyle(unref(style)),
          tabindex: "-1"
        },
        [
          createElementVNode(
            "header",
            {
              ref_key: "headerRef",
              ref: headerRef,
              class: normalizeClass([unref(ns).e("header"), __props.headerClass, { "show-close": __props.showClose }])
            },
            [
              renderSlot(_ctx.$slots, "header", {}, () => [
                createElementVNode("span", {
                  role: "heading",
                  "aria-level": __props.ariaLevel,
                  class: normalizeClass(unref(ns).e("title"))
                }, toDisplayString(__props.title), 11, _hoisted_1$1)
              ]),
              __props.showClose ? (openBlock(), createElementBlock("button", {
                key: 0,
                "aria-label": unref(t)("el.dialog.close"),
                class: normalizeClass(unref(ns).e("headerbtn")),
                type: "button",
                onClick: _cache[0] || (_cache[0] = ($event) => _ctx.$emit("close"))
              }, [
                createVNode(unref(ElIcon), {
                  class: normalizeClass(unref(ns).e("close"))
                }, {
                  default: withCtx(() => [
                    (openBlock(), createBlock(resolveDynamicComponent(__props.closeIcon || unref(Close))))
                  ]),
                  _: 1
                  /* STABLE */
                }, 8, ["class"])
              ], 10, _hoisted_2)) : createCommentVNode("v-if", true)
            ],
            2
            /* CLASS */
          ),
          createElementVNode("div", {
            id: unref(bodyId),
            class: normalizeClass([unref(ns).e("body"), __props.bodyClass])
          }, [
            renderSlot(_ctx.$slots, "default")
          ], 10, _hoisted_3),
          _ctx.$slots.footer ? (openBlock(), createElementBlock(
            "footer",
            {
              key: 0,
              class: normalizeClass([unref(ns).e("footer"), __props.footerClass])
            },
            [
              renderSlot(_ctx.$slots, "footer")
            ],
            2
            /* CLASS */
          )) : createCommentVNode("v-if", true)
        ],
        6
        /* CLASS, STYLE */
      );
    };
  }
});
const _hoisted_1 = ["aria-label", "aria-labelledby", "aria-describedby"];
var _sfc_main = /* @__PURE__ */ defineComponent({
  ...{
    name: "ElDialog",
    inheritAttrs: false
  },
  __name: "dialog",
  props: dialogProps,
  emits: dialogEmits,
  setup(__props, { expose: __expose }) {
    const props = __props;
    const slots = useSlots();
    useDeprecated(
      {
        scope: "el-dialog",
        from: "the title slot",
        replacement: "the header slot",
        version: "3.0.0",
        ref: "https://element-plus.org/en-US/component/dialog.html#slots"
      },
      computed(() => !!slots.title)
    );
    const ns = useNamespace("dialog");
    const dialogRef = ref();
    const headerRef = ref();
    const dialogContentRef = ref();
    const {
      visible,
      titleId,
      bodyId,
      style,
      overlayDialogStyle,
      rendered,
      transitionConfig,
      zIndex,
      _draggable,
      _alignCenter,
      _overflow,
      handleClose,
      onModalClick,
      onOpenAutoFocus,
      onCloseAutoFocus,
      onCloseRequested,
      onFocusoutPrevented,
      closing
    } = useDialog(props, dialogRef);
    provide(dialogInjectionKey, {
      dialogRef,
      headerRef,
      bodyId,
      ns,
      rendered,
      style
    });
    const overlayEvent = useSameTarget(onModalClick);
    const penetrable = computed(
      () => props.modalPenetrable && !props.modal && !props.fullscreen
    );
    const resetPosition = () => {
      var _a;
      (_a = dialogContentRef.value) == null ? void 0 : _a.resetPosition();
    };
    __expose({
      /** @description whether the dialog is visible */
      visible,
      dialogContentRef,
      resetPosition,
      handleClose
    });
    return (_ctx, _cache) => {
      return openBlock(), createBlock(unref(ElTeleport), {
        to: __props.appendTo,
        disabled: __props.appendTo !== "body" ? false : !__props.appendToBody
      }, {
        default: withCtx(() => [
          createVNode(
            Transition,
            mergeProps(unref(transitionConfig), { persisted: "" }),
            {
              default: withCtx(() => {
                var _a;
                return [
                  withDirectives(createVNode(unref(ElOverlay), {
                    "custom-mask-event": "",
                    mask: __props.modal,
                    "overlay-class": [
                      (_a = __props.modalClass) != null ? _a : "",
                      `${unref(ns).namespace.value}-modal-dialog`,
                      unref(ns).is("penetrable", penetrable.value)
                    ],
                    "z-index": unref(zIndex)
                  }, {
                    default: withCtx(() => [
                      createElementVNode("div", {
                        role: "dialog",
                        "aria-modal": "true",
                        "aria-label": __props.title || void 0,
                        "aria-labelledby": !__props.title ? unref(titleId) : void 0,
                        "aria-describedby": unref(bodyId),
                        class: normalizeClass([
                          `${unref(ns).namespace.value}-overlay-dialog`,
                          unref(ns).is("closing", unref(closing))
                        ]),
                        style: normalizeStyle(unref(overlayDialogStyle)),
                        onClick: _cache[0] || (_cache[0] = //@ts-ignore
                        (...args) => unref(overlayEvent).onClick && unref(overlayEvent).onClick(...args)),
                        onMousedown: _cache[1] || (_cache[1] = //@ts-ignore
                        (...args) => unref(overlayEvent).onMousedown && unref(overlayEvent).onMousedown(...args)),
                        onMouseup: _cache[2] || (_cache[2] = //@ts-ignore
                        (...args) => unref(overlayEvent).onMouseup && unref(overlayEvent).onMouseup(...args))
                      }, [
                        createVNode(unref(ElFocusTrap), {
                          loop: "",
                          trapped: unref(visible),
                          "focus-start-el": "container",
                          onFocusAfterTrapped: unref(onOpenAutoFocus),
                          onFocusAfterReleased: unref(onCloseAutoFocus),
                          onFocusoutPrevented: unref(onFocusoutPrevented),
                          onReleaseRequested: unref(onCloseRequested)
                        }, {
                          default: withCtx(() => [
                            unref(rendered) ? (openBlock(), createBlock(_sfc_main$1, mergeProps({
                              key: 0,
                              ref_key: "dialogContentRef",
                              ref: dialogContentRef
                            }, _ctx.$attrs, {
                              center: __props.center,
                              "align-center": unref(_alignCenter),
                              "close-icon": __props.closeIcon,
                              draggable: unref(_draggable),
                              overflow: unref(_overflow),
                              fullscreen: __props.fullscreen,
                              "header-class": __props.headerClass,
                              "body-class": __props.bodyClass,
                              "footer-class": __props.footerClass,
                              "show-close": __props.showClose,
                              title: __props.title,
                              "aria-level": __props.headerAriaLevel,
                              onClose: unref(handleClose)
                            }), createSlots({
                              header: withCtx(() => [
                                !_ctx.$slots.title ? renderSlot(_ctx.$slots, "header", {
                                  key: 0,
                                  close: unref(handleClose),
                                  titleId: unref(titleId),
                                  titleClass: unref(ns).e("title")
                                }) : renderSlot(_ctx.$slots, "title", { key: 1 })
                              ]),
                              default: withCtx(() => [
                                renderSlot(_ctx.$slots, "default")
                              ]),
                              _: 2
                              /* DYNAMIC */
                            }, [
                              _ctx.$slots.footer ? {
                                name: "footer",
                                fn: withCtx(() => [
                                  renderSlot(_ctx.$slots, "footer")
                                ]),
                                key: "0"
                              } : void 0
                            ]), 1040, ["center", "align-center", "close-icon", "draggable", "overflow", "fullscreen", "header-class", "body-class", "footer-class", "show-close", "title", "aria-level", "onClose"])) : createCommentVNode("v-if", true)
                          ]),
                          _: 3
                          /* FORWARDED */
                        }, 8, ["trapped", "onFocusAfterTrapped", "onFocusAfterReleased", "onFocusoutPrevented", "onReleaseRequested"])
                      ], 46, _hoisted_1)
                    ]),
                    _: 3
                    /* FORWARDED */
                  }, 8, ["mask", "overlay-class", "z-index"]), [
                    [vShow, unref(visible)]
                  ])
                ];
              }),
              _: 3
              /* FORWARDED */
            },
            16
            /* FULL_PROPS */
          )
        ]),
        _: 3
        /* FORWARDED */
      }, 8, ["to", "disabled"]);
    };
  }
});
const ElDialog = withInstall(_sfc_main);

export { ElDialog as E, composeRefs as c };
