import { a as useI18n, j as actionStore, $ as useLocalePath, k as deviceStore, d as useRoute, f as useRouter, r as useRequest, e as useUtils, x as __nuxt_component_0$1 } from './server.mjs';
import { useSSRContext, ref, reactive, computed } from 'vue';
import { ssrRenderAttrs, ssrRenderComponent } from 'vue/server-renderer';
import { _ as _export_sfc } from './_plugin-vue_export-helper-1tPrXgE0.mjs';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "ModulesCommonTopicItemContent",
  __ssrInlineRender: true,
  props: ["data", "id", "settings", "postType"],
  setup(__props) {
    const { locale } = useI18n();
    actionStore();
    const localePath = useLocalePath();
    ref("");
    deviceStore();
    useRoute();
    const shareData = ref({});
    useRouter();
    const footer = ref({
      seo: {
        single: {
          databaseId: "",
          likeCount: 0,
          collected: false,
          collectionCount: 0,
          commentCount: 0,
          viewsCache: 0,
          liked: false,
          collected: false
        }
      }
    });
    function cleanHtmlContent(htmlString) {
      const div = (void 0).createElement("div");
      div.innerHTML = htmlString;
      const selector = ".wp-block-image,.wp-block-gallery, .wp-block-video, img, video";
      const elementsToRemove = div.querySelectorAll(selector);
      elementsToRemove.forEach((el) => el.remove());
      return div.innerHTML;
    }
    const state = reactive({
      item: null,
      data: null,
      commentData: null,
      commentSettings: {
        showList: true,
        openCommentForm: true,
        box: {
          backgroundCSS: ""
        },
        commentCount: 16,
        replyCount: 5,
        attrsPicked: [
          "emoji",
          "image",
          "draw",
          "reply",
          "like",
          "ipInfo",
          "date",
          "avatar",
          "report",
          "author"
        ]
      },
      getData: async () => {
        const res = await useRequest("/api/request", {
          body: {
            data: {
              id: state.item?.node?.databaseId,
              commentCount: state.commentSettings.commentCount,
              replyCount: state.commentSettings.replyCount
            }
          }
        });
        if (res?.guaqi?.community?.single?.content) {
          res.guaqi.community.single.content.content = cleanHtmlContent(
            res?.guaqi?.community?.single?.content.content
          );
          state.data = res?.guaqi?.community?.single?.content;
          state.commentData = res?.guaqi?.community?.single?.comment;
        }
        if (res?.guaqi?.community?.single?.interactive) {
          res.guaqi.community.single.interactive.databaseId = state.item?.node?.databaseId;
          footer.value.seo.single = res?.guaqi?.community?.single?.interactive;
        }
        const description = useUtils.extractText(
          state.item?.node?.topicContent?.topicExcerpt?.text
        );
        shareData.value = {
          title: state.item?.node?.title,
          description,
          summary: description,
          image: state.item?.node?.topicContent?.topicExcerpt?.gallery?.[0]?.src || "",
          url: (void 0).location.origin + localePath(state.item?.node?.gqSlug),
          source: (void 0).location.host
        };
      },
      submitSuccess: (data) => {
        data.new = true;
        state.commentData.edges.unshift({
          node: data
        });
        state.commentSettings.commentCount = state.commentSettings.commentCount + 1;
      }
    });
    computed(() => {
      return state.item?.node?.terms?.nodes.find(
        (node) => node.taxonomyName == "community_cat"
      ) || state.item?.node?.categories?.nodes?.[0];
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(`<div${ssrRenderAttrs(_attrs)} data-v-d6402aa7>`);
      _push(ssrRenderComponent(_component_ClientOnly, null, {}, _parent));
      _push(`</div>`);
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/modules/common/topic/itemContent.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const __nuxt_component_1 = /* @__PURE__ */ _export_sfc(_sfc_main, [["__scopeId", "data-v-d6402aa7"]]);

export { __nuxt_component_1 as default };
