import { a as useI18n, E as ElMessage, x as __nuxt_component_0$1 } from './server.mjs';
import { ref, useSSRContext } from 'vue';
import { ssrRenderComponent } from 'vue/server-renderer';
import '../_/nitro.mjs';
import 'node:crypto';
import 'node:http';
import 'node:https';
import 'node:events';
import 'node:buffer';
import 'ioredis';
import 'node:fs';
import 'node:path';
import '@intlify/utils';
import 'vue-router';
import 'node:url';
import 'undici';
import 'turndown';
import '@joplin/turndown-plugin-gfm';
import 'unhead/server';
import 'unhead/plugins';
import 'unhead/utils';
import 'vue-bundle-renderer/runtime';
import 'pinia';
import '@vue/shared';
import 'lodash-unified';
import 'quick-lru';

const _sfc_main = {
  __name: "CommonEditorLinks",
  __ssrInlineRender: true,
  props: ["editor"],
  setup(__props, { expose: __expose }) {
    const props = __props;
    const { t } = useI18n();
    const linkAction = ref({
      linkForm: {
        href: "",
        target: "_self",
        text: ""
      },
      show: false,
      setLink: () => {
        const { state } = props.editor;
        const { from, to } = state.selection;
        const selectedText = state.doc.textBetween(from, to, " ");
        const url = props.editor.getAttributes("link").href;
        const target = props.editor.getAttributes("link").target;
        linkAction.value.openLinkEditDialog({
          href: url,
          target: target || "_self",
          text: selectedText
          // 如果没有选中文本，使用URL作为默认文本
        });
      },
      insert: (linkForm) => {
        const { state } = props.editor;
        const { from, to, empty } = state.selection;
        const chain = props.editor.chain().focus();
        if (empty) {
          const currentNode = state.doc.nodeAt(from);
          if (currentNode && currentNode.marks.some((mark) => mark.type.name === "link")) {
            let start = from;
            let end = to;
            state.doc.nodesBetween(from, to, (node, pos) => {
              if (node.marks.some((mark) => mark.type.name === "link")) {
                start = pos;
                end = pos + node.nodeSize;
              }
            });
            chain.deleteRange({ from: start, to: end }).insertContent({
              type: "text",
              text: linkForm.text,
              marks: [
                {
                  type: "link",
                  attrs: {
                    href: linkForm.href,
                    target: linkForm.target
                  }
                }
              ]
            }).run();
          } else {
            chain.insertContent({
              type: "text",
              text: linkForm.text,
              marks: [
                {
                  type: "link",
                  attrs: {
                    href: linkForm.href,
                    target: linkForm.target
                  }
                }
              ]
            }).run();
          }
        } else {
          chain.deleteRange({ from, to }).insertContent({
            type: "text",
            text: linkForm.text,
            marks: [
              {
                type: "link",
                attrs: {
                  href: linkForm.href,
                  target: linkForm.target
                }
              }
            ]
          }).run();
        }
      },
      save: () => {
        if (!linkAction.value.linkForm.href) {
          ElMessage.warning(t("common.editor.error.linkInvalid"));
          return;
        }
        if (!linkAction.value.linkForm.text) {
          ElMessage.warning(t("common.editor.error.linkText"));
          return;
        }
        linkAction.value.show = false;
        linkAction.value.insert(linkAction.value.linkForm);
      },
      openLinkEditDialog: (linkInfo) => {
        linkAction.value.linkForm.href = linkInfo.href;
        linkAction.value.linkForm.target = linkInfo.target;
        linkAction.value.linkForm.text = linkInfo.text;
        linkAction.value.show = true;
      },
      clickAction: (target) => {
        if (!target) return;
        if (target.tagName === "A" && target.className.includes("wp-block-link")) {
          const url = props.editor.getAttributes("link").href;
          const _target = props.editor.getAttributes("link").target;
          const text = target.innerText;
          linkAction.value.openLinkEditDialog({
            href: url,
            target: _target || "_self",
            text
            // 如果没有选中文本，使用URL作为默认文本
          });
        }
      }
    });
    __expose({
      linkAction
    });
    return (_ctx, _push, _parent, _attrs) => {
      const _component_ClientOnly = __nuxt_component_0$1;
      _push(ssrRenderComponent(_component_ClientOnly, _attrs, {}, _parent));
    };
  }
};
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("layers/base/app/components/common/editor/links.client.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};

export { _sfc_main as default };
